/*******************************************************************************
* netchannel.cpp: network channel
*-------------------------------------------------------------------------------
* (c)1999-2001 VideoLAN
* $Id: netchannel.cpp,v 1.7 2002/08/09 13:42:32 tooney Exp $
*
* Authors: Benoit Steiner <benny@via.ecp.fr>
*          Arnaud de Bossoreille de Ribou <bozo@via.ecp.fr>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*
*-------------------------------------------------------------------------------
*
*******************************************************************************/


//------------------------------------------------------------------------------
// Preamble
//------------------------------------------------------------------------------
#include "../../core/defs.h"

#include "../../core/core.h"
#include "../../mpeg/mpeg.h"
#include "../../mpeg/ts.h"
#include "../../mpeg/rtp.h"

#include "../../server/buffer.h"
#include "../../server/output.h"
#include "../../server/channel.h"

#include "netoutput.h"
#include "netchannel.h"


//------------------------------------------------------------------------------
// Library declaration
//------------------------------------------------------------------------------
#ifdef __PLUGIN__
GENERATE_LIB_ARGS(C_NetChannelModule, handle);
#endif


//------------------------------------------------------------------------------
// Builtin declaration
//------------------------------------------------------------------------------
#ifdef __BUILTIN__
C_Module* NewBuiltin_netchannel(handle hLog)
{
  return new C_NetChannelModule(hLog);
}
#endif


//******************************************************************************
// class C_NetChannel
//******************************************************************************
//
//******************************************************************************

//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
C_NetChannel::C_NetChannel(C_Module* pModule,
                           const C_String& strName) : C_Channel(pModule,
                                                                strName)
{
  C_Application* pApp = C_Application::GetApp();
  ASSERT(pApp);

  C_String strDomain = pApp->GetSetting(m_strName+".Domain", "Inet4").ToLower();

  if(strDomain == "inet4")
    m_pOutput = new C_Net4Output(m_strName);
#ifdef HAVE_IPV6
  else if(strDomain == "inet6")
    m_pOutput = new C_Net6Output(m_strName);
#endif
  else
    throw E_Exception(GEN_ERR, "Unknown domain \"" + strDomain +
                      "\" for network channel \"" + m_strName + "\"");
}


