/*
 * Decompiled with CFR 0.152.
 */
package snmp;

import java.math.BigInteger;
import snmp.SNMPBadValueException;
import snmp.SNMPInteger;

public class SNMPGauge32
extends SNMPInteger {
    private static BigInteger maxValue = new BigInteger("4294967295");

    public SNMPGauge32() {
        this(0L);
    }

    public SNMPGauge32(long l) {
        this.tag = (byte)66;
        this.value = new BigInteger(new Long(l).toString());
        this.value = this.value.min(maxValue);
    }

    protected SNMPGauge32(byte[] byArray) throws SNMPBadValueException {
        this.tag = (byte)66;
        this.extractValueFromBEREncoding(byArray);
        this.value = this.value.min(maxValue);
    }

    public void setValue(Object object) throws SNMPBadValueException {
        if (object instanceof BigInteger) {
            this.value = (BigInteger)object;
            this.value = this.value.min(maxValue);
        } else if (object instanceof Integer) {
            this.value = this.value = new BigInteger(object.toString());
            this.value = this.value.min(maxValue);
        } else if (object instanceof String) {
            this.value = this.value = new BigInteger((String)object);
            this.value = this.value.min(maxValue);
        } else {
            throw new SNMPBadValueException(" Gauge32: bad object supplied to set value ");
        }
    }
}

