/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.plaf.FontUIResource;
import snmp.SNMPObject;
import snmp.SNMPObjectIdentifier;
import snmp.SNMPOctetString;
import snmp.SNMPSequence;
import snmp.SNMPVarBindList;
import snmp.SNMPv1CommunicationInterface;

public class SNMPInquisitor
extends JFrame
implements ActionListener,
Runnable {
    JButton getDataButton;
    JButton getTreewalkDataButton;
    JButton getTableButton;
    JButton getNextButton;
    JButton setValueButton;
    JButton clearButton;
    JTextArea messagesArea;
    JScrollPane messagesScroll;
    JTextField hostIDField;
    JTextField communityField;
    JTextField OIDField;
    JTextField valueField;
    JLabel authorLabel;
    JLabel hostIDLabel;
    JLabel communityLabel;
    JLabel OIDLabel;
    JLabel valueLabel;
    JComboBox valueTypeBox;
    MenuBar theMenubar;
    Menu fileMenu;
    MenuItem aboutItem;
    MenuItem quitItem;
    Thread treewalkThread = new Thread(this);
    SNMPv1CommunicationInterface comInterface;
    String community;
    InetAddress hostAddress;
    int version;

    public SNMPInquisitor() {
        this.setUpDisplay();
    }

    private void setUpDisplay() {
        Object object;
        this.setTitle("SNMP Inquisitor");
        this.getRootPane().setBorder(new BevelBorder(0));
        UIManager uIManager = new UIManager();
        FontUIResource fontUIResource = new FontUIResource("SansSerif", 0, 10);
        UIDefaults uIDefaults = uIManager.getLookAndFeelDefaults();
        Enumeration enumeration = uIDefaults.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (((String)object).indexOf("font") <= -1 && ((String)object).indexOf("Font") <= -1) continue;
            UIManager.put(object, fontUIResource);
        }
        this.addWindowListener(new WindowCloseAdapter());
        this.theMenubar = new MenuBar();
        this.setMenuBar(this.theMenubar);
        this.fileMenu = new Menu("File");
        this.aboutItem = new MenuItem("About...");
        this.aboutItem.setActionCommand("about");
        this.aboutItem.addActionListener(this);
        this.fileMenu.add(this.aboutItem);
        this.fileMenu.addSeparator();
        this.quitItem = new MenuItem("Quit");
        this.quitItem.setActionCommand("quit");
        this.quitItem.addActionListener(this);
        this.fileMenu.add(this.quitItem);
        this.theMenubar.add(this.fileMenu);
        this.hostIDLabel = new JLabel("Device address:");
        this.hostIDField = new JTextField(20);
        this.hostIDField.setText("10.0.1.1");
        this.hostIDField.setEditable(true);
        this.OIDLabel = new JLabel("OID:");
        this.OIDField = new JTextField(20);
        this.OIDField.setEditable(true);
        this.valueLabel = new JLabel("Value (for Set):");
        this.valueField = new JTextField(20);
        this.valueField.setEditable(true);
        this.communityLabel = new JLabel("Community:");
        this.communityField = new JTextField(20);
        this.communityField.setText("public");
        this.communityField.setEditable(true);
        this.authorLabel = new JLabel(" Version 1.1        J. Sevy, January 2001 ");
        this.authorLabel.setFont(new Font("SansSerif", 2, 8));
        this.getDataButton = new JButton("Get OID value");
        this.getDataButton.setActionCommand("get data");
        this.getDataButton.addActionListener(this);
        this.setValueButton = new JButton("Set OID value");
        this.setValueButton.setActionCommand("set value");
        this.setValueButton.addActionListener(this);
        this.getTableButton = new JButton("Get table");
        this.getTableButton.setActionCommand("get table");
        this.getTableButton.addActionListener(this);
        this.getNextButton = new JButton("Get next OID value");
        this.getNextButton.setActionCommand("get next");
        this.getNextButton.addActionListener(this);
        this.getTreewalkDataButton = new JButton("Get all OID values");
        this.getTreewalkDataButton.setActionCommand("get treewalk data");
        this.getTreewalkDataButton.addActionListener(this);
        this.clearButton = new JButton("Clear responses");
        this.clearButton.setActionCommand("clear messages");
        this.clearButton.addActionListener(this);
        this.messagesArea = new JTextArea(10, 60);
        this.messagesScroll = new JScrollPane(this.messagesArea);
        this.valueTypeBox = new JComboBox();
        this.valueTypeBox.addItem("SNMPInteger");
        this.valueTypeBox.addItem("SNMPCounter32");
        this.valueTypeBox.addItem("SNMPCounter64");
        this.valueTypeBox.addItem("SNMPGauge32");
        this.valueTypeBox.addItem("SNMPOctetString");
        this.valueTypeBox.addItem("SNMPIPAddress");
        this.valueTypeBox.addItem("SNMPNSAPAddress");
        this.valueTypeBox.addItem("SNMPObjectIdentifier");
        this.valueTypeBox.addItem("SNMPTimeTicks");
        this.valueTypeBox.addItem("SNMPUInteger32");
        object = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)object);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        ((GridBagLayout)object).setConstraints(this.getDataButton, gridBagConstraints);
        jPanel.add(this.getDataButton);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        ((GridBagLayout)object).setConstraints(this.getNextButton, gridBagConstraints);
        jPanel.add(this.getNextButton);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        ((GridBagLayout)object).setConstraints(this.getTableButton, gridBagConstraints);
        jPanel.add(this.getTableButton);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        ((GridBagLayout)object).setConstraints(this.getTreewalkDataButton, gridBagConstraints);
        jPanel.add(this.getTreewalkDataButton);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        ((GridBagLayout)object).setConstraints(this.setValueButton, gridBagConstraints);
        jPanel.add(this.setValueButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)object);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        ((GridBagLayout)object).setConstraints(this.hostIDLabel, gridBagConstraints);
        jPanel2.add(this.hostIDLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        ((GridBagLayout)object).setConstraints(this.hostIDField, gridBagConstraints);
        jPanel2.add(this.hostIDField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        ((GridBagLayout)object).setConstraints(this.communityLabel, gridBagConstraints);
        jPanel2.add(this.communityLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        ((GridBagLayout)object).setConstraints(this.communityField, gridBagConstraints);
        jPanel2.add(this.communityField);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)object);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        ((GridBagLayout)object).setConstraints(this.OIDLabel, gridBagConstraints);
        jPanel3.add(this.OIDLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        ((GridBagLayout)object).setConstraints(this.OIDField, gridBagConstraints);
        jPanel3.add(this.OIDField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        ((GridBagLayout)object).setConstraints(this.valueLabel, gridBagConstraints);
        jPanel3.add(this.valueLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        ((GridBagLayout)object).setConstraints(this.valueField, gridBagConstraints);
        jPanel3.add(this.valueField);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        ((GridBagLayout)object).setConstraints(this.valueTypeBox, gridBagConstraints);
        jPanel3.add(this.valueTypeBox);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 10;
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)object);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        JLabel jLabel = new JLabel("Responses:");
        ((GridBagLayout)object).setConstraints(jLabel, gridBagConstraints);
        jPanel4.add(jLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        ((GridBagLayout)object).setConstraints(this.clearButton, gridBagConstraints);
        jPanel4.add(this.clearButton);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.anchor = 10;
        ((GridBagLayout)object).setConstraints(this.messagesScroll, gridBagConstraints);
        jPanel4.add(this.messagesScroll);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.getContentPane().setLayout((LayoutManager)object);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        ((GridBagLayout)object).setConstraints(jPanel2, gridBagConstraints);
        this.getContentPane().add(jPanel2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        ((GridBagLayout)object).setConstraints(jPanel3, gridBagConstraints);
        this.getContentPane().add(jPanel3);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        ((GridBagLayout)object).setConstraints(jPanel, gridBagConstraints);
        this.getContentPane().add(jPanel);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        ((GridBagLayout)object).setConstraints(jPanel4, gridBagConstraints);
        this.getContentPane().add(jPanel4);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        ((GridBagLayout)object).setConstraints(this.authorLabel, gridBagConstraints);
        this.getContentPane().add(this.authorLabel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        Object object;
        Object object2;
        SNMPObject sNMPObject;
        Object object3;
        SNMPObject sNMPObject2;
        SNMPVarBindList sNMPVarBindList;
        Object object4;
        Object object5;
        SNMPv1CommunicationInterface sNMPv1CommunicationInterface;
        InetAddress inetAddress;
        int n2;
        Object object6;
        String string = actionEvent.getActionCommand();
        if (string == "quit") {
            System.exit(0);
        }
        if (string == "clear messages") {
            this.messagesArea.setText("");
        }
        if (string == "about") {
            object6 = new AboutDialog(this);
        }
        if (string == "get data") {
            try {
                object6 = this.communityField.getText();
                n2 = 0;
                inetAddress = InetAddress.getByName(this.hostIDField.getText());
                sNMPv1CommunicationInterface = new SNMPv1CommunicationInterface(n2, inetAddress, (String)object6);
                object5 = new StringTokenizer(this.OIDField.getText(), " ,;");
                while (((StringTokenizer)object5).hasMoreTokens()) {
                    object4 = ((StringTokenizer)object5).nextToken();
                    sNMPVarBindList = sNMPv1CommunicationInterface.getMIBEntry((String)object4);
                    sNMPObject2 = (SNMPSequence)sNMPVarBindList.getSNMPObjectAt(0);
                    object3 = (SNMPObjectIdentifier)((SNMPSequence)sNMPObject2).getSNMPObjectAt(0);
                    sNMPObject = ((SNMPSequence)sNMPObject2).getSNMPObjectAt(1);
                    object2 = sNMPObject.getClass().getName();
                    if (((String)object2).equals("snmp.SNMPOctetString")) {
                        object = sNMPObject.toString();
                        n = ((String)object).indexOf(0);
                        if (n >= 0) {
                            object = ((String)object).substring(0, n);
                        }
                        this.messagesArea.append("OID: " + object3 + "  type: " + (String)object2 + "  value: " + (String)object);
                        this.messagesArea.append("  (hex: " + ((SNMPOctetString)sNMPObject).toHexString() + ")\n");
                        continue;
                    }
                    this.messagesArea.append("OID: " + object3 + "  type: " + (String)object2 + "  value: " + sNMPObject);
                    this.messagesArea.append("\n");
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                this.messagesArea.append("Interrupted during retrieval:  " + interruptedIOException + "\n");
            }
            catch (Exception exception) {
                this.messagesArea.append("Exception during retrieval:  " + exception + "\n");
            }
        }
        if (string == "get next") {
            try {
                object6 = this.communityField.getText();
                n2 = 0;
                inetAddress = InetAddress.getByName(this.hostIDField.getText());
                sNMPv1CommunicationInterface = new SNMPv1CommunicationInterface(n2, inetAddress, (String)object6);
                object5 = new StringTokenizer(this.OIDField.getText(), " ,;");
                while (((StringTokenizer)object5).hasMoreTokens()) {
                    object4 = ((StringTokenizer)object5).nextToken();
                    sNMPVarBindList = sNMPv1CommunicationInterface.getNextMIBEntry((String)object4);
                    sNMPObject2 = (SNMPSequence)sNMPVarBindList.getSNMPObjectAt(0);
                    object3 = (SNMPObjectIdentifier)((SNMPSequence)sNMPObject2).getSNMPObjectAt(0);
                    sNMPObject = ((SNMPSequence)sNMPObject2).getSNMPObjectAt(1);
                    object2 = sNMPObject.getClass().getName();
                    if (((String)object2).equals("snmp.SNMPOctetString")) {
                        object = sNMPObject.toString();
                        n = ((String)object).indexOf(0);
                        if (n >= 0) {
                            object = ((String)object).substring(0, n);
                        }
                        this.messagesArea.append("OID: " + object3 + "  type: " + (String)object2 + "  value: " + (String)object);
                        this.messagesArea.append("  (hex: " + ((SNMPOctetString)sNMPObject).toHexString() + ")\n");
                        continue;
                    }
                    this.messagesArea.append("OID: " + object3 + "  type: " + (String)object2 + "  value: " + sNMPObject);
                    this.messagesArea.append("\n");
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                this.messagesArea.append("Interrupted during retrieval:  " + interruptedIOException + "\n");
            }
            catch (Exception exception) {
                this.messagesArea.append("Exception during retrieval:  " + exception + "\n");
            }
        }
        if (string == "get table") {
            try {
                object6 = this.communityField.getText();
                n2 = 0;
                inetAddress = InetAddress.getByName(this.hostIDField.getText());
                sNMPv1CommunicationInterface = new SNMPv1CommunicationInterface(n2, inetAddress, (String)object6);
                object5 = this.OIDField.getText();
                object4 = sNMPv1CommunicationInterface.retrieveMIBTable((String)object5);
                for (int i = 0; i < ((SNMPSequence)object4).size(); ++i) {
                    sNMPObject2 = (SNMPSequence)((SNMPSequence)object4).getSNMPObjectAt(i);
                    object3 = (SNMPObjectIdentifier)((SNMPSequence)sNMPObject2).getSNMPObjectAt(0);
                    sNMPObject = ((SNMPSequence)sNMPObject2).getSNMPObjectAt(1);
                    object2 = sNMPObject.getClass().getName();
                    if (((String)object2).equals("snmp.SNMPOctetString")) {
                        object = sNMPObject.toString();
                        n = ((String)object).indexOf(0);
                        if (n >= 0) {
                            object = ((String)object).substring(0, n);
                        }
                        this.messagesArea.append("OID: " + object3 + "  type: " + (String)object2 + "  value: " + (String)object);
                        this.messagesArea.append("  (hex: " + ((SNMPOctetString)sNMPObject).toHexString() + ")\n");
                        continue;
                    }
                    this.messagesArea.append("OID: " + object3 + "  type: " + (String)object2 + "  value: " + sNMPObject);
                    this.messagesArea.append("\n");
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                this.messagesArea.append("Interrupted during retrieval:  " + interruptedIOException + "\n");
            }
            catch (Exception exception) {
                this.messagesArea.append("Exception during retrieval:  " + exception + "\n");
            }
        }
        if (string == "set value") {
            try {
                object6 = this.communityField.getText();
                n2 = 0;
                inetAddress = InetAddress.getByName(this.hostIDField.getText());
                sNMPv1CommunicationInterface = new SNMPv1CommunicationInterface(n2, inetAddress, (String)object6);
                object5 = this.OIDField.getText();
                object4 = this.valueField.getText();
                String string2 = (String)this.valueTypeBox.getSelectedItem();
                string2 = "snmp." + string2;
                object3 = Class.forName(string2);
                sNMPObject2 = (SNMPObject)((Class)object3).newInstance();
                sNMPObject2.setValue(object4);
                sNMPObject = sNMPv1CommunicationInterface.setMIBEntry((String)object5, sNMPObject2);
                object2 = (SNMPSequence)((SNMPSequence)sNMPObject).getSNMPObjectAt(0);
                object = (SNMPObjectIdentifier)((SNMPSequence)object2).getSNMPObjectAt(0);
                SNMPObject sNMPObject3 = ((SNMPSequence)object2).getSNMPObjectAt(1);
                String string3 = sNMPObject3.getClass().getName();
                this.messagesArea.append("OID: " + object + "  type: " + string3 + "  value: " + sNMPObject3);
                if (string3.equals("snmp.SNMPOctetString")) {
                    this.messagesArea.append("  (hex: " + ((SNMPOctetString)sNMPObject3).toHexString() + ")\n");
                } else {
                    this.messagesArea.append("\n");
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                this.messagesArea.append("Interrupted during retrieval:  " + interruptedIOException + "\n");
            }
            catch (Exception exception) {
                this.messagesArea.append("Exception during retrieval:  " + exception + "\n");
            }
        }
        if (string == "get treewalk data") {
            if (!this.treewalkThread.isAlive()) {
                this.treewalkThread = new Thread(this);
                this.treewalkThread.start();
                this.getTreewalkDataButton.setText("Stop OID retrieval");
            } else {
                this.treewalkThread.interrupt();
            }
        }
    }

    public void run() {
        try {
            String string = this.communityField.getText();
            int n = 0;
            InetAddress inetAddress = InetAddress.getByName(this.hostIDField.getText());
            SNMPv1CommunicationInterface sNMPv1CommunicationInterface = new SNMPv1CommunicationInterface(n, inetAddress, string);
            String string2 = "";
            String string3 = "1.3.6.1.2.1";
            while (!Thread.interrupted() && !string3.equals(string2)) {
                string2 = string3;
                SNMPVarBindList sNMPVarBindList = sNMPv1CommunicationInterface.getNextMIBEntry(string2);
                SNMPSequence sNMPSequence = (SNMPSequence)sNMPVarBindList.getSNMPObjectAt(0);
                SNMPObjectIdentifier sNMPObjectIdentifier = (SNMPObjectIdentifier)sNMPSequence.getSNMPObjectAt(0);
                SNMPObject sNMPObject = sNMPSequence.getSNMPObjectAt(1);
                string3 = sNMPObjectIdentifier.toString();
                String string4 = sNMPObject.getClass().getName();
                if (string4.equals("snmp.SNMPOctetString")) {
                    String string5 = sNMPObject.toString();
                    int n2 = string5.indexOf(0);
                    if (n2 >= 0) {
                        string5 = string5.substring(0, n2);
                    }
                    this.messagesArea.append("OID: " + sNMPObjectIdentifier + "  type: " + string4 + "  value: " + string5);
                    this.messagesArea.append("  (hex: " + ((SNMPOctetString)sNMPObject).toHexString() + ")\n");
                    continue;
                }
                this.messagesArea.append("OID: " + sNMPObjectIdentifier + "  type: " + string4 + "  value: " + sNMPObject);
                this.messagesArea.append("\n");
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            this.messagesArea.append("Interrupted during retrieval:  " + interruptedIOException + "\n");
        }
        catch (Exception exception) {
            this.messagesArea.append("Exception during retrieval:  " + exception + "\n");
        }
        catch (Error error) {
            this.messagesArea.append("Error during retrieval:  " + error + "\n");
        }
        this.getTreewalkDataButton.setText("Get all OID values");
    }

    private String hexByte(byte n) {
        int n2 = n;
        if (n2 < 0) {
            n2 += 256;
        }
        String string = new String();
        string = string + Integer.toHexString(n2 / 16);
        string = string + Integer.toHexString(n2 % 16);
        return string;
    }

    public static void main(String[] stringArray) {
        try {
            SNMPInquisitor sNMPInquisitor = new SNMPInquisitor();
            sNMPInquisitor.pack();
            sNMPInquisitor.setSize(600, 500);
            sNMPInquisitor.show();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class WindowCloseAdapter
    extends WindowAdapter {
        private WindowCloseAdapter() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            System.exit(0);
        }
    }
}

