/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.beans.PropertyEditor;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.Ordered;
import org.springframework.util.ClassUtils;

public class CustomEditorConfigurer
implements BeanFactoryPostProcessor,
BeanClassLoaderAware,
Ordered {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private int order = Integer.MAX_VALUE;
    private PropertyEditorRegistrar[] propertyEditorRegistrars;
    private Map customEditors;
    private boolean ignoreUnresolvableEditors = false;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setPropertyEditorRegistrars(PropertyEditorRegistrar[] propertyEditorRegistrars) {
        this.propertyEditorRegistrars = propertyEditorRegistrars;
    }

    public void setCustomEditors(Map customEditors) {
        this.customEditors = customEditors;
    }

    public void setIgnoreUnresolvableEditors(boolean ignoreUnresolvableEditors) {
        this.ignoreUnresolvableEditors = ignoreUnresolvableEditors;
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (this.propertyEditorRegistrars != null) {
            for (int i = 0; i < this.propertyEditorRegistrars.length; ++i) {
                beanFactory.addPropertyEditorRegistrar(this.propertyEditorRegistrars[i]);
            }
        }
        if (this.customEditors != null) {
            Iterator it = this.customEditors.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                Class requiredType = null;
                try {
                    if (key instanceof Class) {
                        requiredType = (Class)key;
                    } else if (key instanceof String) {
                        requiredType = ClassUtils.forName((String)key, this.beanClassLoader);
                    } else {
                        throw new IllegalArgumentException("Invalid key [" + key + "] for custom editor: needs to be Class or String.");
                    }
                    if (value instanceof PropertyEditor) {
                        beanFactory.registerCustomEditor(requiredType, (PropertyEditor)value);
                        continue;
                    }
                    if (value instanceof Class) {
                        beanFactory.registerCustomEditor(requiredType, (Class)value);
                        continue;
                    }
                    if (value instanceof String) {
                        Class editorClass = ClassUtils.forName((String)value, this.beanClassLoader);
                        beanFactory.registerCustomEditor(requiredType, editorClass);
                        continue;
                    }
                    throw new IllegalArgumentException("Mapped value [" + value + "] for custom editor key [" + key + "] is not of required type [" + PropertyEditor.class.getName() + "] or a corresponding Class or String value indicating a PropertyEditor implementation");
                }
                catch (ClassNotFoundException ex) {
                    if (this.ignoreUnresolvableEditors) {
                        this.logger.info((Object)("Skipping editor [" + value + "] for required type [" + key + "]: " + (requiredType != null ? "editor" : "required type") + " class not found."));
                        continue;
                    }
                    throw new FatalBeanException((requiredType != null ? "Editor" : "Required type") + " class not found", ex);
                }
            }
        }
    }
}

