/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma.order;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.videolan.vlma.exception.NoAvailableOrderSenderException;
import org.videolan.vlma.model.DTTChannel;
import org.videolan.vlma.model.FilesChannel;
import org.videolan.vlma.model.Order;
import org.videolan.vlma.model.SatChannel;
import org.videolan.vlma.model.StreamChannel;
import org.videolan.vlma.order.DTTOrderSender;
import org.videolan.vlma.order.FilesOrderSender;
import org.videolan.vlma.order.OrderSender;
import org.videolan.vlma.order.SatOrderSender;
import org.videolan.vlma.order.StreamOrderSender;

public class OrderSenderDispatcher
extends OrderSender {
    private static final Logger logger = Logger.getLogger(OrderSenderDispatcher.class);

    private OrderSender getOrderSenderForClass(Class clazz) throws NoAvailableOrderSenderException {
        OrderSender result;
        if (SatChannel.class.isAssignableFrom(clazz)) {
            result = new SatOrderSender();
        } else if (DTTChannel.class.isAssignableFrom(clazz)) {
            result = new DTTOrderSender();
        } else if (FilesChannel.class.isAssignableFrom(clazz)) {
            result = new FilesOrderSender();
        } else if (StreamChannel.class.isAssignableFrom(clazz)) {
            result = new StreamOrderSender();
        } else {
            throw new NoAvailableOrderSenderException("No available OrderSender for class " + clazz);
        }
        result.setCommandLogger(this.commandLogger);
        result.setConfiguration(this.configuration);
        return result;
    }

    public void start(Order order) throws IOException {
        Class clazz = order.getMedias().getMediaClass();
        try {
            OrderSender orderSender = this.getOrderSenderForClass(clazz);
            orderSender.start(order);
        }
        catch (NoAvailableOrderSenderException e) {
            logger.warn((Object)("Couldn't find an appropriate OrderSender for the media class: " + clazz));
        }
    }

    public void stop(Order order) throws IOException {
        Class clazz = order.getMedias().getMediaClass();
        try {
            OrderSender orderSender = this.getOrderSenderForClass(clazz);
            orderSender.stop(order);
        }
        catch (NoAvailableOrderSenderException e) {
            logger.warn((Object)("Couldn't find an appropriate OrderSender for the media class: " + clazz));
        }
    }
}

