/*
 * Decompiled with CFR 0.152.
 */
package snmp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import snmp.SNMPMessage;
import snmp.SNMPTrapPDU;

public class SNMPv1TrapSenderInterface {
    public static final int SNMP_TRAP_PORT = 162;
    public static final int MAXSIZE = 512;
    private DatagramSocket dSocket;

    public SNMPv1TrapSenderInterface() throws SocketException {
        this.dSocket = new DatagramSocket();
    }

    public SNMPv1TrapSenderInterface(int n) throws SocketException {
        this.dSocket = new DatagramSocket(n);
    }

    public void sendTrap(int n, InetAddress inetAddress, String string, SNMPTrapPDU sNMPTrapPDU) throws IOException {
        SNMPMessage sNMPMessage = new SNMPMessage(n, string, sNMPTrapPDU);
        byte[] byArray = sNMPMessage.getBEREncoding();
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, 162);
        this.dSocket.send(datagramPacket);
    }

    public void sendTrap(InetAddress inetAddress, String string, SNMPTrapPDU sNMPTrapPDU) throws IOException {
        int n = 0;
        this.sendTrap(n, inetAddress, string, sNMPTrapPDU);
    }

    private String hexByte(byte n) {
        int n2 = n;
        if (n2 < 0) {
            n2 += 256;
        }
        String string = new String();
        string = string + Integer.toHexString(n2 / 16);
        string = string + Integer.toHexString(n2 % 16);
        return string;
    }

    private String getHex(byte n) {
        String string;
        int n2 = n;
        if (n2 < 0) {
            n2 += 256;
        }
        if ((string = new String(Integer.toHexString(n2))).length() % 2 == 1) {
            string = "0" + string;
        }
        return string;
    }
}

