/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma.notifier;

import java.io.IOException;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.schwering.irc.lib.IRCConnection;
import org.schwering.irc.lib.IRCEventListener;
import org.schwering.irc.lib.IRCModeParser;
import org.schwering.irc.lib.IRCUser;
import org.videolan.vlma.notifier.Notifier;

public class IRCNotifier
extends Notifier {
    private static final Logger logger = Logger.getLogger(IRCNotifier.class);
    private Configuration configuration;
    private IRCConnection conn;
    private String nick;
    private String pass;
    private List<String> chans;
    private String host;
    private int port;

    private void connect() throws IOException {
        this.nick = this.configuration.getString("vlma.notification.irc.nick");
        this.pass = this.configuration.getString("vlma.notification.irc.pass");
        this.host = this.configuration.getString("vlma.notification.irc.host");
        this.port = this.configuration.getInt("vlma.notification.irc.port");
        this.chans = this.configuration.getList("vlma.notification.irc.chan");
        this.conn = new IRCConnection(this.host, new int[]{this.port}, this.pass, this.nick, "vlma", "VLMa");
        this.conn.setEncoding("UTF-8");
        this.conn.addIRCEventListener((IRCEventListener)new Listener());
        this.conn.setPong(true);
        this.conn.setDaemon(true);
        this.conn.connect();
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        for (String chan : this.chans) {
            this.conn.doJoin(chan);
        }
    }

    public void init() {
        if (this.isIRCEnabled()) {
            try {
                this.connect();
            }
            catch (IOException e) {
                logger.error((Object)"Error while connecting", (Throwable)e);
            }
        }
    }

    private void checkConnection() throws IOException {
        if (this.conn == null || !this.conn.isConnected()) {
            this.connect();
        }
    }

    private boolean isIRCEnabled() {
        List tmp = this.configuration.getList("vlma.notification.irc.chan");
        return tmp != null && tmp.size() > 0;
    }

    public void sendNotification(String message) {
        if (this.isIRCEnabled()) {
            for (String chan : this.chans) {
                try {
                    this.checkConnection();
                    this.conn.doPrivmsg(chan, message);
                }
                catch (IOException e) {
                    logger.error((Object)"IRC notifier cannot connect", (Throwable)e);
                }
            }
        }
    }

    public void destroy() {
        if (this.conn != null) {
            this.conn.doQuit("VLMa daemon stopping. Quitting IRC.");
            this.conn.close();
        }
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public class Listener
    implements IRCEventListener {
        public void onDisconnected() {
            logger.info((Object)"IRC notifier deconnected");
        }

        public void onError(String error) {
            logger.error((Object)("IRC notifier encountered an error: " + error));
        }

        public void onError(int code, String error) {
            logger.error((Object)("IRC notifier encountered an error: " + error));
            if (code == 433) {
                IRCNotifier.this.nick = IRCNotifier.this.nick + "_";
                IRCNotifier.this.conn.doNick(IRCNotifier.this.nick);
                try {
                    IRCNotifier.this.conn.connect();
                }
                catch (IOException e) {
                    logger.error((Object)"Cannot connect to the IRC server", (Throwable)e);
                }
            }
        }

        public void onInvite(String chan, IRCUser user, String nick) {
        }

        public void onJoin(String chan, IRCUser user) {
            logger.info((Object)("IRC notifier joined " + chan));
        }

        public void onKick(String chan, IRCUser user, String nick, String msg) {
            logger.info((Object)("IRC notifier was kicked by " + user.getNick()));
        }

        public void onMode(String arg0, IRCUser arg1, IRCModeParser arg2) {
        }

        public void onMode(IRCUser arg0, String arg1, String arg2) {
        }

        public void onNick(IRCUser arg0, String arg1) {
        }

        public void onNotice(String arg0, IRCUser arg1, String arg2) {
        }

        public void onPart(String arg0, IRCUser arg1, String arg2) {
        }

        public void onPing(String ping) {
            logger.info((Object)("IRC notifier received ping " + ping));
        }

        public void onPrivmsg(String chan, IRCUser user, String msg) {
            logger.debug((Object)("User " + user + " said " + msg));
        }

        public void onQuit(IRCUser arg0, String arg1) {
        }

        public void onRegistered() {
        }

        public void onReply(int arg0, String arg1, String arg2) {
        }

        public void onTopic(String arg0, IRCUser arg1, String arg2) {
        }

        public void unknown(String arg0, String arg1, String arg2, String arg3) {
        }
    }
}

