/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.awt.Color;
import org.jrobin.core.RrdException;
import org.jrobin.graph.RrdGraphDef;

public class RrdtoolGraph {
    private static final int SAVE_PNG = 0;
    private static final int SAVE_GIF = 1;
    private static final int DS_DEF = 0;
    private static final int DS_CDEF = 1;
    private static final int TXT_COMMENT = 0;
    private static final int TXT_GPRINT = 1;
    private static final int GRAPH_LINE = 0;
    private static final int GRAPH_AREA = 1;
    private static final int GRAPH_STACK = 2;
    private static final int TKN_IGNORE = -2;
    private static final int TKN_UNKNOWN = -1;
    private static final int TKN_RRDTOOL = 0;
    private static final int TKN_GRAPH = 1;
    private static final int TKN_START = 2;
    private static final int TKN_END = 3;
    private static final int TKN_COMMENT = 4;
    private static final int TKN_LINE = 5;
    private static final int TKN_AREA = 6;
    private static final int TKN_STACK = 7;
    private static final int TKN_CDEF = 8;
    private static final int TKN_DEF = 9;
    private static final int TKN_GPRINT = 11;
    private static final int TKN_HRULE = 12;
    private static final int TKN_VRULE = 13;
    private static final int TKN_STEP = 14;
    private static final int TKN_TITLE = 15;
    private static final int TKN_NOLEGEND = 16;
    private static final int TKN_COLOR = 17;
    private static final int TKN_RIGID = 18;
    private static final int TKN_LOWERLIMIT = 19;
    private static final int TKN_UPPERLIMIT = 20;
    private static final int TKN_LAZY = 21;
    private static final int TKN_OVERLAY = 23;
    private static final int TKN_BACKGROUND = 24;
    private static final int TKN_IMGFORMAT = 25;
    private static final int TKN_WIDTH = 26;
    private static final int TKN_HEIGHT = 27;
    private static final int TKN_VERT_LABEL = 28;
    private static final int TKN_UNITS_EXP = 29;
    private static final int TKN_NOMINOR = 30;
    private static final int TKN_XGRID = 31;
    private static final int TKN_YGRID = 32;
    private static final int TKN_BASE = 33;
    private String token = "";
    private String script = null;
    private RrdGraphDef graphDef = null;
    private int tokenPos = 0;
    private char[] parseCmd = new char[0];
    private boolean gridRigid = false;
    private double gridLower = Double.MAX_VALUE;
    private double gridUpper = Double.MIN_VALUE;
    private int width = 0;
    private int height = 0;
    private int fileType = 0;
    private String fileName = "";

    public RrdtoolGraph(String string) {
        this.script = string;
    }

    public RrdGraphDef getRrdGraphDef() throws RrdException {
        this.parseRrdtoolScript();
        return this.graphDef;
    }

    private boolean parseRrdtoolScript() throws RrdException {
        long l = 0L;
        long l2 = 0L;
        this.graphDef = new RrdGraphDef();
        this.parseCmd = this.script.replace('\n', ' ').replace('\r', ' ').replace('\t', ' ').toCharArray();
        while (this.nextToken() > 0) {
            System.err.println(this.token);
            switch (this.parseToken(this.token)) {
                case 0: {
                    break;
                }
                case 1: {
                    this.nextToken();
                    break;
                }
                case 2: {
                    this.nextToken();
                    l = Long.parseLong(this.token);
                    break;
                }
                case 3: {
                    this.nextToken();
                    l2 = Long.parseLong(this.token);
                    break;
                }
                case 30: {
                    this.graphDef.setMinorGridX(false);
                    this.graphDef.setMinorGridY(false);
                    break;
                }
                case 26: {
                    this.nextToken();
                    this.width = Integer.parseInt(this.token);
                    break;
                }
                case 27: {
                    this.nextToken();
                    this.height = Integer.parseInt(this.token);
                    break;
                }
                case 29: {
                    this.nextToken();
                    this.graphDef.setUnitsExponent(Integer.parseInt(this.token));
                    break;
                }
                case 28: {
                    this.nextToken();
                    this.graphDef.setVerticalLabel(this.unescape(this.token));
                    break;
                }
                case 15: {
                    this.nextToken();
                    this.graphDef.setTitle(this.unescape(this.token));
                    break;
                }
                case 25: {
                    this.nextToken();
                    if (!this.token.equalsIgnoreCase("gif")) break;
                    this.fileType = 1;
                    break;
                }
                case 24: {
                    this.nextToken();
                    this.graphDef.setBackground(this.unescape(this.token));
                    break;
                }
                case 23: {
                    this.nextToken();
                    this.graphDef.setOverlay(this.unescape(this.token));
                    break;
                }
                case 16: {
                    this.graphDef.setShowLegend(false);
                    break;
                }
                case 19: {
                    this.nextToken();
                    this.gridLower = Double.parseDouble(this.token);
                    break;
                }
                case 20: {
                    this.nextToken();
                    this.gridUpper = Double.parseDouble(this.token);
                    break;
                }
                case 18: {
                    this.gridRigid = true;
                    break;
                }
                case 33: {
                    this.nextToken();
                    this.graphDef.setBaseValue(Double.parseDouble(this.token));
                    break;
                }
                case 4: {
                    this.parseTextCommand(0);
                    break;
                }
                case 11: {
                    this.parseTextCommand(1);
                    break;
                }
                case 5: {
                    this.parseGraphCommand(0);
                    break;
                }
                case 6: {
                    this.parseGraphCommand(1);
                    break;
                }
                case 7: {
                    this.parseGraphCommand(2);
                    break;
                }
                case 9: {
                    this.parseDatasource(0);
                    break;
                }
                case 8: {
                    this.parseDatasource(1);
                    break;
                }
                case -2: {
                    break;
                }
                case -1: {
                    throw new RrdException("Unknown token: " + this.token);
                }
            }
        }
        if (this.gridRigid || this.gridLower == Double.MAX_VALUE || this.gridUpper == Double.MIN_VALUE) {
            this.graphDef.setGridRange(this.gridLower, this.gridUpper, this.gridRigid);
        }
        return true;
    }

    private void parseGraphCommand(int n) throws RrdException {
        if (n == 0) {
            int n2 = Integer.parseInt("" + this.token.charAt(4));
            int n3 = this.token.indexOf(35, 6);
            int n4 = this.token.indexOf(58, 6);
            if (n3 < 0) {
                n3 = n4;
            }
            String string = n3 > 0 ? this.token.substring(6, n3) : this.token.substring(6);
            Color color = null;
            String string2 = null;
            if (n3 > 0 && this.token.charAt(n3) == '#') {
                color = Color.decode(n4 > 0 ? this.token.substring(n3, n4) : this.token.substring(n3));
            }
            if (n4 > 0) {
                string2 = this.unescape(this.token.substring(n4 + 1));
            }
            this.graphDef.line(string, color, string2, n2);
        } else {
            this.token = n == 2 ? this.token.substring(6) : this.token.substring(5);
            int n5 = this.token.indexOf(35);
            int n6 = this.token.indexOf(58);
            String string = n5 > 0 ? this.token.substring(0, n5) : this.token.substring(0);
            Color color = null;
            String string3 = null;
            if (n5 > 0 && this.token.charAt(n5) == '#') {
                color = Color.decode(n6 > 0 ? this.token.substring(n5, n6) : this.token.substring(n5));
            }
            if (n6 > 0) {
                string3 = this.unescape(this.token.substring(n6 + 1));
            }
            if (n == 1) {
                this.graphDef.area(string, color, string3);
            } else if (n == 2) {
                this.graphDef.stack(string, color, string3);
            }
        }
    }

    private String unescape(String string) {
        if (string.startsWith("'") || string.startsWith("\"")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    private void parseTextCommand(int n) throws RrdException {
        int n2 = this.token.indexOf(58);
        if (n == 0) {
            String string = this.unescape(this.token.substring(n2 + 1));
            this.graphDef.comment(string);
        } else if (n == 1) {
            int n3 = this.token.indexOf(58, ++n2);
            String string = this.token.substring(n2, n3);
            n2 = this.token.indexOf(58, ++n3);
            String string2 = this.token.substring(n3, n2);
            String string3 = this.unescape(this.token.substring(n2 + 1));
        }
    }

    private void parseDatasource(int n) throws RrdException {
        int n2 = this.token.indexOf(58);
        int n3 = this.token.indexOf(61, ++n2);
        String string = this.token.substring(n2, n3);
        if (n == 0) {
            this.token = this.token.substring(n3 + 1);
            n2 = this.token.lastIndexOf(58);
            String string2 = this.token.substring(n2 + 1);
            n3 = this.token.lastIndexOf(58, n2 - 1);
            String string3 = this.token.substring(n3 + 1, n2);
            String string4 = this.token.substring(0, n3);
            this.graphDef.datasource(string, string4, string3, string2);
        } else {
            this.graphDef.datasource(string, this.token.substring(n3 + 1));
        }
    }

    private int nextToken() {
        char[] cArray = new char[512];
        int n = 0;
        int n2 = this.tokenPos;
        boolean bl = false;
        boolean bl2 = true;
        int n3 = 32;
        while (n < 512 && n2 < this.parseCmd.length && !bl) {
            if (this.parseCmd[n2] == '\"') {
                if (bl2) {
                    bl2 = false;
                    n3 = 34;
                } else if (n3 == 34 && this.parseCmd[n2 - 1] != '\\') {
                    bl2 = true;
                }
            } else if (this.parseCmd[n2] == '\'') {
                if (bl2) {
                    bl2 = false;
                    n3 = 39;
                } else if (n3 == 39 && this.parseCmd[n2 - 1] != '\\') {
                    bl2 = true;
                }
            }
            if (bl2 && this.parseCmd[n2] == ' ') {
                bl = true;
                continue;
            }
            cArray[n++] = this.parseCmd[n2++];
        }
        this.token = new String(cArray, 0, n).trim();
        this.tokenPos = n2 + 1;
        return n;
    }

    private int parseToken(String string) {
        if (string.equalsIgnoreCase("rrdtool")) {
            return 0;
        }
        if (string.equalsIgnoreCase("graph")) {
            return 1;
        }
        if (string.equalsIgnoreCase("--start") || string.equals("-s")) {
            return 2;
        }
        if (string.equalsIgnoreCase("--end") || string.equals("-e")) {
            return 3;
        }
        if (string.equalsIgnoreCase("--width") || string.equals("-w")) {
            return 26;
        }
        if (string.equalsIgnoreCase("--height") || string.equals("-h")) {
            return 27;
        }
        if (string.equalsIgnoreCase("--no-minor")) {
            return 30;
        }
        if (string.equalsIgnoreCase("--units-exponent") || string.equals("-X")) {
            return 29;
        }
        if (string.equalsIgnoreCase("--vertical-label") || string.equals("-v")) {
            return 28;
        }
        if (string.equalsIgnoreCase("--imgformat") || string.equals("-a")) {
            return 25;
        }
        if (string.equalsIgnoreCase("--background") || string.equals("-B")) {
            return 24;
        }
        if (string.equalsIgnoreCase("--overlay") || string.equals("-O")) {
            return 23;
        }
        if (string.equalsIgnoreCase("--title") || string.equals("-t")) {
            return 15;
        }
        if (string.equalsIgnoreCase("--step") || string.equals("-S")) {
            return 14;
        }
        if (string.equalsIgnoreCase("--no-legend") || string.equals("-g")) {
            return 16;
        }
        if (string.equalsIgnoreCase("--base") || string.equals("-b")) {
            return 33;
        }
        if (string.equalsIgnoreCase("--lower-limit") || string.equals("-l")) {
            return 19;
        }
        if (string.equalsIgnoreCase("--upper-limit") || string.equals("-u")) {
            return 20;
        }
        if (string.equalsIgnoreCase("--rigid") || string.equals("-r")) {
            return 18;
        }
        if (string.startsWith("COMMENT")) {
            return 4;
        }
        if (string.startsWith("GPRINT")) {
            return 11;
        }
        if (string.startsWith("LINE")) {
            return 5;
        }
        if (string.startsWith("AREA")) {
            return 6;
        }
        if (string.startsWith("STACK")) {
            return 7;
        }
        if (string.startsWith("HRULE")) {
            return 12;
        }
        if (string.startsWith("VRULE")) {
            return 13;
        }
        if (string.startsWith("CDEF")) {
            return 8;
        }
        if (string.startsWith("DEF")) {
            return 9;
        }
        if (string.equals("-Y") || string.equals("--alt-y-grid") || string.equals("-R") || string.equals("--alt-y-mrtg") || string.equals("-A") || string.equals("--alt-autoscale") || string.equals("-M") || string.equals("--alt-autoscale-max") || string.equals("-L") || string.equals("--units-length") || string.equals("-i") || string.equals("--interlaced") || string.equals("-f") || string.equals("--imginfo") || string.equals("-o") || string.equals("--logarithmic") || string.equals("-j") || string.equals("--only-graph") || string.equals("-F") || string.equals("--force-rules-legend") || string.startsWith("PRINT") || string.equals("-U") || string.startsWith("--unit")) {
            return -2;
        }
        return -1;
    }

    public static void main(String[] stringArray) throws Exception {
        String string = "rrdtool graph FNAME --start 100 --end 700\nDEF:inOctets=c:/file.rrd:test-run:AVERAGE CDEF:bitIn=inOctets,8,* COMMENT:'commentaar \"nr\" 1'\nAREA:test#ffa9b3:'this is the legend'\nCOMMENT:\"commentaar 'nr' 2\"\nLINE2:test2:'this is the legend two' GPRINT:bitIn:AVG:'Average %2.5'";
        RrdtoolGraph rrdtoolGraph = new RrdtoolGraph(string);
        rrdtoolGraph.getRrdGraphDef();
    }
}

