/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.videolan.BDJLoader;
import org.videolan.BDJXletContext;
import org.videolan.Logger;
import org.videolan.MountManager;

public class FileInputStream
extends InputStream {
    private FileDescriptor fd;
    private final Object closeLock = new Object();
    private volatile boolean closed = false;
    private static Logger logger = null;
    private int available = 0;
    private boolean useFdCount = false;

    public FileInputStream(File file) throws FileNotFoundException {
        SecurityManager security;
        String name;
        String string = name = file != null ? file.getPath() : null;
        if (name != null && name.startsWith("file:")) {
            int idx = name.indexOf(".jar!/");
            if (idx > 0 || (idx = name.indexOf(".jar!\\")) > 0) {
                try {
                    String mountPoint = MountManager.getMount(Integer.parseInt(name.substring(idx - 5, idx)));
                    if (mountPoint != null) {
                        name = mountPoint + name.substring(idx + 5);
                        FileInputStream.getLogger().info("Fixing invalid resource url " + file + " --> " + name);
                        file = new File(name);
                    }
                }
                catch (Exception e) {
                    FileInputStream.getLogger().error("" + e);
                }
            }
            if (name.startsWith("file:")) {
                System.err.println("ERROR: unresolved URL in FileInputStream: " + name);
            }
        }
        if ((security = System.getSecurityManager()) != null) {
            security.checkRead(name);
        }
        if (name == null) {
            throw new NullPointerException();
        }
        this.fd = new FileDescriptor();
        this.fdAttach();
        if (file.isAbsolute()) {
            String cachedName = BDJLoader.getCachedFile(name);
            if (cachedName != name) {
                FileInputStream.getLogger().info("Using cached " + cachedName + " for " + name);
                name = cachedName;
            }
            this.openImpl(name);
        } else {
            String home = BDJXletContext.getCurrentXletHome();
            if (home == null) {
                FileInputStream.getLogger().error("Xlet home directory not found for " + name + " at " + Logger.dumpStack());
                throw new FileNotFoundException(name);
            }
            this.openImpl(home + name);
        }
        this.available = 1024;
    }

    public FileInputStream(String name) throws FileNotFoundException {
        this(name != null ? new File(name) : null);
    }

    public FileInputStream(FileDescriptor fdObj) {
        SecurityManager security = System.getSecurityManager();
        if (fdObj == null) {
            throw new NullPointerException();
        }
        if (security != null) {
            security.checkRead(fdObj);
        }
        this.fd = fdObj;
        this.available = 1024;
        this.fdAttach();
    }

    private void openImpl(String name) throws FileNotFoundException {
        try {
            this.open0(name);
        }
        catch (UnsatisfiedLinkError e) {
            this.open(name);
        }
    }

    private native int readBytes(byte[] var1, int var2, int var3) throws IOException;

    private native int close0();

    private native void open(String var1) throws FileNotFoundException;

    private native void open0(String var1) throws FileNotFoundException;

    public int available() throws IOException {
        return this.available;
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        if (this.read(b) == 1) {
            return b[0];
        }
        return -1;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        int r = this.readBytes(b, off, len);
        if (r != len) {
            this.available = 0;
        }
        return r;
    }

    public long skip(long n) throws IOException {
        return super.skip(n);
    }

    public void close() throws IOException {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(boolean force) throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.available = 0;
        this.fdClose(force);
    }

    public final FileDescriptor getFD() throws IOException {
        if (this.fd == null) {
            throw new IOException();
        }
        return this.fd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Logger getLogger() {
        Class clazz = FileInputStream.class;
        synchronized (clazz) {
            if (logger == null) {
                logger = Logger.getLogger(FileInputStream.class.getName());
            }
            return logger;
        }
    }

    private static native void initIDs();

    protected void finalize() throws IOException {
        if (this.fd != null && this.fd != FileDescriptor.in) {
            this.close(false);
        }
    }

    private void fdAttach() {
        block6: {
            try {
                try {
                    this.fd.getClass().getDeclaredMethod("attach", Closeable.class).invoke((Object)this.fd, this);
                    return;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    try {
                        this.fd.getClass().getDeclaredMethod("incrementAndGetUseCount", new Class[0]).invoke((Object)this.fd, new Object[0]);
                        this.useFdCount = true;
                        return;
                    }
                    catch (NoSuchMethodException e) {
                        FileInputStream.getLogger().error("internal error in FileDescriptor usage");
                    }
                }
            }
            catch (Throwable t) {
                if (logger == null) break block6;
                logger.error("" + t);
            }
        }
    }

    private void closeImpl() throws IOException {
        try {
            this.fd.getClass().getDeclaredMethod("close", new Class[0]).invoke((Object)this.fd, new Object[0]);
            return;
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            FileInputStream.getLogger().error("" + t);
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new IOException();
        }
        catch (IllegalAccessException iae) {
            FileInputStream.getLogger().error("internal error in FileDescriptor usage: " + iae);
            return;
        }
        catch (NoSuchMethodException iae) {
            try {
                this.close0();
            }
            catch (UnsatisfiedLinkError no_close0) {
                FileInputStream.getLogger().error("internal error in FileDescriptor usage: " + no_close0);
            }
            return;
        }
    }

    private void fdClose(boolean force) throws IOException {
        try {
            if (this.useFdCount) {
                try {
                    Integer i = (Integer)this.fd.getClass().getDeclaredMethod("decrementAndGetUseCount", new Class[0]).invoke((Object)this.fd, new Object[0]);
                    if (i > 0 && !force) {
                        return;
                    }
                    this.closeImpl();
                }
                catch (NoSuchMethodException no_method) {
                    FileInputStream.getLogger().error("internal error in FileDescriptor usage: " + no_method);
                }
                return;
            }
            try {
                this.fd.getClass().getDeclaredMethod("closeAll", Closeable.class).invoke((Object)this.fd, new Closeable(){

                    public void close() throws IOException {
                        FileInputStream.this.closeImpl();
                    }
                });
                return;
            }
            catch (NoSuchMethodException no_closeAll) {
                FileInputStream.getLogger().error("internal error in FileDescriptor usage: " + no_closeAll);
            }
        }
        catch (IllegalAccessException iae) {
            FileInputStream.getLogger().error("internal error in FileDescriptor usage: " + iae);
            return;
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            FileInputStream.getLogger().error("" + t);
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new IOException();
        }
    }

    static {
        FileInputStream.initIDs();
    }
}

