/*
 * Decompiled with CFR 0.152.
 */
package org.videolan;

import java.awt.BDFontMetrics;
import java.awt.BDJHelper;
import java.awt.BDToolkit;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.media.PackageManager;
import javax.tv.service.SIManager;
import javax.tv.service.SIManagerImpl;
import javax.tv.service.selection.ServiceContextFactory;
import javax.tv.service.selection.ServiceContextFactoryImpl;
import org.bluray.bdplus.Status;
import org.bluray.net.BDLocator;
import org.bluray.ti.DiscManager;
import org.bluray.ti.TitleImpl;
import org.bluray.ti.selection.TitleContext;
import org.dvb.event.EventManager;
import org.dvb.io.ixc.IxcRegistry;
import org.dvb.ui.FontFactory;
import org.videolan.BDJActionManager;
import org.videolan.BDJClassLoaderAdapter;
import org.videolan.BDJLoader;
import org.videolan.BDJLoaderAdapter;
import org.videolan.BDJSecurityManager;
import org.videolan.BDJSocketFactory;
import org.videolan.BDJXletContext;
import org.videolan.CacheDir;
import org.videolan.GUIManager;
import org.videolan.Logger;
import org.videolan.MountManager;
import org.videolan.PlaylistInfo;
import org.videolan.TitleInfo;
import org.videolan.bdjo.Bdjo;
import org.videolan.media.content.PlayerManager;

public class Libbluray {
    private static boolean booted;
    private static BDJClassLoaderAdapter classLoaderAdapter;
    private static BDJLoaderAdapter loaderAdapter;
    private static boolean initOnce;
    private static Map bdjoFiles;
    private static Object bdjoFilesLock;
    private static final int BDJ_EVENT_START = 1;
    private static final int BDJ_EVENT_STOP = 2;
    private static final int BDJ_EVENT_PSR102 = 3;
    public static final int BDJ_EVENT_PLAYLIST = 4;
    public static final int BDJ_EVENT_PLAYITEM = 5;
    public static final int BDJ_EVENT_CHAPTER = 6;
    public static final int BDJ_EVENT_MARK = 7;
    public static final int BDJ_EVENT_PTS = 8;
    public static final int BDJ_EVENT_END_OF_PLAYLIST = 9;
    public static final int BDJ_EVENT_SEEK = 10;
    public static final int BDJ_EVENT_RATE = 11;
    public static final int BDJ_EVENT_ANGLE = 12;
    public static final int BDJ_EVENT_AUDIO_STREAM = 13;
    public static final int BDJ_EVENT_SUBTITLE = 14;
    public static final int BDJ_EVENT_SECONDARY_STREAM = 15;
    private static final int BDJ_EVENT_VK_KEY = 16;
    public static final int BDJ_EVENT_UO_MASKED = 17;
    private static final int BDJ_EVENT_MOUSE = 18;
    public static final int AACS_DISC_ID = 1;
    public static final int AACS_MEDIA_VID = 2;
    public static final int AACS_MEDIA_PMSN = 3;
    public static final int AACS_DEVICE_BINDING_ID = 4;
    public static final int AACS_DEVICE_NONCE = 5;
    public static final int AACS_MEDIA_KEY = 6;
    public static final int AACS_CONTENT_CERT_ID = 7;
    public static final int AACS_BDJ_ROOT_CERT_HASH = 8;
    private static long nativePointer;
    private static Object titleInfosLock;
    private static TitleInfo[] titleInfos;

    private static void hookProperties() {
        Properties p = new Properties(System.getProperties()){
            private static final long serialVersionUID = -6253354431747524430L;

            public String getProperty(String key) {
                if (key.equals("user.dir")) {
                    BDJXletContext ctx = BDJXletContext.getCurrentContext();
                    if (ctx != null) {
                        return ctx.getXletHome();
                    }
                    if (booted) {
                        System.err.println("getProperty(user.dir): no context !  " + Logger.dumpStack());
                    }
                }
                return super.getProperty(key);
            }
        };
        System.setProperties(p);
    }

    protected static BDJClassLoaderAdapter getClassLoaderAdapter() {
        return classLoaderAdapter;
    }

    protected static BDJLoaderAdapter getLoaderAdapter() {
        return loaderAdapter;
    }

    private static void loadAdapter(String pkg) {
        if (pkg == null) {
            return;
        }
        if (pkg.indexOf(59) > 0) {
            pkg = pkg.substring(0, pkg.indexOf(59));
        }
        try {
            Object obj = Class.forName("org.videolan." + pkg + ".Adapter").newInstance();
            if (!(obj instanceof BDJClassLoaderAdapter) && !(obj instanceof BDJLoaderAdapter)) {
                System.err.println("Unsupported interface in " + obj);
                return;
            }
            if (obj instanceof BDJLoaderAdapter) {
                loaderAdapter = (BDJLoaderAdapter)obj;
            }
            if (obj instanceof BDJClassLoaderAdapter) {
                classLoaderAdapter = (BDJClassLoaderAdapter)obj;
            }
        }
        catch (ClassNotFoundException ce) {
            System.out.println("" + ce);
        }
        catch (Exception e) {
            System.err.println("" + e);
        }
    }

    private static void initOnce() {
        if (initOnce) {
            return;
        }
        initOnce = true;
        try {
            Libbluray.hookProperties();
        }
        catch (Throwable t) {
            System.err.println("hookProperties() failed: " + t);
        }
        try {
            BDJSocketFactory.init();
        }
        catch (Throwable t) {
            System.err.println("Hooking socket factory failed: " + t + "\n" + Logger.dumpStack(t));
        }
    }

    private static String canonicalize(String path, boolean create) {
        try {
            File dir = new File(path);
            if (create && !dir.isDirectory() && !dir.mkdirs()) {
                System.err.println("error creating directory " + path);
            }
            return dir.getCanonicalPath();
        }
        catch (Exception ioe) {
            System.err.println("error canonicalizing " + path + ": " + ioe);
            return path;
        }
    }

    private static void removeProperty(String property) {
        try {
            System.getProperties().remove(property);
        }
        catch (Exception e) {
            System.err.println("" + e);
        }
    }

    private static void resetProfile() {
        Libbluray.removeProperty("bluray.profile.1");
        Libbluray.removeProperty("bluray.p1.version.major");
        Libbluray.removeProperty("bluray.p1.version.minor");
        Libbluray.removeProperty("bluray.p1.version.micro");
        Libbluray.removeProperty("bluray.profile.2");
        Libbluray.removeProperty("bluray.p2.version.major");
        Libbluray.removeProperty("bluray.p2.version.minor");
        Libbluray.removeProperty("bluray.p2.version.micro");
        Libbluray.removeProperty("bluray.profile.5");
        Libbluray.removeProperty("bluray.p5.version.major");
        Libbluray.removeProperty("bluray.p5.version.minor");
        Libbluray.removeProperty("bluray.p5.version.micro");
        Libbluray.removeProperty("bluray.profile.6");
        Libbluray.removeProperty("bluray.p6.version.major");
        Libbluray.removeProperty("bluray.p6.version.minor");
        Libbluray.removeProperty("bluray.p6.version.micro");
    }

    private static void init(long nativePointer, String discID, String discRoot, String persistentRoot, String budaRoot) {
        String pkg;
        Libbluray.initOnce();
        try {
            if (persistentRoot == null) {
                persistentRoot = CacheDir.create("dvb.persistent.root").getPath() + File.separator;
            }
            if (budaRoot == null) {
                budaRoot = CacheDir.create("bluray.bindingunit.root").getPath() + File.separator;
            }
        }
        catch (IOException e) {
            System.err.println("Cache creation failed: " + e);
        }
        if (persistentRoot != null) {
            persistentRoot = Libbluray.canonicalize(persistentRoot, true);
        }
        if (budaRoot != null) {
            budaRoot = Libbluray.canonicalize(budaRoot, true);
        }
        System.setProperty("dvb.persistent.root", persistentRoot);
        System.setProperty("bluray.bindingunit.root", budaRoot);
        if (discRoot != null) {
            discRoot = Libbluray.canonicalize(discRoot, false);
            System.setProperty("bluray.vfs.root", discRoot);
        } else {
            System.getProperties().remove("bluray.vfs.root");
        }
        Libbluray.nativePointer = nativePointer;
        DiscManager.getDiscManager().setCurrentDisc(discID);
        BDJActionManager.createInstance();
        Vector<String> prefix = new Vector<String>();
        prefix.add("org.videolan");
        PackageManager.setContentPrefixList(prefix);
        PackageManager.setProtocolPrefixList(prefix);
        PackageManager.commitContentPrefixList();
        PackageManager.commitProtocolPrefixList();
        try {
            BDFontMetrics.init();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        byte[] type = Libbluray.getAacsData(4096);
        try {
            String string = pkg = type != null ? new String(type, "UTF-8") : null;
            if (pkg != null) {
                System.out.println("using " + pkg);
            }
        }
        catch (UnsupportedEncodingException uee) {
            pkg = null;
        }
        System.setProperty("mhp.profile.enhanced_broadcast", "YES");
        System.setProperty("mhp.profile.interactive_broadcast", "YES");
        System.setProperty("mhp.profile.internet_access", "YES");
        System.setProperty("mhp.eb.version.major", "1");
        System.setProperty("mhp.eb.version.minor", "0");
        System.setProperty("mhp.eb.version.micro", "3");
        System.setProperty("mhp.ia.version.major", "1");
        System.setProperty("mhp.ia.version.minor", "0");
        System.setProperty("mhp.ia.version.micro", "3");
        System.setProperty("mhp.ib.version.major", "1");
        System.setProperty("mhp.ib.version.minor", "0");
        System.setProperty("mhp.ib.version.micro", "3");
        System.setProperty("mhp.option.ip.multicast", "UNSUPPORTED");
        System.setProperty("mhp.option.dsmcc.uu", "UNSUPPORTED");
        System.setProperty("mhp.option.dvb.html", "UNSUPPORTED");
        System.setProperty("dvb.returnchannel.timeout", "30");
        int psr31 = Libbluray.readPSR(31);
        int version = psr31 & 0xFFFF;
        int profile = psr31 >> 16;
        boolean p11 = (profile & 1) != 0;
        boolean p2 = (profile & 2) != 0;
        boolean p5 = (profile & 0x10) != 0;
        boolean p6 = (profile & 0x1F) == 0 && version >= 768;
        Libbluray.resetProfile();
        if (!p6) {
            System.setProperty("bluray.profile.1", "YES");
            System.setProperty("bluray.p1.version.major", "1");
            System.setProperty("bluray.p1.version.minor", p11 ? "1" : "0");
            System.setProperty("bluray.p1.version.micro", "0");
            System.setProperty("bluray.profile.2", p2 ? "YES" : "NO");
            System.setProperty("bluray.p2.version.major", "1");
            System.setProperty("bluray.p2.version.minor", "0");
            System.setProperty("bluray.p2.version.micro", "0");
        }
        if (p5) {
            System.setProperty("bluray.profile.5", "YES");
            System.setProperty("bluray.p5.version.major", "1");
            System.setProperty("bluray.p5.version.minor", "0");
            System.setProperty("bluray.p5.version.micro", "0");
        }
        if (p6) {
            System.setProperty("bluray.profile.6", "YES");
            System.setProperty("bluray.p6.version.major", "1");
            System.setProperty("bluray.p6.version.minor", "0");
            System.setProperty("bluray.p6.version.micro", "0");
        }
        System.setProperty("bluray.disc.avplayback.readcapability", "NO");
        System.setProperty("bluray.video.fullscreenSD", "YES");
        System.setProperty("bluray.video.fullscreenSDPG", "YES");
        System.setProperty("bluray.DynamicRangeConversion.Level", "0");
        System.setProperty("aacs.bluray.online.capability", "YES");
        System.setProperty("aacs.bluray.mc.capability", "NO");
        System.setProperty("bluray.prefetchedplaylistloading", "NO");
        System.setProperty("bluray.video.autoresume", "NO");
        System.setProperty("bluray.mediaselect", "NO");
        System.setProperty("bluray.event.extension", "YES");
        System.setProperty("bluray.jmf.subtitlestyle", "YES");
        System.setProperty("bluray.rccapability.release", "YES");
        System.setProperty("bluray.rccapability.holdandrelease", "YES");
        System.setProperty("bluray.rccapability.repeatonhold", "NO");
        System.setProperty("bluray.localstorage.level", "5");
        System.setProperty("bluray.localstorage.maxlevel", "5");
        System.setProperty("bluray.localstorage.removable", "NO");
        System.setProperty("bluray.localstorage.upgradable", "NO");
        System.setProperty("bluray.localstorage.name", "HDD");
        System.setProperty("bluray.memory.images", "131072");
        System.setProperty("bluray.memory.audio", "8192");
        System.setProperty("bluray.memory.audio_plus_img", "139264");
        System.setProperty("bluray.memory.java_heap", "32768");
        System.setProperty("bluray.memory.font_cache", "4096");
        System.setProperty("bluray.network.connected", "YES");
        try {
            System.setSecurityManager(new BDJSecurityManager(discRoot, persistentRoot, budaRoot));
        }
        catch (Exception ex) {
            System.err.println("System.setSecurityManager() failed: " + ex);
            throw new SecurityException("Failed initializing SecurityManager");
        }
        Libbluray.loadAdapter(System.getProperty("org.videolan.loader.adapter"));
        Libbluray.loadAdapter(pkg);
        booted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void shutdown() {
        if (nativePointer == 0L) {
            return;
        }
        try {
            Libbluray.stopTitle(true);
            BDJLoader.shutdown();
            BDJActionManager.shutdown();
            try {
                System.setSecurityManager(null);
            }
            catch (Exception ex) {
                System.err.println("System.setSecurityManager(null) failed: " + ex);
            }
            MountManager.unmountAll();
            GUIManager.shutdown();
            BDToolkit.shutdownDisc();
            BDFontMetrics.shutdown();
            SIManagerImpl.shutdown();
            IxcRegistry.shutdown();
            EventManager.shutdown();
            Status.shutdown();
            ServiceContextFactoryImpl.shutdown();
            FontFactory.unloadDiscFonts();
            CacheDir.remove();
        }
        catch (Throwable e) {
            System.err.println("shutdown() failed: " + e + "\n" + Logger.dumpStack(e));
        }
        nativePointer = 0L;
        Object object = titleInfosLock;
        synchronized (object) {
            titleInfos = null;
        }
        object = bdjoFilesLock;
        synchronized (object) {
            bdjoFiles = null;
        }
        classLoaderAdapter = null;
        loaderAdapter = null;
        booted = false;
    }

    protected static boolean selectHdmvTitle(int title) {
        return Libbluray.selectTitleN(nativePointer, title) == 1;
    }

    protected static boolean cacheBdRomFile(String path, String cachePath) {
        return Libbluray.cacheBdRomFileN(nativePointer, path, cachePath) == 0;
    }

    protected static void setUOMask(boolean menuCallMask, boolean titleSearchMask) {
        Libbluray.setUOMaskN(nativePointer, menuCallMask, titleSearchMask);
    }

    protected static void setKeyInterest(int mask) {
        Libbluray.setKeyInterestN(nativePointer, mask);
    }

    protected static int setVirtualPackage(String vpPath, boolean initBackupRegs) {
        return Libbluray.setVirtualPackageN(nativePointer, vpPath, initBackupRegs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int numTitles() {
        Object object = titleInfosLock;
        synchronized (object) {
            if (titleInfos == null && (titleInfos = Libbluray.getTitleInfosN(nativePointer)) == null) {
                return -1;
            }
            return titleInfos.length - 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TitleInfo getTitleInfo(int titleNum) {
        Object object = titleInfosLock;
        synchronized (object) {
            int numTitles = Libbluray.numTitles();
            if (numTitles < 0) {
                return null;
            }
            if (titleNum == 65535) {
                return titleInfos[titleInfos.length - 1];
            }
            if (titleNum < 0 || titleNum > numTitles) {
                throw new IllegalArgumentException();
            }
            return titleInfos[titleNum];
        }
    }

    public static int getCurrentTitle() {
        return Libbluray.readPSR(4);
    }

    public static byte[] getAacsData(int type) {
        return Libbluray.getAacsDataN(nativePointer, type);
    }

    public static PlaylistInfo getPlaylistInfo(int playlist) {
        return Libbluray.getPlaylistInfoN(nativePointer, playlist);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bdjo getBdjo(String name) {
        Object object = bdjoFilesLock;
        synchronized (object) {
            Bdjo bdjo;
            if (bdjoFiles == null) {
                bdjoFiles = new HashMap();
            } else {
                bdjo = (Bdjo)bdjoFiles.get(name);
                if (bdjo != null) {
                    return bdjo;
                }
            }
            bdjo = Libbluray.getBdjoN(nativePointer, name + ".bdjo");
            if (bdjo != null) {
                bdjoFiles.put(name, bdjo);
            }
            return bdjo;
        }
    }

    public static String[] listBdFiles(String path, boolean onlyBdRom) {
        return Libbluray.listBdFilesN(nativePointer, path, onlyBdRom);
    }

    public static boolean selectPlaylist(int playlist, int playitem, int playmark, long time) {
        if (playlist < 0) {
            throw new IllegalArgumentException("Playlist cannot be negative");
        }
        return Libbluray.selectPlaylistN(nativePointer, playlist, playitem, playmark, time) == 1;
    }

    public static boolean selectPlaylist(int playlist) {
        return Libbluray.selectPlaylist(playlist, -1, -1, -1L);
    }

    public static void stopPlaylist() {
        Libbluray.selectPlaylistN(nativePointer, -1, -1, -1, -1L);
    }

    public static long seekTime(long tick) {
        return Libbluray.seekN(nativePointer, -1, -1, tick);
    }

    public static long seekMark(int mark) {
        if (mark < 0) {
            throw new IllegalArgumentException("Mark cannot be negative");
        }
        long result = Libbluray.seekN(nativePointer, -1, mark, -1L);
        if (result == -1L) {
            throw new IllegalArgumentException("Seek error");
        }
        return result;
    }

    public static long seekPlayItem(int clip) {
        if (clip < 0) {
            throw new IllegalArgumentException("Mark cannot be negative");
        }
        long result = Libbluray.seekN(nativePointer, clip, -1, -1L);
        if (result == -1L) {
            throw new IllegalArgumentException("Seek error");
        }
        return result;
    }

    public static boolean selectAngle(int angle) {
        if (angle < 1) {
            throw new IllegalArgumentException("Angle cannot be negative");
        }
        return Libbluray.selectAngleN(nativePointer, angle) == 1;
    }

    public static int soundEffect(int id) {
        return Libbluray.soundEffectN(nativePointer, id);
    }

    public static int getCurrentAngle() {
        return Libbluray.readPSR(3);
    }

    public static long getUOMask() {
        return Libbluray.getUOMaskN(nativePointer);
    }

    public static long tellTime() {
        return Libbluray.tellTimeN(nativePointer);
    }

    public static boolean selectRate(float rate) {
        return Libbluray.selectRateN(nativePointer, rate, 0) == 1;
    }

    public static boolean selectRate(float rate, boolean start) {
        return Libbluray.selectRateN(nativePointer, rate, start ? 1 : 2) == 1;
    }

    public static void writeGPR(int num, int value) {
        int ret = Libbluray.writeRegN(nativePointer, 0, num, value, -1);
        if (ret == -1) {
            throw new IllegalArgumentException("Invalid GPR");
        }
    }

    public static void writePSR(int num, int value) {
        Libbluray.writePSR(num, value, -1);
    }

    public static void writePSR(int num, int value, int psr_value_mask) {
        int ret = Libbluray.writeRegN(nativePointer, 1, num, value, psr_value_mask);
        if (ret == -1) {
            throw new IllegalArgumentException("Invalid PSR");
        }
    }

    public static int readGPR(int num) {
        if (num < 0 || num >= 4096) {
            throw new IllegalArgumentException("Invalid GPR");
        }
        return Libbluray.readRegN(nativePointer, 0, num);
    }

    public static int readPSR(int num) {
        if (num < 0 || num >= 128) {
            throw new IllegalArgumentException("Invalid PSR");
        }
        return Libbluray.readRegN(nativePointer, 1, num);
    }

    public static void updateGraphic(int width, int height, int[] rgbArray) {
        Libbluray.updateGraphicN(nativePointer, width, height, rgbArray, 0, 0, width - 1, height - 1);
    }

    public static void updateGraphic(int width, int height, int[] rgbArray, int x0, int y0, int x1, int y1) {
        Libbluray.updateGraphicN(nativePointer, width, height, rgbArray, x0, y0, x1, y1);
    }

    private static boolean startTitle(int titleNumber) {
        TitleContext titleContext = null;
        try {
            BDLocator locator = new BDLocator(null, titleNumber, -1);
            TitleImpl title = (TitleImpl)SIManager.createInstance().getService(locator);
            if (title == null) {
                System.err.println("startTitle() failed: title " + titleNumber + " not found");
                return false;
            }
            titleContext = (TitleContext)ServiceContextFactory.getInstance().getServiceContext(null);
            titleContext.start(title, true);
            return true;
        }
        catch (Throwable e) {
            System.err.println("startTitle() failed: " + e + "\n" + Logger.dumpStack(e));
            return false;
        }
    }

    private static boolean stopTitle(boolean shutdown) {
        TitleContext titleContext = null;
        try {
            titleContext = (TitleContext)ServiceContextFactory.getInstance().getServiceContext(null);
            if (shutdown) {
                titleContext.destroy();
            } else {
                titleContext.stop();
            }
            return true;
        }
        catch (Throwable e) {
            System.err.println("stopTitle() failed: " + e + "\n" + Logger.dumpStack(e));
            return false;
        }
    }

    private static boolean processEventImpl(int event, int param) {
        boolean result = true;
        int key = 0;
        switch (event) {
            case 1: {
                return Libbluray.startTitle(param);
            }
            case 2: {
                return Libbluray.stopTitle(false);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                result = PlayerManager.getInstance().onEvent(event, param);
                break;
            }
            case 3: {
                Status.getInstance().receive(param);
                break;
            }
            case 16: {
                switch (param) {
                    case 0: {
                        key = 48;
                        break;
                    }
                    case 1: {
                        key = 49;
                        break;
                    }
                    case 2: {
                        key = 50;
                        break;
                    }
                    case 3: {
                        key = 51;
                        break;
                    }
                    case 4: {
                        key = 52;
                        break;
                    }
                    case 5: {
                        key = 53;
                        break;
                    }
                    case 6: {
                        key = 54;
                        break;
                    }
                    case 7: {
                        key = 55;
                        break;
                    }
                    case 8: {
                        key = 56;
                        break;
                    }
                    case 9: {
                        key = 57;
                        break;
                    }
                    case 11: {
                        key = 461;
                        break;
                    }
                    case 12: {
                        key = 38;
                        break;
                    }
                    case 13: {
                        key = 40;
                        break;
                    }
                    case 14: {
                        key = 37;
                        break;
                    }
                    case 15: {
                        key = 39;
                        break;
                    }
                    case 16: {
                        key = 10;
                        break;
                    }
                    case 403: {
                        key = 403;
                        break;
                    }
                    case 404: {
                        key = 404;
                        break;
                    }
                    case 405: {
                        key = 405;
                        break;
                    }
                    case 406: {
                        key = 406;
                        break;
                    }
                    case 17: {
                        result = BDJHelper.postMouseEvent((int)0);
                        key = -1;
                        break;
                    }
                    default: {
                        key = -1;
                        result = false;
                    }
                }
                if (key <= 0) break;
                boolean r1 = EventManager.getInstance().receiveKeyEventN(401, 0, key);
                boolean r2 = EventManager.getInstance().receiveKeyEventN(400, 0, key);
                boolean r3 = EventManager.getInstance().receiveKeyEventN(402, 0, key);
                result = r1 || r2 || r3;
                break;
            }
            case 18: {
                result = BDJHelper.postMouseEvent((int)(param >> 16), (int)(param & 0xFFFF));
                break;
            }
            default: {
                System.err.println("Unknown event " + event + "." + param);
                result = false;
            }
        }
        return result;
    }

    private static boolean processEvent(int event, int param) {
        try {
            return Libbluray.processEventImpl(event, param);
        }
        catch (Throwable e) {
            System.err.println("processEvent() failed: " + e + "\n" + Logger.dumpStack(e));
            return false;
        }
    }

    private static native byte[] getAacsDataN(long var0, int var2);

    private static native TitleInfo[] getTitleInfosN(long var0);

    private static native PlaylistInfo getPlaylistInfoN(long var0, int var2);

    private static native long seekN(long var0, int var2, int var3, long var4);

    private static native int selectPlaylistN(long var0, int var2, int var3, int var4, long var5);

    private static native int selectTitleN(long var0, int var2);

    private static native int selectAngleN(long var0, int var2);

    private static native int soundEffectN(long var0, int var2);

    private static native long getUOMaskN(long var0);

    private static native void setUOMaskN(long var0, boolean var2, boolean var3);

    private static native void setKeyInterestN(long var0, int var2);

    private static native long tellTimeN(long var0);

    private static native int selectRateN(long var0, float var2, int var3);

    private static native int writeRegN(long var0, int var2, int var3, int var4, int var5);

    private static native int readRegN(long var0, int var2, int var3);

    private static native int setVirtualPackageN(long var0, String var2, boolean var3);

    private static native int cacheBdRomFileN(long var0, String var2, String var3);

    private static native String[] listBdFilesN(long var0, String var2, boolean var3);

    private static native Bdjo getBdjoN(long var0, String var2);

    private static native void updateGraphicN(long var0, int var2, int var3, int[] var4, int var5, int var6, int var7, int var8);

    static {
        classLoaderAdapter = null;
        loaderAdapter = null;
        initOnce = false;
        bdjoFiles = null;
        bdjoFilesLock = new Object();
        nativePointer = 0L;
        titleInfosLock = new Object();
        titleInfos = null;
    }
}

