/*
 * Decompiled with CFR 0.152.
 */
package javax.media.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PullSourceStream;

class URLSourceStream
implements PullSourceStream {
    protected URLConnection conn;
    protected InputStream stream;
    protected boolean eosReached;
    ContentDescriptor contentType;

    public URLSourceStream(URLConnection conn, ContentDescriptor type) throws IOException {
        this.conn = conn;
        this.stream = conn.getInputStream();
        this.eosReached = false;
        this.contentType = type;
    }

    public ContentDescriptor getContentDescriptor() {
        return this.contentType;
    }

    public boolean willReadBlock() {
        if (this.eosReached) {
            return true;
        }
        try {
            return this.stream.available() == 0;
        }
        catch (IOException iOException) {
            return true;
        }
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        int bytesRead = this.stream.read(buffer, offset, length);
        if (bytesRead == -1) {
            this.eosReached = true;
        }
        return bytesRead;
    }

    public void close() throws IOException {
        this.stream.close();
    }

    public boolean endOfStream() {
        return this.eosReached;
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public Object getControl(String controlName) {
        return null;
    }

    public long getContentLength() {
        return this.conn.getContentLength();
    }
}

