/*
 * Decompiled with CFR 0.152.
 */
package org.dvb.lang;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.SecureClassLoader;
import java.util.Enumeration;
import java.util.jar.Manifest;
import org.dvb.lang.DVBClassLoaderImpl;

public abstract class DVBClassLoader
extends SecureClassLoader {
    protected DVBURLClassLoader loader;

    public static DVBClassLoader newInstance(URL[] urls) {
        return new DVBClassLoaderImpl(urls);
    }

    public static DVBClassLoader newInstance(URL[] urls, ClassLoader parent) {
        return new DVBClassLoaderImpl(urls, parent);
    }

    public DVBClassLoader(URL[] urls) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkCreateClassLoader();
        }
        this.loader = new DVBURLClassLoader(urls);
    }

    public DVBClassLoader(URL[] urls, ClassLoader parent) {
        super(parent);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkCreateClassLoader();
        }
        this.loader = new DVBURLClassLoader(urls, parent);
    }

    public Class findClass(String name) throws ClassNotFoundException {
        return this.loader.findClass(name);
    }

    protected Package definePackage(String name, Manifest man, URL url) throws IllegalArgumentException {
        return this.loader.definePackage(name, man, url);
    }

    protected URL findResource(String name) {
        return this.loader.findResource(name);
    }

    protected Enumeration findResources(String name) throws IOException {
        return this.loader.findResources(name);
    }

    protected PermissionCollection getPermissions(CodeSource codesource) {
        return this.loader.getPermissions(codesource);
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.loader.loadClass(name, resolve);
    }

    protected class DVBURLClassLoader
    extends URLClassLoader {
        public DVBURLClassLoader(URL[] urls) {
            super(urls);
        }

        public DVBURLClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        protected Class findClass(String name) throws ClassNotFoundException {
            return super.findClass(name);
        }

        protected Package definePackage(String name, Manifest man, URL url) throws IllegalArgumentException {
            return super.definePackage(name, man, url);
        }

        protected PermissionCollection getPermissions(CodeSource codesource) {
            return super.getPermissions(codesource);
        }

        protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            return super.loadClass(name, resolve);
        }
    }
}

