/****************************************************************************
** libmatroska : parse Matroska files, see http://www.matroska.org/
**
** <file/class MATROSKA_DLL_API description>
**
** Copyright (C) 2002-2004 Steve Lhomme.  All rights reserved.
**
** This file is part of libmatroska.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding an other license may use this file in accordance with 
** the Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.matroska.org/license/qpl/ for QPL licensing information.
** See http://www.matroska.org/license/gpl/ for GPL licensing information.
**
** Contact license@matroska.org if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

/*!
	\file
	\version \$Id: KaxChapters.h,v 1.8 2004/01/17 21:40:47 mosu Exp $
	\author Steve Lhomme     <robux4 @ users.sf.net>
*/
#ifndef LIBMATROSKA_CHAPTERS_H
#define LIBMATROSKA_CHAPTERS_H

#include "matroska/KaxTypes.h"
#include "ebml/EbmlMaster.h"
#include "ebml/EbmlUInteger.h"
#include "ebml/EbmlUnicodeString.h"
#include "ebml/EbmlString.h"

using namespace LIBEBML_NAMESPACE;

START_LIBMATROSKA_NAMESPACE

class MATROSKA_DLL_API KaxChapters : public EbmlMaster {
	public:
		KaxChapters();
		KaxChapters(const KaxChapters & ElementToClone) :EbmlMaster(ElementToClone) {}
		static EbmlElement & Create() {return *(new KaxChapters);}
		const EbmlCallbacks & Generic() const {return ClassInfos;}
		static const EbmlCallbacks ClassInfos;
		operator const EbmlId &() const {return ClassInfos.GlobalId;}
		EbmlElement * Clone() const {return new KaxChapters(*this);}
};

class MATROSKA_DLL_API KaxEditionEntry : public EbmlMaster {
	public:
		KaxEditionEntry();
		KaxEditionEntry(const KaxEditionEntry & ElementToClone) :EbmlMaster(ElementToClone) {}
		static EbmlElement & Create() {return *(new KaxEditionEntry);}
		const EbmlCallbacks & Generic() const {return ClassInfos;}
		static const EbmlCallbacks ClassInfos;
		operator const EbmlId &() const {return ClassInfos.GlobalId;}
		EbmlElement * Clone() const {return new KaxEditionEntry(*this);}
};

class MATROSKA_DLL_API KaxChapterAtom : public EbmlMaster {
public:
    KaxChapterAtom();
	KaxChapterAtom(const KaxChapterAtom & ElementToClone) :EbmlMaster(ElementToClone) {}
    static EbmlElement & Create() {return *(new KaxChapterAtom);}
    const EbmlCallbacks & Generic() const {return ClassInfos;}
    static const EbmlCallbacks ClassInfos;
    operator const EbmlId &() const {return ClassInfos.GlobalId;}
	EbmlElement * Clone() const {return new KaxChapterAtom(*this);}
};

class MATROSKA_DLL_API KaxChapterUID : public EbmlUInteger {
public:
    KaxChapterUID() {}
	KaxChapterUID(const KaxChapterUID & ElementToClone) :EbmlUInteger(ElementToClone) {}
    static EbmlElement & Create() {return *(new KaxChapterUID);}
    const EbmlCallbacks & Generic() const {return ClassInfos;}
    static const EbmlCallbacks ClassInfos;
    operator const EbmlId &() const {return ClassInfos.GlobalId;}
	EbmlElement * Clone() const {return new KaxChapterUID(*this);}
};

class MATROSKA_DLL_API KaxChapterTimeStart : public EbmlUInteger {
public:
    KaxChapterTimeStart() {}
	KaxChapterTimeStart(const KaxChapterTimeStart & ElementToClone) :EbmlUInteger(ElementToClone) {}
    static EbmlElement & Create() {return *(new KaxChapterTimeStart);}
    const EbmlCallbacks & Generic() const {return ClassInfos;}
    static const EbmlCallbacks ClassInfos;
    operator const EbmlId &() const {return ClassInfos.GlobalId;}
	EbmlElement * Clone() const {return new KaxChapterTimeStart(*this);}
};

class MATROSKA_DLL_API KaxChapterTimeEnd : public EbmlUInteger {
public:
    KaxChapterTimeEnd() {}
	KaxChapterTimeEnd(const KaxChapterTimeEnd & ElementToClone) :EbmlUInteger(ElementToClone) {}
    static EbmlElement & Create() {return *(new KaxChapterTimeEnd);}
    const EbmlCallbacks & Generic() const {return ClassInfos;}
    static const EbmlCallbacks ClassInfos;
    operator const EbmlId &() const {return ClassInfos.GlobalId;}
	EbmlElement * Clone() const {return new KaxChapterTimeEnd(*this);}
};

class MATROSKA_DLL_API KaxChapterFlagHidden : public EbmlUInteger {
public:
	KaxChapterFlagHidden(): EbmlUInteger(0) {}
	KaxChapterFlagHidden(const KaxChapterFlagHidden & ElementToClone) :EbmlUInteger(ElementToClone) {}
	static EbmlElement & Create() {return *(new KaxChapterFlagHidden);}
	const EbmlCallbacks & Generic() const {return ClassInfos;}
	static const EbmlCallbacks ClassInfos;
	operator const EbmlId &() const {return ClassInfos.GlobalId;}
	EbmlElement * Clone() const {return new KaxChapterFlagHidden(*this);}
};

class MATROSKA_DLL_API KaxChapterFlagEnabled : public EbmlUInteger {
public:
	KaxChapterFlagEnabled(): EbmlUInteger(1) {}
	KaxChapterFlagEnabled(const KaxChapterFlagEnabled & ElementToClone) :EbmlUInteger(ElementToClone) {}
	static EbmlElement & Create() {return *(new KaxChapterFlagEnabled);}
	const EbmlCallbacks & Generic() const {return ClassInfos;}
	static const EbmlCallbacks ClassInfos;
	operator const EbmlId &() const {return ClassInfos.GlobalId;}
	EbmlElement * Clone() const {return new KaxChapterFlagEnabled(*this);}
};

class MATROSKA_DLL_API KaxChapterTrack : public EbmlMaster {
public:
    KaxChapterTrack();
	KaxChapterTrack(const KaxChapterTrack & ElementToClone) :EbmlMaster(ElementToClone) {}
    static EbmlElement & Create() {return *(new KaxChapterTrack);}
    const EbmlCallbacks & Generic() const {return ClassInfos;}
    static const EbmlCallbacks ClassInfos;
    operator const EbmlId &() const {return ClassInfos.GlobalId;}
	EbmlElement * Clone() const {return new KaxChapterTrack(*this);}
};

class MATROSKA_DLL_API KaxChapterTrackNumber : public EbmlUInteger {
public:
    KaxChapterTrackNumber() {}
	KaxChapterTrackNumber(const KaxChapterTrackNumber & ElementToClone) :EbmlUInteger(ElementToClone) {}
    static EbmlElement & Create() {return *(new KaxChapterTrackNumber);}
    const EbmlCallbacks & Generic() const {return ClassInfos;}
    static const EbmlCallbacks ClassInfos;
    operator const EbmlId &() const {return ClassInfos.GlobalId;}
	EbmlElement * Clone() const {return new KaxChapterTrackNumber(*this);}
};

class MATROSKA_DLL_API KaxChapterDisplay : public EbmlMaster {
public:
    KaxChapterDisplay();
	KaxChapterDisplay(const KaxChapterDisplay & ElementToClone) :EbmlMaster(ElementToClone) {}
    static EbmlElement & Create() {return *(new KaxChapterDisplay);}
    const EbmlCallbacks & Generic() const {return ClassInfos;}
    static const EbmlCallbacks ClassInfos;
    operator const EbmlId &() const {return ClassInfos.GlobalId;}
	EbmlElement * Clone() const {return new KaxChapterDisplay(*this);}
};

class MATROSKA_DLL_API KaxChapterString : public EbmlUnicodeString {
public:
    KaxChapterString() {}
	KaxChapterString(const KaxChapterString & ElementToClone) :EbmlUnicodeString(ElementToClone) {}
    static EbmlElement & Create() {return *(new KaxChapterString);}
    const EbmlCallbacks & Generic() const {return ClassInfos;}
    static const EbmlCallbacks ClassInfos;
    operator const EbmlId &() const {return ClassInfos.GlobalId;}
	EbmlElement * Clone() const {return new KaxChapterString(*this);}
};

class MATROSKA_DLL_API KaxChapterLanguage : public EbmlString {
public:
    KaxChapterLanguage() :EbmlString("eng") {}
	KaxChapterLanguage(const KaxChapterLanguage & ElementToClone) :EbmlString(ElementToClone) {}
    static EbmlElement & Create() {return *(new KaxChapterLanguage);}
    const EbmlCallbacks & Generic() const {return ClassInfos;}
    static const EbmlCallbacks ClassInfos;
    operator const EbmlId &() const {return ClassInfos.GlobalId;}
	EbmlElement * Clone() const {return new KaxChapterLanguage(*this);}
};

class MATROSKA_DLL_API KaxChapterCountry : public EbmlString {
public:
    KaxChapterCountry() :EbmlString() {}
	KaxChapterCountry(const KaxChapterCountry & ElementToClone) :EbmlString(ElementToClone) {}
    static EbmlElement & Create() {return *(new KaxChapterCountry);}
    const EbmlCallbacks & Generic() const {return ClassInfos;}
    static const EbmlCallbacks ClassInfos;
    operator const EbmlId &() const {return ClassInfos.GlobalId;}
	EbmlElement * Clone() const {return new KaxChapterCountry(*this);}
};

END_LIBMATROSKA_NAMESPACE

#endif // LIBMATROSKA_CHAPTERS_H
