// Winamp test visualization library v1.0
// Copyright (C) 1997-1998, Justin Frankel/Nullsoft
// Feel free to base any plugins on this "framework"...

#include <windows.h>
#include <process.h>

#include "vis.h"
#include "resource.h"

#include "..\goom_core.h"
#include "tinyptc.h"
#include "gmtimer.h"
#include "frame_rate_tester.h"

//extern int ptc_open_fs(char *title,int width,int height);
//extern int ptc_update_fs(void *buffer);
//extern void ptc_close_fs();

char szAppName[] = "What A Goom!"; // Our window class, etc

// configuration declarations
int config_x=50, config_y=50;	// screen X position and Y position, repsectively
void config_read(struct winampVisModule *this_mod);		// reads the configuration
void config_write(struct winampVisModule *this_mod);	// writes the configuration
void config_getinifn(struct winampVisModule *this_mod, char *ini_file); // makes the .ini file filename

// returns a winampVisModule when requested. Used in hdr, below
winampVisModule *getModule(int which);

// "member" functions
void config(struct winampVisModule *this_mod); // configuration dialog
int init_goom(struct winampVisModule *this_mod);	   // initialization for module
int render_goom(struct winampVisModule *this_mod);  // rendering for module 1
void quit(struct winampVisModule *this_mod);   // deinitialization for module



// Module header, includes version, description, and address of the module retriever function
winampVisHeader hdr = { VIS_HDRVER, "What A Goom! v1.99.4", getModule };

#define MINXVEL  240              
#define MINYVEL  160              
#define MAXXVEL  800
#define MAXYVEL  600
#define DEFXVEL  320             
#define DEFYVEL  240
#define DEFCSCOPE 0             

static visGoomData permVG =
{
0,
FALSE,
0,
0,
DEFXVEL,
DEFYVEL,
DEFCSCOPE,
"",
"",
NULL
};

winampVisModule goom_mod =
{
	"What A Goom!",
	NULL,	// hwndParent
	NULL,	// hDllInstance
	0,		// sRate
	0,		// nCh
	25,		// latencyMS
	25,		// delayMS
	0,		// spectrumNch
	2,		// waveformNch
	{ 0, },	// spectrumData
	{ 0, },	// waveformData
	config,
	init_goom,
	render_goom, 
	quit,
	&permVG
};



// this is the only exported symbol. returns our main header.
// if you are compiling C++, the extern "C" { is necessary, so we just #ifdef it
#ifdef __cplusplus
extern "C" {
#endif
__declspec( dllexport ) winampVisHeader *winampVisGetHeader()
{
	return &hdr;
}
#ifdef __cplusplus
}
#endif


// getmodule routine from the main header. Returns NULL if an invalid module was requested,
// otherwise returns either mod1, mod2 or mod3 depending on 'which'.
winampVisModule *getModule(int which)
{
	switch (which)
	{
		case 0: return &goom_mod;
		default:return NULL;
	}
}



static CHAR szXres[] = "GOOMXres";
static CHAR szYres[] = "GOOMYres";
static CHAR szCScope[] = "GOOMCScope";
static CHAR szCFPS[] = "GOOMCFPS";
static CHAR szCTitle[] = "GOOMCTitle";
static CHAR szFPSLim[] = "GOOMFPSLim";

extern char *readme();
static struct winampVisModule *this_mod_config;

static BOOL bChangeUpdate;
BOOL WINAPI VisGoomConfigureDialog(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
//        return TRUE;
	static CHAR szTemp[32];
    static HWND hXres; 
    static HWND hYres; 
    static HWND hXlab; 
    static HWND hYlab; 
	static HWND hCScope;
	static HWND hlim;
	static HWND hCFPS;
	static HWND hCTitle;

	static LONG lXresTmp;
	static LONG lYresTmp;
	visGoomData *vg = (visGoomData *)this_mod_config->userData;

    LONG *pVar;

    switch(message) 
    { 
        case WM_INITDIALOG: 
 
            config_read(this_mod_config);
			lXresTmp = vg->lXres;
			lYresTmp = vg->lYres;

            hXlab = GetDlgItem(hDlg, IDC_XRESLAB); 
            hYlab = GetDlgItem(hDlg, IDC_YRESLAB); 
 
            hXres = GetDlgItem(hDlg, IDC_XRES_SCROLL); 
            hYres = GetDlgItem(hDlg, IDC_YRES_SCROLL);

			hCScope = GetDlgItem(hDlg,IDC_CHECK_CSCOPE);

            SetScrollRange(hXres, SB_CTL, MINXVEL, MAXXVEL, FALSE); 
            SetScrollPos(hXres, SB_CTL, vg->lXres, TRUE); 
 
            SetScrollRange(hYres, SB_CTL, MINYVEL, MAXYVEL, FALSE); 
            SetScrollPos(hYres, SB_CTL, vg->lYres, TRUE); 
 
            wsprintf(szTemp, "Width : %ld", vg->lXres); 
            SetWindowText(hXlab,szTemp);
            wsprintf(szTemp, "Height : %ld", vg->lYres); 
            SetWindowText(hYlab,szTemp);

			if (vg->lCScope == 1) {
				SendMessage(hCScope,BM_SETCHECK,BST_CHECKED,0);
			} else {
				SendMessage(hCScope,BM_SETCHECK,BST_UNCHECKED,0);
			}
			hlim = GetDlgItem(hDlg,IDC_COMBO_FPSLIM);
			SendMessage(hlim,CB_ADDSTRING,0,(LPARAM)"5");
			SendMessage(hlim,CB_ADDSTRING,0,(LPARAM)"10");
			SendMessage(hlim,CB_ADDSTRING,0,(LPARAM)"15");
			SendMessage(hlim,CB_ADDSTRING,0,(LPARAM)"20");
			SendMessage(hlim,CB_ADDSTRING,0,(LPARAM)"25");
			SendMessage(hlim,CB_ADDSTRING,0,(LPARAM)"30");
			SendMessage(hlim,CB_ADDSTRING,0,(LPARAM)"None");
			if (vg->sleeprate == 5) SendMessage(hlim,CB_SETCURSEL,0,0);
			else if (vg->sleeprate == 10) SendMessage(hlim,CB_SETCURSEL,1,0);
			else if (vg->sleeprate == 15) SendMessage(hlim,CB_SETCURSEL,2,0);
			else if (vg->sleeprate == 20) SendMessage(hlim,CB_SETCURSEL,3,0);
			else if (vg->sleeprate == 25) SendMessage(hlim,CB_SETCURSEL,4,0);
			else if (vg->sleeprate == 30) SendMessage(hlim,CB_SETCURSEL,5,0);
			else SendMessage(hlim,CB_SETCURSEL,6,0);
			hCFPS = GetDlgItem(hDlg,IDC_CHECK_FPS);
			if (vg->showfps) {
				SendMessage(hCFPS,BM_SETCHECK,BST_CHECKED,0);
			} else {
				SendMessage(hCFPS,BM_SETCHECK,BST_UNCHECKED,0);
			}
			hCTitle = GetDlgItem(hDlg,IDC_CHECK_TITLE);
			if (vg->showtitle) {
				SendMessage(hCTitle,BM_SETCHECK,BST_CHECKED,0);
			} else {
				SendMessage(hCTitle,BM_SETCHECK,BST_UNCHECKED,0);
			}

            return TRUE; 
 
        case WM_HSCROLL: 
 
            if ((HWND)lParam == hXres) {
               pVar = &lXresTmp;
            } else {
               pVar = &lYresTmp;
            }
 
            switch (LOWORD(wParam)) 
                { 
                    case SB_PAGEUP: 
                        (*pVar)-=20; 
                    break; 
 
                    case SB_LINEUP: 
                        (*pVar)--; 
                    break; 
 
                    case SB_PAGEDOWN: 
                        (*pVar)+=20; 
                    break; 
 
                    case SB_LINEDOWN: 
                        (*pVar)++; 
                    break; 
 
                    case SB_THUMBPOSITION: 
                         *pVar = HIWORD(wParam); 
                    break; 
 
                    case SB_BOTTOM: 
                        if (pVar == &lXresTmp)
                           *pVar = MINXVEL; 
                        else
                           *pVar = MINYVEL;
                    break; 
 
                    case SB_TOP: 
                        if (pVar == &lYresTmp)
                           *pVar = MAXXVEL; 
                        else
                           *pVar = MAXYVEL;
                    break; 
 
                    case SB_THUMBTRACK: 
                         *pVar = HIWORD(wParam); 
                    break; 

                    case SB_ENDSCROLL: 
                        return TRUE; 
                    break; 
                } 
                if(lXresTmp > MAXXVEL) 
                  lXresTmp = MAXXVEL; 
                if(lXresTmp < MINXVEL) 
                  lXresTmp = MINXVEL; 

                if(lYresTmp > MAXYVEL) 
                  lYresTmp = MAXYVEL; 
                if(lYresTmp < MINYVEL) 
                  lYresTmp = MINYVEL; 
 
                SetScrollPos((HWND) lParam, SB_CTL, *pVar, TRUE); 

                 wsprintf(szTemp, "Width : %ld", lXresTmp); 
                 SetWindowText(hXlab,szTemp);
                 wsprintf(szTemp, "Height : %ld", lYresTmp); 
                 SetWindowText(hYlab,szTemp);
            break; 
 
        case WM_COMMAND: 
            switch(LOWORD(wParam)) 
            {
				int ichk;
				case IDC_CHECK_CSCOPE:
				case IDC_CHECK_FPS:
				case IDC_CHECK_TITLE:
				case IDC_COMBO_FPSLIM:
					return TRUE;

                case ID_OK: 
 

					vg->lXres = lXresTmp;
					vg->lYres = lYresTmp;
					if (SendMessage(hCScope,BM_GETCHECK,0,0) == BST_CHECKED) {
						vg->lCScope = 1;
					} else {
						vg->lCScope = 0;
					}
					ichk=SendMessage(hlim,CB_GETCURSEL,0,0);
					switch (ichk) {
					case 0:
						vg->sleeprate = 5;
						break;
					case 1:
						vg->sleeprate = 10;
						break;
					case 2:
						vg->sleeprate = 15;
						break;
					case 3:
						vg->sleeprate = 20;
						break;
					case 4:
						vg->sleeprate = 25;
						break;
					case 5:
						vg->sleeprate = 30;
						break;
					case 6:
						vg->sleeprate = -1;
						break;
					}
					vg->showfps = (SendMessage(hCFPS,BM_GETCHECK,0,0) == BST_CHECKED);
					vg->showtitle = (SendMessage(hCTitle,BM_GETCHECK,0,0) == BST_CHECKED);
					config_write(this_mod_config);
					if (vg->spf < 0.5) {
						/* We're not sleeping */
						vg->spf = 1.0f/(float)vg->sleeprate;
					}
 
                case ID_CANCEL: 
                    EndDialog(hDlg, LOWORD(wParam) == ID_OK); 
                return TRUE;

				case ID_ABOUT:
					MessageBox(hDlg,readme(),"Goom",MB_OK);
					return TRUE;
            }
		case WM_CLOSE:
			EndDialog(hDlg,0);
			return TRUE;
    } 
    return FALSE; 
}
// configuration. Passed this_mod, as a "this" parameter. Allows you to make one configuration
// function that shares code for all your modules (you don't HAVE to use it though, you can make
// config1(), config2(), etc...)

void config(struct winampVisModule *this_mod)
{
//	MessageBox(NULL,"Goom Configuration later","Goom Readme",MB_OK);
	this_mod_config=this_mod;
	DialogBox(this_mod->hDllInstance,MAKEINTRESOURCE(DLG_SCRNSAVECONFIGURE),this_mod->hwndParent,VisGoomConfigureDialog);
}

extern void goom_init(guint32,guint32,int);
struct winampVisModule *init_mod;
static HANDLE hThread;
static void __cdecl  render_thread(void *pVoid);
int init_goom(struct winampVisModule *this_mod)
{
	visGoomData *vg;
	init_mod = this_mod;
	
	vg = (visGoomData *)init_mod->userData;

	vg->lXres = DEFXVEL;
	vg->lYres = DEFYVEL;
	vg->lCScope = DEFCSCOPE;
	vg->forcemode = 0;
	vg->bQuit=FALSE;
	vg->iQuitMode = 0;
	vg->waThreadID=GetCurrentThreadId();

	config_read(this_mod);
	vg->spf = 1.0f/(float)vg->sleeprate;

	
	goom_init(vg->lXres,vg->lYres,vg->lCScope);
	
	hThread = (HANDLE)_beginthread(render_thread,0,this_mod);
	if ((int)hThread == -1) return 1;

	return 0;
}

#define ENCORE_NUL_LOCK (32*60)
static int msg_pos = 0;
extern int msg_rotate_ogl;
static char *msg_tab[] = {
	"What a GOOM! version " VERSION
	"\n\n\n\n\n\n\n\n"
	"an iOS sotfware production.\n"
	"\n\n\n"
	"http://ios.free.fr",
	"", // will be replaced by readme()
	"copyright (c)2000-2003, by jeko"
};
static int encore_frame_ogl[] = { /* Note the times are off by one because msg_pos is incremented */
	32*15,						/* drawglgoom is called */
	32*20,
	32*35
};

static short data[2][512];
static int xgoom_render_pcm(visGoomData *vg);
static void __cdecl render_thread(void *pVoid)
{
//  float time1,time2;
  struct winampVisModule *this_mod = (struct winampVisModule *)pVoid;
  visGoomData *vg;
  BOOL bError = FALSE;
  GMTimer *t;
  float time1,time2;


  vg = (visGoomData *)this_mod->userData;

  t = gmtimer_new();
  time1 = gmtimer_getvalue (t);
  framerate_tester_init();

  msg_tab[1]=readme();
  vg->encore_nul = 0;
  vg->encore_switch = 0;
  msg_pos = 0;

  ZeroMemory(&data[0][0],sizeof(data));

  if (!ptc_open("What A GOOM!",vg->lXres,vg->lYres)) {
	  bError = TRUE;
  }

  vg->ogl = 0;

  while (!vg->bQuit && !bError) {

	/* main work */
	if (xgoom_render_pcm (vg) == 1) {
		bError = TRUE;
		break;
	}
	/**/

	time2 = gmtimer_getvalue (t);
	if (vg->spf < 0.0) {
		time1=time2;
	} else {
		if ((time2 - time1) < vg->spf) {
			DWORD ti = (DWORD)(1000.0*(vg->spf + time1 - time2));
			Sleep (ti);
			time1 = time1 + vg->spf;
		}
		else
			time1 = time2;
	}

  }
  gmtimer_delete(&t);
  framerate_tester_close();
  if (vg->ogl == 1) {
	ptc_gl_close();
  } else {
	ptc_close();
  }
  if (bError) {
	  while (!vg->bQuit) {
		  Sleep(1000);
	  }
  }
  if (vg->iQuitMode == 1) {
	PostThreadMessage(vg->waThreadID,WM_QUIT,0,0);
  }

}

static int xgoom_render_pcm(visGoomData *vg)
{
	static BOOL bFirst = TRUE;
	static int xr=-1,yr=-1,cs=-1,ogl=-1;
	BOOL bChangeUpdate;
	BOOL bResetTitle;
	float fps;
	char *title;
	char *message=NULL;
	int i;


	bChangeUpdate = ((xr != vg->lXres) || (yr != vg->lYres) || (cs != vg->lCScope)) || (ogl != vg->ogl);
	if (cs == vg->lCScope && ogl == vg->ogl && vg->ogl == 1) bChangeUpdate = FALSE; // can't change resolution while in 3D

	if (bChangeUpdate) {
		if (!bFirst) {
			if (ogl == 1) {
				ptc_gl_close();
			} else {
				ptc_close ();
			}
			if (vg->ogl == 1) {
				goom_set_resolution (256, 256,vg->lCScope) ;
				if (!ptc_gl_open("What a GOOM!",
						256,256))
					      return 1;
			} else {
				goom_set_resolution (vg->lXres, vg->lYres,vg->lCScope) ;
				if (!ptc_open("What a GOOM!",
						vg->lXres,vg->lYres))
					      return 1;
			}
		}
		bFirst = FALSE;
		xr = vg->lXres;
		yr = vg->lYres;
		cs = vg->lCScope;
		ogl = vg->ogl;
	}

	for (i=0;i<512;i++)
		if (data[0][i]>2) {
			if (vg->encore_nul > ENCORE_NUL_LOCK)
				vg->encore_nul = 0;
			break;
		}
	
	if ((i == 512) && (vg->encore_nul == 0))
		vg->encore_nul = ENCORE_NUL_LOCK + 100;

	if (vg->encore_switch == -1) {
		vg->encore_nul = 0;
		message = "";
	} else if (vg->encore_switch == 1) {
		vg->encore_nul = ENCORE_NUL_LOCK;
	}

	vg->encore_switch = 0;

	if (vg->encore_nul == ENCORE_NUL_LOCK) {
		message = msg_tab[msg_pos];
		msg_pos ++;
		msg_pos %= 3;
	}

	msg_rotate_ogl = 0;
	if (vg->encore_nul > (ENCORE_NUL_LOCK - encore_frame_ogl[msg_pos])) {
		if (vg->encore_nul <= ENCORE_NUL_LOCK) {
			msg_rotate_ogl = 1;
		}
	}

	if (vg->encore_nul > 0) {
		vg->encore_nul --;
	}


	bResetTitle = (vg->titlePtr != NULL);
	fps = framerate_tester_getvalue(); if (!vg->showfps) fps=-1.0f;
	title = vg->titlePtr; if (!vg->showtitle) title=NULL;
	if (ogl == 1) {
		ptc_gl_update (goom_update (data,vg->forcemode,fps,title,message));
	} else {
		ptc_update (goom_update (data,vg->forcemode,fps,title,message));
	}
	if (bResetTitle) vg->titlePtr = NULL;
	framerate_tester_newframe();
	vg->forcemode=0;
	return 0;
}

int render_goom(struct winampVisModule *this_mod)
{
	static int izero = 0;
	int i;	

	if (izero == 0) {
		izero = 1;
		ZeroMemory(&data[0][0],sizeof(data));
	}

	if (this_mod->nCh == 2) {
		for (i = 0; i < 512; i++) {
			data[0][i] = (short)(this_mod->waveformData[0][i]) <<8;
			data[1][i] = (short)(this_mod->waveformData[1][i]) <<8;
		}
	} else {
		for (i = 0; i < 512; i++) {
			data[0][i] = (short)(this_mod->waveformData[0][i]) <<8;
			data[1][i] = (short)(this_mod->waveformData[0][i]) <<8;
		}
	}
	{
		visGoomData *vg;
       char *p;
	  vg = (visGoomData *)this_mod->userData;
      GetWindowText(this_mod->hwndParent,vg->songTitle,sizeof(vg->songTitle));
      p = vg->songTitle+strlen(vg->songTitle)-8;
      while (p >= vg->songTitle)
      {
            if (!strnicmp(p,"- Winamp",8)) break;
            p--;
      }
      if (p >= vg->songTitle) p--;
      while (p >= vg->songTitle && *p == ' ') p--;
      *++p=0;
	  if (strcmp(vg->songTitle,vg->songSave)) {
		  strcpy(vg->songSave,vg->songTitle);
		  vg->titlePtr = vg->songSave;
	  } else {
//		  vg->titlePtr = NULL;
	  }
	}


	return 0;
}

// cleanup (opposite of init()). Destroys the window, unregisters the window class
void quit(struct winampVisModule *this_mod)
{
	visGoomData *vg = (visGoomData *)this_mod->userData;
	int iQuitMode = vg->iQuitMode;

	if (iQuitMode == 0) {
		vg->bQuit=TRUE;
		WaitForSingleObject(hThread,INFINITE);
	}

	config_write(this_mod);		// write configuration
	goom_close();

//	if (iQuitMode == 1) {
//		_endthread();
//	}


}




void config_getinifn(struct winampVisModule *this_mod, char *ini_file)
{	// makes a .ini file in the winamp directory named "plugin.ini"
	char *p;
	GetModuleFileName(this_mod->hDllInstance,ini_file,MAX_PATH);
	p=ini_file+strlen(ini_file);
	while (p >= ini_file && *p != '\\') p--;
	if (++p >= ini_file) *p = 0;
	strcat(ini_file,"plugin.ini");
}


void config_read(struct winampVisModule *this_mod)
{
	char ini_file[MAX_PATH];
	int itmp;
	visGoomData *vg = (visGoomData *)this_mod->userData;
	config_getinifn(this_mod,ini_file);
      vg->lXres = GetPrivateProfileInt(this_mod->description, szXres, 
        DEFXVEL, ini_file); 
      vg->lYres = GetPrivateProfileInt(this_mod->description, szYres, 
         DEFYVEL, ini_file); 
      vg->lCScope = GetPrivateProfileInt(this_mod->description, szCScope, 
         DEFCSCOPE, ini_file); 
 
 
      if(vg->lXres > GetSystemMetrics(SM_CXSCREEN) || vg->lXres < MINXVEL) 
         vg->lXres = DEFXVEL; 

      if(vg->lYres > GetSystemMetrics(SM_CYSCREEN) || vg->lYres < MINYVEL) 
           vg->lYres = DEFYVEL;

	  if (vg->lCScope != 0 && vg->lCScope != 1) vg->lCScope = DEFCSCOPE;

	  itmp = GetPrivateProfileInt(this_mod->description, szCFPS, 
         1, ini_file); 
	  vg->showfps = (itmp != 0);
	  itmp = GetPrivateProfileInt(this_mod->description, szCTitle, 
         1, ini_file); 
	  vg->showtitle = (itmp != 0);
	  itmp = GetPrivateProfileInt(this_mod->description, szFPSLim, 
         30, ini_file); 
	  if (itmp == 0) itmp=30;
	  vg->sleeprate = itmp;
	 
}

void config_write(struct winampVisModule *this_mod)
{
	char szTemp[32];
	visGoomData *vg = (visGoomData *)this_mod->userData;
	char ini_file[MAX_PATH];
	LONG ltmp;

	config_getinifn(this_mod,ini_file);

     wsprintf(szTemp, "%ld", vg->lXres); 
     WritePrivateProfileString(this_mod->description, szXres, 
       szTemp, ini_file); 
     wsprintf(szTemp, "%ld", vg->lYres); 
     WritePrivateProfileString(this_mod->description, szYres, 
       szTemp, ini_file); 
     wsprintf(szTemp, "%ld", vg->lCScope); 
     WritePrivateProfileString(this_mod->description, szCScope, 
       szTemp, ini_file); 
	 ltmp = 0; if (vg->showfps) ltmp=1;
     wsprintf(szTemp, "%ld", ltmp); 
     WritePrivateProfileString(this_mod->description, szCFPS, 
       szTemp, ini_file); 
	 ltmp = 0; if (vg->showtitle) ltmp=1;
     wsprintf(szTemp, "%ld", ltmp); 
     WritePrivateProfileString(this_mod->description, szCTitle, 
       szTemp, ini_file); 
	 ltmp = vg->sleeprate;
     wsprintf(szTemp, "%ld", ltmp); 
     WritePrivateProfileString(this_mod->description, szFPSLim, 
       szTemp, ini_file); 
}

