"""wxStyledTextControl constants for documentation.
"""

__author__ = "Patrick K. O'Brien <pobrien@orbtech.com>"
__cvsid__ = "$Id: StyledTextConstants.py,v 1.2 2003/11/12 21:28:45 RD Exp $"
__revision__ = "$Revision: 1.2 $"[11:-2]


from wxPython import wx
from wxPython import stc


"""
>>> from wxPython import stc_c
>>> def gen_constants():
...     print '# Begin generated constants.'
...     for item in dir(stc_c):  # dir returns a sorted list.
...         if not callable(stc_c.__dict__[item]) \
...         and not item.startswith('__'):
...             print item, '=', 'stc.' + item, ' #', \
...                   repr(stc_c.__dict__[item])
...     print '# End generated constants.'

"""

# Begin generated constants.
STC_USE_DND = stc.STC_USE_DND  # 1
wxEVT_STC_CHANGE = stc.wxEVT_STC_CHANGE  # 10206
wxEVT_STC_CHARADDED = stc.wxEVT_STC_CHARADDED  # 10208
wxEVT_STC_DOUBLECLICK = stc.wxEVT_STC_DOUBLECLICK  # 10213
wxEVT_STC_DO_DROP = stc.wxEVT_STC_DO_DROP  # 10227
wxEVT_STC_DRAG_OVER = stc.wxEVT_STC_DRAG_OVER  # 10226
wxEVT_STC_DWELLEND = stc.wxEVT_STC_DWELLEND  # 10224
wxEVT_STC_DWELLSTART = stc.wxEVT_STC_DWELLSTART  # 10223
wxEVT_STC_KEY = stc.wxEVT_STC_KEY  # 10212
wxEVT_STC_MACRORECORD = stc.wxEVT_STC_MACRORECORD  # 10216
wxEVT_STC_MARGINCLICK = stc.wxEVT_STC_MARGINCLICK  # 10217
wxEVT_STC_MODIFIED = stc.wxEVT_STC_MODIFIED  # 10215
wxEVT_STC_NEEDSHOWN = stc.wxEVT_STC_NEEDSHOWN  # 10218
wxEVT_STC_PAINTED = stc.wxEVT_STC_PAINTED  # 10220
wxEVT_STC_POSCHANGED = stc.wxEVT_STC_POSCHANGED  # 10219
wxEVT_STC_ROMODIFYATTEMPT = stc.wxEVT_STC_ROMODIFYATTEMPT  # 10211
wxEVT_STC_SAVEPOINTLEFT = stc.wxEVT_STC_SAVEPOINTLEFT  # 10210
wxEVT_STC_SAVEPOINTREACHED = stc.wxEVT_STC_SAVEPOINTREACHED  # 10209
wxEVT_STC_START_DRAG = stc.wxEVT_STC_START_DRAG  # 10225
wxEVT_STC_STYLENEEDED = stc.wxEVT_STC_STYLENEEDED  # 10207
wxEVT_STC_UPDATEUI = stc.wxEVT_STC_UPDATEUI  # 10214
wxEVT_STC_URIDROPPED = stc.wxEVT_STC_URIDROPPED  # 10222
wxEVT_STC_USERLISTSELECTION = stc.wxEVT_STC_USERLISTSELECTION  # 10221
wxEVT_STC_ZOOM = stc.wxEVT_STC_ZOOM  # 10228
wxSTC_ADA_CHARACTER = stc.wxSTC_ADA_CHARACTER  # 5
wxSTC_ADA_COMMENT = stc.wxSTC_ADA_COMMENT  # 1
wxSTC_ADA_DEFAULT = stc.wxSTC_ADA_DEFAULT  # 0
wxSTC_ADA_IDENTIFIER = stc.wxSTC_ADA_IDENTIFIER  # 7
wxSTC_ADA_NUMBER = stc.wxSTC_ADA_NUMBER  # 2
wxSTC_ADA_OPERATOR = stc.wxSTC_ADA_OPERATOR  # 6
wxSTC_ADA_STRING = stc.wxSTC_ADA_STRING  # 4
wxSTC_ADA_STRINGEOL = stc.wxSTC_ADA_STRINGEOL  # 8
wxSTC_ADA_WORD = stc.wxSTC_ADA_WORD  # 3
wxSTC_AVE_COMMENT = stc.wxSTC_AVE_COMMENT  # 1
wxSTC_AVE_DEFAULT = stc.wxSTC_AVE_DEFAULT  # 0
wxSTC_AVE_ENUM = stc.wxSTC_AVE_ENUM  # 7
wxSTC_AVE_IDENTIFIER = stc.wxSTC_AVE_IDENTIFIER  # 9
wxSTC_AVE_KEYWORD = stc.wxSTC_AVE_KEYWORD  # 4
wxSTC_AVE_NUMBER = stc.wxSTC_AVE_NUMBER  # 2
wxSTC_AVE_OPERATOR = stc.wxSTC_AVE_OPERATOR  # 10
wxSTC_AVE_STATEMENT = stc.wxSTC_AVE_STATEMENT  # 5
wxSTC_AVE_STRING = stc.wxSTC_AVE_STRING  # 6
wxSTC_AVE_STRINGEOL = stc.wxSTC_AVE_STRINGEOL  # 8
wxSTC_AVE_WORD = stc.wxSTC_AVE_WORD  # 3
wxSTC_BAAN_COMMENT = stc.wxSTC_BAAN_COMMENT  # 1
wxSTC_BAAN_COMMENTDOC = stc.wxSTC_BAAN_COMMENTDOC  # 2
wxSTC_BAAN_DEFAULT = stc.wxSTC_BAAN_DEFAULT  # 0
wxSTC_BAAN_IDENTIFIER = stc.wxSTC_BAAN_IDENTIFIER  # 8
wxSTC_BAAN_NUMBER = stc.wxSTC_BAAN_NUMBER  # 3
wxSTC_BAAN_OPERATOR = stc.wxSTC_BAAN_OPERATOR  # 7
wxSTC_BAAN_PREPROCESSOR = stc.wxSTC_BAAN_PREPROCESSOR  # 6
wxSTC_BAAN_STRING = stc.wxSTC_BAAN_STRING  # 5
wxSTC_BAAN_STRINGEOL = stc.wxSTC_BAAN_STRINGEOL  # 9
wxSTC_BAAN_WORD = stc.wxSTC_BAAN_WORD  # 4
wxSTC_BAAN_WORD2 = stc.wxSTC_BAAN_WORD2  # 10
wxSTC_BAT_COMMAND = stc.wxSTC_BAT_COMMAND  # 5
wxSTC_BAT_COMMENT = stc.wxSTC_BAT_COMMENT  # 1
wxSTC_BAT_DEFAULT = stc.wxSTC_BAT_DEFAULT  # 0
wxSTC_BAT_HIDE = stc.wxSTC_BAT_HIDE  # 4
wxSTC_BAT_IDENTIFIER = stc.wxSTC_BAT_IDENTIFIER  # 6
wxSTC_BAT_LABEL = stc.wxSTC_BAT_LABEL  # 3
wxSTC_BAT_OPERATOR = stc.wxSTC_BAT_OPERATOR  # 7
wxSTC_BAT_WORD = stc.wxSTC_BAT_WORD  # 2
wxSTC_B_COMMENT = stc.wxSTC_B_COMMENT  # 1
wxSTC_B_DATE = stc.wxSTC_B_DATE  # 8
wxSTC_B_DEFAULT = stc.wxSTC_B_DEFAULT  # 0
wxSTC_B_IDENTIFIER = stc.wxSTC_B_IDENTIFIER  # 7
wxSTC_B_KEYWORD = stc.wxSTC_B_KEYWORD  # 3
wxSTC_B_NUMBER = stc.wxSTC_B_NUMBER  # 2
wxSTC_B_OPERATOR = stc.wxSTC_B_OPERATOR  # 6
wxSTC_B_PREPROCESSOR = stc.wxSTC_B_PREPROCESSOR  # 5
wxSTC_B_STRING = stc.wxSTC_B_STRING  # 4
wxSTC_CACHE_CARET = stc.wxSTC_CACHE_CARET  # 1
wxSTC_CACHE_DOCUMENT = stc.wxSTC_CACHE_DOCUMENT  # 3
wxSTC_CACHE_NONE = stc.wxSTC_CACHE_NONE  # 0
wxSTC_CACHE_PAGE = stc.wxSTC_CACHE_PAGE  # 2
wxSTC_CARET_EVEN = stc.wxSTC_CARET_EVEN  # 8
wxSTC_CARET_JUMPS = stc.wxSTC_CARET_JUMPS  # 16
wxSTC_CARET_SLOP = stc.wxSTC_CARET_SLOP  # 1
wxSTC_CARET_STRICT = stc.wxSTC_CARET_STRICT  # 4
wxSTC_CASE_LOWER = stc.wxSTC_CASE_LOWER  # 2
wxSTC_CASE_MIXED = stc.wxSTC_CASE_MIXED  # 0
wxSTC_CASE_UPPER = stc.wxSTC_CASE_UPPER  # 1
wxSTC_CHARSET_ANSI = stc.wxSTC_CHARSET_ANSI  # 0
wxSTC_CHARSET_ARABIC = stc.wxSTC_CHARSET_ARABIC  # 178
wxSTC_CHARSET_BALTIC = stc.wxSTC_CHARSET_BALTIC  # 186
wxSTC_CHARSET_CHINESEBIG5 = stc.wxSTC_CHARSET_CHINESEBIG5  # 136
wxSTC_CHARSET_DEFAULT = stc.wxSTC_CHARSET_DEFAULT  # 1
wxSTC_CHARSET_EASTEUROPE = stc.wxSTC_CHARSET_EASTEUROPE  # 238
wxSTC_CHARSET_GB2312 = stc.wxSTC_CHARSET_GB2312  # 134
wxSTC_CHARSET_GREEK = stc.wxSTC_CHARSET_GREEK  # 161
wxSTC_CHARSET_HANGUL = stc.wxSTC_CHARSET_HANGUL  # 129
wxSTC_CHARSET_HEBREW = stc.wxSTC_CHARSET_HEBREW  # 177
wxSTC_CHARSET_JOHAB = stc.wxSTC_CHARSET_JOHAB  # 130
wxSTC_CHARSET_MAC = stc.wxSTC_CHARSET_MAC  # 77
wxSTC_CHARSET_OEM = stc.wxSTC_CHARSET_OEM  # 255
wxSTC_CHARSET_RUSSIAN = stc.wxSTC_CHARSET_RUSSIAN  # 204
wxSTC_CHARSET_SHIFTJIS = stc.wxSTC_CHARSET_SHIFTJIS  # 128
wxSTC_CHARSET_SYMBOL = stc.wxSTC_CHARSET_SYMBOL  # 2
wxSTC_CHARSET_THAI = stc.wxSTC_CHARSET_THAI  # 222
wxSTC_CHARSET_TURKISH = stc.wxSTC_CHARSET_TURKISH  # 162
wxSTC_CHARSET_VIETNAMESE = stc.wxSTC_CHARSET_VIETNAMESE  # 163
wxSTC_CMD_BACKTAB = stc.wxSTC_CMD_BACKTAB  # 2328
wxSTC_CMD_CANCEL = stc.wxSTC_CMD_CANCEL  # 2325
wxSTC_CMD_CHARLEFT = stc.wxSTC_CMD_CHARLEFT  # 2304
wxSTC_CMD_CHARLEFTEXTEND = stc.wxSTC_CMD_CHARLEFTEXTEND  # 2305
wxSTC_CMD_CHARRIGHT = stc.wxSTC_CMD_CHARRIGHT  # 2306
wxSTC_CMD_CHARRIGHTEXTEND = stc.wxSTC_CMD_CHARRIGHTEXTEND  # 2307
wxSTC_CMD_CLEAR = stc.wxSTC_CMD_CLEAR  # 2180
wxSTC_CMD_COPY = stc.wxSTC_CMD_COPY  # 2178
wxSTC_CMD_CUT = stc.wxSTC_CMD_CUT  # 2177
wxSTC_CMD_DELETEBACK = stc.wxSTC_CMD_DELETEBACK  # 2326
wxSTC_CMD_DELETEBACKNOTLINE = stc.wxSTC_CMD_DELETEBACKNOTLINE  # 2344
wxSTC_CMD_DELLINELEFT = stc.wxSTC_CMD_DELLINELEFT  # 2395
wxSTC_CMD_DELLINERIGHT = stc.wxSTC_CMD_DELLINERIGHT  # 2396
wxSTC_CMD_DELWORDLEFT = stc.wxSTC_CMD_DELWORDLEFT  # 2335
wxSTC_CMD_DELWORDRIGHT = stc.wxSTC_CMD_DELWORDRIGHT  # 2336
wxSTC_CMD_DOCUMENTEND = stc.wxSTC_CMD_DOCUMENTEND  # 2318
wxSTC_CMD_DOCUMENTENDEXTEND = stc.wxSTC_CMD_DOCUMENTENDEXTEND  # 2319
wxSTC_CMD_DOCUMENTSTART = stc.wxSTC_CMD_DOCUMENTSTART  # 2316
wxSTC_CMD_DOCUMENTSTARTEXTEND = stc.wxSTC_CMD_DOCUMENTSTARTEXTEND  # 2317
wxSTC_CMD_EDITTOGGLEOVERTYPE = stc.wxSTC_CMD_EDITTOGGLEOVERTYPE  # 2324
wxSTC_CMD_FORMFEED = stc.wxSTC_CMD_FORMFEED  # 2330
wxSTC_CMD_HOME = stc.wxSTC_CMD_HOME  # 2312
wxSTC_CMD_HOMEDISPLAY = stc.wxSTC_CMD_HOMEDISPLAY  # 2345
wxSTC_CMD_HOMEDISPLAYEXTEND = stc.wxSTC_CMD_HOMEDISPLAYEXTEND  # 2346
wxSTC_CMD_HOMEEXTEND = stc.wxSTC_CMD_HOMEEXTEND  # 2313
wxSTC_CMD_LINECUT = stc.wxSTC_CMD_LINECUT  # 2337
wxSTC_CMD_LINEDELETE = stc.wxSTC_CMD_LINEDELETE  # 2338
wxSTC_CMD_LINEDOWN = stc.wxSTC_CMD_LINEDOWN  # 2300
wxSTC_CMD_LINEDOWNEXTEND = stc.wxSTC_CMD_LINEDOWNEXTEND  # 2301
wxSTC_CMD_LINEEND = stc.wxSTC_CMD_LINEEND  # 2314
wxSTC_CMD_LINEENDDISPLAY = stc.wxSTC_CMD_LINEENDDISPLAY  # 2347
wxSTC_CMD_LINEENDDISPLAYEXTEND = stc.wxSTC_CMD_LINEENDDISPLAYEXTEND  # 2348
wxSTC_CMD_LINEENDEXTEND = stc.wxSTC_CMD_LINEENDEXTEND  # 2315
wxSTC_CMD_LINESCROLLDOWN = stc.wxSTC_CMD_LINESCROLLDOWN  # 2342
wxSTC_CMD_LINESCROLLUP = stc.wxSTC_CMD_LINESCROLLUP  # 2343
wxSTC_CMD_LINETRANSPOSE = stc.wxSTC_CMD_LINETRANSPOSE  # 2339
wxSTC_CMD_LINEUP = stc.wxSTC_CMD_LINEUP  # 2302
wxSTC_CMD_LINEUPEXTEND = stc.wxSTC_CMD_LINEUPEXTEND  # 2303
wxSTC_CMD_LOWERCASE = stc.wxSTC_CMD_LOWERCASE  # 2340
wxSTC_CMD_NEWLINE = stc.wxSTC_CMD_NEWLINE  # 2329
wxSTC_CMD_PAGEDOWN = stc.wxSTC_CMD_PAGEDOWN  # 2322
wxSTC_CMD_PAGEDOWNEXTEND = stc.wxSTC_CMD_PAGEDOWNEXTEND  # 2323
wxSTC_CMD_PAGEUP = stc.wxSTC_CMD_PAGEUP  # 2320
wxSTC_CMD_PAGEUPEXTEND = stc.wxSTC_CMD_PAGEUPEXTEND  # 2321
wxSTC_CMD_PASTE = stc.wxSTC_CMD_PASTE  # 2179
wxSTC_CMD_REDO = stc.wxSTC_CMD_REDO  # 2011
wxSTC_CMD_SELECTALL = stc.wxSTC_CMD_SELECTALL  # 2013
wxSTC_CMD_TAB = stc.wxSTC_CMD_TAB  # 2327
wxSTC_CMD_UNDO = stc.wxSTC_CMD_UNDO  # 2176
wxSTC_CMD_UPPERCASE = stc.wxSTC_CMD_UPPERCASE  # 2341
wxSTC_CMD_VCHOME = stc.wxSTC_CMD_VCHOME  # 2331
wxSTC_CMD_VCHOMEEXTEND = stc.wxSTC_CMD_VCHOMEEXTEND  # 2332
wxSTC_CMD_WORDLEFT = stc.wxSTC_CMD_WORDLEFT  # 2308
wxSTC_CMD_WORDLEFTEXTEND = stc.wxSTC_CMD_WORDLEFTEXTEND  # 2309
wxSTC_CMD_WORDPARTLEFT = stc.wxSTC_CMD_WORDPARTLEFT  # 2390
wxSTC_CMD_WORDPARTLEFTEXTEND = stc.wxSTC_CMD_WORDPARTLEFTEXTEND  # 2391
wxSTC_CMD_WORDPARTRIGHT = stc.wxSTC_CMD_WORDPARTRIGHT  # 2392
wxSTC_CMD_WORDPARTRIGHTEXTEND = stc.wxSTC_CMD_WORDPARTRIGHTEXTEND  # 2393
wxSTC_CMD_WORDRIGHT = stc.wxSTC_CMD_WORDRIGHT  # 2310
wxSTC_CMD_WORDRIGHTEXTEND = stc.wxSTC_CMD_WORDRIGHTEXTEND  # 2311
wxSTC_CMD_ZOOMIN = stc.wxSTC_CMD_ZOOMIN  # 2333
wxSTC_CMD_ZOOMOUT = stc.wxSTC_CMD_ZOOMOUT  # 2334
wxSTC_CONF_COMMENT = stc.wxSTC_CONF_COMMENT  # 1
wxSTC_CONF_DEFAULT = stc.wxSTC_CONF_DEFAULT  # 0
wxSTC_CONF_DIRECTIVE = stc.wxSTC_CONF_DIRECTIVE  # 9
wxSTC_CONF_EXTENSION = stc.wxSTC_CONF_EXTENSION  # 4
wxSTC_CONF_IDENTIFIER = stc.wxSTC_CONF_IDENTIFIER  # 3
wxSTC_CONF_IP = stc.wxSTC_CONF_IP  # 8
wxSTC_CONF_NUMBER = stc.wxSTC_CONF_NUMBER  # 2
wxSTC_CONF_OPERATOR = stc.wxSTC_CONF_OPERATOR  # 7
wxSTC_CONF_PARAMETER = stc.wxSTC_CONF_PARAMETER  # 5
wxSTC_CONF_STRING = stc.wxSTC_CONF_STRING  # 6
wxSTC_CP_UTF8 = stc.wxSTC_CP_UTF8  # 65001
wxSTC_CURSORNORMAL = stc.wxSTC_CURSORNORMAL  # -1
wxSTC_CURSORWAIT = stc.wxSTC_CURSORWAIT  # 3
wxSTC_C_CHARACTER = stc.wxSTC_C_CHARACTER  # 7
wxSTC_C_COMMENT = stc.wxSTC_C_COMMENT  # 1
wxSTC_C_COMMENTDOC = stc.wxSTC_C_COMMENTDOC  # 3
wxSTC_C_COMMENTDOCKEYWORD = stc.wxSTC_C_COMMENTDOCKEYWORD  # 17
wxSTC_C_COMMENTDOCKEYWORDERROR = stc.wxSTC_C_COMMENTDOCKEYWORDERROR  # 18
wxSTC_C_COMMENTLINE = stc.wxSTC_C_COMMENTLINE  # 2
wxSTC_C_COMMENTLINEDOC = stc.wxSTC_C_COMMENTLINEDOC  # 15
wxSTC_C_DEFAULT = stc.wxSTC_C_DEFAULT  # 0
wxSTC_C_IDENTIFIER = stc.wxSTC_C_IDENTIFIER  # 11
wxSTC_C_NUMBER = stc.wxSTC_C_NUMBER  # 4
wxSTC_C_OPERATOR = stc.wxSTC_C_OPERATOR  # 10
wxSTC_C_PREPROCESSOR = stc.wxSTC_C_PREPROCESSOR  # 9
wxSTC_C_REGEX = stc.wxSTC_C_REGEX  # 14
wxSTC_C_STRING = stc.wxSTC_C_STRING  # 6
wxSTC_C_STRINGEOL = stc.wxSTC_C_STRINGEOL  # 12
wxSTC_C_UUID = stc.wxSTC_C_UUID  # 8
wxSTC_C_VERBATIM = stc.wxSTC_C_VERBATIM  # 13
wxSTC_C_WORD = stc.wxSTC_C_WORD  # 5
wxSTC_C_WORD2 = stc.wxSTC_C_WORD2  # 16
wxSTC_DIFF_ADDED = stc.wxSTC_DIFF_ADDED  # 6
wxSTC_DIFF_COMMAND = stc.wxSTC_DIFF_COMMAND  # 2
wxSTC_DIFF_COMMENT = stc.wxSTC_DIFF_COMMENT  # 1
wxSTC_DIFF_DEFAULT = stc.wxSTC_DIFF_DEFAULT  # 0
wxSTC_DIFF_DELETED = stc.wxSTC_DIFF_DELETED  # 5
wxSTC_DIFF_HEADER = stc.wxSTC_DIFF_HEADER  # 3
wxSTC_DIFF_POSITION = stc.wxSTC_DIFF_POSITION  # 4
wxSTC_EDGE_BACKGROUND = stc.wxSTC_EDGE_BACKGROUND  # 2
wxSTC_EDGE_LINE = stc.wxSTC_EDGE_LINE  # 1
wxSTC_EDGE_NONE = stc.wxSTC_EDGE_NONE  # 0
wxSTC_EIFFEL_CHARACTER = stc.wxSTC_EIFFEL_CHARACTER  # 5
wxSTC_EIFFEL_COMMENTLINE = stc.wxSTC_EIFFEL_COMMENTLINE  # 1
wxSTC_EIFFEL_DEFAULT = stc.wxSTC_EIFFEL_DEFAULT  # 0
wxSTC_EIFFEL_IDENTIFIER = stc.wxSTC_EIFFEL_IDENTIFIER  # 7
wxSTC_EIFFEL_NUMBER = stc.wxSTC_EIFFEL_NUMBER  # 2
wxSTC_EIFFEL_OPERATOR = stc.wxSTC_EIFFEL_OPERATOR  # 6
wxSTC_EIFFEL_STRING = stc.wxSTC_EIFFEL_STRING  # 4
wxSTC_EIFFEL_STRINGEOL = stc.wxSTC_EIFFEL_STRINGEOL  # 8
wxSTC_EIFFEL_WORD = stc.wxSTC_EIFFEL_WORD  # 3
wxSTC_EOL_CR = stc.wxSTC_EOL_CR  # 1
wxSTC_EOL_CRLF = stc.wxSTC_EOL_CRLF  # 0
wxSTC_EOL_LF = stc.wxSTC_EOL_LF  # 2
wxSTC_ERR_BORLAND = stc.wxSTC_ERR_BORLAND  # 5
wxSTC_ERR_CMD = stc.wxSTC_ERR_CMD  # 4
wxSTC_ERR_CTAG = stc.wxSTC_ERR_CTAG  # 9
wxSTC_ERR_DEFAULT = stc.wxSTC_ERR_DEFAULT  # 0
wxSTC_ERR_DIFF_ADDITION = stc.wxSTC_ERR_DIFF_ADDITION  # 11
wxSTC_ERR_DIFF_CHANGED = stc.wxSTC_ERR_DIFF_CHANGED  # 10
wxSTC_ERR_DIFF_DELETION = stc.wxSTC_ERR_DIFF_DELETION  # 12
wxSTC_ERR_DIFF_MESSAGE = stc.wxSTC_ERR_DIFF_MESSAGE  # 13
wxSTC_ERR_GCC = stc.wxSTC_ERR_GCC  # 2
wxSTC_ERR_LUA = stc.wxSTC_ERR_LUA  # 8
wxSTC_ERR_MS = stc.wxSTC_ERR_MS  # 3
wxSTC_ERR_NET = stc.wxSTC_ERR_NET  # 7
wxSTC_ERR_PERL = stc.wxSTC_ERR_PERL  # 6
wxSTC_ERR_PYTHON = stc.wxSTC_ERR_PYTHON  # 1
wxSTC_FIND_MATCHCASE = stc.wxSTC_FIND_MATCHCASE  # 4
wxSTC_FIND_REGEXP = stc.wxSTC_FIND_REGEXP  # 2097152
wxSTC_FIND_WHOLEWORD = stc.wxSTC_FIND_WHOLEWORD  # 2
wxSTC_FIND_WORDSTART = stc.wxSTC_FIND_WORDSTART  # 1048576
wxSTC_FOLDLEVELBASE = stc.wxSTC_FOLDLEVELBASE  # 1024
wxSTC_FOLDLEVELHEADERFLAG = stc.wxSTC_FOLDLEVELHEADERFLAG  # 8192
wxSTC_FOLDLEVELNUMBERMASK = stc.wxSTC_FOLDLEVELNUMBERMASK  # 4095
wxSTC_FOLDLEVELWHITEFLAG = stc.wxSTC_FOLDLEVELWHITEFLAG  # 4096
wxSTC_HBA_COMMENTLINE = stc.wxSTC_HBA_COMMENTLINE  # 82
wxSTC_HBA_DEFAULT = stc.wxSTC_HBA_DEFAULT  # 81
wxSTC_HBA_IDENTIFIER = stc.wxSTC_HBA_IDENTIFIER  # 86
wxSTC_HBA_NUMBER = stc.wxSTC_HBA_NUMBER  # 83
wxSTC_HBA_START = stc.wxSTC_HBA_START  # 80
wxSTC_HBA_STRING = stc.wxSTC_HBA_STRING  # 85
wxSTC_HBA_STRINGEOL = stc.wxSTC_HBA_STRINGEOL  # 87
wxSTC_HBA_WORD = stc.wxSTC_HBA_WORD  # 84
wxSTC_HB_COMMENTLINE = stc.wxSTC_HB_COMMENTLINE  # 72
wxSTC_HB_DEFAULT = stc.wxSTC_HB_DEFAULT  # 71
wxSTC_HB_IDENTIFIER = stc.wxSTC_HB_IDENTIFIER  # 76
wxSTC_HB_NUMBER = stc.wxSTC_HB_NUMBER  # 73
wxSTC_HB_START = stc.wxSTC_HB_START  # 70
wxSTC_HB_STRING = stc.wxSTC_HB_STRING  # 75
wxSTC_HB_STRINGEOL = stc.wxSTC_HB_STRINGEOL  # 77
wxSTC_HB_WORD = stc.wxSTC_HB_WORD  # 74
wxSTC_HJA_COMMENT = stc.wxSTC_HJA_COMMENT  # 57
wxSTC_HJA_COMMENTDOC = stc.wxSTC_HJA_COMMENTDOC  # 59
wxSTC_HJA_COMMENTLINE = stc.wxSTC_HJA_COMMENTLINE  # 58
wxSTC_HJA_DEFAULT = stc.wxSTC_HJA_DEFAULT  # 56
wxSTC_HJA_DOUBLESTRING = stc.wxSTC_HJA_DOUBLESTRING  # 63
wxSTC_HJA_KEYWORD = stc.wxSTC_HJA_KEYWORD  # 62
wxSTC_HJA_NUMBER = stc.wxSTC_HJA_NUMBER  # 60
wxSTC_HJA_REGEX = stc.wxSTC_HJA_REGEX  # 67
wxSTC_HJA_SINGLESTRING = stc.wxSTC_HJA_SINGLESTRING  # 64
wxSTC_HJA_START = stc.wxSTC_HJA_START  # 55
wxSTC_HJA_STRINGEOL = stc.wxSTC_HJA_STRINGEOL  # 66
wxSTC_HJA_SYMBOLS = stc.wxSTC_HJA_SYMBOLS  # 65
wxSTC_HJA_WORD = stc.wxSTC_HJA_WORD  # 61
wxSTC_HJ_COMMENT = stc.wxSTC_HJ_COMMENT  # 42
wxSTC_HJ_COMMENTDOC = stc.wxSTC_HJ_COMMENTDOC  # 44
wxSTC_HJ_COMMENTLINE = stc.wxSTC_HJ_COMMENTLINE  # 43
wxSTC_HJ_DEFAULT = stc.wxSTC_HJ_DEFAULT  # 41
wxSTC_HJ_DOUBLESTRING = stc.wxSTC_HJ_DOUBLESTRING  # 48
wxSTC_HJ_KEYWORD = stc.wxSTC_HJ_KEYWORD  # 47
wxSTC_HJ_NUMBER = stc.wxSTC_HJ_NUMBER  # 45
wxSTC_HJ_REGEX = stc.wxSTC_HJ_REGEX  # 52
wxSTC_HJ_SINGLESTRING = stc.wxSTC_HJ_SINGLESTRING  # 49
wxSTC_HJ_START = stc.wxSTC_HJ_START  # 40
wxSTC_HJ_STRINGEOL = stc.wxSTC_HJ_STRINGEOL  # 51
wxSTC_HJ_SYMBOLS = stc.wxSTC_HJ_SYMBOLS  # 50
wxSTC_HJ_WORD = stc.wxSTC_HJ_WORD  # 46
wxSTC_HPA_CHARACTER = stc.wxSTC_HPA_CHARACTER  # 110
wxSTC_HPA_CLASSNAME = stc.wxSTC_HPA_CLASSNAME  # 114
wxSTC_HPA_COMMENTLINE = stc.wxSTC_HPA_COMMENTLINE  # 107
wxSTC_HPA_DEFAULT = stc.wxSTC_HPA_DEFAULT  # 106
wxSTC_HPA_DEFNAME = stc.wxSTC_HPA_DEFNAME  # 115
wxSTC_HPA_IDENTIFIER = stc.wxSTC_HPA_IDENTIFIER  # 117
wxSTC_HPA_NUMBER = stc.wxSTC_HPA_NUMBER  # 108
wxSTC_HPA_OPERATOR = stc.wxSTC_HPA_OPERATOR  # 116
wxSTC_HPA_START = stc.wxSTC_HPA_START  # 105
wxSTC_HPA_STRING = stc.wxSTC_HPA_STRING  # 109
wxSTC_HPA_TRIPLE = stc.wxSTC_HPA_TRIPLE  # 112
wxSTC_HPA_TRIPLEDOUBLE = stc.wxSTC_HPA_TRIPLEDOUBLE  # 113
wxSTC_HPA_WORD = stc.wxSTC_HPA_WORD  # 111
wxSTC_HPHP_COMMENT = stc.wxSTC_HPHP_COMMENT  # 124
wxSTC_HPHP_COMMENTLINE = stc.wxSTC_HPHP_COMMENTLINE  # 125
wxSTC_HPHP_DEFAULT = stc.wxSTC_HPHP_DEFAULT  # 118
wxSTC_HPHP_HSTRING = stc.wxSTC_HPHP_HSTRING  # 119
wxSTC_HPHP_HSTRING_VARIABLE = stc.wxSTC_HPHP_HSTRING_VARIABLE  # 126
wxSTC_HPHP_NUMBER = stc.wxSTC_HPHP_NUMBER  # 122
wxSTC_HPHP_OPERATOR = stc.wxSTC_HPHP_OPERATOR  # 127
wxSTC_HPHP_SIMPLESTRING = stc.wxSTC_HPHP_SIMPLESTRING  # 120
wxSTC_HPHP_VARIABLE = stc.wxSTC_HPHP_VARIABLE  # 123
wxSTC_HPHP_WORD = stc.wxSTC_HPHP_WORD  # 121
wxSTC_HP_CHARACTER = stc.wxSTC_HP_CHARACTER  # 95
wxSTC_HP_CLASSNAME = stc.wxSTC_HP_CLASSNAME  # 99
wxSTC_HP_COMMENTLINE = stc.wxSTC_HP_COMMENTLINE  # 92
wxSTC_HP_DEFAULT = stc.wxSTC_HP_DEFAULT  # 91
wxSTC_HP_DEFNAME = stc.wxSTC_HP_DEFNAME  # 100
wxSTC_HP_IDENTIFIER = stc.wxSTC_HP_IDENTIFIER  # 102
wxSTC_HP_NUMBER = stc.wxSTC_HP_NUMBER  # 93
wxSTC_HP_OPERATOR = stc.wxSTC_HP_OPERATOR  # 101
wxSTC_HP_START = stc.wxSTC_HP_START  # 90
wxSTC_HP_STRING = stc.wxSTC_HP_STRING  # 94
wxSTC_HP_TRIPLE = stc.wxSTC_HP_TRIPLE  # 97
wxSTC_HP_TRIPLEDOUBLE = stc.wxSTC_HP_TRIPLEDOUBLE  # 98
wxSTC_HP_WORD = stc.wxSTC_HP_WORD  # 96
wxSTC_H_ASP = stc.wxSTC_H_ASP  # 15
wxSTC_H_ASPAT = stc.wxSTC_H_ASPAT  # 16
wxSTC_H_ATTRIBUTE = stc.wxSTC_H_ATTRIBUTE  # 3
wxSTC_H_ATTRIBUTEUNKNOWN = stc.wxSTC_H_ATTRIBUTEUNKNOWN  # 4
wxSTC_H_CDATA = stc.wxSTC_H_CDATA  # 17
wxSTC_H_COMMENT = stc.wxSTC_H_COMMENT  # 9
wxSTC_H_DEFAULT = stc.wxSTC_H_DEFAULT  # 0
wxSTC_H_DOUBLESTRING = stc.wxSTC_H_DOUBLESTRING  # 6
wxSTC_H_ENTITY = stc.wxSTC_H_ENTITY  # 10
wxSTC_H_NUMBER = stc.wxSTC_H_NUMBER  # 5
wxSTC_H_OTHER = stc.wxSTC_H_OTHER  # 8
wxSTC_H_QUESTION = stc.wxSTC_H_QUESTION  # 18
wxSTC_H_SCRIPT = stc.wxSTC_H_SCRIPT  # 14
wxSTC_H_SGML_1ST_PARAM = stc.wxSTC_H_SGML_1ST_PARAM  # 23
wxSTC_H_SGML_1ST_PARAM_COMMENT = stc.wxSTC_H_SGML_1ST_PARAM_COMMENT  # 30
wxSTC_H_SGML_BLOCK_DEFAULT = stc.wxSTC_H_SGML_BLOCK_DEFAULT  # 31
wxSTC_H_SGML_COMMAND = stc.wxSTC_H_SGML_COMMAND  # 22
wxSTC_H_SGML_COMMENT = stc.wxSTC_H_SGML_COMMENT  # 29
wxSTC_H_SGML_DEFAULT = stc.wxSTC_H_SGML_DEFAULT  # 21
wxSTC_H_SGML_DOUBLESTRING = stc.wxSTC_H_SGML_DOUBLESTRING  # 24
wxSTC_H_SGML_ENTITY = stc.wxSTC_H_SGML_ENTITY  # 28
wxSTC_H_SGML_ERROR = stc.wxSTC_H_SGML_ERROR  # 26
wxSTC_H_SGML_SIMPLESTRING = stc.wxSTC_H_SGML_SIMPLESTRING  # 25
wxSTC_H_SGML_SPECIAL = stc.wxSTC_H_SGML_SPECIAL  # 27
wxSTC_H_SINGLESTRING = stc.wxSTC_H_SINGLESTRING  # 7
wxSTC_H_TAG = stc.wxSTC_H_TAG  # 1
wxSTC_H_TAGEND = stc.wxSTC_H_TAGEND  # 11
wxSTC_H_TAGUNKNOWN = stc.wxSTC_H_TAGUNKNOWN  # 2
wxSTC_H_VALUE = stc.wxSTC_H_VALUE  # 19
wxSTC_H_XCCOMMENT = stc.wxSTC_H_XCCOMMENT  # 20
wxSTC_H_XMLEND = stc.wxSTC_H_XMLEND  # 13
wxSTC_H_XMLSTART = stc.wxSTC_H_XMLSTART  # 12
wxSTC_INDIC0_MASK = stc.wxSTC_INDIC0_MASK  # 32
wxSTC_INDIC1_MASK = stc.wxSTC_INDIC1_MASK  # 64
wxSTC_INDIC2_MASK = stc.wxSTC_INDIC2_MASK  # 128
wxSTC_INDICS_MASK = stc.wxSTC_INDICS_MASK  # 224
wxSTC_INDIC_DIAGONAL = stc.wxSTC_INDIC_DIAGONAL  # 3
wxSTC_INDIC_MAX = stc.wxSTC_INDIC_MAX  # 7
wxSTC_INDIC_PLAIN = stc.wxSTC_INDIC_PLAIN  # 0
wxSTC_INDIC_SQUIGGLE = stc.wxSTC_INDIC_SQUIGGLE  # 1
wxSTC_INDIC_STRIKE = stc.wxSTC_INDIC_STRIKE  # 4
wxSTC_INDIC_TT = stc.wxSTC_INDIC_TT  # 2
wxSTC_INVALID_POSITION = stc.wxSTC_INVALID_POSITION  # -1
wxSTC_KEY_ADD = stc.wxSTC_KEY_ADD  # 310
wxSTC_KEY_BACK = stc.wxSTC_KEY_BACK  # 8
wxSTC_KEY_DELETE = stc.wxSTC_KEY_DELETE  # 308
wxSTC_KEY_DIVIDE = stc.wxSTC_KEY_DIVIDE  # 312
wxSTC_KEY_DOWN = stc.wxSTC_KEY_DOWN  # 300
wxSTC_KEY_END = stc.wxSTC_KEY_END  # 305
wxSTC_KEY_ESCAPE = stc.wxSTC_KEY_ESCAPE  # 7
wxSTC_KEY_HOME = stc.wxSTC_KEY_HOME  # 304
wxSTC_KEY_INSERT = stc.wxSTC_KEY_INSERT  # 309
wxSTC_KEY_LEFT = stc.wxSTC_KEY_LEFT  # 302
wxSTC_KEY_NEXT = stc.wxSTC_KEY_NEXT  # 307
wxSTC_KEY_PRIOR = stc.wxSTC_KEY_PRIOR  # 306
wxSTC_KEY_RETURN = stc.wxSTC_KEY_RETURN  # 13
wxSTC_KEY_RIGHT = stc.wxSTC_KEY_RIGHT  # 303
wxSTC_KEY_SUBTRACT = stc.wxSTC_KEY_SUBTRACT  # 311
wxSTC_KEY_TAB = stc.wxSTC_KEY_TAB  # 9
wxSTC_KEY_UP = stc.wxSTC_KEY_UP  # 301
wxSTC_LASTSTEPINUNDOREDO = stc.wxSTC_LASTSTEPINUNDOREDO  # 256
wxSTC_LEXER_START = stc.wxSTC_LEXER_START  # 4000
wxSTC_LEX_ADA = stc.wxSTC_LEX_ADA  # 20
wxSTC_LEX_ASP = stc.wxSTC_LEX_ASP  # 29
wxSTC_LEX_AUTOMATIC = stc.wxSTC_LEX_AUTOMATIC  # 1000
wxSTC_LEX_AVE = stc.wxSTC_LEX_AVE  # 19
wxSTC_LEX_BAAN = stc.wxSTC_LEX_BAAN  # 31
wxSTC_LEX_BATCH = stc.wxSTC_LEX_BATCH  # 12
wxSTC_LEX_BULLANT = stc.wxSTC_LEX_BULLANT  # 27
wxSTC_LEX_CONF = stc.wxSTC_LEX_CONF  # 17
wxSTC_LEX_CONTAINER = stc.wxSTC_LEX_CONTAINER  # 0
wxSTC_LEX_CPP = stc.wxSTC_LEX_CPP  # 3
wxSTC_LEX_DIFF = stc.wxSTC_LEX_DIFF  # 16
wxSTC_LEX_EIFFEL = stc.wxSTC_LEX_EIFFEL  # 23
wxSTC_LEX_EIFFELKW = stc.wxSTC_LEX_EIFFELKW  # 24
wxSTC_LEX_ERRORLIST = stc.wxSTC_LEX_ERRORLIST  # 10
wxSTC_LEX_HTML = stc.wxSTC_LEX_HTML  # 4
wxSTC_LEX_LATEX = stc.wxSTC_LEX_LATEX  # 14
wxSTC_LEX_LISP = stc.wxSTC_LEX_LISP  # 21
wxSTC_LEX_LUA = stc.wxSTC_LEX_LUA  # 15
wxSTC_LEX_MAKEFILE = stc.wxSTC_LEX_MAKEFILE  # 11
wxSTC_LEX_MATLAB = stc.wxSTC_LEX_MATLAB  # 32
wxSTC_LEX_NNCRONTAB = stc.wxSTC_LEX_NNCRONTAB  # 26
wxSTC_LEX_NULL = stc.wxSTC_LEX_NULL  # 1
wxSTC_LEX_PASCAL = stc.wxSTC_LEX_PASCAL  # 18
wxSTC_LEX_PERL = stc.wxSTC_LEX_PERL  # 6
wxSTC_LEX_PHP = stc.wxSTC_LEX_PHP  # 30
wxSTC_LEX_PROPERTIES = stc.wxSTC_LEX_PROPERTIES  # 9
wxSTC_LEX_PYTHON = stc.wxSTC_LEX_PYTHON  # 2
wxSTC_LEX_RUBY = stc.wxSTC_LEX_RUBY  # 22
wxSTC_LEX_SCRIPTOL = stc.wxSTC_LEX_SCRIPTOL  # 33
wxSTC_LEX_SQL = stc.wxSTC_LEX_SQL  # 7
wxSTC_LEX_TCL = stc.wxSTC_LEX_TCL  # 25
wxSTC_LEX_VB = stc.wxSTC_LEX_VB  # 8
wxSTC_LEX_VBSCRIPT = stc.wxSTC_LEX_VBSCRIPT  # 28
wxSTC_LEX_XCODE = stc.wxSTC_LEX_XCODE  # 13
wxSTC_LEX_XML = stc.wxSTC_LEX_XML  # 5
wxSTC_LISP_COMMENT = stc.wxSTC_LISP_COMMENT  # 1
wxSTC_LISP_DEFAULT = stc.wxSTC_LISP_DEFAULT  # 0
wxSTC_LISP_IDENTIFIER = stc.wxSTC_LISP_IDENTIFIER  # 9
wxSTC_LISP_KEYWORD = stc.wxSTC_LISP_KEYWORD  # 3
wxSTC_LISP_NUMBER = stc.wxSTC_LISP_NUMBER  # 2
wxSTC_LISP_OPERATOR = stc.wxSTC_LISP_OPERATOR  # 10
wxSTC_LISP_STRING = stc.wxSTC_LISP_STRING  # 6
wxSTC_LISP_STRINGEOL = stc.wxSTC_LISP_STRINGEOL  # 8
wxSTC_LUA_CHARACTER = stc.wxSTC_LUA_CHARACTER  # 7
wxSTC_LUA_COMMENT = stc.wxSTC_LUA_COMMENT  # 1
wxSTC_LUA_COMMENTDOC = stc.wxSTC_LUA_COMMENTDOC  # 3
wxSTC_LUA_COMMENTLINE = stc.wxSTC_LUA_COMMENTLINE  # 2
wxSTC_LUA_DEFAULT = stc.wxSTC_LUA_DEFAULT  # 0
wxSTC_LUA_IDENTIFIER = stc.wxSTC_LUA_IDENTIFIER  # 11
wxSTC_LUA_LITERALSTRING = stc.wxSTC_LUA_LITERALSTRING  # 8
wxSTC_LUA_NUMBER = stc.wxSTC_LUA_NUMBER  # 4
wxSTC_LUA_OPERATOR = stc.wxSTC_LUA_OPERATOR  # 10
wxSTC_LUA_PREPROCESSOR = stc.wxSTC_LUA_PREPROCESSOR  # 9
wxSTC_LUA_STRING = stc.wxSTC_LUA_STRING  # 6
wxSTC_LUA_STRINGEOL = stc.wxSTC_LUA_STRINGEOL  # 12
wxSTC_LUA_WORD = stc.wxSTC_LUA_WORD  # 5
wxSTC_LUA_WORD2 = stc.wxSTC_LUA_WORD2  # 13
wxSTC_LUA_WORD3 = stc.wxSTC_LUA_WORD3  # 14
wxSTC_LUA_WORD4 = stc.wxSTC_LUA_WORD4  # 15
wxSTC_LUA_WORD5 = stc.wxSTC_LUA_WORD5  # 16
wxSTC_LUA_WORD6 = stc.wxSTC_LUA_WORD6  # 17
wxSTC_L_COMMAND = stc.wxSTC_L_COMMAND  # 1
wxSTC_L_COMMENT = stc.wxSTC_L_COMMENT  # 4
wxSTC_L_DEFAULT = stc.wxSTC_L_DEFAULT  # 0
wxSTC_L_MATH = stc.wxSTC_L_MATH  # 3
wxSTC_L_TAG = stc.wxSTC_L_TAG  # 2
wxSTC_MAKE_COMMENT = stc.wxSTC_MAKE_COMMENT  # 1
wxSTC_MAKE_DEFAULT = stc.wxSTC_MAKE_DEFAULT  # 0
wxSTC_MAKE_IDENTIFIER = stc.wxSTC_MAKE_IDENTIFIER  # 3
wxSTC_MAKE_IDEOL = stc.wxSTC_MAKE_IDEOL  # 9
wxSTC_MAKE_OPERATOR = stc.wxSTC_MAKE_OPERATOR  # 4
wxSTC_MAKE_PREPROCESSOR = stc.wxSTC_MAKE_PREPROCESSOR  # 2
wxSTC_MAKE_TARGET = stc.wxSTC_MAKE_TARGET  # 5
wxSTC_MARGIN_NUMBER = stc.wxSTC_MARGIN_NUMBER  # 1
wxSTC_MARGIN_SYMBOL = stc.wxSTC_MARGIN_SYMBOL  # 0
wxSTC_MARKER_MAX = stc.wxSTC_MARKER_MAX  # 31
wxSTC_MARKNUM_FOLDER = stc.wxSTC_MARKNUM_FOLDER  # 30
wxSTC_MARKNUM_FOLDEREND = stc.wxSTC_MARKNUM_FOLDEREND  # 25
wxSTC_MARKNUM_FOLDERMIDTAIL = stc.wxSTC_MARKNUM_FOLDERMIDTAIL  # 27
wxSTC_MARKNUM_FOLDEROPEN = stc.wxSTC_MARKNUM_FOLDEROPEN  # 31
wxSTC_MARKNUM_FOLDEROPENMID = stc.wxSTC_MARKNUM_FOLDEROPENMID  # 26
wxSTC_MARKNUM_FOLDERSUB = stc.wxSTC_MARKNUM_FOLDERSUB  # 29
wxSTC_MARKNUM_FOLDERTAIL = stc.wxSTC_MARKNUM_FOLDERTAIL  # 28
wxSTC_MARK_ARROW = stc.wxSTC_MARK_ARROW  # 2
wxSTC_MARK_ARROWDOWN = stc.wxSTC_MARK_ARROWDOWN  # 6
wxSTC_MARK_ARROWS = stc.wxSTC_MARK_ARROWS  # 24
wxSTC_MARK_BACKGROUND = stc.wxSTC_MARK_BACKGROUND  # 22
wxSTC_MARK_BOXMINUS = stc.wxSTC_MARK_BOXMINUS  # 14
wxSTC_MARK_BOXMINUSCONNECTED = stc.wxSTC_MARK_BOXMINUSCONNECTED  # 15
wxSTC_MARK_BOXPLUS = stc.wxSTC_MARK_BOXPLUS  # 12
wxSTC_MARK_BOXPLUSCONNECTED = stc.wxSTC_MARK_BOXPLUSCONNECTED  # 13
wxSTC_MARK_CHARACTER = stc.wxSTC_MARK_CHARACTER  # 10000
wxSTC_MARK_CIRCLE = stc.wxSTC_MARK_CIRCLE  # 0
wxSTC_MARK_CIRCLEMINUS = stc.wxSTC_MARK_CIRCLEMINUS  # 20
wxSTC_MARK_CIRCLEMINUSCONNECTED = stc.wxSTC_MARK_CIRCLEMINUSCONNECTED  # 21
wxSTC_MARK_CIRCLEPLUS = stc.wxSTC_MARK_CIRCLEPLUS  # 18
wxSTC_MARK_CIRCLEPLUSCONNECTED = stc.wxSTC_MARK_CIRCLEPLUSCONNECTED  # 19
wxSTC_MARK_DOTDOTDOT = stc.wxSTC_MARK_DOTDOTDOT  # 23
wxSTC_MARK_EMPTY = stc.wxSTC_MARK_EMPTY  # 5
wxSTC_MARK_LCORNER = stc.wxSTC_MARK_LCORNER  # 10
wxSTC_MARK_LCORNERCURVE = stc.wxSTC_MARK_LCORNERCURVE  # 16
wxSTC_MARK_MINUS = stc.wxSTC_MARK_MINUS  # 7
wxSTC_MARK_PLUS = stc.wxSTC_MARK_PLUS  # 8
wxSTC_MARK_ROUNDRECT = stc.wxSTC_MARK_ROUNDRECT  # 1
wxSTC_MARK_SHORTARROW = stc.wxSTC_MARK_SHORTARROW  # 4
wxSTC_MARK_SMALLRECT = stc.wxSTC_MARK_SMALLRECT  # 3
wxSTC_MARK_TCORNER = stc.wxSTC_MARK_TCORNER  # 11
wxSTC_MARK_TCORNERCURVE = stc.wxSTC_MARK_TCORNERCURVE  # 17
wxSTC_MARK_VLINE = stc.wxSTC_MARK_VLINE  # 9
wxSTC_MASK_FOLDERS = stc.wxSTC_MASK_FOLDERS  # -33554432
wxSTC_MATLAB_COMMAND = stc.wxSTC_MATLAB_COMMAND  # 2
wxSTC_MATLAB_COMMENT = stc.wxSTC_MATLAB_COMMENT  # 1
wxSTC_MATLAB_DEFAULT = stc.wxSTC_MATLAB_DEFAULT  # 0
wxSTC_MATLAB_IDENTIFIER = stc.wxSTC_MATLAB_IDENTIFIER  # 7
wxSTC_MATLAB_KEYWORD = stc.wxSTC_MATLAB_KEYWORD  # 4
wxSTC_MATLAB_NUMBER = stc.wxSTC_MATLAB_NUMBER  # 3
wxSTC_MATLAB_OPERATOR = stc.wxSTC_MATLAB_OPERATOR  # 6
wxSTC_MATLAB_STRING = stc.wxSTC_MATLAB_STRING  # 5
wxSTC_MODEVENTMASKALL = stc.wxSTC_MODEVENTMASKALL  # 3959
wxSTC_MOD_BEFOREDELETE = stc.wxSTC_MOD_BEFOREDELETE  # 2048
wxSTC_MOD_BEFOREINSERT = stc.wxSTC_MOD_BEFOREINSERT  # 1024
wxSTC_MOD_CHANGEFOLD = stc.wxSTC_MOD_CHANGEFOLD  # 8
wxSTC_MOD_CHANGEMARKER = stc.wxSTC_MOD_CHANGEMARKER  # 512
wxSTC_MOD_CHANGESTYLE = stc.wxSTC_MOD_CHANGESTYLE  # 4
wxSTC_MOD_DELETETEXT = stc.wxSTC_MOD_DELETETEXT  # 2
wxSTC_MOD_INSERTTEXT = stc.wxSTC_MOD_INSERTTEXT  # 1
wxSTC_NNCRONTAB_ASTERISK = stc.wxSTC_NNCRONTAB_ASTERISK  # 6
wxSTC_NNCRONTAB_COMMENT = stc.wxSTC_NNCRONTAB_COMMENT  # 1
wxSTC_NNCRONTAB_DEFAULT = stc.wxSTC_NNCRONTAB_DEFAULT  # 0
wxSTC_NNCRONTAB_ENVIRONMENT = stc.wxSTC_NNCRONTAB_ENVIRONMENT  # 9
wxSTC_NNCRONTAB_IDENTIFIER = stc.wxSTC_NNCRONTAB_IDENTIFIER  # 10
wxSTC_NNCRONTAB_KEYWORD = stc.wxSTC_NNCRONTAB_KEYWORD  # 4
wxSTC_NNCRONTAB_MODIFIER = stc.wxSTC_NNCRONTAB_MODIFIER  # 5
wxSTC_NNCRONTAB_NUMBER = stc.wxSTC_NNCRONTAB_NUMBER  # 7
wxSTC_NNCRONTAB_SECTION = stc.wxSTC_NNCRONTAB_SECTION  # 3
wxSTC_NNCRONTAB_STRING = stc.wxSTC_NNCRONTAB_STRING  # 8
wxSTC_NNCRONTAB_TASK = stc.wxSTC_NNCRONTAB_TASK  # 2
wxSTC_OPTIONAL_START = stc.wxSTC_OPTIONAL_START  # 3000
wxSTC_PERFORMED_REDO = stc.wxSTC_PERFORMED_REDO  # 64
wxSTC_PERFORMED_UNDO = stc.wxSTC_PERFORMED_UNDO  # 32
wxSTC_PERFORMED_USER = stc.wxSTC_PERFORMED_USER  # 16
wxSTC_PL_ARRAY = stc.wxSTC_PL_ARRAY  # 13
wxSTC_PL_BACKTICKS = stc.wxSTC_PL_BACKTICKS  # 20
wxSTC_PL_CHARACTER = stc.wxSTC_PL_CHARACTER  # 7
wxSTC_PL_COMMENTLINE = stc.wxSTC_PL_COMMENTLINE  # 2
wxSTC_PL_DATASECTION = stc.wxSTC_PL_DATASECTION  # 21
wxSTC_PL_DEFAULT = stc.wxSTC_PL_DEFAULT  # 0
wxSTC_PL_ERROR = stc.wxSTC_PL_ERROR  # 1
wxSTC_PL_HASH = stc.wxSTC_PL_HASH  # 14
wxSTC_PL_HERE_DELIM = stc.wxSTC_PL_HERE_DELIM  # 22
wxSTC_PL_HERE_Q = stc.wxSTC_PL_HERE_Q  # 23
wxSTC_PL_HERE_QQ = stc.wxSTC_PL_HERE_QQ  # 24
wxSTC_PL_HERE_QX = stc.wxSTC_PL_HERE_QX  # 25
wxSTC_PL_IDENTIFIER = stc.wxSTC_PL_IDENTIFIER  # 11
wxSTC_PL_LONGQUOTE = stc.wxSTC_PL_LONGQUOTE  # 19
wxSTC_PL_NUMBER = stc.wxSTC_PL_NUMBER  # 4
wxSTC_PL_OPERATOR = stc.wxSTC_PL_OPERATOR  # 10
wxSTC_PL_POD = stc.wxSTC_PL_POD  # 3
wxSTC_PL_PREPROCESSOR = stc.wxSTC_PL_PREPROCESSOR  # 9
wxSTC_PL_PUNCTUATION = stc.wxSTC_PL_PUNCTUATION  # 8
wxSTC_PL_REGEX = stc.wxSTC_PL_REGEX  # 17
wxSTC_PL_REGSUBST = stc.wxSTC_PL_REGSUBST  # 18
wxSTC_PL_SCALAR = stc.wxSTC_PL_SCALAR  # 12
wxSTC_PL_STRING = stc.wxSTC_PL_STRING  # 6
wxSTC_PL_STRING_Q = stc.wxSTC_PL_STRING_Q  # 26
wxSTC_PL_STRING_QQ = stc.wxSTC_PL_STRING_QQ  # 27
wxSTC_PL_STRING_QR = stc.wxSTC_PL_STRING_QR  # 29
wxSTC_PL_STRING_QW = stc.wxSTC_PL_STRING_QW  # 30
wxSTC_PL_STRING_QX = stc.wxSTC_PL_STRING_QX  # 28
wxSTC_PL_SYMBOLTABLE = stc.wxSTC_PL_SYMBOLTABLE  # 15
wxSTC_PL_WORD = stc.wxSTC_PL_WORD  # 5
wxSTC_PRINT_BLACKONWHITE = stc.wxSTC_PRINT_BLACKONWHITE  # 2
wxSTC_PRINT_COLOURONWHITE = stc.wxSTC_PRINT_COLOURONWHITE  # 3
wxSTC_PRINT_COLOURONWHITEDEFAULTBG = stc.wxSTC_PRINT_COLOURONWHITEDEFAULTBG  # 4
wxSTC_PRINT_INVERTLIGHT = stc.wxSTC_PRINT_INVERTLIGHT  # 1
wxSTC_PRINT_NORMAL = stc.wxSTC_PRINT_NORMAL  # 0
wxSTC_PROPS_ASSIGNMENT = stc.wxSTC_PROPS_ASSIGNMENT  # 3
wxSTC_PROPS_COMMENT = stc.wxSTC_PROPS_COMMENT  # 1
wxSTC_PROPS_DEFAULT = stc.wxSTC_PROPS_DEFAULT  # 0
wxSTC_PROPS_DEFVAL = stc.wxSTC_PROPS_DEFVAL  # 4
wxSTC_PROPS_SECTION = stc.wxSTC_PROPS_SECTION  # 2
wxSTC_P_CHARACTER = stc.wxSTC_P_CHARACTER  # 4
wxSTC_P_CLASSNAME = stc.wxSTC_P_CLASSNAME  # 8
wxSTC_P_COMMENTBLOCK = stc.wxSTC_P_COMMENTBLOCK  # 12
wxSTC_P_COMMENTLINE = stc.wxSTC_P_COMMENTLINE  # 1
wxSTC_P_DEFAULT = stc.wxSTC_P_DEFAULT  # 0
wxSTC_P_DEFNAME = stc.wxSTC_P_DEFNAME  # 9
wxSTC_P_IDENTIFIER = stc.wxSTC_P_IDENTIFIER  # 11
wxSTC_P_NUMBER = stc.wxSTC_P_NUMBER  # 2
wxSTC_P_OPERATOR = stc.wxSTC_P_OPERATOR  # 10
wxSTC_P_STRING = stc.wxSTC_P_STRING  # 3
wxSTC_P_STRINGEOL = stc.wxSTC_P_STRINGEOL  # 13
wxSTC_P_TRIPLE = stc.wxSTC_P_TRIPLE  # 6
wxSTC_P_TRIPLEDOUBLE = stc.wxSTC_P_TRIPLEDOUBLE  # 7
wxSTC_P_WORD = stc.wxSTC_P_WORD  # 5
wxSTC_SCMOD_ALT = stc.wxSTC_SCMOD_ALT  # 4
wxSTC_SCMOD_CTRL = stc.wxSTC_SCMOD_CTRL  # 2
wxSTC_SCMOD_SHIFT = stc.wxSTC_SCMOD_SHIFT  # 1
wxSTC_SCRIPTOL_CHARACTER = stc.wxSTC_SCRIPTOL_CHARACTER  # 7
wxSTC_SCRIPTOL_COMMENT = stc.wxSTC_SCRIPTOL_COMMENT  # 1
wxSTC_SCRIPTOL_COMMENTBASIC = stc.wxSTC_SCRIPTOL_COMMENTBASIC  # 19
wxSTC_SCRIPTOL_COMMENTDOC = stc.wxSTC_SCRIPTOL_COMMENTDOC  # 3
wxSTC_SCRIPTOL_COMMENTDOCKEYWORD = stc.wxSTC_SCRIPTOL_COMMENTDOCKEYWORD  # 17
wxSTC_SCRIPTOL_COMMENTDOCKEYWORDERROR = stc.wxSTC_SCRIPTOL_COMMENTDOCKEYWORDERROR  # 18
wxSTC_SCRIPTOL_COMMENTLINE = stc.wxSTC_SCRIPTOL_COMMENTLINE  # 2
wxSTC_SCRIPTOL_COMMENTLINEDOC = stc.wxSTC_SCRIPTOL_COMMENTLINEDOC  # 15
wxSTC_SCRIPTOL_DEFAULT = stc.wxSTC_SCRIPTOL_DEFAULT  # 0
wxSTC_SCRIPTOL_IDENTIFIER = stc.wxSTC_SCRIPTOL_IDENTIFIER  # 11
wxSTC_SCRIPTOL_NUMBER = stc.wxSTC_SCRIPTOL_NUMBER  # 4
wxSTC_SCRIPTOL_OPERATOR = stc.wxSTC_SCRIPTOL_OPERATOR  # 10
wxSTC_SCRIPTOL_PREPROCESSOR = stc.wxSTC_SCRIPTOL_PREPROCESSOR  # 9
wxSTC_SCRIPTOL_REGEX = stc.wxSTC_SCRIPTOL_REGEX  # 14
wxSTC_SCRIPTOL_STRING = stc.wxSTC_SCRIPTOL_STRING  # 6
wxSTC_SCRIPTOL_STRINGEOL = stc.wxSTC_SCRIPTOL_STRINGEOL  # 12
wxSTC_SCRIPTOL_UUID = stc.wxSTC_SCRIPTOL_UUID  # 8
wxSTC_SCRIPTOL_VERBATIM = stc.wxSTC_SCRIPTOL_VERBATIM  # 13
wxSTC_SCRIPTOL_WORD = stc.wxSTC_SCRIPTOL_WORD  # 5
wxSTC_SCRIPTOL_WORD2 = stc.wxSTC_SCRIPTOL_WORD2  # 16
wxSTC_START = stc.wxSTC_START  # 2000
wxSTC_STYLE_BRACEBAD = stc.wxSTC_STYLE_BRACEBAD  # 35
wxSTC_STYLE_BRACELIGHT = stc.wxSTC_STYLE_BRACELIGHT  # 34
wxSTC_STYLE_CONTROLCHAR = stc.wxSTC_STYLE_CONTROLCHAR  # 36
wxSTC_STYLE_DEFAULT = stc.wxSTC_STYLE_DEFAULT  # 32
wxSTC_STYLE_INDENTGUIDE = stc.wxSTC_STYLE_INDENTGUIDE  # 37
wxSTC_STYLE_LASTPREDEFINED = stc.wxSTC_STYLE_LASTPREDEFINED  # 39
wxSTC_STYLE_LINENUMBER = stc.wxSTC_STYLE_LINENUMBER  # 33
wxSTC_STYLE_MAX = stc.wxSTC_STYLE_MAX  # 127
wxSTC_TIME_FOREVER = stc.wxSTC_TIME_FOREVER  # 10000000
wxSTC_USE_POPUP = stc.wxSTC_USE_POPUP  # 1
wxSTC_VISIBLE_SLOP = stc.wxSTC_VISIBLE_SLOP  # 1
wxSTC_VISIBLE_STRICT = stc.wxSTC_VISIBLE_STRICT  # 4
wxSTC_WRAP_NONE = stc.wxSTC_WRAP_NONE  # 0
wxSTC_WRAP_WORD = stc.wxSTC_WRAP_WORD  # 1
wxSTC_WS_INVISIBLE = stc.wxSTC_WS_INVISIBLE  # 0
wxSTC_WS_VISIBLEAFTERINDENT = stc.wxSTC_WS_VISIBLEAFTERINDENT  # 2
wxSTC_WS_VISIBLEALWAYS = stc.wxSTC_WS_VISIBLEALWAYS  # 1
# End generated constants.
