/****************************************************************************
** libebml : parse EBML files, see http://embl.sourceforge.net/
**
** <file/class description>
**
** Copyright (C) 2003 Jory Stone.  All rights reserved.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding an other license may use this file in accordance with 
** the Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.matroska.org/license/qpl/ for QPL licensing information.
** See http://www.matroska.org/license/gpl/ for GPL licensing information.
**
** Contact license@matroska.org if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

/*!
	\file
	\version \$Id: MemIOCallback.cpp,v 1.3 2003/08/01 22:25:39 robux4 Exp $
	\author Jory Stone <jcsston @ toughguy.net>
*/

#include "StdInclude.h"
#include "ebml/MemIOCallback.h"
#include "ebml/Debug.h"
#include "ebml/EbmlConfig.h"

START_LIBEBML_NAMESPACE

MemIOCallback::MemIOCallback(uint64 DefaultSize)
{
	//The default size of the buffer is 128 bytes
	dataBuffer = (binary *)malloc(DefaultSize);
	dataBufferMemorySize = DefaultSize;
	dataBufferPos = 0;
	dataBufferTotalSize = 0;
}

MemIOCallback::~MemIOCallback()
{
	free(dataBuffer);
}

uint32 MemIOCallback::read(void *Buffer, size_t Size)
{
	if (Buffer == NULL || Size < 1)
		return 0;
	//If the size is larger than than the amount left in the buffer
	if (Size > dataBufferTotalSize - dataBufferPos)
	{
		//We will only return the remaining data
		memcpy(Buffer, dataBuffer + dataBufferPos, dataBufferTotalSize - dataBufferPos);
		dataBufferPos = dataBufferTotalSize;
		return dataBufferTotalSize - dataBufferPos;
	}
		
	//Well... We made it here, so do a quick and simple copy
	memcpy(Buffer, dataBuffer+dataBufferPos, Size);
	dataBufferPos += Size;

	return Size;
}

void MemIOCallback::setFilePointer(int64 Offset, seek_mode Mode)
{
	if (Mode == seek_beginning)
		dataBufferPos = Offset;
	else if (Mode == seek_current)
		dataBufferPos = dataBufferPos + Offset;
	else if (Mode == seek_end)
		dataBufferPos = dataBufferTotalSize + Offset;
}

size_t MemIOCallback::write(const void *Buffer, size_t Size)
{
	if (dataBufferMemorySize < dataBufferPos + Size)
	{
		//We need more memory!
		dataBuffer = (binary *)realloc((void *)dataBuffer, dataBufferPos + Size);		
	}
	memcpy(dataBuffer+dataBufferPos, Buffer, Size);
	dataBufferPos += Size;
	if (dataBufferPos > dataBufferTotalSize)
		dataBufferTotalSize = dataBufferPos;

	return Size;
}

uint32 MemIOCallback::write(IOCallback & IOToRead, size_t Size)
{
	if (dataBufferMemorySize < dataBufferPos + Size)
	{
		//We need more memory!
		dataBuffer = (binary *)realloc((void *)dataBuffer, dataBufferPos + Size);		
	}
	IOToRead.readFully(&dataBuffer[dataBufferPos], Size);
	dataBufferTotalSize = Size;
	return Size;
}

END_LIBEBML_NAMESPACE
