/*****************************************************************************
 * modules_builtin.h: built-in modules list
 *****************************************************************************
 * Copyright (C) 2001 VideoLAN
 *
 * Authors: Samuel Hocevar <sam@zoy.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/

#define ALLOCATE_BUILTIN( NAME ) \
    AllocateBuiltinModule( module_ ## NAME ## _InitModule, \
                           module_ ## NAME ## _ActivateModule, \
                           module_ ## NAME ## _DeactivateModule );

/* Add stuff here */

int module_es_InitModule( module_t* );
int module_es_ActivateModule( module_t* );
int module_es_DeactivateModule( module_t* );
int module_ps_InitModule( module_t* );
int module_ps_ActivateModule( module_t* );
int module_ps_DeactivateModule( module_t* );
int module_ts_InitModule( module_t* );
int module_ts_ActivateModule( module_t* );
int module_ts_DeactivateModule( module_t* );
int module_yuv_InitModule( module_t* );
int module_yuv_ActivateModule( module_t* );
int module_yuv_DeactivateModule( module_t* );
int module_idct_InitModule( module_t* );
int module_idct_ActivateModule( module_t* );
int module_idct_DeactivateModule( module_t* );
int module_idctclassic_InitModule( module_t* );
int module_idctclassic_ActivateModule( module_t* );
int module_idctclassic_DeactivateModule( module_t* );
int module_motion_InitModule( module_t* );
int module_motion_ActivateModule( module_t* );
int module_motion_DeactivateModule( module_t* );
int module_imdct_InitModule( module_t* );
int module_imdct_ActivateModule( module_t* );
int module_imdct_DeactivateModule( module_t* );
int module_downmix_InitModule( module_t* );
int module_downmix_ActivateModule( module_t* );
int module_downmix_DeactivateModule( module_t* );
int module_dummy_InitModule( module_t* );
int module_dummy_ActivateModule( module_t* );
int module_dummy_DeactivateModule( module_t* );
int module_null_InitModule( module_t* );
int module_null_ActivateModule( module_t* );
int module_null_DeactivateModule( module_t* );
int module_rc_InitModule( module_t* );
int module_rc_ActivateModule( module_t* );
int module_rc_DeactivateModule( module_t* );
int module_idctmmx_InitModule( module_t* );
int module_idctmmx_ActivateModule( module_t* );
int module_idctmmx_DeactivateModule( module_t* );
int module_motionmmx_InitModule( module_t* );
int module_motionmmx_ActivateModule( module_t* );
int module_motionmmx_DeactivateModule( module_t* );
int module_idctmmxext_InitModule( module_t* );
int module_idctmmxext_ActivateModule( module_t* );
int module_idctmmxext_DeactivateModule( module_t* );
int module_motionmmxext_InitModule( module_t* );
int module_motionmmxext_ActivateModule( module_t* );
int module_motionmmxext_DeactivateModule( module_t* );
int module_imdct3dn_InitModule( module_t* );
int module_imdct3dn_ActivateModule( module_t* );
int module_imdct3dn_DeactivateModule( module_t* );

#define ALLOCATE_ALL_BUILTINS() do { ALLOCATE_BUILTIN(es); ALLOCATE_BUILTIN(ps); ALLOCATE_BUILTIN(ts); ALLOCATE_BUILTIN(yuv); ALLOCATE_BUILTIN(idct); ALLOCATE_BUILTIN(idctclassic); ALLOCATE_BUILTIN(motion); ALLOCATE_BUILTIN(imdct); ALLOCATE_BUILTIN(downmix); ALLOCATE_BUILTIN(dummy); ALLOCATE_BUILTIN(null); ALLOCATE_BUILTIN(rc); ALLOCATE_BUILTIN(idctmmx); ALLOCATE_BUILTIN(motionmmx); ALLOCATE_BUILTIN(idctmmxext); ALLOCATE_BUILTIN(motionmmxext); ALLOCATE_BUILTIN(imdct3dn); } while( 0 );

