/*
 * Copyright (C) 2013 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef ANDROID_AUDIO_TIMESTAMP_H
#define ANDROID_AUDIO_TIMESTAMP_H

#include <time.h>

class AudioTimestamp {
public:
    AudioTimestamp() : mPosition(0) {
        mTime.tv_sec = 0;
        mTime.tv_nsec = 0;
    }
    // FIXME change type to match android.media.AudioTrack
    uint32_t        mPosition; // a frame position in AudioTrack::getPosition() units
    struct timespec mTime;     // corresponding CLOCK_MONOTONIC when frame is expected to present
};

#endif  // ANDROID_AUDIO_TIMESTAMP_H
