/*
 * Decompiled with CFR 0.152.
 */
package vlcskineditor;

import java.util.LinkedList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import vlcskineditor.Skin;
import vlcskineditor.resources.ResourceChangeListener;
import vlcskineditor.resources.ResourceChangedEvent;

public abstract class Resource {
    public String id;
    public String type;
    public Skin s;
    public List<ResourceChangeListener> resourceChangeListeners = new LinkedList<ResourceChangeListener>();

    public abstract void showOptions();

    public abstract void update();

    public abstract String returnCode(String var1);

    public abstract DefaultMutableTreeNode getTreeNode();

    public Resource getParentOf(String string) {
        return null;
    }

    public void renameForCopy(String string) {
        String string2;
        String string3 = string2 = (string = string.replaceAll("%oldid%", this.id));
        int n = 1;
        while (this.s.idExists(string3)) {
            string3 = string2 + "_" + String.valueOf(++n);
        }
        this.id = string3;
    }

    public void addResourceChangeListener(ResourceChangeListener resourceChangeListener) {
        this.resourceChangeListeners.add(resourceChangeListener);
    }

    public void removeResourceChangeListener(ResourceChangeListener resourceChangeListener) {
        this.resourceChangeListeners.remove(resourceChangeListener);
    }

    protected void fireResourceChangedEvent(String string) {
        ResourceChangedEvent resourceChangedEvent = new ResourceChangedEvent(string, this);
        for (ResourceChangeListener resourceChangeListener : this.resourceChangeListeners) {
            resourceChangeListener.onResourceChanged(resourceChangedEvent);
        }
    }
}

