/*

	dxerr.c - DirectX 8 & 9 Error Functions

	Written by Filip Navara <xnavara@volny.cz>

	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

	NOTE: Do not use this file directly!

*/

#include <windows.h>

#ifndef DXERROR
#define DXERROR(v,n,d) {v, TEXT(n), TEXT(d)},
#define DXERRORLAST(v,n,d) {v, TEXT(n), TEXT(d)}
#endif
#ifndef DXERROR8
#define DXERROR8(v,n,d)
#define DXERROR8LAST(v,n,d)
#endif
#ifndef DXERROR9
#define DXERROR9(v,n,d)
#define DXERROR9LAST(v,n,d)
#endif

typedef struct {
	unsigned long Value;
	TCHAR *Name;
	TCHAR *Description;
} Error;

static Error Errors[] = {
	DXERROR(0, "S_OK", "The function completed successfully")
	DXERROR(0x1, "S_FALSE", "Call successful, but returned FALSE")
	DXERROR(0x2, "DXERROR_FILE_NOT_FOUND", "The system cannot find the file specified.")
	DXERROR(0x3, "DXERROR_PATH_NOT_FOUND", "The system cannot find the path specified.")
	DXERROR(0x4, "DXERROR_TOO_MANY_OPEN_FILES", "The system cannot open the file.")
	DXERROR(0x5, "DXERROR_ACCESS_DENIED", "Access is denied.")
	DXERROR(0x6, "DXERROR_INVALID_HANDLE", "The handle is invalid.")
	DXERROR(0x8, "DXERROR_NOT_ENOUGH_MEMORY", "Not enough storage is available to process this command.")
	DXERROR(0x9, "DXERROR_INVALID_BLOCK", "The storage control block address is invalid.")
	DXERROR(0xa, "DXERROR_BAD_ENVIRONMENT", "The environment is incorrect.")
	DXERROR(0xb, "DXERROR_BAD_FORMAT", "An attempt was made to load a program with an incorrect format.")
	DXERROR(0xe, "DXERROR_OUTOFMEMORY", "The system cannot find the drive specified.")
	DXERROR9(0x40003, "Unknown", "End of stream. Sample not updated.")
	DXERROR(0x40103, "VFW_S_NO_MORE_ITEMS", "The end of the list has been reached.")
	DXERROR(0x4022d, "VFW_S_DUPLICATE_NAME", "An attempt to add a filter with a duplicate name succeeded with a modified name.")
	DXERROR(0x40237, "VFW_S_STATE_INTERMEDIATE", "The state transition has not completed.")
	DXERROR(0x40242, "VFW_S_PARTIAL_RENDER", "Some of the streams in this movie are in an unsupported format.")
	DXERROR(0x40245, "VFW_S_SOME_DATA_IGNORED", "The file contained some property settings that were not used.")
	DXERROR(0x40246, "VFW_S_CONNECTIONS_DEFERRED", "Some connections have failed and have been deferred.")
	DXERROR(0x40250, "VFW_S_RESOURCE_NOT_NEEDED", "The resource specified is no longer needed.")
	DXERROR(0x40254, "VFW_S_MEDIA_TYPE_IGNORED", "A connection could not be made with the media type in the persistent graph, but has been made with a negotiated media type.")
	DXERROR(0x40257, "VFW_S_VIDEO_NOT_RENDERED", "Cannot play back the video stream: no suitable decompressor could be found.")
	DXERROR(0x40258, "VFW_S_AUDIO_NOT_RENDERED", "Cannot play back the audio stream: no audio hardware is available.")
	DXERROR(0x4025a, "VFW_S_RPZA", "Cannot play back the video stream: format 'RPZA' is not supported.")
	DXERROR(0x40260, "VFW_S_ESTIMATED", "The value returned had to be estimated.  It's accuracy can not be guaranteed.")
	DXERROR(0x40263, "VFW_S_RESERVED", "This success code is reserved for internal purposes within ActiveMovie.")
	DXERROR(0x40267, "VFW_S_STREAM_OFF", "The stream has been turned off.")
	DXERROR(0x40268, "VFW_S_CANT_CUE", "The graph can't be cued because of lack of or corrupt data.")
	DXERROR(0x40270, "VFW_S_NO_STOP_TIME", "The stop time for the sample was not set.")
	DXERROR(0x4027e, "VFW_S_NOPREVIEWPIN", "There was no preview pin available, so the capture pin output is being split to provide both capture and preview.")
	DXERROR(0x40280, "VFW_S_DVD_NON_ONE_SEQUENTIAL", "The current title was not a sequential set of chapters (PGC) and the returned timing information might not be continuous.")
	DXERROR(0x4028c, "VFW_S_DVD_CHANNEL_CONTENTS_NOT_AVAILABLE", "The audio stream did not contain sufficient information to determine the contents of each channel.")
	DXERROR(0x4028d, "VFW_S_DVD_NOT_ACCURATE", "The seek into the movie was not frame accurate.")
	DXERROR9(0x150005, "DV_FULLDUPLEX", "Full duplex")
	DXERROR9(0x15000a, "DV_HALFDUPLEX", "Half duplex")
	DXERROR9(0x150010, "DV_PENDING", "Pending")
	DXERROR9(0x876086f, "D3DOK_NOAUTOGEN", "The call succeeded but there won't be any mipmaps generated")
	DXERROR(0x878000a, "DS_NO_VIRTUALIZATION", "The call succeeded, but we had to substitute the 3D algorithm")
	DXERROR8(0x8780014, "DS_INCOMPLETE", "The call succeeded, but not all of the optional effects were obtained.")
	DXERROR(0x8781091, "DMUS_S_PARTIALLOAD", "The object could only load partially. This can happen if some components are not registered properly, such as embedded tracks and tools. This can also happen if some content is missing. For example, if a segment uses a DLS collection that is not in the loader's current search directory.")
	DXERROR(0x8781092, "DMUS_S_PARTIALDOWNLOAD", "Return value from IDirectMusicBand::Download() which indicates that some of the instruments safely downloaded, but others failed. This usually occurs when some instruments are on PChannels not supported by the performance or port.")
	DXERROR(0x8781200, "DMUS_S_REQUEUE", "Return value from IDirectMusicTool::ProcessPMsg() which indicates to the performance that it should cue the PMsg again automatically.")
	DXERROR(0x8781201, "DMUS_S_FREE", "Return value from IDirectMusicTool::ProcessPMsg() which indicates to the performance that it should free the PMsg automatically.")
	DXERROR(0x8781202, "DMUS_S_END", "Return value from IDirectMusicTrack::Play() which indicates to the segment that the track has no more data after mtEnd.")
	DXERROR(0x8781210, "DMUS_S_STRING_TRUNCATED", "Returned string has been truncated to fit the buffer size.")
	DXERROR(0x8781211, "DMUS_S_LAST_TOOL", "Returned from IDirectMusicGraph::StampPMsg() this indicates that the PMsg is already stamped with the last tool in the graph. The returned PMsg's tool pointer is now NULL.")
	DXERROR(0x8781212, "DMUS_S_OVER_CHORD", "Returned from IDirectMusicPerformance::MusicToMIDI() this indicates  that no note has been calculated because the music value has the note  at a position higher than the top note of the chord. This applies only to DMUS_PLAYMODE_NORMALCHORD play mode. This success code indicates that the caller should not do anything with the note. It is not meant to be played against this chord.")
	DXERROR(0x8781213, "DMUS_S_UP_OCTAVE", "Returned from IDirectMusicPerformance::MIDIToMusic()  and IDirectMusicPerformance::MusicToMIDI() this indicates  that the note conversion generated a note value that is below 0,  so it has been bumped up one or more octaves to be in the proper MIDI range of 0 through 127.  Note that this is valid for MIDIToMusic() when using play modes DMUS_PLAYMODE_FIXEDTOCHORD and DMUS_PLAYMODE_FIXEDTOKEY, both of which store MIDI values in wMusicValue. With MusicToMIDI() it is valid for all play modes. Ofcourse, DMUS_PLAYMODE_FIXED will never return this success code.")
	DXERROR(0x8781214, "DMUS_S_DOWN_OCTAVE", "Returned from IDirectMusicPerformance::MIDIToMusic()  and IDirectMusicPerformance::MusicToMIDI() this indicates  that the note conversion generated a note value that is above 127, so it has been bumped down one or more octaves to be in the proper MIDI range of 0 through 127.  Note that this is valid for MIDIToMusic() when using play modes DMUS_PLAYMODE_FIXEDTOCHORD and DMUS_PLAYMODE_FIXEDTOKEY, both of which store MIDI values in wMusicValue. With MusicToMIDI() it is valid for all play modes. Ofcourse, DMUS_PLAYMODE_FIXED will never return this success code.")
	DXERROR(0x8781215, "DMUS_S_NOBUFFERCONTROL", "Although the audio output from the port will be routed to the same device as the given DirectSound buffer, buffer controls such as pan and volume will not affect the output.")
	DXERROR(0x8781216, "DMUS_S_GARBAGE_COLLECTED", "The requested operation was not performed because during CollectGarbage the loader determined that the object had been released.")
	DXERROR(0x8000000a, "E_PENDING", "The data necessary to complete this operation is not yet available.")
	DXERROR(0x80004001, "E_NOTIMPL", "The function called is not supported at this time")
	DXERROR(0x80004002, "E_NOINTERFACE", "The requested COM interface is not available")
	DXERROR(0x80004003, "E_POINTER", "Invalid pointer")
	DXERROR(0x80004004, "E_ABORT", "Operation aborted")
	DXERROR(0x80004005, "E_FAIL", "An undetermined error occurred")
	DXERROR(0x8000ffff, "E_UNEXPECTED", "Catastrophic failure")
	DXERROR8(0x80040110, "CLASS_E_NOAGGREGATION", "This object does not support aggregation")
	DXERROR9(0x80040110, "CLASSFACTORY_E_FIRST", "This object does not support aggregation")
	DXERROR(0x80040154, "REGDB_E_CLASSNOTREG", "Class not registered")
	DXERROR(0x800401f0, "CO_E_NOTINITIALIZED", "CoInitialize has not been called.")
	DXERROR(0x800401f1, "CO_E_ALREADYINITIALIZED", "CoInitialize has already been called.")
	DXERROR(0x80040200, "DIERR_INSUFFICIENTPRIVS & VFW_E_INVALIDMEDIATYPE", "Unable to IDirectInputJoyConfig_Acquire because the user does not have sufficient privileges to change the joystick configuration. & An invalid media type was specified")
	DXERROR8(0x80040201, "DIERR_DEVICEFULL & VFW_E_INVALIDSUBTYPE", "The device is full. & An invalid media subtype was specified.")
	DXERROR8(0x80040202, "DIERR_MOREDATA & VFW_E_NEED_OWNER", "Not all the requested information fit into the buffer. & This object can only be created as an aggregated object.")
	DXERROR8(0x80040203, "DIERR_NOTDOWNLOADED & VFW_E_ENUM_OUT_OF_SYNC", "The effect is not downloaded. & The enumerator has become invalid.")
	DXERROR8(0x80040204, "DIERR_HASEFFECTS & VFW_E_ALREADY_CONNECTED", "The device cannot be reinitialized because there are still effects attached to it. & At least one of the pins involved in the operation is already connected.")
	DXERROR8(0x80040205, "DIERR_NOTEXCLUSIVEACQUIRED & VFW_E_FILTER_ACTIVE", "The operation cannot be performed unless the device is acquired in DISCL_EXCLUSIVE mode. & This operation cannot be performed because the filter is active.")
	DXERROR8(0x80040206, "DIERR_INCOMPLETEEFFECT & VFW_E_NO_TYPES", "The effect could not be downloaded because essential information is missing.  For example, no axes have been associated with the effect, or no type-specific information has been created. & One of the specified pins supports no media types.")
	DXERROR9(0x80040201, "DIERR_DEVICEFULL & VFW_E_INVALIDSUBTYPE & DMO_E_INVALIDSTREAMINDEX", "The device is full. & An invalid media subtype was specified.")
	DXERROR9(0x80040202, "DIERR_MOREDATA & VFW_E_NEED_OWNER & DMO_E_INVALIDTYPE", "Not all the requested information fit into the buffer. & This object can only be created as an aggregated object.")
	DXERROR9(0x80040203, "DIERR_NOTDOWNLOADED & VFW_E_ENUM_OUT_OF_SYNC & DMO_E_TYPE_NOT_SET", "The effect is not downloaded. & The enumerator has become invalid.")
	DXERROR9(0x80040204, "DIERR_HASEFFECTS & VFW_E_ALREADY_CONNECTED & DMO_E_NOTACCEPTING", "The device cannot be reinitialized because there are still effects attached to it. & At least one of the pins involved in the operation is already connected.")
	DXERROR9(0x80040205, "DIERR_NOTEXCLUSIVEACQUIRED & VFW_E_FILTER_ACTIVE & DMO_E_TYPE_NOT_ACCEPTED", "The operation cannot be performed unless the device is acquired in DISCL_EXCLUSIVE mode. & This operation cannot be performed because the filter is active.")
	DXERROR9(0x80040206, "DIERR_INCOMPLETEEFFECT & VFW_E_NO_TYPES & DMO_E_NO_MORE_ITEMS", "The effect could not be downloaded because essential information is missing.  For example, no axes have been associated with the effect, or no type-specific information has been created. & One of the specified pins supports no media types.")
	DXERROR(0x80040207, "DIERR_NOTBUFFERED & VFW_E_NO_ACCEPTABLE_TYPES", "Attempted to read buffered device data from a device that is not buffered. & There is no common media type between these pins.")
	DXERROR(0x80040208, "DIERR_EFFECTPLAYING & VFW_E_INVALID_DIRECTION", "An attempt was made to modify parameters of an effect while it is playing.  Not all hardware devices support altering the parameters of an effect while it is playing. & Two pins of the same direction cannot be connected together.")
	DXERROR(0x80040209, "DIERR_UNPLUGGED & VFW_E_NOT_CONNECTED", "The operation could not be completed because the device is not plugged in. & The operation cannot be performed because the pins are not connected.")
	DXERROR(0x8004020a, "DIERR_REPORTFULL & VFW_E_NO_ALLOCATOR", "SendDeviceData failed because more information was requested to be sent than can be sent to the device.  Some devices have restrictions on how much data can be sent to them.  (For example, there might be a limit on the number of buttons that can be pressed at once.) & No sample buffer allocator is available.")
	DXERROR(0x8004020b, "DIERR_MAPFILEFAIL & VFW_E_RUNTIME_DXERROR", "A mapper file function failed because reading or writing the user or IHV settings file failed. & A run-time error occurred.")
	DXERROR(0x8004020c, "VFW_E_BUFFER_NOTSET", "No buffer space has been set")
	DXERROR(0x8004020d, "VFW_E_BUFFER_OVERFLOW", "The buffer is not big enough.")
	DXERROR(0x8004020e, "VFW_E_BADALIGN", "An invalid alignment was specified.")
	DXERROR(0x8004020f, "VFW_E_ALREADY_COMMITTED", "Cannot change allocated memory while the filter is active.")
	DXERROR(0x80040210, "VFW_E_BUFFERS_OUTSTANDING", "One or more buffers are still active.")
	DXERROR(0x80040211, "VFW_E_NOT_COMMITTED", "Cannot allocate a sample when the allocator is not active.")
	DXERROR(0x80040212, "VFW_E_SIZENOTSET", "Cannot allocate memory because no size has been set.")
	DXERROR(0x80040213, "VFW_E_NO_CLOCK", "Cannot lock for synchronization because no clock has been defined.")
	DXERROR(0x80040214, "VFW_E_NO_SINK", "Quality messages could not be sent because no quality sink has been defined.")
	DXERROR(0x80040215, "VFW_E_NO_INTERFACE", "A required interface has not been implemented.")
	DXERROR(0x80040216, "VFW_E_NOT_FOUND", "An object or name was not found.")
	DXERROR(0x80040217, "VFW_E_CANNOT_CONNECT", "No combination of intermediate filters could be found to make the connection.")
	DXERROR(0x80040218, "VFW_E_CANNOT_RENDER", "No combination of filters could be found to render the stream.")
	DXERROR(0x80040219, "VFW_E_CHANGING_FORMAT", "Could not change formats dynamically.")
	DXERROR(0x8004021a, "VFW_E_NO_COLOR_KEY_SET", "No color key has been set.")
	DXERROR(0x8004021b, "VFW_E_NOT_OVERLAY_CONNECTION", "Current pin connection is not using the IOverlay transport.")
	DXERROR(0x8004021c, "VFW_E_NOT_SAMPLE_CONNECTION", "Current pin connection is not using the IMemInputPin transport.")
	DXERROR(0x8004021d, "VFW_E_PALETTE_SET", "Setting a color key would conflict with the palette already set.")
	DXERROR(0x8004021e, "VFW_E_COLOR_KEY_SET", "Setting a palette would conflict with the color key already set.")
	DXERROR(0x8004021f, "VFW_E_NO_COLOR_KEY_FOUND", "No matching color key is available.")
	DXERROR(0x80040220, "VFW_E_NO_PALETTE_AVAILABLE", "No palette is available.")
	DXERROR(0x80040221, "VFW_E_NO_DISPLAY_PALETTE", "Display does not use a palette.")
	DXERROR(0x80040222, "VFW_E_TOO_MANY_COLORS", "Too many colors for the current display settings.")
	DXERROR(0x80040223, "VFW_E_STATE_CHANGED", "The state changed while waiting to process the sample.")
	DXERROR(0x80040224, "VFW_E_NOT_STOPPED", "The operation could not be performed because the filter is not stopped.")
	DXERROR(0x80040225, "VFW_E_NOT_PAUSED", "The operation could not be performed because the filter is not paused.")
	DXERROR(0x80040226, "VFW_E_NOT_RUNNING", "The operation could not be performed because the filter is not running.")
	DXERROR(0x80040227, "VFW_E_WRONG_STATE", "The operation could not be performed because the filter is in the wrong state.")
	DXERROR(0x80040228, "VFW_E_START_TIME_AFTER_END", "The sample start time is after the sample end time.")
	DXERROR(0x80040229, "VFW_E_INVALID_RECT", "The supplied rectangle is invalid.")
	DXERROR(0x8004022a, "VFW_E_TYPE_NOT_ACCEPTED", "This pin cannot use the supplied media type.")
	DXERROR(0x8004022b, "VFW_E_SAMPLE_REJECTED", "This sample cannot be rendered.")
	DXERROR(0x8004022c, "VFW_E_SAMPLE_REJECTED_EOS", "This sample cannot be rendered because the end of the stream has been reached.")
	DXERROR(0x8004022d, "VFW_E_DUPLICATE_NAME", "An attempt to add a filter with a duplicate name failed.")
	DXERROR(0x8004022e, "VFW_E_TIMEOUT", "A time-out has expired.")
	DXERROR(0x8004022f, "VFW_E_INVALID_FILE_FORMAT", "The file format is invalid.")
	DXERROR(0x80040230, "VFW_E_ENUM_OUT_OF_RANGE", "The list has already been exhausted.")
	DXERROR(0x80040231, "VFW_E_CIRCULAR_GRAPH", "The filter graph is circular.")
	DXERROR(0x80040232, "VFW_E_NOT_ALLOWED_TO_SAVE", "Updates are not allowed in this state.")
	DXERROR(0x80040233, "VFW_E_TIME_ALREADY_PASSED", "An attempt was made to queue a command for a time in the past.")
	DXERROR(0x80040234, "VFW_E_ALREADY_CANCELLED", "The queued command has already been canceled.")
	DXERROR(0x80040235, "VFW_E_CORRUPT_GRAPH_FILE", "Cannot render the file because it is corrupt.")
	DXERROR(0x80040236, "VFW_E_ADVISE_ALREADY_SET", "An overlay advise link already exists.")
	DXERROR(0x80040238, "VFW_E_NO_MODEX_AVAILABLE", "No full-screen modes are available.")
	DXERROR(0x80040239, "VFW_E_NO_ADVISE_SET", "This Advise cannot be canceled because it was not successfully set.")
	DXERROR(0x8004023a, "VFW_E_NO_FULLSCREEN", "A full-screen mode is not available.")
	DXERROR(0x8004023b, "VFW_E_IN_FULLSCREEN_MODE", "Cannot call IVideoWindow methods while in full-screen mode.")
	DXERROR(0x80040240, "VFW_E_UNKNOWN_FILE_TYPE", "The media type of this file is not recognized.")
	DXERROR(0x80040241, "VFW_E_CANNOT_LOAD_SOURCE_FILTER", "The source filter for this file could not be loaded.")
	DXERROR(0x80040243, "VFW_E_FILE_TOO_SHORT", "A file appeared to be incomplete.")
	DXERROR(0x80040244, "VFW_E_INVALID_FILE_VERSION", "The version number of the file is invalid.")
	DXERROR(0x80040247, "VFW_E_INVALID_CLSID", "This file is corrupt: it contains an invalid class identifier.")
	DXERROR(0x80040248, "VFW_E_INVALID_MEDIA_TYPE", "This file is corrupt: it contains an invalid media type.")
	DXERROR(0x80040249, "VFW_E_SAMPLE_TIME_NOT_SET", "No time stamp has been set for this sample.")
	DXERROR(0x80040251, "VFW_E_MEDIA_TIME_NOT_SET", "No media time stamp has been set for this sample.")
	DXERROR(0x80040252, "VFW_E_NO_TIME_FORMAT_SET", "No media time format has been selected.")
	DXERROR(0x80040253, "VFW_E_MONO_AUDIO_HW", "Cannot change balance because audio device is mono only.")
	DXERROR(0x80040255, "VFW_E_NO_DECOMPRESSOR", "Cannot play back the video stream: no suitable decompressor could be found.")
	DXERROR(0x80040256, "VFW_E_NO_AUDIO_HARDWARE", "Cannot play back the audio stream: no audio hardware is available, or the hardware is not responding.")
	DXERROR(0x80040259, "VFW_E_RPZA", "Cannot play back the video stream: format 'RPZA' is not supported.")
	DXERROR(0x8004025b, "VFW_E_PROCESSOR_NOT_SUITABLE", "ActiveMovie cannot play MPEG movies on this processor.")
	DXERROR(0x8004025c, "VFW_E_UNSUPPORTED_AUDIO", "Cannot play back the audio stream: the audio format is not supported.")
	DXERROR(0x8004025d, "VFW_E_UNSUPPORTED_VIDEO", "Cannot play back the video stream: the video format is not supported.")
	DXERROR(0x8004025e, "VFW_E_MPEG_NOT_CONSTRAINED", "ActiveMovie cannot play this video stream because it falls outside the constrained standard.")
	DXERROR(0x8004025f, "VFW_E_NOT_IN_GRAPH", "Cannot perform the requested function on an object that is not in the filter graph.")
	DXERROR(0x80040261, "VFW_E_NO_TIME_FORMAT", "Cannot get or set time related information on an object that is using a time format of TIME_FORMAT_NONE.")
	DXERROR(0x80040262, "VFW_E_READ_ONLY", "The connection cannot be made because the stream is read only and the filter alters the data.")
	DXERROR(0x80040264, "VFW_E_BUFFER_UNDERFLOW", "The buffer is not full enough.")
	DXERROR(0x80040265, "VFW_E_UNSUPPORTED_STREAM", "Cannot play back the file.  The format is not supported.")
	DXERROR(0x80040266, "VFW_E_NO_TRANSPORT", "Pins cannot connect due to not supporting the same transport.")
	DXERROR(0x80040269, "VFW_E_BAD_VIDEOCD", "The Video CD can't be read correctly by the device or is the data is corrupt.")
	DXERROR(0x80040271, "VFW_E_OUT_OF_VIDEO_MEMORY", "There is not enough Video Memory at this display resolution and number of colors. Reducing resolution might help.")
	DXERROR(0x80040272, "VFW_E_VP_NEGOTIATION_FAILED", "The VideoPort connection negotiation process has failed.")
	DXERROR(0x80040273, "VFW_E_DDRAW_CAPS_NOT_SUITABLE", "Either DirectDraw has not been installed or the Video Card capabilities are not suitable. Make sure the display is not in 16 color mode.")
	DXERROR(0x80040274, "VFW_E_NO_VP_HARDWARE", "No VideoPort hardware is available, or the hardware is not responding.")
	DXERROR(0x80040275, "VFW_E_NO_CAPTURE_HARDWARE", "No Capture hardware is available, or the hardware is not responding.")
	DXERROR(0x80040276, "VFW_E_DVD_OPERATION_INHIBITED", "This User Operation is inhibited by DVD Content at this time.")
	DXERROR(0x80040277, "VFW_E_DVD_INVALIDDOMAIN", "This Operation is not permitted in the current domain.")
	DXERROR(0x80040278, "VFW_E_DVD_NO_BUTTON", "The specified button is invalid or is not present at the current time, or there is no button present at the specified location.")
	DXERROR(0x80040279, "VFW_E_DVD_GRAPHNOTREADY", "DVD-Video playback graph has not been built yet.")
	DXERROR(0x8004027a, "VFW_E_DVD_RENDERFAIL", "DVD-Video playback graph building failed.")
	DXERROR(0x8004027b, "VFW_E_DVD_DECNOTENOUGH", "DVD-Video playback graph could not be built due to insufficient decoders.")
	DXERROR(0x8004027c, "VFW_E_DDRAW_VERSION_NOT_SUITABLE", "Version number of DirectDraw not suitable. Make sure to install dx5 or higher version.")
	DXERROR(0x8004027d, "VFW_E_COPYPROT_FAILED", "Copy protection cannot be enabled. Please make sure any other copy protected content is not being shown now.")
	DXERROR(0x8004027f, "VFW_E_TIME_EXPIRED", "This object cannot be used anymore as its time has expired.")
	DXERROR(0x80040281, "VFW_E_DVD_WRONG_SPEED", "The operation cannot be performed at the current playback speed.")
	DXERROR(0x80040282, "VFW_E_DVD_MENU_DOES_NOT_EXIST", "The specified menu doesn't exist.")
	DXERROR(0x80040283, "VFW_E_DVD_CMD_CANCELLED", "The specified command was either cancelled or no longer exists.")
	DXERROR(0x80040284, "VFW_E_DVD_STATE_WRONG_VERSION", "The data did not contain a recognized version.")
	DXERROR(0x80040285, "VFW_E_DVD_STATE_CORRUPT", "The state data was corrupt.")
	DXERROR(0x80040286, "VFW_E_DVD_STATE_WRONG_DISC", "The state data is from a different disc.")
	DXERROR(0x80040287, "VFW_E_DVD_INCOMPATIBLE_REGION", "The region was not compatible with the current drive.")
	DXERROR(0x80040288, "VFW_E_DVD_NO_ATTRIBUTES", "The requested DVD stream attribute does not exist.")
	DXERROR(0x80040289, "VFW_E_DVD_NO_GOUP_PGC", "Currently there is no GoUp (Annex J user function) program chain (PGC).")
	DXERROR(0x8004028a, "VFW_E_DVD_LOW_PARENTAL_LEVEL", "The current parental level was too low.")
	DXERROR(0x8004028b, "VFW_E_DVD_NOT_IN_KARAOKE_MODE", "The current audio is not karaoke content.")
	DXERROR(0x8004028e, "VFW_E_FRAME_STEP_UNSUPPORTED", "Frame step is not supported on this configuration.")
	DXERROR(0x8004028f, "VFW_E_DVD_STREAM_DISABLED", "The specified stream is disabled and cannot be selected.")
	DXERROR(0x80040290, "VFW_E_DVD_TITLE_UNKNOWN", "The operation depends on the current title number, however the navigator has not yet entered the VTSM or the title domains, so the 'current' title index is unknown.")
	DXERROR(0x80040291, "VFW_E_DVD_INVALID_DISC", "The specified path does not point to a valid DVD disc.")
	DXERROR(0x80040292, "VFW_E_DVD_NO_RESUME_INFORMATION", "There is currently no resume information.")
	DXERROR(0x80040293, "VFW_E_PIN_ALREADY_BLOCKED_ON_THIS_THREAD", "This thread has already blocked this output pin.  There is no need to call IPinFlowControl::Block() again.")
	DXERROR(0x80040294, "VFW_E_PIN_ALREADY_BLOCKED", "IPinFlowControl::Block() has been called on another thread.  The current thread cannot make any assumptions about this pin's block state.")
	DXERROR(0x80040295, "VFW_E_CERTIFICATION_FAILURE", "An operation failed due to a certification failure.")
	DXERROR(0x80040300, "DIERR_DRIVERFIRST", "Device driver-specific codes. Unless the specific driver has been precisely identified, no meaning should be attributed to these values other than that the driver originated the error.")
	DXERROR(0x80040301, "DIERR_DRIVERFIRST+1", "DIERR_DRIVERFIRST+1")
	DXERROR(0x80040302, "DIERR_DRIVERFIRST+2", "DIERR_DRIVERFIRST+2")
	DXERROR(0x80040303, "DIERR_DRIVERFIRST+3", "DIERR_DRIVERFIRST+3")
	DXERROR(0x80040304, "DIERR_DRIVERFIRST+4", "DIERR_DRIVERFIRST+4")
	DXERROR(0x80040305, "DIERR_DRIVERFIRST+5", "DIERR_DRIVERFIRST+5")
	DXERROR(0x800403f2, "VFW_E_BAD_KEY", "A registry entry is corrupt.")
	DXERROR(0x800403ff, "DIERR_DRIVERLAST", "Device installer errors.")
	DXERROR(0x80040400, "DIERR_INVALIDCLASSINSTALLER", "Registry entry or DLL for class installer invalid or class installer not found.")
	DXERROR8(0x80040401, "DIERR_CANCELLED", "The user cancelled the install operation.")
	DXERROR8(0x80040402, "DIERR_BADINF", "The INF file for the selected device could not be found or is invalid or is damaged.")
	DXERROR8(0x80070002, "DIERR_NOTFOUND", "The requested object does not exist.")
	DXERROR9(0x80040401, "DIERR_CANCELLED & MS_E_SAMPLEALLOC", "The user cancelled the install operation. & The stream already has allocated samples and the surface doesn't match the sample format.")
	DXERROR9(0x80040402, "DIERR_BADINF & MS_E_PURPOSEID", "The INF file for the selected device could not be found or is invalid or is damaged. & The specified purpose ID can't be used for the call.")
	DXERROR9(0x80040403, "MS_E_NOSTREAM", "No stream can be found with the specified attributes.")
	DXERROR9(0x80040404, "MS_E_NOSEEKING", "Seeking not supported for this object.")
	DXERROR9(0x80040405, "MS_E_INCOMPATIBLE", "The stream formats are not compatible.")
	DXERROR9(0x80040406, "MS_E_BUSY", "The sample is busy.")
	DXERROR9(0x80040407, "MS_E_NOTINIT", "The object can't accept the call because its initialize function or equivalent has not been called.")
	DXERROR9(0x80040408, "MS_E_SOURCEALREADYDEFINED", "MS_E_SOURCEALREADYDEFINED")
	DXERROR9(0x80040409, "MS_E_INVALIDSTREAMTYPE", "The stream type is not valid for this operation.")
	DXERROR9(0x8004040a, "MS_E_NOTRUNNING", "The object is not in running state.")
	DXERROR9(0x80070002, "DXERROR_FILE_NOT_FOUND", "The system cannot find the file specified.")
	DXERROR9(0x80070003, "DXERROR_PATH_NOT_FOUND", "The system cannot find the path specified.")
	DXERROR9(0x80070004, "DXERROR_TOO_MANY_OPEN_FILES", "The system cannot open the file.")
	DXERROR(0x80070005, "E_ACCESSDENIED", "Access is denied")
	DXERROR(0x80070006, "E_HANDLE", "Invalid handle")
	DXERROR8(0x8007000c, "DIERR_NOTACQUIRED", "The operation cannot be performed unless the device is acquired.")
	DXERROR9(0x80070008, "DXERROR_NOT_ENOUGH_MEMORY", "Not enough storage is available to process this command.")
	DXERROR9(0x80070009, "DXERROR_INVALID_BLOCK", "The storage control block address is invalid.")
	DXERROR9(0x8007000a, "DXERROR_BAD_ENVIRONMENT", "The environment is incorrect.")
	DXERROR9(0x8007000b, "DXERROR_BAD_FORMAT", "An attempt was made to load a program with an incorrect format.")
	DXERROR9(0x8007000c, "DXERROR_INVALID_ACCESS & DIERR_NOTACQUIRED", "The operation cannot be performed unless the device is acquired.")
	DXERROR(0x8007000e, "E_OUTOFMEMORY", "Ran out of memory")
	DXERROR8(0x80070015, "DIERR_NOTINITIALIZED", "This object has not been initialized")
	DXERROR8(0x8007001e, "DIERR_INPUTLOST", "Access to the device has been lost.  It must be re-acquired.")
	DXERROR9(0x80070015, "DXERROR_NOT_READY & DIERR_NOTINITIALIZED", "This object has not been initialized")
	DXERROR9(0x8007001e, "DXERROR_READ_FAULT & DIERR_INPUTLOST", "Access to the device has been lost.  It must be re-acquired.")
	DXERROR(0x80070057, "E_INVALIDARG", "An invalid parameter was passed to the returning function")
	DXERROR8(0x80070077, "DIERR_BADDRIVERVER", "The object could not be created due to an incompatible driver version or mismatched or incomplete driver components.")
	DXERROR8(0x800700aa, "DIERR_ACQUIRED", "The operation cannot be performed while the device is acquired.")
	DXERROR8(0x80070103, "DIERR_NOMOREITEMS", "No more items.")
	DXERROR8(0x8007047e, "DIERR_OLDDIRECTINPUTVERSION", "The application requires a newer version of DirectInput.")
	DXERROR8(0x80070481, "DIERR_BETADIRECTINPUTVERSION", "The application was written for an unsupported prerelease version of DirectInput.")
	DXERROR8(0x80070490, "E_PROP_ID_UNSUPPORTED", "The specified property ID is not supported for the specified property set.")
	DXERROR8(0x80070492, "E_PROP_SET_UNSUPPORTED", "The Specified property set is not supported.")
	DXERROR8(0x800704df, "DIERR_ALREADYINITIALIZED", "This object is already initialized")
	DXERROR9(0x80070077, "DXERROR_BAD_DRIVER_LEVEL & DIERR_BADDRIVERVER", "The object could not be created due to an incompatible driver version or mismatched or incomplete driver components.")
	DXERROR9(0x800700aa, "DXERROR_BUSY & DIERR_ACQUIRED", "The operation cannot be performed while the device is acquired.")
	DXERROR9(0x80070103, "DXERROR_NO_MORE_ITEMS & DIERR_NOMOREITEMS", "No more items.")
	DXERROR9(0x8007047e, "DXERROR_OLD_WIN_VERSION & DIERR_OLDDIRECTINPUTVERSION", "The application requires a newer version of DirectInput.")
	DXERROR9(0x80070481, "DXERROR_RMODE_APP & DIERR_BETADIRECTINPUTVERSION", "The application was written for an unsupported prerelease version of DirectInput.")
	DXERROR9(0x80070490, "DXERROR_NOT_FOUND & E_PROP_ID_UNSUPPORTED", "The specified property ID is not supported for the specified property set.")
	DXERROR9(0x80070492, "DXERROR_SET_NOT_FOUND & E_PROP_SET_UNSUPPORTED", "The specified property set is not supported.")
	DXERROR9(0x800704df, "DXERROR_ALREADY_INITIALIZED & DIERR_ALREADYINITIALIZED", "This object is already initialized")
	DXERROR9(0x8015001e, "DVERR_BUFFERTOOSMALL", "Buffer too small")
	DXERROR9(0x8015004a, "DVERR_EXCEPTION", "Exception")
	DXERROR9(0x80150078, "DVERR_INVALIDFLAGS", "Invalid flags")
	DXERROR9(0x80150082, "DVERR_INVALIDOBJECT", "Invalid object")
	DXERROR9(0x80150087, "DVERR_INVALIDPLAYER", "Invalid player")
	DXERROR9(0x80150091, "DVERR_INVALIDGROUP", "Invalid group")
	DXERROR9(0x80150096, "DVERR_INVALIDHANDLE", "Invalid handle")
	DXERROR9(0x8015012c, "DVERR_SESSIONLOST", "Session lost")
	DXERROR9(0x8015012e, "DVERR_NOVOICESESSION", "No voice session")
	DXERROR9(0x80150168, "DVERR_CONNECTIONLOST", "Connection lost")
	DXERROR9(0x80150169, "DVERR_NOTINITIALIZED", "Not initialized")
	DXERROR9(0x8015016a, "DVERR_CONNECTED", "Connected")
	DXERROR9(0x8015016b, "DVERR_NOTCONNECTED", "Not connected")
	DXERROR9(0x8015016e, "DVERR_CONNECTABORTING", "Connect aborting")
	DXERROR9(0x8015016f, "DVERR_NOTALLOWED", "Not allowed")
	DXERROR9(0x80150170, "DVERR_INVALIDTARGET", "Invalid target")
	DXERROR9(0x80150171, "DVERR_TRANSPORTNOTHOST", "Transport not host")
	DXERROR9(0x80150172, "DVERR_COMPRESSIONNOTSUPPORTED", "Compression not supported")
	DXERROR9(0x80150173, "DVERR_ALREADYPENDING", "Already pending")
	DXERROR9(0x80150174, "DVERR_SOUNDINITFAILURE", "Sound init failure")
	DXERROR9(0x80150175, "DVERR_TIMEOUT", "Time out")
	DXERROR9(0x80150176, "DVERR_CONNECTABORTED", "Connect aborted")
	DXERROR9(0x80150177, "DVERR_NO3DSOUND", "No 3d sound")
	DXERROR9(0x80150178, "DVERR_ALREADYBUFFERED", "Already buffered")
	DXERROR9(0x80150179, "DVERR_NOTBUFFERED", "Not buffered")
	DXERROR9(0x8015017a, "DVERR_HOSTING", "Hosting")
	DXERROR9(0x8015017b, "DVERR_NOTHOSTING", "Not hosting")
	DXERROR9(0x8015017c, "DVERR_INVALIDDEVICE", "Invalid device")
	DXERROR9(0x8015017d, "DVERR_RECORDSYSTEMDXERROR", "Record system error")
	DXERROR9(0x8015017e, "DVERR_PLAYBACKSYSTEMDXERROR", "Playback system error")
	DXERROR9(0x8015017f, "DVERR_SENDDXERROR", "Send error")
	DXERROR9(0x80150180, "DVERR_USERCANCEL", "User cancel")
	DXERROR9(0x80150183, "DVERR_RUNSETUP", "Run setup")
	DXERROR9(0x80150184, "DVERR_INCOMPATIBLEVERSION", "Incompatible version")
	DXERROR9(0x80150187, "DVERR_INITIALIZED", "Initialized")
	DXERROR9(0x80150188, "DVERR_NOTRANSPORT", "No transport")
	DXERROR9(0x80150189, "DVERR_NOCALLBACK", "No callback")
	DXERROR9(0x8015018a, "DVERR_TRANSPORTNOTINIT", "Transport not init")
	DXERROR9(0x8015018b, "DVERR_TRANSPORTNOSESSION", "Transport no session")
	DXERROR9(0x8015018c, "DVERR_TRANSPORTNOPLAYER", "Transport no player")
	DXERROR9(0x8015018d, "DVERR_USERBACK", "User back")
	DXERROR9(0x8015018e, "DVERR_NORECVOLAVAILABLE", "No rec vol available")
	DXERROR9(0x8015018f, "DVERR_INVALIDBUFFER", "Invalid buffer")
	DXERROR9(0x80150190, "DVERR_LOCKEDBUFFER", "Locked buffer")
	DXERROR9(0x80158030, "DPNERR_ABORTED", "Aborted")
	DXERROR9(0x80158040, "DPNERR_ADDRESSING", "Addressing")
	DXERROR9(0x80158050, "DPNERR_ALREADYCLOSING", "Already closing")
	DXERROR9(0x80158060, "DPNERR_ALREADYCONNECTED", "Already connected")
	DXERROR9(0x80158070, "DPNERR_ALREADYDISCONNECTING", "Already disconnecting")
	DXERROR9(0x80158080, "DPNERR_ALREADYINITIALIZED", "Already initialized")
	DXERROR9(0x80158090, "DPNERR_ALREADYREGISTERED", "Already registered")
	DXERROR9(0x80158100, "DPNERR_BUFFERTOOSMALL", "Buffer too small")
	DXERROR9(0x80158110, "DPNERR_CANNOTCANCEL", "Can not cancel")
	DXERROR9(0x80158120, "DPNERR_CANTCREATEGROUP", "Cant create group")
	DXERROR9(0x80158130, "DPNERR_CANTCREATEPLAYER", "Cant create player")
	DXERROR9(0x80158140, "DPNERR_CANTLAUNCHAPPLICATION", "Cant launch application")
	DXERROR9(0x80158150, "DPNERR_CONNECTING", "Connecting")
	DXERROR9(0x80158160, "DPNERR_CONNECTIONLOST", "Connection lost")
	DXERROR9(0x80158170, "DPNERR_CONVERSION", "Conversion")
	DXERROR9(0x80158175, "DPNERR_DATATOOLARGE", "Data too large")
	DXERROR9(0x80158180, "DPNERR_DOESNOTEXIST", "Does not exist")
	DXERROR9(0x80158185, "DPNERR_DPNSVRNOTAVAILABLE", "dpnsvr not available")
	DXERROR9(0x80158190, "DPNERR_DUPLICATECOMMAND", "Duplicate command")
	DXERROR9(0x80158200, "DPNERR_ENDPOINTNOTRECEIVING", "End point not receiving")
	DXERROR9(0x80158210, "DPNERR_ENUMQUERYTOOLARGE", "Enum query too large")
	DXERROR9(0x80158220, "DPNERR_ENUMRESPONSETOOLARGE", "Enum response too large")
	DXERROR9(0x80158230, "DPNERR_EXCEPTION", "Exception")
	DXERROR9(0x80158240, "DPNERR_GROUPNOTEMPTY", "Group not empty")
	DXERROR9(0x80158250, "DPNERR_HOSTING", "Hosting")
	DXERROR9(0x80158260, "DPNERR_HOSTREJECTEDCONNECTION", "Host rejected connection")
	DXERROR9(0x80158270, "DPNERR_HOSTTERMINATEDSESSION", "Host terminated session")
	DXERROR9(0x80158280, "DPNERR_INCOMPLETEADDRESS", "Incomplete address")
	DXERROR9(0x80158290, "DPNERR_INVALIDADDRESSFORMAT", "Invalid address format")
	DXERROR9(0x80158300, "DPNERR_INVALIDAPPLICATION", "Invalid application")
	DXERROR9(0x80158310, "DPNERR_INVALIDCOMMAND", "Invalid command")
	DXERROR9(0x80158320, "DPNERR_INVALIDDEVICEADDRESS", "Invalid device address")
	DXERROR9(0x80158330, "DPNERR_INVALIDENDPOINT", "Invalid end point")
	DXERROR9(0x80158340, "DPNERR_INVALIDFLAGS", "Invalid flags")
	DXERROR9(0x80158350, "DPNERR_INVALIDGROUP", "Invalid group")
	DXERROR9(0x80158360, "DPNERR_INVALIDHANDLE", "Invalid handle")
	DXERROR9(0x80158370, "DPNERR_INVALIDHOSTADDRESS", "Invalid host address")
	DXERROR9(0x80158380, "DPNERR_INVALIDINSTANCE", "Invalid instance")
	DXERROR9(0x80158390, "DPNERR_INVALIDINTERFACE", "Invalid interface")
	DXERROR9(0x80158400, "DPNERR_INVALIDOBJECT", "Invalid object")
	DXERROR9(0x80158410, "DPNERR_INVALIDPASSWORD", "Invalid password")
	DXERROR9(0x80158420, "DPNERR_INVALIDPLAYER", "Invalid player")
	DXERROR9(0x80158430, "DPNERR_INVALIDPRIORITY", "Invalid priority")
	DXERROR9(0x80158440, "DPNERR_INVALIDSTRING", "Invalid string")
	DXERROR9(0x80158450, "DPNERR_INVALIDURL", "Invalid url")
	DXERROR9(0x80158460, "DPNERR_INVALIDVERSION", "Invalid version")
	DXERROR9(0x80158470, "DPNERR_NOCAPS", "No caps")
	DXERROR9(0x80158480, "DPNERR_NOCONNECTION", "No connection")
	DXERROR9(0x80158490, "DPNERR_NOHOSTPLAYER", "No host player")
	DXERROR9(0x80158500, "DPNERR_NOMOREADDRESSCOMPONENTS", "No more address components")
	DXERROR9(0x80158510, "DPNERR_NORESPONSE", "No response")
	DXERROR9(0x80158520, "DPNERR_NOTALLOWED", "Not allowed")
	DXERROR9(0x80158530, "DPNERR_NOTHOST", "Not host")
	DXERROR9(0x80158540, "DPNERR_NOTREADY", "Not ready")
	DXERROR9(0x80158550, "DPNERR_NOTREGISTERED", "Not registered")
	DXERROR9(0x80158560, "DPNERR_PLAYERALREADYINGROUP", "Player already in group")
	DXERROR9(0x80158570, "DPNERR_PLAYERLOST", "Player lost")
	DXERROR9(0x80158580, "DPNERR_PLAYERNOTINGROUP", "Player not in group")
	DXERROR9(0x80158590, "DPNERR_PLAYERNOTREACHABLE", "Player not reachable")
	DXERROR9(0x80158600, "DPNERR_SENDTOOLARGE", "Send too large")
	DXERROR9(0x80158610, "DPNERR_SESSIONFULL", "Session full")
	DXERROR9(0x80158620, "DPNERR_TABLEFULL", "Table full")
	DXERROR9(0x80158630, "DPNERR_TIMEDOUT", "Timed out")
	DXERROR9(0x80158640, "DPNERR_UNINITIALIZED", "Uninitialized")
	DXERROR9(0x80158650, "DPNERR_USERCANCEL", "User cancel")
	DXERROR(0x88760005, "DDERR_ALREADYINITIALIZED", "This object is already initialized")
	DXERROR(0x8876000a, "DDERR_CANNOTATTACHSURFACE", "This surface can not be attached to the requested surface.")
	DXERROR(0x88760014, "DDERR_CANNOTDETACHSURFACE", "This surface can not be detached from the requested surface.")
	DXERROR(0x88760028, "DDERR_CURRENTLYNOTAVAIL", "Support is currently not available.")
	DXERROR(0x88760037, "DDERR_EXCEPTION", "An exception was encountered while performing the requested operation")
	DXERROR(0x8876005a, "DDERR_HEIGHTALIGN", "Height of rectangle provided is not a multiple of reqd alignment")
	DXERROR(0x8876005f, "DDERR_INCOMPATIBLEPRIMARY", "Unable to match primary surface creation request with existing primary surface.")
	DXERROR(0x88760064, "DDERR_INVALIDCAPS", "One or more of the caps bits passed to the callback are incorrect.")
	DXERROR(0x8876006e, "DDERR_INVALIDCLIPLIST", "DirectDraw does not support provided Cliplist.")
	DXERROR(0x88760078, "DDERR_INVALIDMODE", "DirectDraw does not support the requested mode")
	DXERROR(0x88760082, "DDERR_INVALIDOBJECT", "DirectDraw received a pointer that was an invalid DIRECTDRAW object.")
	DXERROR(0x88760091, "DDERR_INVALIDPIXELFORMAT", "pixel format was invalid as specified")
	DXERROR(0x88760096, "DDERR_INVALIDRECT", "Rectangle provided was invalid.")
	DXERROR(0x887600a0, "DDERR_LOCKEDSURFACES", "Operation could not be carried out because one or more surfaces are locked")
	DXERROR(0x887600aa, "DDERR_NO3D", "There is no 3D present.")
	DXERROR(0x887600b4, "DDERR_NOALPHAHW", "Operation could not be carried out because there is no alpha accleration hardware present or available.")
	DXERROR(0x887600b5, "DDERR_NOSTEREOHARDWARE", "Operation could not be carried out because there is no stereo hardware present or available.")
	DXERROR(0x887600b6, "DDERR_NOSURFACELEFT", "Operation could not be carried out because there is no hardware present which supports stereo surfaces")
	DXERROR(0x887600cd, "DDERR_NOCLIPLIST", "no clip list available")
	DXERROR(0x887600d2, "DDERR_NOCOLORCONVHW", "Operation could not be carried out because there is no color conversion hardware present or available.")
	DXERROR(0x887600d4, "DDERR_NOCOOPERATIVELEVELSET", "Create function called without DirectDraw object method SetCooperativeLevel being called.")
	DXERROR(0x887600d7, "DDERR_NOCOLORKEY", "Surface doesn't currently have a color key")
	DXERROR(0x887600dc, "DDERR_NOCOLORKEYHW", "Operation could not be carried out because there is no hardware support of the dest color key.")
	DXERROR(0x887600de, "DDERR_NODIRECTDRAWSUPPORT", "No DirectDraw support possible with current display driver")
	DXERROR(0x887600e1, "DDERR_NOEXCLUSIVEMODE", "Operation requires the application to have exclusive mode but the application does not have exclusive mode.")
	DXERROR(0x887600e6, "DDERR_NOFLIPHW", "Flipping visible surfaces is not supported.")
	DXERROR(0x887600f0, "DDERR_NOGDI", "There is no GDI present.")
	DXERROR(0x887600fa, "DDERR_NOMIRRORHW", "Operation could not be carried out because there is no hardware present or available.")
	DXERROR(0x887600ff, "DDERR_NOTFOUND", "Requested item was not found")
	DXERROR(0x88760104, "DDERR_NOOVERLAYHW", "Operation could not be carried out because there is no overlay hardware present or available.")
	DXERROR(0x8876010e, "DDERR_OVERLAPPINGRECTS", "Operation could not be carried out because the source and destination rectangles are on the same surface and overlap each other.")
	DXERROR(0x88760118, "DDERR_NORASTEROPHW", "Operation could not be carried out because there is no appropriate raster op hardware present or available.")
	DXERROR(0x88760122, "DDERR_NOROTATIONHW", "Operation could not be carried out because there is no rotation hardware present or available.")
	DXERROR(0x88760136, "DDERR_NOSTRETCHHW", "Operation could not be carried out because there is no hardware support for stretching")
	DXERROR(0x8876013c, "DDERR_NOT4BITCOLOR", "DirectDrawSurface is not in 4 bit color palette and the requested operation requires 4 bit color palette.")
	DXERROR(0x8876013d, "DDERR_NOT4BITCOLORINDEX", "DirectDrawSurface is not in 4 bit color index palette and the requested operation requires 4 bit color index palette.")
	DXERROR(0x88760140, "DDERR_NOT8BITCOLOR", "DirectDraw Surface is not in 8 bit color mode and the requested operation requires 8 bit color.")
	DXERROR(0x8876014a, "DDERR_NOTEXTUREHW", "Operation could not be carried out because there is no texture mapping hardware present or available.")
	DXERROR(0x8876014f, "DDERR_NOVSYNCHW", "Operation could not be carried out because there is no hardware support for vertical blank synchronized operations.")
	DXERROR(0x88760154, "DDERR_NOZBUFFERHW", "Operation could not be carried out because there is no hardware support for zbuffer blting.")
	DXERROR(0x8876015e, "DDERR_NOZOVERLAYHW", "Overlay surfaces could not be z layered based on their BltOrder because the hardware does not support z layering of overlays.")
	DXERROR(0x88760168, "DDERR_OUTOFCAPS", "The hardware needed for the requested operation has already been allocated.")
	DXERROR9(0x8876017c, "D3DERR_OUTOFVIDEOMEMORY", "Out of video memory")
	DXERROR(0x8876017e, "DDERR_OVERLAYCANTCLIP", "hardware does not support clipped overlays")
	DXERROR(0x88760180, "DDERR_OVERLAYCOLORKEYONLYONEACTIVE", "Can only have ony color key active at one time for overlays")
	DXERROR(0x88760183, "DDERR_PALETTEBUSY", "Access to this palette is being refused because the palette is already locked by another thread.")
	DXERROR(0x88760190, "DDERR_COLORKEYNOTSET", "No src color key specified for this operation.")
	DXERROR(0x8876019a, "DDERR_SURFACEALREADYATTACHED", "This surface is already attached to the surface it is being attached to.")
	DXERROR(0x887601a4, "DDERR_SURFACEALREADYDEPENDENT", "This surface is already a dependency of the surface it is being made a dependency of.")
	DXERROR(0x887601ae, "DDERR_SURFACEBUSY", "Access to this surface is being refused because the surface is already locked by another thread.")
	DXERROR(0x887601b3, "DDERR_CANTLOCKSURFACE", "Access to this surface is being refused because no driver exists which can supply a pointer to the surface. This is most likely to happen when attempting to lock the primary surface when no DCI provider is present. Will also happen on attempts to lock an optimized surface.")
	DXERROR(0x887601b8, "DDERR_SURFACEISOBSCURED", "Access to Surface refused because Surface is obscured.")
	DXERROR(0x887601c2, "DDERR_SURFACELOST", "Access to this surface is being refused because the surface is gone. The DIRECTDRAWSURFACE object representing this surface should have Restore called on it.")
	DXERROR(0x887601cc, "DDERR_SURFACENOTATTACHED", "The requested surface is not attached.")
	DXERROR(0x887601d6, "DDERR_TOOBIGHEIGHT", "Height requested by DirectDraw is too large.")
	DXERROR(0x887601e0, "DDERR_TOOBIGSIZE", "Size requested by DirectDraw is too large --  The individual height and width are OK.")
	DXERROR(0x887601ea, "DDERR_TOOBIGWIDTH", "Width requested by DirectDraw is too large.")
	DXERROR(0x887601fe, "DDERR_UNSUPPORTEDFORMAT", "Pixel format requested is unsupported by DirectDraw")
	DXERROR(0x88760208, "DDERR_UNSUPPORTEDMASK", "Bitmask in the pixel format requested is unsupported by DirectDraw")
	DXERROR(0x88760209, "DDERR_INVALIDSTREAM", "The specified stream contains invalid data")
	DXERROR(0x88760219, "DDERR_VERTICALBLANKINPROGRESS", "vertical blank is in progress")
	DXERROR8(0x8876021c, "DDERR_WASSTILLDRAWING", "Informs DirectDraw that the previous Blt which is transfering information to or from this Surface is incomplete.")
	DXERROR9(0x8876021c, "DDERR_WASSTILLDRAWING", "Was still drawing")
	DXERROR(0x8876021e, "DDERR_DDSCAPSCOMPLEXREQUIRED", "The specified surface type requires specification of the COMPLEX flag")
	DXERROR(0x88760230, "DDERR_XALIGN", "Rectangle provided was not horizontally aligned on reqd. boundary")
	DXERROR(0x88760231, "DDERR_INVALIDDIRECTDRAWGUID", "The GUID passed to DirectDrawCreate is not a valid DirectDraw driver identifier.")
	DXERROR(0x88760232, "DDERR_DIRECTDRAWALREADYCREATED", "A DirectDraw object representing this driver has already been created for this process.")
	DXERROR(0x88760233, "DDERR_NODIRECTDRAWHW", "A hardware only DirectDraw object creation was attempted but the driver did not support any hardware.")
	DXERROR(0x88760234, "DDERR_PRIMARYSURFACEALREADYEXISTS", "this process already has created a primary surface")
	DXERROR(0x88760235, "DDERR_NOEMULATION", "software emulation not available.")
	DXERROR(0x88760236, "DDERR_REGIONTOOSMALL", "region passed to Clipper::GetClipList is too small.")
	DXERROR(0x88760237, "DDERR_CLIPPERISUSINGHWND", "an attempt was made to set a clip list for a clipper objec that is already monitoring an hwnd.")
	DXERROR(0x88760238, "DDERR_NOCLIPPERATTACHED", "No clipper object attached to surface object")
	DXERROR(0x88760239, "DDERR_NOHWND", "Clipper notification requires an HWND or no HWND has previously been set as the CooperativeLevel HWND.")
	DXERROR(0x8876023a, "DDERR_HWNDSUBCLASSED", "HWND used by DirectDraw CooperativeLevel has been subclassed, this prevents DirectDraw from restoring state.")
	DXERROR(0x8876023b, "DDERR_HWNDALREADYSET", "The CooperativeLevel HWND has already been set. It can not be reset while the process has surfaces or palettes created.")
	DXERROR(0x8876023c, "DDERR_NOPALETTEATTACHED", "No palette object attached to this surface.")
	DXERROR(0x8876023d, "DDERR_NOPALETTEHW", "No hardware support for 16 or 256 color palettes.")
	DXERROR(0x8876023e, "DDERR_BLTFASTCANTCLIP", "If a clipper object is attached to the source surface passed into a BltFast call.")
	DXERROR(0x8876023f, "DDERR_NOBLTHW", "No blter.")
	DXERROR(0x88760240, "DDERR_NODDROPSHW", "No DirectDraw ROP hardware.")
	DXERROR(0x88760241, "DDERR_OVERLAYNOTVISIBLE", "returned when GetOverlayPosition is called on a hidden overlay")
	DXERROR(0x88760242, "DDERR_NOOVERLAYDEST", "returned when GetOverlayPosition is called on a overlay that UpdateOverlay has never been called on to establish a destionation.")
	DXERROR(0x88760243, "DDERR_INVALIDPOSITION", "returned when the position of the overlay on the destionation is no longer legal for that destionation.")
	DXERROR(0x88760244, "DDERR_NOTAOVERLAYSURFACE", "returned when an overlay member is called for a non-overlay surface")
	DXERROR(0x88760245, "DDERR_EXCLUSIVEMODEALREADYSET", "An attempt was made to set the cooperative level when it was already set to exclusive.")
	DXERROR(0x88760246, "DDERR_NOTFLIPPABLE", "An attempt has been made to flip a surface that is not flippable.")
	DXERROR(0x88760247, "DDERR_CANTDUPLICATE", "Can't duplicate primary & 3D surfaces, or surfaces that are implicitly created.")
	DXERROR(0x88760248, "DDERR_NOTLOCKED", "Surface was not locked.  An attempt to unlock a surface that was not locked at all, or by this process, has been attempted.")
	DXERROR(0x88760249, "DDERR_CANTCREATEDC", "Windows can not create any more DCs, or a DC was requested for a paltte-indexed surface when the surface had no palette AND the display mode was not palette-indexed (in this case DirectDraw cannot select a proper palette into the DC)")
	DXERROR(0x8876024a, "DDERR_NODC", "No DC was ever created for this surface.")
	DXERROR(0x8876024b, "DDERR_WRONGMODE", "This surface can not be restored because it was created in a different mode.")
	DXERROR(0x8876024c, "DDERR_IMPLICITLYCREATED", "This surface can not be restored because it is an implicitly created surface.")
	DXERROR(0x8876024d, "DDERR_NOTPALETTIZED", "The surface being used is not a palette-based surface")
	DXERROR(0x8876024e, "DDERR_UNSUPPORTEDMODE", "The display is currently in an unsupported mode")
	DXERROR(0x8876024f, "DDERR_NOMIPMAPHW", "Operation could not be carried out because there is no mip-map texture mapping hardware present or available.")
	DXERROR(0x88760250, "DDERR_INVALIDSURFACETYPE", "The requested action could not be performed because the surface was of the wrong type.")
	DXERROR(0x88760258, "DDERR_NOOPTIMIZEHW", "Device does not support optimized surfaces, therefore no video memory optimized surfaces")
	DXERROR(0x88760259, "DDERR_NOTLOADED", "Surface is an optimized surface, but has not yet been allocated any memory")
	DXERROR(0x8876025a, "DDERR_NOFOCUSWINDOW", "Attempt was made to create or set a device window without first setting the focus window")
	DXERROR(0x8876025b, "DDERR_NOTONMIPMAPSUBLEVEL", "Attempt was made to set a palette on a mipmap sublevel")
	DXERROR(0x8876026c, "DDERR_DCALREADYCREATED", "A DC has already been returned for this surface. Only one DC can be retrieved per surface.")
	DXERROR(0x88760276, "DDERR_NONONLOCALVIDMEM", "An attempt was made to allocate non-local video memory from a device that does not support non-local video memory.")
	DXERROR(0x88760280, "DDERR_CANTPAGELOCK", "The attempt to page lock a surface failed.")
	DXERROR(0x88760294, "DDERR_CANTPAGEUNLOCK", "The attempt to page unlock a surface failed.")
	DXERROR(0x887602a8, "DDERR_NOTPAGELOCKED", "An attempt was made to page unlock a surface with no outstanding page locks.")
	DXERROR(0x887602b2, "DDERR_MOREDATA", "There is more data available than the specified buffer size could hold")
	DXERROR(0x887602b3, "DDERR_EXPIRED", "The data has expired and is therefore no longer valid.")
	DXERROR(0x887602b4, "DDERR_TESTFINISHED", "The mode test has finished executing.")
	DXERROR(0x887602b5, "DDERR_NEWMODE", "The mode test has switched to a new mode.")
	DXERROR(0x887602b6, "DDERR_D3DNOTINITIALIZED", "D3D has not yet been initialized.")
	DXERROR(0x887602b7, "DDERR_VIDEONOTACTIVE", "The video port is not active")
	DXERROR(0x887602b8, "DDERR_NOMONITORINFORMATION", "The monitor does not have EDID data.")
	DXERROR(0x887602b9, "DDERR_NODRIVERSUPPORT", "The driver does not enumerate display mode refresh rates.")
	DXERROR(0x887602bb, "DDERR_DEVICEDOESNTOWNSURFACE", "Surfaces created by one direct draw device cannot be used directly by another direct draw device.")
	DXERROR9(0x88760352, "DXFILEERR_BADOBJECT", "Bad object")
	DXERROR9(0x88760353, "DXFILEERR_BADVALUE", "Bad value")
	DXERROR9(0x88760354, "DXFILEERR_BADTYPE", "Bad type")
	DXERROR9(0x88760355, "DXFILEERR_BADSTREAMHANDLE", "Bad stream handle")
	DXERROR9(0x88760356, "DXFILEERR_BADALLOC", "Bad alloc")
	DXERROR9(0x88760357, "DXFILEERR_NOTFOUND", "Not found")
	DXERROR9(0x88760358, "DXFILEERR_NOTDONEYET", "Not done yet")
	DXERROR9(0x88760359, "DXFILEERR_FILENOTFOUND", "File not found")
	DXERROR9(0x8876035a, "DXFILEERR_RESOURCENOTFOUND", "Resource not found")
	DXERROR9(0x8876035b, "DXFILEERR_URLNOTFOUND", "Url not found")
	DXERROR9(0x8876035c, "DXFILEERR_BADRESOURCE", "Bad resource")
	DXERROR9(0x8876035d, "DXFILEERR_BADFILETYPE", "Bad file type")
	DXERROR9(0x8876035e, "DXFILEERR_BADFILEVERSION", "Bad file version")
	DXERROR9(0x8876035f, "DXFILEERR_BADFILEFLOATSIZE", "Bad file float size")
	DXERROR9(0x88760360, "DXFILEERR_BADFILECOMPRESSIONTYPE", "Bad file compression type")
	DXERROR9(0x88760361, "DXFILEERR_BADFILE", "Bad file")
	DXERROR9(0x88760362, "DXFILEERR_PARSEDXERROR", "Parse error")
	DXERROR9(0x88760363, "DXFILEERR_NOTEMPLATE", "No template")
	DXERROR9(0x88760364, "DXFILEERR_BADARRAYSIZE", "Bad array size")
	DXERROR9(0x88760365, "DXFILEERR_BADDATAREFERENCE", "Bad data reference")
	DXERROR9(0x88760366, "DXFILEERR_INTERNALDXERROR", "Internal error")
	DXERROR9(0x88760367, "DXFILEERR_NOMOREOBJECTS", "No more objects")
	DXERROR9(0x88760368, "DXFILEERR_BADINTRINSICS", "Bad intrinsics")
	DXERROR9(0x88760369, "DXFILEERR_NOMORESTREAMHANDLES", "No more stream handles")
	DXERROR9(0x8876036a, "DXFILEERR_NOMOREDATA", "No more data")
	DXERROR9(0x8876036b, "DXFILEERR_BADCACHEFILE", "Bad cache file")
	DXERROR9(0x8876036c, "DXFILEERR_NOINTERNET", "No internet")
	DXERROR9(0x88760818, "D3DERR_WRONGTEXTUREFORMAT", "Wrong texture format")
	DXERROR9(0x88760819, "D3DERR_UNSUPPORTEDCOLOROPERATION", "Unsupported color operation")
	DXERROR9(0x8876081a, "D3DERR_UNSUPPORTEDCOLORARG", "Unsupported color arg")
	DXERROR9(0x8876081b, "D3DERR_UNSUPPORTEDALPHAOPERATION", "Unsupported alpha operation")
	DXERROR9(0x8876081c, "D3DERR_UNSUPPORTEDALPHAARG", "Unsupported alpha arg")
	DXERROR9(0x8876081d, "D3DERR_TOOMANYOPERATIONS", "Too many operations")
	DXERROR9(0x8876081e, "D3DERR_CONFLICTINGTEXTUREFILTER", "Conflicting texture filter")
	DXERROR9(0x8876081f, "D3DERR_UNSUPPORTEDFACTORVALUE", "Unsupported factor value")
	DXERROR9(0x88760821, "D3DERR_CONFLICTINGRENDERSTATE", "Conflicting render state")
	DXERROR9(0x88760822, "D3DERR_UNSUPPORTEDTEXTUREFILTER", "Unsupported texture filter")
	DXERROR9(0x88760826, "D3DERR_CONFLICTINGTEXTUREPALETTE", "Conflicting texture palette")
	DXERROR9(0x88760827, "D3DERR_DRIVERINTERNALDXERROR", "Driver internal error")
	DXERROR9(0x88760866, "D3DERR_NOTFOUND", "Not found")
	DXERROR9(0x88760867, "D3DERR_MOREDATA", "More data")
	DXERROR9(0x88760868, "D3DERR_DEVICELOST", "Device lost")
	DXERROR9(0x88760869, "D3DERR_DEVICENOTRESET", "Device not reset")
	DXERROR9(0x8876086a, "D3DERR_NOTAVAILABLE", "Not available")
	DXERROR9(0x8876086b, "D3DERR_INVALIDDEVICE", "Invalid device")
	DXERROR9(0x8876086c, "D3DERR_INVALIDCALL", "Invalid call")
	DXERROR9(0x8876086d, "D3DERR_DRIVERINVALIDCALL", "Driver invalid call")
	DXERROR9(0x88760b54, "D3DXERR_CANNOTMODIFYINDEXBUFFER", "Can not modify index buffer")
	DXERROR9(0x88760b55, "D3DXERR_INVALIDMESH", "Invalid mesh")
	DXERROR9(0x88760b56, "D3DXERR_CANNOTATTRSORT", "Cannot attr sort")
	DXERROR9(0x88760b57, "D3DXERR_SKINNINGNOTSUPPORTED", "Skinning not supported")
	DXERROR9(0x88760b58, "D3DXERR_TOOMANYINFLUENCES", "Too many influences")
	DXERROR9(0x88760b59, "D3DXERR_INVALIDDATA", "Invalid data")
	DXERROR9(0x88760b5a, "D3DXERR_LOADEDMESHASNODATA", "Loaded mesh has no data")
	DXERROR9(0x88760b5b, "D3DXERR_DUPLICATENAMEDFRAGMENT", "Duplicate named fragment")
	DXERROR(0x8878000a, "DSERR_ALLOCATED", "The call failed because resources (such as a priority level) were already being used by another caller")
	DXERROR(0x8878001e, "DSERR_CONTROLUNAVAIL", "The control (vol, pan, etc.) requested by the caller is not available")
	DXERROR(0x88780032, "DSERR_INVALIDCALL", "This call is not valid for the current state of this object")
	DXERROR(0x88780046, "DSERR_PRIOLEVELNEEDED", "The caller does not have the priority level required for the function to succeed")
	DXERROR(0x88780064, "DSERR_BADFORMAT", "The specified WAVE format is not supported")
	DXERROR(0x88780078, "DSERR_NODRIVER", "No sound driver is available for use")
	DXERROR(0x88780082, "DSERR_ALREADYINITIALIZED", "This object is already initialized")
	DXERROR(0x88780096, "DSERR_BUFFERLOST", "The buffer memory has been lost, and must be restored")
	DXERROR(0x887800a0, "DSERR_OTHERAPPHASPRIO", "Another app has a higher priority level, preventing this call from succeeding")
	DXERROR(0x887800aa, "DSERR_UNINITIALIZED", "This object has not been initialized")
	DXERROR(0x887800b4, "DSERR_BUFFERTOOSMALL", "Tried to create a DSBCAPS_CTRLFX buffer shorter than DSBSIZE_FX_MIN milliseconds")
	DXERROR(0x887800be, "DSERR_DS8_REQUIRED", "Attempt to use DirectSound 8 functionality on an older DirectSound object")
	DXERROR(0x887800c8, "DSERR_SENDLOOP", "A circular loop of send effects was detected")
	DXERROR(0x887800d2, "DSERR_BADSENDBUFFERGUID", "The GUID specified in an audiopath file does not match a valid MIXIN buffer")
	DXERROR(0x88781101, "DMUS_E_DRIVER_FAILED", "An unexpected error was returned from a device driver, indicating possible failure of the driver or hardware.")
	DXERROR(0x88781102, "DMUS_E_PORTS_OPEN", "The requested operation cannot be performed while there are  instantiated ports in any process in the system.")
	DXERROR(0x88781103, "DMUS_E_DEVICE_IN_USE", "The requested device is already in use (possibly by a non-DirectMusic client) and cannot be opened again.")
	DXERROR(0x88781104, "DMUS_E_INSUFFICIENTBUFFER", "Buffer is not large enough for requested operation.")
	DXERROR(0x88781105, "DMUS_E_BUFFERNOTSET", "No buffer was prepared for the download data.")
	DXERROR(0x88781106, "DMUS_E_BUFFERNOTAVAILABLE", "Download failed due to inability to access or create download buffer.")
	DXERROR(0x88781108, "DMUS_E_NOTADLSCOL", "Error parsing DLS collection. File is corrupt.")
	DXERROR(0x88781109, "DMUS_E_INVALIDOFFSET", "Wave chunks in DLS collection file are at incorrect offsets.")
	DXERROR(0x88781111, "DMUS_E_ALREADY_LOADED", "Second attempt to load a DLS collection that is currently open. ")
	DXERROR(0x88781113, "DMUS_E_INVALIDPOS", "Error reading wave data from DLS collection. Indicates bad file.")
	DXERROR(0x88781114, "DMUS_E_INVALIDPATCH", "There is no instrument in the collection that matches patch number.")
	DXERROR(0x88781115, "DMUS_E_CANNOTSEEK", "The IStream* doesn't support Seek().")
	DXERROR(0x88781116, "DMUS_E_CANNOTWRITE", "The IStream* doesn't support Write().")
	DXERROR(0x88781117, "DMUS_E_CHUNKNOTFOUND", "The RIFF parser doesn't contain a required chunk while parsing file.")
	DXERROR(0x88781119, "DMUS_E_INVALID_DOWNLOADID", "Invalid download id was used in the process of creating a download buffer.")
	DXERROR(0x88781120, "DMUS_E_NOT_DOWNLOADED_TO_PORT", "Tried to unload an object that was not downloaded or previously unloaded.")
	DXERROR(0x88781121, "DMUS_E_ALREADY_DOWNLOADED", "Buffer was already downloaded to synth.")
	DXERROR(0x88781122, "DMUS_E_UNKNOWN_PROPERTY", "The specified property item was not recognized by the target object.")
	DXERROR(0x88781123, "DMUS_E_SET_UNSUPPORTED", "The specified property item may not be set on the target object.")
	DXERROR(0x88781124, "DMUS_E_GET_UNSUPPORTED", "* The specified property item may not be retrieved from the target object.")
	DXERROR(0x88781125, "DMUS_E_NOTMONO", "Wave chunk has more than one interleaved channel. DLS format requires MONO.")
	DXERROR(0x88781126, "DMUS_E_BADARTICULATION", "Invalid articulation chunk in DLS collection.")
	DXERROR(0x88781127, "DMUS_E_BADINSTRUMENT", "Invalid instrument chunk in DLS collection.")
	DXERROR(0x88781128, "DMUS_E_BADWAVELINK", "Wavelink chunk in DLS collection points to invalid wave.")
	DXERROR(0x88781129, "DMUS_E_NOARTICULATION", "Articulation missing from instrument in DLS collection.")
	DXERROR(0x8878112a, "DMUS_E_NOTPCM", "Downoaded DLS wave is not in PCM format. ")
	DXERROR(0x8878112b, "DMUS_E_BADWAVE", "Bad wave chunk in DLS collection")
	DXERROR(0x8878112c, "DMUS_E_BADOFFSETTABLE", "Offset Table for download buffer has errors. ")
	DXERROR(0x8878112d, "DMUS_E_UNKNOWNDOWNLOAD", "Attempted to download unknown data type.")
	DXERROR(0x8878112e, "DMUS_E_NOSYNTHSINK", "The operation could not be completed because no sink was connected to the synthesizer.")
	DXERROR(0x8878112f, "DMUS_E_ALREADYOPEN", "An attempt was made to open the software synthesizer while it was already  open.")
	DXERROR(0x88781130, "DMUS_E_ALREADYCLOSED", "An attempt was made to close the software synthesizer while it was already  open.")
	DXERROR(0x88781131, "DMUS_E_SYNTHNOTCONFIGURED", "The operation could not be completed because the software synth has not  yet been fully configured.")
	DXERROR(0x88781132, "DMUS_E_SYNTHACTIVE", "The operation cannot be carried out while the synthesizer is active.")
	DXERROR(0x88781133, "DMUS_E_CANNOTREAD", "An error occurred while attempting to read from the IStream* object.")
	DXERROR(0x88781134, "DMUS_E_DMUSIC_RELEASED", "The operation cannot be performed because the final instance of the DirectMusic object was released. Ports cannot be used after final  release of the DirectMusic object.")
	DXERROR(0x88781135, "DMUS_E_BUFFER_EMPTY", "There was no data in the referenced buffer.")
	DXERROR(0x88781136, "DMUS_E_BUFFER_FULL", "There is insufficient space to insert the given event into the buffer.")
	DXERROR(0x88781137, "DMUS_E_PORT_NOT_CAPTURE", "The given operation could not be carried out because the port is a capture port.")
	DXERROR(0x88781138, "DMUS_E_PORT_NOT_RENDER", "The given operation could not be carried out because the port is a render port.")
	DXERROR(0x88781139, "DMUS_E_DSOUND_NOT_SET", "The port could not be created because no DirectSound has been specified. Specify a DirectSound interface via the IDirectMusic::SetDirectSound method; pass NULL to have DirectMusic manage usage of DirectSound.")
	DXERROR(0x8878113a, "DMUS_E_ALREADY_ACTIVATED", "The operation cannot be carried out while the port is active.")
	DXERROR(0x8878113b, "DMUS_E_INVALIDBUFFER", "Invalid DirectSound buffer was handed to port. ")
	DXERROR(0x8878113c, "DMUS_E_WAVEFORMATNOTSUPPORTED", "Invalid buffer format was handed to the synth sink.")
	DXERROR(0x8878113d, "DMUS_E_SYNTHINACTIVE", "The operation cannot be carried out while the synthesizer is inactive.")
	DXERROR(0x8878113e, "DMUS_E_DSOUND_ALREADY_SET", "IDirectMusic::SetDirectSound has already been called. It may not be changed while in use.")
	DXERROR(0x8878113f, "DMUS_E_INVALID_EVENT", "The given event is invalid (either it is not a valid MIDI message or it makes use of running status). The event cannot be packed into the buffer.")
	DXERROR(0x88781150, "DMUS_E_UNSUPPORTED_STREAM", "The IStream* object does not contain data supported by the loading object.")
	DXERROR(0x88781151, "DMUS_E_ALREADY_INITED", "The object has already been initialized.")
	DXERROR(0x88781152, "DMUS_E_INVALID_BAND", "The file does not contain a valid band.")
	DXERROR(0x88781155, "DMUS_E_TRACK_HDR_NOT_FIRST_CK", "The IStream* object's data does not have a track header as the first chunk, and therefore can not be read by the segment object.")
	DXERROR(0x88781156, "DMUS_E_TOOL_HDR_NOT_FIRST_CK", "The IStream* object's data does not have a tool header as the first chunk, and therefore can not be read by the graph object.")
	DXERROR(0x88781157, "DMUS_E_INVALID_TRACK_HDR", "The IStream* object's data contains an invalid track header (ckid is 0 and fccType is NULL,) and therefore can not be read by the segment object.")
	DXERROR(0x88781158, "DMUS_E_INVALID_TOOL_HDR", "The IStream* object's data contains an invalid tool header (ckid is 0 and fccType is NULL,) and therefore can not be read by the graph object.")
	DXERROR(0x88781159, "DMUS_E_ALL_TOOLS_FAILED", "The graph object was unable to load all tools from the IStream* object data. This may be due to errors in the stream, or the tools being incorrectly registered on the client.")
	DXERROR(0x88781160, "DMUS_E_ALL_TRACKS_FAILED", "The segment object was unable to load all tracks from the IStream* object data. This may be due to errors in the stream, or the tracks being incorrectly registered on the client.")
	DXERROR(0x88781161, "DSERR_OBJECTNOTFOUND", "The object requested was not found (numerically equal to DMUS_E_NOT_FOUND)")
	DXERROR(0x88781162, "DMUS_E_NOT_INIT", "A required object is not initialized or failed to initialize.")
	DXERROR(0x88781163, "DMUS_E_TYPE_DISABLED", "The requested parameter type is currently disabled. Parameter types may be enabled and disabled by certain calls to SetParam().")
	DXERROR(0x88781164, "DMUS_E_TYPE_UNSUPPORTED", "The requested parameter type is not supported on the object.")
	DXERROR(0x88781165, "DMUS_E_TIME_PAST", "The time is in the past, and the operation can not succeed.")
	DXERROR(0x88781166, "DMUS_E_TRACK_NOT_FOUND", "The requested track is not contained by the segment.")
	DXERROR(0x88781167, "DMUS_E_TRACK_NO_CLOCKTIME_SUPPORT", "The track does not support clock time playback or getparam.")
	DXERROR(0x88781170, "DMUS_E_NO_MASTER_CLOCK", "There is no master clock in the performance. Be sure to call IDirectMusicPerformance::Init().")
	DXERROR(0x88781180, "DMUS_E_LOADER_NOCLASSID", "The class id field is required and missing in the DMUS_OBJECTDESC.")
	DXERROR(0x88781181, "DMUS_E_LOADER_BADPATH", "The requested file path is invalid.")
	DXERROR(0x88781182, "DMUS_E_LOADER_FAILEDOPEN", "File open failed - either file doesn't exist or is locked.")
	DXERROR(0x88781183, "DMUS_E_LOADER_FORMATNOTSUPPORTED", "Search data type is not supported.")
	DXERROR(0x88781184, "DMUS_E_LOADER_FAILEDCREATE", "Unable to find or create object.")
	DXERROR(0x88781185, "DMUS_E_LOADER_OBJECTNOTFOUND", "Object was not found.")
	DXERROR(0x88781186, "DMUS_E_LOADER_NOFILENAME", "The file name is missing from the DMUS_OBJECTDESC.")
	DXERROR(0x88781200, "DMUS_E_INVALIDFILE", "The file requested is not a valid file.")
	DXERROR(0x88781201, "DMUS_E_ALREADY_EXISTS", "The tool is already contained in the graph. Create a new instance.")
	DXERROR(0x88781202, "DMUS_E_OUT_OF_RANGE", "Value is out of range, for instance the requested length is longer than the segment.")
	DXERROR(0x88781203, "DMUS_E_SEGMENT_INIT_FAILED", "Segment initialization failed, most likely due to a critical memory situation.")
	DXERROR(0x88781204, "DMUS_E_ALREADY_SENT", "The DMUS_PMSG has already been sent to the performance object via IDirectMusicPerformance::SendPMsg().")
	DXERROR(0x88781205, "DMUS_E_CANNOT_FREE", "The DMUS_PMSG was either not allocated by the performance via IDirectMusicPerformance::AllocPMsg() or it was already freed via IDirectMusicPerformance::FreePMsg().")
	DXERROR(0x88781206, "DMUS_E_CANNOT_OPEN_PORT", "The default system port could not be opened.")
	DXERROR(0x88781207, "DMUS_E_CANNOT_CONVERT", "A call to MIDIToMusic() or MusicToMIDI() resulted in an error because the requested conversion could not happen. This usually occurs when the provided DMUS_CHORD_KEY structure has an invalid chord or scale pattern.")
	DXERROR(0x88781210, "DMUS_E_DESCEND_CHUNK_FAIL", "DMUS_E_DESCEND_CHUNK_FAIL is returned when the end of the file  was reached before the desired chunk was found.")
	DXERROR(0x88781211, "DMUS_E_NOT_LOADED", "An attempt to use this object failed because it first needs to be loaded.")
	DXERROR(0x88781213, "DMUS_E_SCRIPT_LANGUAGE_INCOMPATIBLE", "The activeX scripting engine for the script's language is not compatible with DirectMusic.")
	DXERROR(0x88781214, "DMUS_E_SCRIPT_UNSUPPORTED_VARTYPE", "A varient was used that had a type that is not supported by DirectMusic.")
	DXERROR(0x88781215, "DMUS_E_SCRIPT_DXERROR_IN_SCRIPT", "An error was encountered while parsing or executing the script. The pErrorInfo parameter (if supplied) was filled with information about the error.")
	DXERROR(0x88781216, "DMUS_E_SCRIPT_CANTLOAD_OLEAUT32", "Loading of oleaut32.dll failed.  VBScript and other activeX scripting languages require use of oleaut32.dll.  On platforms where oleaut32.dll is not present, only the DirectMusicScript language, which doesn't require oleaut32.dll can be used.")
	DXERROR(0x88781217, "DMUS_E_SCRIPT_LOADSCRIPT_DXERROR", "An error occured while parsing a script loaded using LoadScript.  The script that was loaded contains an error.")
	DXERROR(0x88781218, "DMUS_E_SCRIPT_INVALID_FILE", "The script file is invalid.")
	DXERROR(0x88781219, "DMUS_E_INVALID_SCRIPTTRACK", "The file contains an invalid script track.")
	DXERROR(0x8878121a, "DMUS_E_SCRIPT_VARIABLE_NOT_FOUND", "The script does not contain a variable with the specified name.")
	DXERROR(0x8878121b, "DMUS_E_SCRIPT_ROUTINE_NOT_FOUND", "The script does not contain a routine with the specified name.")
	DXERROR(0x8878121c, "DMUS_E_SCRIPT_CONTENT_READONLY", "Scripts variables for content referenced or embedded in a script cannot be set.")
	DXERROR(0x8878121d, "DMUS_E_SCRIPT_NOT_A_REFERENCE", "Attempt was made to set a script's variable by reference to a value that was not an object type.")
	DXERROR(0x8878121e, "DMUS_E_SCRIPT_VALUE_NOT_SUPPORTED", "Attempt was made to set a script's variable by value to an object that does not support a default value property.")
	DXERROR(0x88781220, "DMUS_E_INVALID_SEGMENTTRIGGERTRACK", "The file contains an invalid segment trigger track.")
	DXERROR(0x88781221, "DMUS_E_INVALID_LYRICSTRACK", "The file contains an invalid lyrics track.")
	DXERROR(0x88781222, "DMUS_E_INVALID_PARAMCONTROLTRACK", "The file contains an invalid parameter control track.")
	DXERROR(0x88781223, "DMUS_E_AUDIOVBSCRIPT_SYNTAXDXERROR", "A script written in AudioVBScript could not be read because it contained a statement that is not allowed by the AudioVBScript language.")
	DXERROR(0x88781224, "DMUS_E_AUDIOVBSCRIPT_RUNTIMEDXERROR", "A script routine written in AudioVBScript failed because an invalid operation occurred.  For example, adding the number 3 to a segment object would produce this error.  So would attempting to call a routine that doesn't exist.")
	DXERROR(0x88781225, "DMUS_E_AUDIOVBSCRIPT_OPERATIONFAILURE", "A script routine written in AudioVBScript failed because a function outside of a script failed to complete. For example, a call to PlaySegment that fails to play because of low memory would return this error.")
	DXERROR(0x88781226, "DMUS_E_AUDIOPATHS_NOT_VALID", "The Performance has set up some PChannels using the AssignPChannel command, which makes it not capable of supporting audio paths.")
	DXERROR(0x88781227, "DMUS_E_AUDIOPATHS_IN_USE", "This is the inverse of the previous error. The Performance has set up some audio paths, which makes is incompatible with the calls to allocate pchannels, etc. ")
	DXERROR(0x88781228, "DMUS_E_NO_AUDIOPATH_CONFIG", "A segment or song was asked for its embedded audio path configuration, but there isn't any. ")
	DXERROR(0x88781229, "DMUS_E_AUDIOPATH_INACTIVE", "An audiopath is inactive, perhaps because closedown was called.")
	DXERROR(0x8878122a, "DMUS_E_AUDIOPATH_NOBUFFER", "An audiopath failed to create because a requested buffer could not be created.")
	DXERROR(0x8878122b, "DMUS_E_AUDIOPATH_NOPORT", "An audiopath could not be used for playback because it lacked port assignments.")
	DXERROR(0x8878122c, "DMUS_E_NO_AUDIOPATH", "Attempt was made to play segment in audiopath mode and there was no audiopath.")
	DXERROR(0x8878122d, "DMUS_E_INVALIDCHUNK", "Invalid data was found in a RIFF file chunk.")
	DXERROR(0x8878122e, "DMUS_E_AUDIOPATH_NOGLOBALFXBUFFER", "Attempt was made to create an audiopath that sends to a global effects buffer which did not exist.")
	DXERRORLAST(0x8878122f, "DMUS_E_INVALID_CONTAINER_OBJECT", "The file does not contain a valid container object.")
};

static Error UnknownError = DXERRORLAST(0xffffffff, "Unknown", "n/a");

static Error *FindError(unsigned long hr)
{
	register Error *Base = &Errors[0];
	register int Limit;
	register Error *Ptr;

	for (Limit = sizeof(Errors) / sizeof(Error); Limit != 0; Limit >>= 1)
	{
		Ptr = Base + (Limit >> 1);
		if (hr == Ptr->Value)
			return Ptr;
		if (hr > Ptr->Value)
		{
			Base = Ptr + 1;
			Limit--;
		}
	}
	return &UnknownError;
}

const TCHAR * __stdcall DXGetErrorString(unsigned long);
const TCHAR * __stdcall DXGetErrorString(unsigned long hr)
{
	return FindError(hr)->Name;
}

const TCHAR * __stdcall DXGetErrorDescription(unsigned long);
const TCHAR * __stdcall DXGetErrorDescription(unsigned long hr)
{
	return FindError(hr)->Description;
}

HRESULT __stdcall DXTrace(char *strFile, DWORD, HRESULT, TCHAR *, BOOL);
HRESULT __stdcall DXTrace(char *strFile, DWORD dwLine, HRESULT hr,
	TCHAR *strMsg, BOOL bPopMsgBox)
{
// FIXME: Decide which version to use?
//        The first version uses dynamic memory allocation and is
//        safer. Second version uses static arrays and that is why
//        it can be better for debugging.
#if 0
	const TCHAR *ErrorName = DXGetErrorString9(hr);
	TCHAR *DebugMessage;
   
	DebugMessage = (TCHAR *)malloc((strlen(strFile) + (strMsg ? _tcslen(strMsg) : 0) + _tcslen(ErrorName) + 48) * sizeof(TCHAR));
	if (DebugMessage == 0)
		return hr;
	wsprintf(DebugMessage, TEXT("%hs(%Lu): %s (hr=%s(0x%Lx))"), strFile, dwLine, (strMsg ? strMsg : TEXT("")) ErrorName, hr);
	OutputDebugString(DebugMessage);
	free(DebugMessage);

	if (bPopMsgBox)
	{
	    int Result;

		DebugMessage = (TCHAR *)malloc((strlen(strFile) + (strMsg ? _tcslen(strMsg) : 0) + _tcslen(ErrorName) + 60) * sizeof(TCHAR));
		if (DebugMessage == 0)
			return DXERROR_NOT_ENOUGH_MEMORY;
		wsprintf(DebugMessage, 
		   TEXT("File: %hs\nLine: %Lu\nError Code: %s(0x%Lx)\nCalling: %s\n"
		   "Do you want to debug the application?"), strFile, dwLine,
		   ErrorName, hr, (strMsg ? strMsg : TEXT("")));		
		Result = MessageBox(0, DebugMessage, TEXT("Unexpected error encountred"), MB_YESNO | MB_ICONDXERROR);
		if (Result == 0)
			return hr;
		if (Result == IDYES)
		{
        	free(DebugMessage);
			DebugBreak();
		} else
			free(DebugMessage);
	}
	return hr;
#else
	const TCHAR *ErrorName = DXGetErrorString(hr);
	TCHAR DebugMessage[4096];
   
	wsprintf(DebugMessage, TEXT("%hs(%Lu): %s (hr=%s(0x%Lx))"), strFile, dwLine, (strMsg ? strMsg : TEXT("")), ErrorName, hr);
	OutputDebugString(DebugMessage);
	if (bPopMsgBox)
	{
	    int Result;
		wsprintf(DebugMessage, 
		   TEXT("File: %hs\nLine: %Lu\nError Code: %s(0x%Lx)\nCalling: %s\n"
		   "Do you want to debug the application?"), strFile, dwLine,
		   ErrorName, hr, (strMsg ? strMsg : TEXT("")));		
		Result = MessageBox(0, DebugMessage, TEXT("Unexpected error encountred"), MB_YESNO | MB_ICONERROR);
		if (Result == IDYES)
			DebugBreak();
	}
	return hr;
#endif
}

