/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.core.scanner.NameValuePair;
import org.parosproxy.paros.core.scanner.RPCParameter;
import org.parosproxy.paros.core.scanner.Variant;
import org.parosproxy.paros.network.HttpMessage;

public abstract class VariantAbstractRPCQuery
implements Variant {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final List<RPCParameter> listParam = new ArrayList<RPCParameter>();
    private final List<NameValuePair> params = new ArrayList<NameValuePair>();
    private String requestContent;
    private final int variantType;

    public VariantAbstractRPCQuery() {
        this(2);
    }

    public VariantAbstractRPCQuery(int vt) {
        this.variantType = vt;
    }

    @Override
    public void setMessage(HttpMessage msg) {
        String contentType = msg.getRequestHeader().getHeader("content-type");
        if (contentType != null && this.isValidContentType(contentType)) {
            try {
                this.setRequestContent(msg.getRequestBody().toString());
            }
            catch (Exception e) {
                this.logger.warn("Failed to parse the request body for url {} : {}", (Object)msg.getRequestHeader().getURI(), (Object)e.getMessage(), (Object)e);
            }
        }
    }

    public void addParameter(RPCParameter param) {
        this.listParam.add(param);
    }

    public void addParameter(String name, int beginOffset, int endOffset, boolean toQuote, boolean escaped) {
        RPCParameter param = new RPCParameter();
        String value = this.requestContent.substring(beginOffset, endOffset);
        param.setName(name);
        param.setValue(escaped ? this.getUnescapedValue(value) : value);
        param.setBeginOffset(beginOffset);
        param.setEndOffset(endOffset);
        param.setToQuote(toQuote);
        this.listParam.add(param);
    }

    public void addParameter(String name, int beginOffset, int endOffset, boolean toQuote, String value) {
        RPCParameter param = new RPCParameter();
        param.setName(name);
        param.setValue(value);
        param.setBeginOffset(beginOffset);
        param.setEndOffset(endOffset);
        param.setToQuote(toQuote);
        this.listParam.add(param);
    }

    public String getToken(int beginOffset, int endOffset) {
        return this.requestContent.substring(beginOffset, endOffset);
    }

    @Override
    public List<NameValuePair> getParamList() {
        return this.params;
    }

    @Override
    public String setParameter(HttpMessage msg, NameValuePair originalPair, String name, String value) {
        return this.setParameter(msg, originalPair, name, value, false);
    }

    @Override
    public String setEscapedParameter(HttpMessage msg, NameValuePair originalPair, String name, String value) {
        return this.setParameter(msg, originalPair, name, value, true);
    }

    private String setParameter(HttpMessage msg, NameValuePair originalPair, String name, String value, boolean escaped) {
        RPCParameter param = this.listParam.get(originalPair.getPosition());
        StringBuilder sb = new StringBuilder();
        sb.append(this.requestContent.substring(0, param.getBeginOffset()));
        sb.append(escaped ? value : this.getEscapedValue(value, param.isToQuote()));
        sb.append(this.requestContent.substring(param.getEndOffset()));
        String query = sb.toString();
        msg.getRequestBody().setBody(query);
        return query;
    }

    protected void setRequestContent(String requestContent) {
        this.requestContent = requestContent;
        this.parseContent(requestContent);
        Collections.sort(this.listParam);
        for (int i = 0; i < this.listParam.size(); ++i) {
            RPCParameter param = this.listParam.get(i);
            this.params.add(new NameValuePair(this.variantType, param.getName(), param.getValue(), i));
        }
    }

    @Deprecated
    public String getReadableParametrizedQuery() {
        return this.getReadableParameterizedQuery();
    }

    public String getReadableParameterizedQuery() {
        StringBuilder result = new StringBuilder();
        int begin = 0;
        for (RPCParameter param : this.listParam) {
            int end = param.getBeginOffset();
            result.append(this.requestContent.substring(begin, end));
            result.append("__INJECTABLE_PARAM__");
            begin = param.getEndOffset();
        }
        result.append(this.requestContent.substring(begin));
        return result.toString();
    }

    public abstract boolean isValidContentType(String var1);

    public abstract void parseContent(String var1);

    public abstract String getEscapedValue(String var1, boolean var2);

    public abstract String getUnescapedValue(String var1);
}

