/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.painter.AbstractAreaPainter;
import org.jdesktop.swingx.painter.PainterUtils;
import org.jdesktop.swingx.painter.effects.AreaEffect;

public class TextPainter
extends AbstractAreaPainter<Object> {
    private String text = "";
    private Font font = null;

    public TextPainter() {
        this("");
    }

    public TextPainter(String text) {
        this(text, null, null);
    }

    public TextPainter(String text, Font font) {
        this(text, font, null);
    }

    public TextPainter(String text, Paint paint) {
        this(text, null, paint);
    }

    public TextPainter(String text, Font font, Paint paint) {
        this.text = text;
        this.font = font;
        this.setFillPaint(paint);
    }

    public void setFont(Font f) {
        Font old = this.getFont();
        this.font = f;
        this.setDirty(true);
        this.firePropertyChange("font", old, this.getFont());
    }

    public Font getFont() {
        return this.font;
    }

    public void setText(String text) {
        String old = this.getText();
        this.text = text == null ? "" : text;
        this.setDirty(true);
        this.firePropertyChange("text", old, this.getText());
    }

    public String getText() {
        return this.text;
    }

    @Override
    protected void doPaint(Graphics2D g, Object component, int width, int height) {
        Font f = this.calculateFont(component);
        if (f != null) {
            g.setFont(f);
        }
        Paint paint = PainterUtils.getForegroundPaint(this.getFillPaint(), component);
        String t = this.calculateText(component);
        FontMetrics metrics = g.getFontMetrics(g.getFont());
        int tw = metrics.stringWidth(t);
        int th = metrics.getHeight();
        Rectangle res = this.calculateLayout(tw, th, width, height);
        g.translate(res.x, res.y);
        if (this.isPaintStretched()) {
            paint = this.calculateSnappedPaint(paint, res.width, res.height);
        }
        if (paint != null) {
            g.setPaint(paint);
        }
        g.drawString(t, 0, 0 + metrics.getAscent());
        if (this.getAreaEffects() != null) {
            Shape shape = this.provideShape(g, component, width, height);
            for (AreaEffect ef : this.getAreaEffects()) {
                ef.apply(g, shape, width, height);
            }
        }
        g.translate(-res.x, -res.y);
    }

    private String calculateText(Object component) {
        String t = this.getText();
        if (t != null && !t.trim().equals("")) {
            return t;
        }
        if (component instanceof JTextComponent) {
            t = ((JTextComponent)component).getText();
        }
        if (component instanceof JLabel) {
            t = ((JLabel)component).getText();
        }
        if (component instanceof AbstractButton) {
            t = ((AbstractButton)component).getText();
        }
        return t;
    }

    private Font calculateFont(Object component) {
        Font f = PainterUtils.getComponentFont(this.getFont(), component);
        if (f == null) {
            f = new Font("Dialog", 0, 18);
        }
        return f;
    }

    @Override
    protected Shape provideShape(Graphics2D g2, Object comp, int width, int height) {
        Font f = this.calculateFont(comp);
        String t = this.calculateText(comp);
        FontMetrics metrics = g2.getFontMetrics(f);
        GlyphVector vect = f.createGlyphVector(g2.getFontRenderContext(), t);
        return vect.getOutline(0.0f, 0.0f + (float)metrics.getAscent());
    }
}

