/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.SplashScreen;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.accessibility.Accessible;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.netbeans.Stamps;
import org.netbeans.Util;
import org.netbeans.core.startup.CLIOptions;
import org.netbeans.core.startup.ScaledBitmapIcon;
import org.netbeans.core.startup.TopLogging;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class Splash
implements Stamps.Updater {
    private static Splash splash;
    private static final boolean noBar;
    private static final String ICON_16 = "org/netbeans/core/startup/frame.gif";
    private static final String ICON_32 = "org/netbeans/core/startup/frame32.gif";
    private static final String ICON_48 = "org/netbeans/core/startup/frame48.gif";
    private static final String ICON_256 = "org/netbeans/core/startup/frame256.png";
    private static final String ICON_512 = "org/netbeans/core/startup/frame512.png";
    private static final String ICON_1024 = "org/netbeans/core/startup/frame1024.png";
    private Frame frame;
    private SplashPainter painter;
    private SplashComponent comp;
    private SplashScreen splashScreen;
    private static final boolean USE_LAUNCHER_SPLASH = false;

    public static Splash getInstance() {
        if (splash == null) {
            splash = new Splash();
        }
        return splash;
    }

    public static void showAboutDialog(Frame frame, JComponent jComponent) {
        Splash.createAboutDialog(frame, jComponent).setVisible(true);
    }

    private static JDialog createAboutDialog(Frame frame, JComponent jComponent) {
        SplashDialog splashDialog = new SplashDialog(frame, jComponent);
        return splashDialog;
    }

    private void initFrameIcons(Frame frame) {
        frame.setIconImages(Arrays.asList(ImageUtilities.loadImage((String)ICON_16, (boolean)true), ImageUtilities.loadImage((String)ICON_32, (boolean)true), ImageUtilities.loadImage((String)ICON_48, (boolean)true), ImageUtilities.loadImage((String)ICON_256, (boolean)true), ImageUtilities.loadImage((String)ICON_512, (boolean)true), ImageUtilities.loadImage((String)ICON_1024, (boolean)true)));
    }

    private Splash() {
        Stamps stamps = Stamps.getModulesJARs();
        if (!CLIOptions.isNoSplash() && !GraphicsEnvironment.isHeadless()) {
            try {
                this.splashScreen = SplashScreen.getSplashScreen();
                if (this.splashScreen != null) {
                    Graphics2D graphics2D = this.splashScreen.createGraphics();
                    this.painter = new SplashPainter(graphics2D, null, false);
                }
            }
            catch (RuntimeException runtimeException) {
                Exceptions.printStackTrace((Throwable)runtimeException);
            }
            if (this.painter == null) {
                this.comp = new SplashComponent(false);
                this.painter = this.comp.painter;
            }
        }
    }

    final int getMaxSteps() {
        return this.painter.maxSteps;
    }

    final int getProgress() {
        return this.painter.progress;
    }

    public void setRunning(boolean bl) {
        if (CLIOptions.isNoSplash()) {
            return;
        }
        if (this.comp == null) {
            return;
        }
        if (bl) {
            if (this.frame == null) {
                this.frame = new Frame(NbBundle.getMessage(Splash.class, (String)"LBL_splash_window_title"));
                this.frame.setType(Window.Type.POPUP);
                this.initFrameIcons(this.frame);
                this.frame.setUndecorated(true);
                this.frame.setLayout(new BorderLayout());
                this.frame.add((Component)this.comp, "Center");
                this.frame.setResizable(false);
                int n = Integer.parseInt(NbBundle.getMessage(Splash.class, (String)"SPLASH_WIDTH"));
                int n2 = Integer.parseInt(NbBundle.getMessage(Splash.class, (String)"SPLASH_HEIGHT"));
                this.frame.setPreferredSize(new Dimension(n, n2));
                SwingUtilities.invokeLater(new SplashRunner(this.frame, true));
            }
        } else {
            SwingUtilities.invokeLater(new SplashRunner(this.frame, false));
        }
    }

    public void dispose() {
        this.setRunning(false);
        splash = null;
    }

    public void increment(int n) {
        if (noBar || CLIOptions.isNoSplash()) {
            return;
        }
        if (this.painter != null) {
            this.painter.increment(n);
        }
    }

    public Component getComponent() {
        return this.comp;
    }

    public void print(String string) {
        if (CLIOptions.isNoSplash() || this.painter == null) {
            return;
        }
        this.painter.setText(string);
    }

    public void addToMaxSteps(int n) {
        if (noBar || CLIOptions.isNoSplash()) {
            return;
        }
        if (this.painter != null) {
            this.painter.addToMaxSteps(n);
        }
    }

    static void center(Window window) {
        window.pack();
        window.setBounds(Utilities.findCenterBounds((Dimension)window.getSize()));
    }

    public static Image loadContent(boolean bl) {
        return ImageUtilities.icon2Image((Icon)Splash.loadContentIcon(bl));
    }

    private static Icon loadContentIcon(boolean bl) {
        Image image = null;
        if (bl) {
            image = ImageUtilities.loadImage((String)"org/netbeans/core/startup/about.png", (boolean)true);
        }
        if (image == null) {
            image = ImageUtilities.loadImage((String)"org/netbeans/core/startup/splash.gif", (boolean)true);
        }
        if (image == null) {
            return null;
        }
        return new ScaledBitmapIcon(image, Integer.parseInt(NbBundle.getMessage(Splash.class, (String)"SPLASH_WIDTH")), Integer.parseInt(NbBundle.getMessage(Splash.class, (String)"SPLASH_HEIGHT")));
    }

    public void flushCaches(DataOutputStream dataOutputStream) throws IOException {
        ImageIO.write((RenderedImage)((BufferedImage)Splash.loadContent(false)), "png", dataOutputStream);
    }

    public void cacheReady() {
    }

    public static void configureDefaultRenderingHints(Graphics2D graphics2D) {
        HashMap<RenderingHints.Key, Object> hashMap = (HashMap<RenderingHints.Key, Object>)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        if (hashMap == null) {
            hashMap = new HashMap<RenderingHints.Key, Object>();
            hashMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        graphics2D.addRenderingHints(hashMap);
    }

    static {
        noBar = Boolean.getBoolean("netbeans.splash.nobar") || !Boolean.parseBoolean(NbBundle.getMessage(Splash.class, (String)"SplashShowProgressBar"));
    }

    private static class SplashRunner
    implements Runnable {
        private Window splashWindow;
        private boolean visible;

        public SplashRunner(Window window, boolean bl) {
            this.splashWindow = window;
            this.visible = bl;
        }

        @Override
        public void run() {
            if (this.visible) {
                Splash.center(this.splashWindow);
                this.splashWindow.setVisible(true);
                this.splashWindow.toFront();
            } else {
                this.splashWindow.setVisible(false);
                this.splashWindow.dispose();
            }
        }
    }

    private static class SplashDialog
    extends JDialog
    implements ActionListener {
        static final long serialVersionUID = 5185644855500178404L;
        private final SplashComponent splashComponent = new SplashComponent(true);

        public SplashDialog(Frame frame, JComponent jComponent) {
            super(frame, true);
            JPanel jPanel = new JPanel();
            JTabbedPane jTabbedPane = new JTabbedPane();
            this.setTitle(NbBundle.getMessage(Splash.class, (String)"CTL_About_Title"));
            jPanel.add(this.splashComponent);
            jTabbedPane.addTab(NbBundle.getMessage(Splash.class, (String)"CTL_About_Title"), jPanel);
            jTabbedPane.addTab(NbBundle.getMessage(Splash.class, (String)"CTL_About_Detail"), jComponent);
            this.getContentPane().add((Component)jTabbedPane, "Center");
            this.getRootPane().registerKeyboardAction(this, KeyStroke.getKeyStroke(27, 0), 1);
            jTabbedPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(Splash.class, (String)"ACSN_AboutTabs"));
            jTabbedPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Splash.class, (String)"ACSD_AboutTabs"));
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Splash.class, (String)"ACSD_AboutDialog"));
            Splash.center(this);
            this.setDefaultCloseOperation(2);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.setVisible(false);
            this.dispose();
        }
    }

    private static class SplashPainter {
        TextBox statusBox;
        TextBox versionBox;
        Color color_bar;
        Color color_edge;
        Color color_corner;
        private Rectangle dirty = new Rectangle();
        private Rectangle bar = new Rectangle();
        private Rectangle bar_inc = new Rectangle();
        private int progress = 0;
        private int maxSteps = 0;
        private int barStart = 0;
        private int barLength = 0;
        private Icon image;
        private String text;
        private Graphics2D graphics;
        private final JComponent comp;
        private final boolean about;
        long next;

        public SplashPainter(Graphics graphics, JComponent jComponent, boolean bl) {
            this.graphics = (Graphics2D)graphics;
            this.comp = jComponent;
            this.about = bl;
        }

        final void init() throws MissingResourceException, NumberFormatException {
            assert (SwingUtilities.isEventDispatchThread());
            if (this.statusBox != null) {
                return;
            }
            this.maxSteps = 140;
            ResourceBundle resourceBundle = NbBundle.getBundle(Splash.class);
            this.statusBox = TextBox.parse(this.graphics, this.comp, resourceBundle, "SplashRunningText", false);
            this.versionBox = TextBox.parse(this.graphics, this.comp, resourceBundle, "SplashVersionText", true);
            StringTokenizer stringTokenizer = new StringTokenizer(resourceBundle.getString("SplashProgressBarBounds"), " ,");
            try {
                this.bar = new Rectangle(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
                Integer n = Integer.decode(resourceBundle.getString("SplashProgressBarColor"));
                this.color_bar = new Color(n);
                n = Integer.decode(resourceBundle.getString("SplashProgressBarEdgeColor"));
                this.color_edge = new Color(n);
                n = Integer.decode(resourceBundle.getString("SplashProgressBarCornerColor"));
                this.color_corner = new Color(n);
            }
            catch (NumberFormatException numberFormatException) {
                Util.err.warning("Number format exception loading splash screen parameters.");
                Logger.getLogger("global").log(Level.WARNING, null, numberFormatException);
                this.color_bar = Color.ORANGE;
                this.color_edge = Color.BLUE;
                this.color_corner = Color.GREEN;
                this.bar = new Rectangle(0, 0, 80, 10);
            }
            this.image = Splash.loadContentIcon(this.about);
            if (this.comp != null) {
                this.comp.setFont(this.statusBox.font);
            }
        }

        final void repaint(Rectangle rectangle) {
            if (this.comp != null) {
                this.comp.repaint(rectangle);
            } else if (this.next < System.currentTimeMillis()) {
                this.paint();
                try {
                    Splash splash = splash;
                    if (splash != null) {
                        splash.splashScreen.update();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.next = System.currentTimeMillis() + 200L;
            }
        }

        public void setText(final String string) {
            if (string != null && string.equals(this.text)) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    this.init();
                    if (string == null) {
                        this.repaint(dirty);
                        return;
                    }
                    if (statusBox.fm == null) {
                        return;
                    }
                    this.adjustText(string);
                    statusBox.layout(string, null);
                    dirty = dirty.union(statusBox.effectiveBounds);
                    this.repaint(dirty);
                    dirty = new Rectangle(statusBox.effectiveBounds);
                }
            });
        }

        private void adjustText(String string) {
            String string2 = null;
            if (string == null) {
                return;
            }
            if (this.statusBox.fm == null) {
                return;
            }
            int n = this.statusBox.fm.stringWidth(string);
            if (n > this.statusBox.bounds.width) {
                String string3;
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    string3 = string2 == null ? string4 : string2 + " " + string4;
                    if (this.statusBox.fm.stringWidth(string3 + "...") > this.statusBox.bounds.width) {
                        this.text = string2 + "...";
                        break;
                    }
                    string2 = string3;
                }
                if (string2 == null) {
                    this.text = "";
                    string3 = "";
                    string2 = "";
                    for (int i = 0; i < string.length(); ++i) {
                        if (this.statusBox.fm.stringWidth((string3 = string3 + string.charAt(i)) + "...") > this.statusBox.bounds.width) {
                            this.text = string2 + "...";
                            break;
                        }
                        string2 = string3;
                    }
                }
            } else {
                this.text = string;
            }
        }

        public void increment(int n) {
            int n2;
            if (n <= 0) {
                return;
            }
            this.progress += n;
            if (this.progress > this.maxSteps) {
                this.progress = this.maxSteps;
            } else if (this.maxSteps > 0 && ((n2 = this.bar.width * this.progress / this.maxSteps - this.barStart) > 1 || this.barStart % 2 == 0)) {
                this.barLength = n2;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.init();
                        this.repaint(bar);
                    }
                });
            }
        }

        final void addToMaxSteps(int n) {
            if (n == 0) {
                return;
            }
            if (this.maxSteps == 0) {
                int n2 = this.progress / n;
                this.maxSteps = n;
                this.progress = n2;
            } else {
                int n3 = this.maxSteps + n;
                int n4 = this.progress * n3 / this.maxSteps;
                this.maxSteps = n3;
                this.progress = n4;
            }
        }

        void paint() {
            if (this.image != null) {
                this.image.paintIcon(this.comp, this.graphics, 0, 0);
            }
            Splash.configureDefaultRenderingHints(this.graphics);
            if (this.versionBox != null) {
                String string = System.getProperty("netbeans.buildnumber");
                this.versionBox.layout(NbBundle.getMessage(TopLogging.class, (String)"currentVersion", (Object)string), this.graphics);
            }
            if (this.text != null) {
                this.statusBox.layout(this.text, this.graphics);
            }
            if (!noBar && this.maxSteps > 0) {
                this.graphics.setColor(this.color_bar);
                this.graphics.fillRect(this.bar.x, this.bar.y, this.barStart + this.barLength, this.bar.height);
                if (!this.color_bar.equals(this.color_corner)) {
                    this.graphics.setColor(this.color_corner);
                    this.graphics.drawLine(this.bar.x, this.bar.y, this.bar.x, this.bar.y + this.bar.height);
                    this.graphics.drawLine(this.bar.x + this.barStart + this.barLength, this.bar.y, this.bar.x + this.barStart + this.barLength, this.bar.y + this.bar.height);
                }
                if (!this.color_bar.equals(this.color_edge)) {
                    this.graphics.setColor(this.color_edge);
                    this.graphics.drawLine(this.bar.x, this.bar.y + this.bar.height / 2, this.bar.x, this.bar.y + this.bar.height / 2);
                    this.graphics.drawLine(this.bar.x + this.barStart + this.barLength, this.bar.y + this.bar.height / 2, this.bar.x + this.barStart + this.barLength, this.bar.y + this.bar.height / 2);
                }
                this.barStart += this.barLength;
                this.barLength = 0;
            }
        }
    }

    private static final class TextBox {
        final Rectangle bounds;
        final Color color;
        final int textSize;
        final Font font;
        final FontMetrics fm;
        final int horizontalAlignment;
        final Rectangle effectiveBounds = new Rectangle();

        private TextBox(Rectangle rectangle, Color color, int n, Font font, FontMetrics fontMetrics, int n2) {
            this.bounds = rectangle;
            this.color = color;
            this.textSize = n;
            this.font = font;
            this.fm = fontMetrics;
            this.horizontalAlignment = n2;
        }

        public void layout(String string, Graphics graphics) {
            if (this.fm == null) {
                return;
            }
            SwingUtilities.layoutCompoundLabel(this.fm, string, null, 3, this.horizontalAlignment, 3, this.horizontalAlignment, this.bounds, new Rectangle(), this.effectiveBounds, 0);
            if (graphics != null) {
                graphics.setColor(this.color);
                graphics.setFont(this.font);
                graphics.drawString(string, this.effectiveBounds.x, this.effectiveBounds.y + this.fm.getAscent());
            }
        }

        public static TextBox parse(Graphics graphics, JComponent jComponent, ResourceBundle resourceBundle, String string, boolean bl) {
            if (bl && !resourceBundle.containsKey(string + "Bounds")) {
                return null;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(resourceBundle.getString(string + "Bounds"), " ,");
            Rectangle rectangle = new Rectangle(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
            Color color = Color.BLACK;
            try {
                Integer n = Integer.decode(resourceBundle.getString(string + "Color"));
                color = new Color(n);
            }
            catch (NumberFormatException numberFormatException) {
                Util.err.warning("Number format exception loading splash screen parameters.");
                Logger.getLogger("global").log(Level.WARNING, null, numberFormatException);
            }
            int n = 12;
            try {
                String string2 = resourceBundle.getString(string + "FontSize");
                n = Integer.parseInt(string2);
            }
            catch (MissingResourceException missingResourceException) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            int n2 = 2;
            try {
                switch (resourceBundle.getString(string + "HorizontalAlignment").toLowerCase(Locale.US)) {
                    case "left": {
                        n2 = 2;
                        break;
                    }
                    case "center": {
                        n2 = 0;
                        break;
                    }
                    case "right": {
                        n2 = 4;
                        break;
                    }
                    default: {
                        Util.err.warning("Invalid horizontal alignment for splash screen text box");
                        break;
                    }
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            Object object = new Font(resourceBundle.getString(string + "FontType"), 0, n);
            FontMetrics fontMetrics = jComponent != null ? jComponent.getFontMetrics((Font)object) : graphics.getFontMetrics((Font)object);
            return new TextBox(rectangle, color, n, (Font)object, fontMetrics, n2);
        }
    }

    private static class SplashComponent
    extends JComponent
    implements Accessible {
        final SplashPainter painter;

        public SplashComponent(boolean bl) {
            this.painter = new SplashPainter((Graphics2D)this.getGraphics(), this, bl);
        }

        @Override
        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        @Override
        public void paint(Graphics graphics) {
            this.painter.graphics = (Graphics2D)graphics;
            this.painter.paint();
        }

        @Override
        public boolean isOpaque() {
            return true;
        }

        @Override
        public String toString() {
            return "SplashComponent - progress: " + this.painter.progress + "/" + this.painter.maxSteps + " text: " + this.painter.text;
        }
    }
}

