/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jsampler.CC;
import org.jsampler.HF;
import org.jsampler.OrchestraModel;
import org.jsampler.view.OrchestraTable;
import org.jsampler.view.OrchestraTableModel;
import org.jsampler.view.std.JSAddOrEditOrchestraDlg;
import org.jsampler.view.std.StdI18n;

public class JSManageOrchestrasPane
extends JPanel {
    protected final OrchestraTable orchestraTable;
    protected final Action actionAddOrchestra = new AddOrchestraAction();
    protected final Action actionEditOrchestra = new EditOrchestraAction();
    protected final Action actionDeleteOrchestra = new DeleteOrchestraAction();
    protected final Action actionOrchestraUp = new OrchestraUpAction();
    protected final Action actionOrchestraDown = new OrchestraDownAction();

    public JSManageOrchestrasPane() {
        this.setLayout(new BorderLayout());
        this.orchestraTable = new OrchestraTable(new OrchestraTableModel(CC.getOrchestras()));
        JScrollPane jScrollPane = new JScrollPane(this.orchestraTable);
        this.add(jScrollPane);
        this.installListeneres();
    }

    private void installListeneres() {
        OrchestraSelectionHandler orchestraSelectionHandler = new OrchestraSelectionHandler();
        this.orchestraTable.getSelectionModel().addListSelectionListener(orchestraSelectionHandler);
        this.orchestraTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() < 2) {
                    return;
                }
                if (JSManageOrchestrasPane.this.orchestraTable.getSelectedOrchestra() == null) {
                    return;
                }
                JSManageOrchestrasPane.this.editOrchestra(JSManageOrchestrasPane.this.orchestraTable.getSelectedOrchestra());
            }
        });
        KeyStroke keyStroke = KeyStroke.getKeyStroke(127, 0);
        this.orchestraTable.getInputMap(0).put(keyStroke, "deleteOrchestra");
        this.orchestraTable.getActionMap().put("deleteOrchestra", this.actionDeleteOrchestra);
    }

    public OrchestraModel createOrchestra() {
        JSAddOrEditOrchestraDlg jSAddOrEditOrchestraDlg = new JSAddOrEditOrchestraDlg();
        jSAddOrEditOrchestraDlg.setVisible(true);
        if (jSAddOrEditOrchestraDlg.isCancelled()) {
            return null;
        }
        return jSAddOrEditOrchestraDlg.getOrchestra();
    }

    public void editOrchestra(OrchestraModel orchestraModel) {
        JSAddOrEditOrchestraDlg jSAddOrEditOrchestraDlg = new JSAddOrEditOrchestraDlg(orchestraModel);
        jSAddOrEditOrchestraDlg.setVisible(true);
    }

    private class OrchestraDownAction
    extends AbstractAction {
        OrchestraDownAction() {
            super("");
            String string = StdI18n.i18n.getLabel("JSManageOrchestrasPane.ttOrchestraDown");
            this.putValue("ShortDescription", string);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            OrchestraModel orchestraModel = JSManageOrchestrasPane.this.orchestraTable.getSelectedOrchestra();
            CC.getOrchestras().moveOrchestraDown(orchestraModel);
            JSManageOrchestrasPane.this.orchestraTable.setSelectedOrchestra(orchestraModel);
        }
    }

    private class OrchestraUpAction
    extends AbstractAction {
        OrchestraUpAction() {
            super("");
            String string = StdI18n.i18n.getLabel("JSManageOrchestrasPane.ttOrchestraUp");
            this.putValue("ShortDescription", string);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            OrchestraModel orchestraModel = JSManageOrchestrasPane.this.orchestraTable.getSelectedOrchestra();
            CC.getOrchestras().moveOrchestraUp(orchestraModel);
            JSManageOrchestrasPane.this.orchestraTable.setSelectedOrchestra(orchestraModel);
        }
    }

    private class DeleteOrchestraAction
    extends AbstractAction {
        DeleteOrchestraAction() {
            super("");
            String string = StdI18n.i18n.getLabel("JSManageOrchestrasPane.ttDeleteOrchestra");
            this.putValue("ShortDescription", string);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            OrchestraModel orchestraModel = JSManageOrchestrasPane.this.orchestraTable.getSelectedOrchestra();
            if (orchestraModel == null) {
                return;
            }
            if (orchestraModel.getInstrumentCount() > 0) {
                String string = StdI18n.i18n.getMessage("JSManageOrchestrasPane.removeOrchestra?");
                if (!HF.showYesNoDialog(CC.getMainFrame(), string)) {
                    return;
                }
            }
            int n = JSManageOrchestrasPane.this.orchestraTable.getSelectedRow();
            CC.getOrchestras().removeOrchestra(orchestraModel);
            if (JSManageOrchestrasPane.this.orchestraTable.getRowCount() > n) {
                JSManageOrchestrasPane.this.orchestraTable.getSelectionModel().setSelectionInterval(n, n);
            }
        }
    }

    private class EditOrchestraAction
    extends AbstractAction {
        EditOrchestraAction() {
            super("");
            String string = StdI18n.i18n.getLabel("JSManageOrchestrasPane.ttEditOrchestra");
            this.putValue("ShortDescription", string);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JSManageOrchestrasPane.this.editOrchestra(JSManageOrchestrasPane.this.orchestraTable.getSelectedOrchestra());
        }
    }

    private class AddOrchestraAction
    extends AbstractAction {
        AddOrchestraAction() {
            super("");
            String string = StdI18n.i18n.getLabel("JSManageOrchestrasPane.ttAddOrchestra");
            this.putValue("ShortDescription", string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            OrchestraModel orchestraModel = JSManageOrchestrasPane.this.createOrchestra();
            if (orchestraModel == null) {
                return;
            }
            OrchestraModel orchestraModel2 = JSManageOrchestrasPane.this.orchestraTable.getSelectedOrchestra();
            int n = CC.getOrchestras().getOrchestraIndex(orchestraModel2);
            if (n < 0) {
                CC.getOrchestras().addOrchestra(orchestraModel);
            } else {
                CC.getOrchestras().insertOrchestra(orchestraModel, n);
            }
            JSManageOrchestrasPane.this.orchestraTable.setSelectedOrchestra(orchestraModel);
        }
    }

    private class OrchestraSelectionHandler
    implements ListSelectionListener {
        private OrchestraSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            if (JSManageOrchestrasPane.this.orchestraTable.getSelectedOrchestra() == null) {
                JSManageOrchestrasPane.this.actionEditOrchestra.setEnabled(false);
                JSManageOrchestrasPane.this.actionDeleteOrchestra.setEnabled(false);
                JSManageOrchestrasPane.this.actionOrchestraUp.setEnabled(false);
                JSManageOrchestrasPane.this.actionOrchestraDown.setEnabled(false);
                return;
            }
            JSManageOrchestrasPane.this.actionEditOrchestra.setEnabled(true);
            JSManageOrchestrasPane.this.actionDeleteOrchestra.setEnabled(true);
            OrchestraModel orchestraModel = JSManageOrchestrasPane.this.orchestraTable.getSelectedOrchestra();
            int n = JSManageOrchestrasPane.this.orchestraTable.getSelectedRow();
            JSManageOrchestrasPane.this.actionOrchestraUp.setEnabled(n != 0);
            JSManageOrchestrasPane.this.actionOrchestraDown.setEnabled(n != JSManageOrchestrasPane.this.orchestraTable.getRowCount() - 1);
        }
    }
}

