/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.util;

import java.io.IOException;
import java.io.Writer;
import org.openjdk.jmc.common.IWritableState;
import org.openjdk.jmc.common.util.XmlToolkit;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class StateElementWriter
implements IWritableState {
    private final Document document;
    private final Element element;

    StateElementWriter(String rootName) throws IOException {
        this(XmlToolkit.createNewDocument(rootName));
    }

    StateElementWriter(Document document) {
        this(document, document.getDocumentElement());
    }

    private StateElementWriter(Document document, Element element) {
        this.element = element;
        this.document = document;
    }

    @Override
    public IWritableState createChild(String type) {
        Element childElement = this.document.createElement(type);
        this.element.appendChild(childElement);
        return new StateElementWriter(this.document, childElement);
    }

    @Override
    public void putString(String key, String value) {
        if (value == null) {
            this.element.removeAttribute(key);
        } else {
            this.element.setAttribute(key, value);
        }
    }

    public void write(Writer writer) {
        XmlToolkit.prettyPrint(this.element, writer);
    }

    public String toString() {
        return XmlToolkit.prettyPrint(this.element);
    }
}

