/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.latex3;

import com.dickimawbooks.texparserlib.Command;
import com.dickimawbooks.texparserlib.Numerical;
import com.dickimawbooks.texparserlib.TeXBoolean;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import java.io.IOException;

public class IfBoolean
extends Command {
    protected boolean hasTrueArg;
    protected boolean hasFalseArg;

    public IfBoolean() {
        this("IfBooleanTF", true, true);
    }

    public IfBoolean(String string, boolean bl, boolean bl2) {
        super(string, false);
        this.hasTrueArg = bl;
        this.hasFalseArg = bl2;
    }

    @Override
    public Object clone() {
        return new IfBoolean(this.getName(), this.hasTrueArg, this.hasFalseArg);
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        return this.expandonce(teXParser, teXParser);
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = this.getResult(teXParser, teXObjectList);
        if (teXObject == null) {
            return teXParser.getListener().createStack();
        }
        if (teXParser.isStack(teXObject)) {
            return (TeXObjectList)teXObject;
        }
        return TeXParserUtils.createStack(teXParser, teXObject);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return this.expandfully(teXParser, teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = this.getResult(teXParser, teXObjectList);
        if (teXObject == null) {
            return teXParser.getListener().createStack();
        }
        if (teXParser.isStack(teXObject = TeXParserUtils.expandFully(teXObject, teXParser, teXObjectList))) {
            return (TeXObjectList)teXObject;
        }
        return TeXParserUtils.createStack(teXParser, teXObject);
    }

    protected boolean isTrue(TeXObject teXObject, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if ((teXObject = TeXParserUtils.resolve(teXObject, teXParser)) instanceof Numerical) {
            return ((Numerical)teXObject).number(teXParser) != 0;
        }
        if (teXObject instanceof TeXBoolean) {
            return ((TeXBoolean)teXObject).booleanValue();
        }
        String string = teXParser.expandToString(teXObject, teXObjectList).toLowerCase().trim();
        return string.equals("1") || string.equals("true");
    }

    protected TeXObject getResult(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = this.popArg(teXParser, teXObjectList);
        TeXObject teXObject2 = null;
        TeXObject teXObject3 = null;
        if (this.hasTrueArg) {
            teXObject2 = this.popArg(teXParser, teXObjectList);
        }
        if (this.hasFalseArg) {
            teXObject3 = this.popArg(teXParser, teXObjectList);
        }
        if (this.isTrue(teXObject, teXParser, teXObjectList)) {
            return teXObject2;
        }
        return teXObject3;
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        TeXObject teXObject = this.getResult(teXParser, teXParser);
        if (teXObject != null) {
            teXObject.process(teXParser);
        }
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = this.getResult(teXParser, teXObjectList);
        if (teXObject != null) {
            teXObject.process(teXParser, teXObjectList);
        }
    }
}

