/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.protege.editor.core.ui.util.FormLabel;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.core.ui.util.VerifiedInputEditor;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.editor.OWLObjectEditorHandler;
import org.semanticweb.owlapi.model.IRI;

public class IRITextEditor
implements OWLObjectEditor<IRI>,
VerifiedInputEditor {
    private OWLObjectEditorHandler<IRI> handler;
    private JPanel editor;
    private JTextField iriTextField;
    private List<InputVerificationStatusChangedListener> inputVerificationListeners = new ArrayList<InputVerificationStatusChangedListener>();

    public IRITextEditor(OWLEditorKit editorKit) {
        this.createGui();
    }

    private void createGui() {
        this.editor = new JPanel();
        this.editor.setBorder(BorderFactory.createEmptyBorder(7, 0, 0, 0));
        this.editor.setLayout(new BorderLayout());
        JPanel holder = new JPanel(new BorderLayout());
        this.editor.add((Component)holder, "North");
        FormLabel iriLabel = new FormLabel("IRI");
        iriLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 7, 0));
        holder.add((Component)iriLabel, "North");
        this.iriTextField = new JTextField();
        this.iriTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                for (InputVerificationStatusChangedListener listener : IRITextEditor.this.inputVerificationListeners) {
                    listener.verifiedStatusChanged(IRITextEditor.this.getEditedObject() != null);
                }
            }
        });
        holder.add((Component)this.iriTextField, "South");
        this.editor.addHierarchyListener(e -> {
            if (this.editor.isShowing()) {
                this.iriTextField.requestFocus();
            }
        });
    }

    @Override
    @Nullable
    public IRI getEditedObject() {
        IRI editedObject = null;
        try {
            editedObject = IRI.create((String)this.iriTextField.getText());
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return editedObject;
    }

    @Override
    @Nonnull
    public String getEditorTypeName() {
        return "IRI Editor";
    }

    @Override
    public boolean canEdit(Object object) {
        return object instanceof IRI;
    }

    @Override
    public boolean isMultiEditSupported() {
        return false;
    }

    public boolean isPreferred() {
        return false;
    }

    @Override
    @Nonnull
    public JComponent getEditorComponent() {
        return this.editor;
    }

    @Override
    public boolean setEditedObject(IRI editedObject) {
        if (editedObject != null) {
            this.iriTextField.setText(editedObject.toString());
        }
        return editedObject != null;
    }

    @Override
    public Set<IRI> getEditedObjects() {
        IRI editedObject = this.getEditedObject();
        if (editedObject != null) {
            return Collections.singleton(editedObject);
        }
        return Collections.emptySet();
    }

    public void addStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.inputVerificationListeners.add(listener);
    }

    public void removeStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.inputVerificationListeners.remove(listener);
    }

    @Override
    public OWLObjectEditorHandler<IRI> getHandler() {
        return this.handler;
    }

    @Override
    public void setHandler(OWLObjectEditorHandler<IRI> handler) {
        this.handler = handler;
    }

    @Override
    public void clear() {
        this.iriTextField.setText("");
    }

    @Override
    public void dispose() {
    }
}

