/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.conf.valueset;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.protege.editor.owl.model.conf.valueset.LabelledValue;
import org.protege.editor.owl.model.conf.valueset.LabelledValueRenderer;

public class ValueSetComponent
extends JPanel {
    private static final int THRESHOLD_SIZE = 6;
    private JComboBox<LabelledValue> comboBox = new JComboBox();
    private Box radioButtonBox = new Box(1);
    private Map<JRadioButton, LabelledValue> radioButtons = new LinkedHashMap<JRadioButton, LabelledValue>();

    public ValueSetComponent() {
        this.setLayout(new BorderLayout());
        this.comboBox.setRenderer(new LabelledValueRenderer());
    }

    public void clearValues() {
        this.removeAll();
        this.radioButtonBox.removeAll();
        this.radioButtons.clear();
    }

    public void setValues(@Nonnull List<LabelledValue> labelledValues) {
        this.removeAll();
        this.radioButtons.clear();
        this.radioButtonBox.removeAll();
        if (labelledValues.size() < 6) {
            this.add((Component)this.radioButtonBox, "North");
            ButtonGroup bg = new ButtonGroup();
            labelledValues.forEach(v -> {
                JRadioButton b = new JRadioButton(v.getLabel());
                bg.add(b);
                this.radioButtons.put(b, (LabelledValue)v);
                this.radioButtonBox.add(b);
            });
        } else {
            this.comboBox.setModel(new DefaultComboBoxModel<LabelledValue>(labelledValues.toArray(new LabelledValue[labelledValues.size()])));
            this.add(this.comboBox, "North");
        }
    }

    @Nonnull
    public Optional<LabelledValue> getSelectedValue() {
        if (this.radioButtons.isEmpty()) {
            return Optional.ofNullable((LabelledValue)this.comboBox.getSelectedItem());
        }
        return this.radioButtons.entrySet().stream().filter(e -> ((JRadioButton)e.getKey()).isSelected()).map(Map.Entry::getValue).findFirst();
    }

    public void setSelectedIndex(int selectedIndex) {
        if (this.radioButtons.isEmpty()) {
            if (selectedIndex < this.comboBox.getModel().getSize()) {
                this.comboBox.setSelectedIndex(selectedIndex);
            }
        } else {
            int counter = 0;
            for (JRadioButton button : this.radioButtons.keySet()) {
                if (selectedIndex == counter) {
                    button.setSelected(true);
                    break;
                }
                ++counter;
            }
        }
    }
}

