/*
 * Decompiled with CFR 0.152.
 */
package org.coode.mdock;

import java.util.Arrays;
import java.util.List;
import org.coode.mdock.HorizontalSplitterNode;
import org.coode.mdock.Node;
import org.coode.mdock.NodeVisitor;
import org.coode.mdock.Splitter;
import org.coode.mdock.SplitterNode;
import org.coode.mdock.VerticalSplitter;

public class VerticalSplitterNode
extends SplitterNode {
    public VerticalSplitterNode(List<? extends Node> children, List<Double> splits) {
        super(children, splits);
    }

    @Override
    protected double getGloballyNormalisedWidth(Node child) {
        return this.getGloballyNormalisedWidth() * this.getNormalisedSplit(child);
    }

    @Override
    public double getGloballyNormalisedXLocation(Node child) {
        double xLoc = this.getGloballyNormalisedXLocation();
        for (Node curChild : this.getVisibleChildren()) {
            if (curChild == child) {
                return xLoc;
            }
            xLoc += this.getGloballyNormalisedWidth(curChild);
        }
        return 0.0;
    }

    @Override
    public boolean isSplitterDirection(int direction) {
        return 1 == direction;
    }

    @Override
    public Splitter createSplitter(Node child0, Node child1) {
        return new VerticalSplitter(this, child0, child1);
    }

    @Override
    protected SplitterNode createPerpendicularSplitterNode(List<Node> children, List<Double> splits) {
        return new HorizontalSplitterNode(children, splits);
    }

    public SplitterNode pushDown(Node existingChild, List<Node> children) {
        HorizontalSplitterNode vsn = new HorizontalSplitterNode(children, Arrays.asList(0.5, 0.5));
        this.replaceChild(existingChild, vsn);
        return vsn;
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }
}

