"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _configSchema = require("@osd/config-schema");
var _helpers = require("../services/utils/helpers");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(services, router, dataSourceEnabled) {
  const {
    anomalyDetectorService
  } = services;
  router.get({
    path: '/api/alerting/detectors/{detectorId}',
    validate: {
      params: _configSchema.schema.object({
        detectorId: _configSchema.schema.string()
      }),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled)
    }
  }, anomalyDetectorService.getDetector);
  router.post({
    path: '/api/alerting/detectors/_search',
    validate: false
  }, anomalyDetectorService.getDetectors);
  router.get({
    path: '/api/alerting/detectors/{detectorId}/results',
    validate: {
      params: _configSchema.schema.object({
        detectorId: _configSchema.schema.string()
      }),
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled, {
        startTime: _configSchema.schema.maybe(_configSchema.schema.number()),
        endTime: _configSchema.schema.maybe(_configSchema.schema.number()),
        preview: _configSchema.schema.maybe(_configSchema.schema.boolean())
      })
    }
  }, anomalyDetectorService.getDetectorResults);
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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