<?php

namespace MediaWiki\Extension\Math\WikiTexVC\MMLnodes;

/**
 * Presentation MathML 3 Element
 * name: "mover"
 * description: "attach an overscript to a base"
 * category: "Script and Limit Schemata"
 */
class MMLmover extends MMLbase {
	public function __construct( string $texclass = "", array $attributes = [] ) {
		parent::__construct( "mover", $texclass, $attributes );
	}

	/**
	 * Creates a new subtree element with base and scripts
	 * @param MMLbase|string $base Main content element
	 * @param MMLbase|string $overscript Element placed above the base (overscript)
	 * @param string $texclass Optional TeX class for styling
	 * @param array $attributes Additional HTML attributes for the element
	 * @return static New instance with children in order: [base, overscript]
	 */
	public static function newSubtree( $base,
									   $overscript,
									   string $texclass = "",
									   array $attributes = [] ) {
		$instance = new self( $texclass, $attributes );
		$instance->children = [ $base, $overscript ];
		return $instance;
	}
}
