/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.protocol;

import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.ProtocolKeyword;
import io.lettuce.core.protocol.RedisCommand;
import io.netty.buffer.ByteBuf;

public class Command<K, V, T>
implements RedisCommand<K, V, T> {
    protected static final byte ST_INITIAL = 0;
    protected static final byte ST_COMPLETED = 1;
    protected static final byte ST_CANCELLED = 2;
    private final ProtocolKeyword type;
    protected CommandArgs<K, V> args;
    protected CommandOutput<K, V, T> output;
    protected Throwable exception;
    protected volatile byte status = 0;

    public Command(ProtocolKeyword type, CommandOutput<K, V, T> output) {
        this(type, output, null);
    }

    public Command(ProtocolKeyword type, CommandOutput<K, V, T> output, CommandArgs<K, V> args) {
        LettuceAssert.notNull((Object)type, "Command type must not be null");
        this.type = type;
        this.output = output;
        this.args = args;
    }

    @Override
    public CommandOutput<K, V, T> getOutput() {
        return this.output;
    }

    @Override
    public boolean completeExceptionally(Throwable throwable) {
        if (this.output != null) {
            this.output.setError(throwable.getMessage());
        }
        this.exception = throwable;
        this.status = 1;
        return true;
    }

    @Override
    public void complete() {
        this.status = 1;
    }

    @Override
    public void cancel() {
        this.status = (byte)2;
    }

    @Override
    public void encode(ByteBuf buf) {
        buf.touch((Object)"Command.encode(\u2026)");
        buf.writeByte(42);
        CommandArgs.IntegerArgument.writeInteger(buf, 1 + (this.args != null ? this.args.count() : 0));
        buf.writeBytes(CommandArgs.CRLF);
        CommandArgs.BytesArgument.writeBytes(buf, this.type.getBytes());
        if (this.args != null) {
            this.args.encode(buf);
        }
    }

    public String getError() {
        return this.output.getError();
    }

    @Override
    public CommandArgs<K, V> getArgs() {
        return this.args;
    }

    public T get() {
        if (this.output != null) {
            return this.output.get();
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [type=").append(this.type);
        sb.append(", output=").append(this.output);
        sb.append(']');
        return sb.toString();
    }

    @Override
    public void setOutput(CommandOutput<K, V, T> output) {
        if (this.status != 0) {
            throw new IllegalStateException("Command is completed/cancelled. Cannot set a new output");
        }
        this.output = output;
    }

    @Override
    public ProtocolKeyword getType() {
        return this.type;
    }

    @Override
    public boolean isCancelled() {
        return this.status == 2;
    }

    @Override
    public boolean isDone() {
        return this.status != 0;
    }
}

