/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.sdjwt.consumer;

import java.util.ArrayList;
import java.util.List;
import org.keycloak.common.VerificationException;
import org.keycloak.crypto.SignatureVerifierContext;
import org.keycloak.sdjwt.IssuerSignedJWT;
import org.keycloak.sdjwt.IssuerSignedJwtVerificationOpts;
import org.keycloak.sdjwt.consumer.PresentationRequirements;
import org.keycloak.sdjwt.consumer.TrustedSdJwtIssuer;
import org.keycloak.sdjwt.vp.KeyBindingJwtVerificationOpts;
import org.keycloak.sdjwt.vp.SdJwtVP;

public class SdJwtPresentationConsumer {
    public void verifySdJwtPresentation(SdJwtVP sdJwtVP, PresentationRequirements presentationRequirements, List<TrustedSdJwtIssuer> trustedSdJwtIssuers, IssuerSignedJwtVerificationOpts issuerSignedJwtVerificationOpts, KeyBindingJwtVerificationOpts keyBindingJwtVerificationOpts) throws VerificationException {
        IssuerSignedJWT issuerSignedJWT = sdJwtVP.getIssuerSignedJWT();
        ArrayList<SignatureVerifierContext> issuerVerifyingKeys = new ArrayList<SignatureVerifierContext>();
        for (TrustedSdJwtIssuer trustedSdJwtIssuer : trustedSdJwtIssuers) {
            List<SignatureVerifierContext> keys = trustedSdJwtIssuer.resolveIssuerVerifyingKeys(issuerSignedJWT);
            issuerVerifyingKeys.addAll(keys);
        }
        sdJwtVP.getSdJwtVerificationContext().verifyPresentation(issuerVerifyingKeys, issuerSignedJwtVerificationOpts, keyBindingJwtVerificationOpts, presentationRequirements);
    }
}

