/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.cache;

import java.io.File;
import java.net.URL;
import net.sourceforge.jnlp.Version;
import net.sourceforge.jnlp.cache.CacheUtil;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.PropertiesFile;
import net.sourceforge.jnlp.util.logging.OutputController;

public class CacheEntry {
    private static final String KEY_CONTENT_LENGTH = "content-length";
    private static final String KEY_LAST_MODIFIED = "last-modified";
    private static final String KEY_LAST_UPDATED = "last-updated";
    public static final String KEY_JNLP_PATH = "jnlp-path";
    private final URL location;
    private final Version version;
    private final PropertiesFile properties;
    private File localFile;

    public CacheEntry(URL location, Version version) {
        this.location = location;
        this.version = version;
        this.localFile = CacheUtil.getCacheFile(location, version);
        File infoFile = new File(this.localFile.getPath() + ".info");
        this.properties = new PropertiesFile(infoFile, Translator.R("CAutoGen"));
    }

    public URL getLocation() {
        return this.location;
    }

    public long getLastUpdated() {
        return this.getLongKey(KEY_LAST_UPDATED);
    }

    public void setLastUpdated(long updatedTime) {
        this.setLongKey(KEY_LAST_UPDATED, updatedTime);
    }

    public long getRemoteContentLength() {
        return this.getLongKey(KEY_CONTENT_LENGTH);
    }

    public void setRemoteContentLength(long length) {
        this.setLongKey(KEY_CONTENT_LENGTH, length);
    }

    public void setJnlpPath(String jnlpPath) {
        this.properties.setProperty(KEY_JNLP_PATH, jnlpPath);
    }

    public long getLastModified() {
        return this.getLongKey(KEY_LAST_MODIFIED);
    }

    public void setLastModified(long modifyTime) {
        this.setLongKey(KEY_LAST_MODIFIED, modifyTime);
    }

    private long getLongKey(String key) {
        try {
            return Long.parseLong(this.properties.getProperty(key));
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    private void setLongKey(String key, long value) {
        this.properties.setProperty(key, Long.toString(value));
    }

    public boolean isCurrent(long lastModified) {
        return this.isCurrent(lastModified, null);
    }

    public boolean isCurrent(long lastModified, File cachedFile) {
        boolean cached = this.isCached(cachedFile);
        OutputController.getLogger().log("isCurrent:isCached " + cached);
        if (!cached) {
            return false;
        }
        try {
            long cachedModified = Long.parseLong(this.properties.getProperty(KEY_LAST_MODIFIED));
            OutputController.getLogger().log("isCurrent:lastModified cache:" + cachedModified + " actual:" + lastModified);
            return lastModified > 0L && lastModified <= cachedModified;
        }
        catch (Exception ex) {
            OutputController.getLogger().log(ex);
            return cached;
        }
    }

    public boolean isCached() {
        return this.isCached(null);
    }

    public boolean isCached(File cachedFile) {
        File localFile = null == this.version && null != cachedFile ? cachedFile : this.getCacheFile();
        if (!localFile.exists()) {
            return false;
        }
        try {
            long cachedLength = localFile.length();
            long remoteLength = Long.parseLong(this.properties.getProperty(KEY_CONTENT_LENGTH, "-1"));
            OutputController.getLogger().log("isCached: remote:" + remoteLength + " cached:" + cachedLength);
            return remoteLength < 0L || cachedLength == remoteLength;
        }
        catch (Exception ex) {
            OutputController.getLogger().log(ex);
            return false;
        }
    }

    File getCacheFile() {
        return CacheUtil.getCacheFile(this.location, this.version);
    }

    protected boolean store() {
        if (this.properties.isHeldByCurrentThread()) {
            this.properties.store();
            return true;
        }
        return false;
    }

    public void markForDelete() {
        this.properties.setProperty("delete", Boolean.toString(true));
    }

    protected void lock() {
        this.properties.lock();
    }

    protected void unlock() {
        this.properties.unlock();
    }

    protected boolean tryLock() {
        return this.properties.tryLock();
    }

    protected boolean isHeldByCurrentThread() {
        return this.properties.isHeldByCurrentThread();
    }

    public File getLocalFile() {
        return this.localFile;
    }
}

