/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.load;

import java.io.File;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.cmd.AppendMediaCmd;
import tim.prune.cmd.Command;
import tim.prune.data.AudioClip;
import tim.prune.data.MediaObject;
import tim.prune.function.Describer;
import tim.prune.load.AudioFileFilter;
import tim.prune.load.GenericFileFilter;
import tim.prune.load.MediaSorter;

public class AudioLoader
extends GenericFunction {
    private JFileChooser _fileChooser = null;
    private final GenericFileFilter _fileFilter = new AudioFileFilter();
    private ArrayList<MediaObject> _audioList = null;

    public AudioLoader(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.loadaudio";
    }

    @Override
    public void begin() {
        Object object;
        if (this._fileChooser == null) {
            this._fileChooser = new JFileChooser();
            this._fileChooser.setMultiSelectionEnabled(true);
            this._fileChooser.setFileSelectionMode(2);
            this._fileChooser.setFileFilter(this._fileFilter);
            this._fileChooser.setDialogTitle(this.getName());
            object = this.getConfig().getConfigString("prune.photodirectory");
            if (object == null) {
                object = this.getConfig().getConfigString("prune.trackdirectory");
            }
            if (object != null) {
                this._fileChooser.setCurrentDirectory(new File((String)object));
            }
        }
        if (this._fileChooser.showOpenDialog(this._parentFrame) == 0) {
            this._audioList = new ArrayList();
            this.processFileList(this._fileChooser.getSelectedFiles());
            if (this._audioList.isEmpty()) {
                this._app.showErrorMessage(this.getNameKey(), "error.audioload.nofilesfound");
            } else {
                this._audioList.sort(new MediaSorter());
                object = new AppendMediaCmd(this._audioList);
                Describer describer = new Describer("confirm.audiosloaded.single", "confirm.audiosloaded");
                ((Command)object).setConfirmText(describer.getDescriptionWithCount(this._audioList.size()));
                Describer describer2 = new Describer("undo.loadaudio", "undo.loadaudios");
                String string = this._audioList.get(0).getName();
                ((Command)object).setDescription(describer2.getDescriptionWithNameOrCount(string, this._audioList.size()));
                this._app.execute((Command)object);
            }
        }
    }

    private void processFileList(File[] fileArray) {
        if (fileArray == null) {
            return;
        }
        File[] fileArray2 = fileArray;
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray2[n2];
            if (file.exists() && file.canRead()) {
                if (file.isFile()) {
                    if (this._fileFilter.accept(file)) {
                        this._audioList.add(new AudioClip(file));
                    }
                } else if (file.isDirectory()) {
                    this.processFileList(file.listFiles());
                }
            }
            ++n2;
        }
    }
}

