/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.importer.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.gephi.io.importer.api.Database;
import org.gephi.io.importer.plugin.database.EdgeListDatabaseImpl;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class EdgeListDatabaseManager {
    private FileObject databaseConfigurations;
    private List<Database> edgeListDatabases = new ArrayList<Database>();

    public EdgeListDatabaseManager() {
        this.load();
    }

    public List<Database> getEdgeListDatabases() {
        return this.edgeListDatabases;
    }

    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Database db : this.edgeListDatabases) {
            names.add(db.getName());
        }
        return names;
    }

    public void addDatabase(EdgeListDatabaseImpl db) {
        this.edgeListDatabases.add((Database)db);
    }

    public boolean removeDatabase(EdgeListDatabaseImpl db) {
        return this.edgeListDatabases.remove(db);
    }

    public void persist() {
        this.doPersist();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        if (this.databaseConfigurations == null) {
            this.databaseConfigurations = FileUtil.getConfigFile((String)"EdgeListDatabase");
        }
        if (this.databaseConfigurations != null) {
            InputStream is = null;
            try {
                is = this.databaseConfigurations.getInputStream();
                ObjectInputStream ois = new ObjectInputStream(is);
                List unserialized = (List)ois.readObject();
                if (unserialized != null) {
                    this.edgeListDatabases = unserialized;
                }
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPersist() {
        FileLock lock = null;
        ObjectOutputStream ois = null;
        try {
            if (this.databaseConfigurations != null) {
                this.databaseConfigurations.delete();
            }
            this.databaseConfigurations = FileUtil.getConfigRoot().createData("EdgeListDatabase");
            lock = this.databaseConfigurations.lock();
            ois = new ObjectOutputStream(this.databaseConfigurations.getOutputStream(lock));
            ois.writeObject(this.edgeListDatabases);
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException iOException) {}
            }
            if (lock != null) {
                lock.releaseLock();
            }
        }
    }
}

