/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service.tool;

import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.invocation.InvocationContext;
import dev.langchain4j.invocation.InvocationParameters;

public class ToolProviderRequest {
    private final InvocationContext invocationContext;
    private final UserMessage userMessage;

    public ToolProviderRequest(Builder builder) {
        this.invocationContext = (InvocationContext)ValidationUtils.ensureNotNull((Object)builder.invocationContext, (String)"invocationContext");
        this.userMessage = (UserMessage)ValidationUtils.ensureNotNull((Object)builder.userMessage, (String)"userMessage");
    }

    public ToolProviderRequest(Object chatMemoryId, UserMessage userMessage) {
        this.invocationContext = InvocationContext.builder().chatMemoryId(chatMemoryId).build();
        this.userMessage = (UserMessage)ValidationUtils.ensureNotNull((Object)userMessage, (String)"userMessage");
    }

    public InvocationContext invocationContext() {
        return this.invocationContext;
    }

    public InvocationParameters invocationParameters() {
        return this.invocationContext.invocationParameters();
    }

    public UserMessage userMessage() {
        return this.userMessage;
    }

    public Object chatMemoryId() {
        return this.invocationContext.chatMemoryId();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private InvocationContext invocationContext;
        private UserMessage userMessage;

        public Builder invocationContext(InvocationContext invocationContext) {
            this.invocationContext = invocationContext;
            return this;
        }

        public Builder userMessage(UserMessage userMessage) {
            this.userMessage = userMessage;
            return this;
        }

        public ToolProviderRequest build() {
            return new ToolProviderRequest(this);
        }
    }
}

