﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/elasticmapreduce/EMR_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace EMR {
namespace Model {
class ModifyClusterResult {
 public:
  AWS_EMR_API ModifyClusterResult() = default;
  AWS_EMR_API ModifyClusterResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_EMR_API ModifyClusterResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The number of steps that can be executed concurrently.</p>
   */
  inline int GetStepConcurrencyLevel() const { return m_stepConcurrencyLevel; }
  inline void SetStepConcurrencyLevel(int value) {
    m_stepConcurrencyLevelHasBeenSet = true;
    m_stepConcurrencyLevel = value;
  }
  inline ModifyClusterResult& WithStepConcurrencyLevel(int value) {
    SetStepConcurrencyLevel(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Reserved.</p>
   */
  inline bool GetExtendedSupport() const { return m_extendedSupport; }
  inline void SetExtendedSupport(bool value) {
    m_extendedSupportHasBeenSet = true;
    m_extendedSupport = value;
  }
  inline ModifyClusterResult& WithExtendedSupport(bool value) {
    SetExtendedSupport(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ModifyClusterResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  int m_stepConcurrencyLevel{0};

  bool m_extendedSupport{false};

  Aws::String m_requestId;
  bool m_stepConcurrencyLevelHasBeenSet = false;
  bool m_extendedSupportHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace EMR
}  // namespace Aws
