# Installation
> `npm install --save @types/object-assign-deep`

# Summary
This package contains type definitions for object-assign-deep (https://github.com/saikojosh/Object-Assign-Deep#readme).

# Details
Files were exported from https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/object-assign-deep.
## [index.d.ts](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/object-assign-deep/index.d.ts)
````ts
declare const objectAssignDeep: ObjectConstructor["assign"];

interface Options {
    arrayBehaviour: "replace" | "merge";
}

interface objectAssignDeep {
    noMutate: ObjectConstructor["assign"];

    withOptions<T, U>(target: T, objects: [U], options: Options): T & U;
    withOptions<T, U, V>(target: T, objects: [U, V], options: Options): T & U & V;
    withOptions<T, U, V, W>(target: T, objects: [U, V, W], options: Options): T & U & V & W;
    withOptions(target: any, objects: any[], options: Options): any;
}

export = objectAssignDeep;

````

### Additional Details
 * Last updated: Tue, 07 Nov 2023 09:09:39 GMT
 * Dependencies: none

# Credits
These definitions were written by [Nick Clifford](https://github.com/nickbclifford).
