// SPDX-FileCopyrightText: Copyright (c) 2008-2013, NVIDIA Corporation. All rights reserved.
// SPDX-License-Identifier: Apache-2.0

#pragma once

#include <thrust/detail/config.h>

#if defined(_CCCL_IMPLICIT_SYSTEM_HEADER_GCC)
#  pragma GCC system_header
#elif defined(_CCCL_IMPLICIT_SYSTEM_HEADER_CLANG)
#  pragma clang system_header
#elif defined(_CCCL_IMPLICIT_SYSTEM_HEADER_MSVC)
#  pragma system_header
#endif // no system header
#include <thrust/iterator/iterator_traits.h>
#include <thrust/system/detail/generic/select_system.h>
#include <thrust/tabulate.h>

// Include all active backend system implementations (generic, sequential, host and device)
#include <thrust/system/detail/generic/tabulate.h>
#include <thrust/system/detail/sequential/tabulate.h>
#include __THRUST_HOST_SYSTEM_ALGORITH_DETAIL_HEADER_INCLUDE(tabulate.h)
#include __THRUST_DEVICE_SYSTEM_ALGORITH_DETAIL_HEADER_INCLUDE(tabulate.h)

// Some build systems need a hint to know which files we could include
#if 0
#  include <thrust/system/cpp/detail/tabulate.h>
#  include <thrust/system/cuda/detail/tabulate.h>
#  include <thrust/system/omp/detail/tabulate.h>
#  include <thrust/system/tbb/detail/tabulate.h>
#endif

THRUST_NAMESPACE_BEGIN

_CCCL_EXEC_CHECK_DISABLE
template <typename DerivedPolicy, typename ForwardIterator, typename UnaryOperation>
_CCCL_HOST_DEVICE void
tabulate(const thrust::detail::execution_policy_base<DerivedPolicy>& exec,
         ForwardIterator first,
         ForwardIterator last,
         UnaryOperation unary_op)
{
  _CCCL_NVTX_RANGE_SCOPE("thrust::tabulate");
  using thrust::system::detail::generic::tabulate;
  return tabulate(thrust::detail::derived_cast(thrust::detail::strip_const(exec)), first, last, unary_op);
} // end tabulate()

template <typename ForwardIterator, typename UnaryOperation>
void tabulate(ForwardIterator first, ForwardIterator last, UnaryOperation unary_op)
{
  _CCCL_NVTX_RANGE_SCOPE("thrust::tabulate");
  using thrust::system::detail::generic::select_system;

  using System = typename thrust::iterator_system<ForwardIterator>::type;

  System system;

  return thrust::tabulate(select_system(system), first, last, unary_op);
} // end tabulate()

THRUST_NAMESPACE_END
