/*
 * Decompiled with CFR 0.152.
 */
package org.protege.xmlcatalog.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.protege.xmlcatalog.CatalogUtilities;
import org.protege.xmlcatalog.XMLCatalog;
import org.protege.xmlcatalog.swing.CatalogJTree;
import org.protege.xmlcatalog.swing.EntryEditor;

public class CatalogEditor
extends JPanel {
    private static final long serialVersionUID = 4105691012851258776L;

    public CatalogEditor(XMLCatalog catalog, List<EntryEditor> editors) {
        this.setLayout(new BorderLayout());
        this.add((Component)new CatalogJTree(catalog, editors), "Center");
    }

    public static void main(String[] args) {
        try {
            JFrame frame = new JFrame("Catalog Viewer");
            frame.setLayout(new BorderLayout());
            frame.setPreferredSize(new Dimension(1024, 768));
            JFileChooser jfc = new JFileChooser();
            int ret = jfc.showOpenDialog(frame);
            if (ret == 0) {
                File f = jfc.getSelectedFile();
                XMLCatalog catalog = CatalogUtilities.parseDocument(f.toURI().toURL());
                frame.add(new CatalogEditor(catalog, new ArrayList<EntryEditor>()));
                frame.setVisible(true);
                frame.repaint();
                frame.setDefaultCloseOperation(3);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

