# CommandHelp
<span class="source-link">[[Source]](src/cli/command_help.md#L-0-37)</span>

CommandHelp encapsulates the information needed to generate a user help
message for a given CommandSpec, optionally with a specific command
identified to print help about. Use `Help.general()` or `Help.for_command()`
to create a CommandHelp instance.


```pony
class box CommandHelp
```

## Constructors

### _create
<span class="source-link">[[Source]](src/cli/command_help.md#L-0-47)</span>


```pony
new ref _create(
  parent': (CommandHelp box | None val),
  spec': CommandSpec box)
: CommandHelp ref^
```
#### Parameters

*   parent': ([CommandHelp](cli-CommandHelp.md) box | [None](builtin-None.md) val)
*   spec': [CommandSpec](cli-CommandSpec.md) box

#### Returns

* [CommandHelp](cli-CommandHelp.md) ref^

---

## Public Functions

### fullname
<span class="source-link">[[Source]](src/cli/command_help.md#L-0-51)</span>


```pony
fun box fullname()
: String val
```

#### Returns

* [String](builtin-String.md) val

---

### string
<span class="source-link">[[Source]](src/cli/command_help.md#L-0-58)</span>


```pony
fun box string()
: String val
```

#### Returns

* [String](builtin-String.md) val

---

### help_string
<span class="source-link">[[Source]](src/cli/command_help.md#L-0-60)</span>


Renders the help message as a String.


```pony
fun box help_string()
: String val
```

#### Returns

* [String](builtin-String.md) val

---

### print_help
<span class="source-link">[[Source]](src/cli/command_help.md#L-0-70)</span>


Prints the help message to an OutStream.


```pony
fun box print_help(
  os: OutStream tag)
: None val
```
#### Parameters

*   os: [OutStream](builtin-OutStream.md) tag

#### Returns

* [None](builtin-None.md) val

---

## Private Functions

### _write_help
<span class="source-link">[[Source]](src/cli/command_help.md#L-0-78)</span>


```pony
fun box _write_help(
  w: Writer ref)
: None val
```
#### Parameters

*   w: [Writer](buffered-Writer.md) ref

#### Returns

* [None](builtin-None.md) val

---

### _write_usage
<span class="source-link">[[Source]](src/cli/command_help.md#L-0-100)</span>


```pony
fun box _write_usage(
  w: Writer ref)
: None val
```
#### Parameters

*   w: [Writer](buffered-Writer.md) ref

#### Returns

* [None](builtin-None.md) val

---

### _write_options
<span class="source-link">[[Source]](src/cli/command_help.md#L-0-117)</span>


```pony
fun box _write_options(
  w: Writer ref,
  options: Array[OptionSpec box] box)
: None val
```
#### Parameters

*   w: [Writer](buffered-Writer.md) ref
*   options: [Array](builtin-Array.md)\[[OptionSpec](cli-OptionSpec.md) box\] box

#### Returns

* [None](builtin-None.md) val

---

### _write_commands
<span class="source-link">[[Source]](src/cli/command_help.md#L-0-124)</span>


```pony
fun box _write_commands(
  w: Writer ref)
: None val
```
#### Parameters

*   w: [Writer](buffered-Writer.md) ref

#### Returns

* [None](builtin-None.md) val

---

### _list_commands
<span class="source-link">[[Source]](src/cli/command_help.md#L-0-129)</span>


```pony
fun box _list_commands(
  cs: CommandSpec box,
  cols: Array[(USize val , String val , String val)] ref,
  level: USize val)
: None val
```
#### Parameters

*   cs: [CommandSpec](cli-CommandSpec.md) box
*   cols: [Array](builtin-Array.md)\[([USize](builtin-USize.md) val , [String](builtin-String.md) val , [String](builtin-String.md) val)\] ref
*   level: [USize](builtin-USize.md) val

#### Returns

* [None](builtin-None.md) val

---

### _write_args
<span class="source-link">[[Source]](src/cli/command_help.md#L-0-139)</span>


```pony
fun box _write_args(
  w: Writer ref,
  args: Array[ArgSpec val] box)
: None val
```
#### Parameters

*   w: [Writer](buffered-Writer.md) ref
*   args: [Array](builtin-Array.md)\[[ArgSpec](cli-ArgSpec.md) val\] box

#### Returns

* [None](builtin-None.md) val

---

### _any_options
<span class="source-link">[[Source]](src/cli/command_help.md#L-0-146)</span>


```pony
fun box _any_options()
: Bool val
```

#### Returns

* [Bool](builtin-Bool.md) val

---

### _all_options
<span class="source-link">[[Source]](src/cli/command_help.md#L-0-157)</span>


```pony
fun box _all_options()
: Array[OptionSpec box] ref
```

#### Returns

* [Array](builtin-Array.md)\[[OptionSpec](cli-OptionSpec.md) box\] ref

---

### _all_options_fill
<span class="source-link">[[Source]](src/cli/command_help.md#L-0-162)</span>


```pony
fun box _all_options_fill(
  options: Array[OptionSpec box] ref)
: None val
```
#### Parameters

*   options: [Array](builtin-Array.md)\[[OptionSpec](cli-OptionSpec.md) box\] ref

#### Returns

* [None](builtin-None.md) val

---

