/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.creole;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.sourceforge.plantuml.klimt.creole.Position;
import net.sourceforge.plantuml.klimt.creole.atom.Atom;
import net.sourceforge.plantuml.klimt.creole.legacy.AtomText;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.geom.MinMax;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;

public class Sea {
    private double currentX;
    private final Map<Atom, Position> positions = new LinkedHashMap<Atom, Position>();
    private final StringBounder stringBounder;

    public Sea(StringBounder stringBounder) {
        this.stringBounder = Objects.requireNonNull(stringBounder);
    }

    public void add(Atom atom) {
        XDimension2D dim = atom.calculateDimension(this.stringBounder);
        double y = 0.0;
        Position position = new Position(this.currentX, 0.0, dim);
        this.positions.put(atom, position);
        this.currentX += dim.getWidth();
    }

    public Position getPosition(Atom atom) {
        return this.positions.get(atom);
    }

    public void doAlign() {
        for (Map.Entry<Atom, Position> ent : new HashMap<Atom, Position>(this.positions).entrySet()) {
            Position pos = ent.getValue();
            Atom atom = ent.getKey();
            double height = atom.calculateDimension(this.stringBounder).getHeight();
            Position newPos = pos.translateY(-height + atom.getStartingAltitude(this.stringBounder));
            this.positions.put(atom, newPos);
        }
    }

    public void translateMinYto(double newValue) {
        double delta = newValue - this.getMinY();
        for (Map.Entry<Atom, Position> ent : new HashMap<Atom, Position>(this.positions).entrySet()) {
            Position pos = ent.getValue();
            Atom atom = ent.getKey();
            this.positions.put(atom, pos.translateY(delta));
        }
    }

    private AtomText findFirstAtomText() {
        for (Atom atom : this.positions.keySet()) {
            AtomText atomText;
            String text;
            if (!(atom instanceof AtomText) || (text = (atomText = (AtomText)atom).getText()).trim().isEmpty()) continue;
            return (AtomText)atom;
        }
        return null;
    }

    public void doAlignTikz() {
        AtomText firstTextAtom = this.findFirstAtomText();
        if (firstTextAtom == null) {
            return;
        }
        Position firstTextPosition = this.positions.get(firstTextAtom);
        double firstTextHeight = firstTextAtom.getFontHeight(this.stringBounder);
        for (Map.Entry<Atom, Position> entry : new LinkedHashMap<Atom, Position>(this.positions).entrySet()) {
            Atom atom = entry.getKey();
            if (atom instanceof AtomText) continue;
            Position position = entry.getValue();
            double targetY = firstTextPosition.getMinY() - (position.getHeight() - firstTextHeight) / 2.0;
            double delta = targetY - position.getMinY();
            if (delta == 0.0) continue;
            this.positions.put(atom, position.translateY(delta));
        }
    }

    public void doAlignTikzBaseline() {
        double delta;
        AtomText firstTextAtom = this.findFirstAtomText();
        if (firstTextAtom == null) {
            return;
        }
        double firstTextHeight = firstTextAtom.getFontHeight(this.stringBounder);
        for (Map.Entry<Atom, Position> entry : new LinkedHashMap<Atom, Position>(this.positions).entrySet()) {
            double delta2;
            Atom atom = entry.getKey();
            if (!(atom instanceof AtomText) || (delta2 = firstTextHeight - ((AtomText)atom).getFontHeight(this.stringBounder)) == 0.0) continue;
            this.positions.put(atom, entry.getValue().translateY(delta2));
        }
        if (this.positions.size() == 1 && (delta = (10.0 - firstTextHeight) / 2.0) > 0.0) {
            this.positions.put(firstTextAtom, this.positions.get(firstTextAtom).translateY(delta));
        }
    }

    public void exportAllPositions(Map<Atom, Position> destination) {
        destination.putAll(this.positions);
    }

    public double getMinY() {
        if (this.positions.size() == 0) {
            throw new IllegalStateException();
        }
        double result = Double.MAX_VALUE;
        for (Position pos : this.positions.values()) {
            if (!(result > pos.getMinY())) continue;
            result = pos.getMinY();
        }
        return result;
    }

    public double getMaxY() {
        if (this.positions.size() == 0) {
            throw new IllegalStateException();
        }
        Atom atom = null;
        double result = -1.7976931348623157E308;
        for (Map.Entry<Atom, Position> entry : this.positions.entrySet()) {
            Position pos = entry.getValue();
            if (!(result < pos.getMaxY())) continue;
            atom = entry.getKey();
            result = pos.getMaxY();
        }
        if (!this.stringBounder.matchesProperty("TIKZ")) {
            return result;
        }
        if (atom instanceof AtomText) {
            AtomText atomText = (AtomText)atom;
            UFont font = atomText.getFontConfiguration().getFont();
            String text = atomText.getText();
            double height = this.stringBounder.calculateDimension(font, text).getHeight();
            double delta = result - height;
            return result + Math.max(1.0 - delta, 0.0);
        }
        return result + 1.0;
    }

    public double getHeight() {
        return this.getMaxY() - this.getMinY();
    }

    public MinMax update(MinMax minMax) {
        for (Position position : this.positions.values()) {
            minMax = position.update(minMax);
        }
        return minMax;
    }

    public final double getWidth() {
        return this.currentX;
    }
}

