/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.field_caps;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class FieldCapability
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, FieldCapability> {
    private final boolean aggregatable;
    @Nonnull
    private final List<String> indices;
    @Nonnull
    private final Map<String, List<String>> meta;
    @Nullable
    private final Boolean metadataField;
    @Nonnull
    private final List<String> nonAggregatableIndices;
    @Nonnull
    private final List<String> nonSearchableIndices;
    private final boolean searchable;
    @Nonnull
    private final String type;
    public static final JsonpDeserializer<FieldCapability> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FieldCapability::setupFieldCapabilityDeserializer);

    private FieldCapability(Builder builder) {
        this.aggregatable = ApiTypeHelper.requireNonNull(builder.aggregatable, this, "aggregatable");
        this.indices = ApiTypeHelper.unmodifiable(builder.indices);
        this.meta = ApiTypeHelper.unmodifiable(builder.meta);
        this.metadataField = builder.metadataField;
        this.nonAggregatableIndices = ApiTypeHelper.unmodifiable(builder.nonAggregatableIndices);
        this.nonSearchableIndices = ApiTypeHelper.unmodifiable(builder.nonSearchableIndices);
        this.searchable = ApiTypeHelper.requireNonNull(builder.searchable, this, "searchable");
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
    }

    public static FieldCapability of(Function<Builder, ObjectBuilder<FieldCapability>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean aggregatable() {
        return this.aggregatable;
    }

    @Nonnull
    public final List<String> indices() {
        return this.indices;
    }

    @Nonnull
    public final Map<String, List<String>> meta() {
        return this.meta;
    }

    @Nullable
    public final Boolean metadataField() {
        return this.metadataField;
    }

    @Nonnull
    public final List<String> nonAggregatableIndices() {
        return this.nonAggregatableIndices;
    }

    @Nonnull
    public final List<String> nonSearchableIndices() {
        return this.nonSearchableIndices;
    }

    public final boolean searchable() {
        return this.searchable;
    }

    @Nonnull
    public final String type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("aggregatable");
        generator.write(this.aggregatable);
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartArray();
            for (String string : this.indices) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.meta)) {
            generator.writeKey("meta");
            generator.writeStartObject();
            for (Map.Entry entry : this.meta.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.writeStartArray();
                if (entry.getValue() != null) {
                    for (String item1 : (List)entry.getValue()) {
                        generator.write(item1);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (this.metadataField != null) {
            generator.writeKey("metadata_field");
            generator.write(this.metadataField.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.nonAggregatableIndices)) {
            generator.writeKey("non_aggregatable_indices");
            generator.writeStartArray();
            for (String string : this.nonAggregatableIndices) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.nonSearchableIndices)) {
            generator.writeKey("non_searchable_indices");
            generator.writeStartArray();
            for (String string : this.nonSearchableIndices) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        generator.writeKey("searchable");
        generator.write(this.searchable);
        generator.writeKey("type");
        generator.write(this.type);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupFieldCapabilityDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::aggregatable, JsonpDeserializer.booleanDeserializer(), "aggregatable");
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "indices");
        op.add(Builder::meta, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer())), "meta");
        op.add(Builder::metadataField, JsonpDeserializer.booleanDeserializer(), "metadata_field");
        op.add(Builder::nonAggregatableIndices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "non_aggregatable_indices");
        op.add(Builder::nonSearchableIndices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "non_searchable_indices");
        op.add(Builder::searchable, JsonpDeserializer.booleanDeserializer(), "searchable");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Boolean.hashCode(this.aggregatable);
        result = 31 * result + Objects.hashCode(this.indices);
        result = 31 * result + Objects.hashCode(this.meta);
        result = 31 * result + Objects.hashCode(this.metadataField);
        result = 31 * result + Objects.hashCode(this.nonAggregatableIndices);
        result = 31 * result + Objects.hashCode(this.nonSearchableIndices);
        result = 31 * result + Boolean.hashCode(this.searchable);
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldCapability other = (FieldCapability)o;
        return this.aggregatable == other.aggregatable && Objects.equals(this.indices, other.indices) && Objects.equals(this.meta, other.meta) && Objects.equals(this.metadataField, other.metadataField) && Objects.equals(this.nonAggregatableIndices, other.nonAggregatableIndices) && Objects.equals(this.nonSearchableIndices, other.nonSearchableIndices) && this.searchable == other.searchable && this.type.equals(other.type);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, FieldCapability> {
        private Boolean aggregatable;
        @Nullable
        private List<String> indices;
        @Nullable
        private Map<String, List<String>> meta;
        @Nullable
        private Boolean metadataField;
        @Nullable
        private List<String> nonAggregatableIndices;
        @Nullable
        private List<String> nonSearchableIndices;
        private Boolean searchable;
        private String type;

        public Builder() {
        }

        private Builder(FieldCapability o) {
            this.aggregatable = o.aggregatable;
            this.indices = Builder._listCopy(o.indices);
            this.meta = Builder._mapCopy(o.meta);
            this.metadataField = o.metadataField;
            this.nonAggregatableIndices = Builder._listCopy(o.nonAggregatableIndices);
            this.nonSearchableIndices = Builder._listCopy(o.nonSearchableIndices);
            this.searchable = o.searchable;
            this.type = o.type;
        }

        private Builder(Builder o) {
            this.aggregatable = o.aggregatable;
            this.indices = Builder._listCopy(o.indices);
            this.meta = Builder._mapCopy(o.meta);
            this.metadataField = o.metadataField;
            this.nonAggregatableIndices = Builder._listCopy(o.nonAggregatableIndices);
            this.nonSearchableIndices = Builder._listCopy(o.nonSearchableIndices);
            this.searchable = o.searchable;
            this.type = o.type;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder aggregatable(boolean value) {
            this.aggregatable = value;
            return this;
        }

        @Nonnull
        public final Builder indices(List<String> list) {
            this.indices = Builder._listAddAll(this.indices, list);
            return this;
        }

        @Nonnull
        public final Builder indices(String value, String ... values) {
            this.indices = Builder._listAdd(this.indices, value, values);
            return this;
        }

        @Nonnull
        public final Builder meta(Map<String, List<String>> map) {
            this.meta = Builder._mapPutAll(this.meta, map);
            return this;
        }

        @Nonnull
        public final Builder meta(String key, List<String> value) {
            this.meta = Builder._mapPut(this.meta, key, value);
            return this;
        }

        @Nonnull
        public final Builder metadataField(@Nullable Boolean value) {
            this.metadataField = value;
            return this;
        }

        @Nonnull
        public final Builder nonAggregatableIndices(List<String> list) {
            this.nonAggregatableIndices = Builder._listAddAll(this.nonAggregatableIndices, list);
            return this;
        }

        @Nonnull
        public final Builder nonAggregatableIndices(String value, String ... values) {
            this.nonAggregatableIndices = Builder._listAdd(this.nonAggregatableIndices, value, values);
            return this;
        }

        @Nonnull
        public final Builder nonSearchableIndices(List<String> list) {
            this.nonSearchableIndices = Builder._listAddAll(this.nonSearchableIndices, list);
            return this;
        }

        @Nonnull
        public final Builder nonSearchableIndices(String value, String ... values) {
            this.nonSearchableIndices = Builder._listAdd(this.nonSearchableIndices, value, values);
            return this;
        }

        @Nonnull
        public final Builder searchable(boolean value) {
            this.searchable = value;
            return this;
        }

        @Nonnull
        public final Builder type(String value) {
            this.type = value;
            return this;
        }

        @Override
        @Nonnull
        public FieldCapability build() {
            this._checkSingleUse();
            return new FieldCapability(this);
        }
    }
}

