/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.pytorch.jni;

import ai.djl.engine.EngineException;
import ai.djl.util.ClassLoaderUtils;
import ai.djl.util.Platform;
import ai.djl.util.Utils;
import ai.djl.util.cuda.CudaUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LibUtils {
    private static final Logger logger = LoggerFactory.getLogger(LibUtils.class);
    private static final String NATIVE_LIB_NAME = System.mapLibraryName("torch");
    private static final String JNI_LIB_NAME = System.mapLibraryName("djl_torch");
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+\\.\\d+\\.\\d+(-[a-z]+)?)(-SNAPSHOT)?(-\\d+)?");
    private static final Pattern LIB_PATTERN = Pattern.compile("(.*\\.(so(\\.\\d+)*|dll|dylib))");
    private static LibTorch libTorch;

    private LibUtils() {
    }

    public static synchronized void loadLibrary() {
        if ("http://www.android.com/".equals(System.getProperty("java.vendor.url"))) {
            System.loadLibrary("djl_torch");
            return;
        }
        libTorch = LibUtils.getLibTorch();
        LibUtils.loadLibTorch(libTorch);
        Path path = LibUtils.findJniLibrary(libTorch).toAbsolutePath();
        LibUtils.loadNativeLibrary(path.toString());
    }

    private static LibTorch getLibTorch() {
        LibTorch lib = LibUtils.findOverrideLibrary();
        if (lib != null) {
            return lib;
        }
        return LibUtils.findNativeLibrary();
    }

    public static String getVersion() {
        Matcher m = VERSION_PATTERN.matcher(LibUtils.libTorch.version);
        if (m.matches()) {
            return m.group(1);
        }
        return LibUtils.libTorch.version;
    }

    public static String getLibtorchPath() {
        return LibUtils.libTorch.dir.toString();
    }

    private static void loadLibTorch(LibTorch libTorch) {
        String libstd;
        Path libDir = libTorch.dir.toAbsolutePath();
        if (Files.exists(libDir.resolve("libstdc++.so.6"), new LinkOption[0]) && (libstd = Utils.getEnvOrSystemProperty((String)"LIBSTDCXX_LIBRARY_PATH")) != null) {
            try {
                logger.info("Loading libstdc++.so.6 from: {}", (Object)libstd);
                System.load(libstd);
            }
            catch (UnsatisfiedLinkError e) {
                logger.warn("Failed Loading libstdc++.so.6 from: {}", (Object)libstd);
            }
        }
        String libExclusion = Utils.getEnvOrSystemProperty((String)"PYTORCH_LIBRARY_EXCLUSION", (String)"");
        HashSet<String> exclusion = new HashSet<String>(Arrays.asList(libExclusion.split(",")));
        boolean isCuda = libTorch.flavor.contains("cu");
        List<String> deferred = Arrays.asList(System.mapLibraryName("fbgemm"), System.mapLibraryName("caffe2_nvrtc"), System.mapLibraryName("torch_cpu"), System.mapLibraryName("c10_cuda"), System.mapLibraryName("torch_cuda_cpp"), System.mapLibraryName("torch_cuda_cu"), System.mapLibraryName("torch_cuda"), System.mapLibraryName("nvfuser_codegen"), System.mapLibraryName("torch"));
        HashSet<String> loadLater = new HashSet<String>(deferred);
        try (Stream<Path> paths = Files.walk(libDir, new FileVisitOption[0]);){
            ConcurrentHashMap rank = new ConcurrentHashMap();
            paths.filter(path -> {
                String name = path.getFileName().toString();
                if (!LIB_PATTERN.matcher(name).matches() || exclusion.contains(name)) {
                    return false;
                }
                if (!isCuda && name.contains("nvrtc") && name.contains("cudart") && name.contains("nvTools")) {
                    return false;
                }
                if (name.startsWith("libarm_compute-") || name.startsWith("libopenblasp")) {
                    rank.put(path, 2);
                    return true;
                }
                if (name.startsWith("libarm_compute_")) {
                    rank.put(path, 3);
                    return true;
                }
                if (!(loadLater.contains(name) || !Files.isRegularFile(path, new LinkOption[0]) || name.endsWith(JNI_LIB_NAME) || name.contains("torch_") || name.contains("caffe2_") || name.startsWith("cudnn"))) {
                    rank.put(path, 1);
                    return true;
                }
                return false;
            }).sorted(Comparator.comparingInt(rank::get)).map(Path::toString).forEach(LibUtils::loadNativeLibrary);
            if (Files.exists(libDir.resolve("cudnn64_8.dll"), new LinkOption[0])) {
                LibUtils.loadNativeLibrary(libDir.resolve("cudnn64_8.dll").toString());
                LibUtils.loadNativeLibrary(libDir.resolve("cudnn_ops_infer64_8.dll").toString());
                LibUtils.loadNativeLibrary(libDir.resolve("cudnn_ops_train64_8.dll").toString());
                LibUtils.loadNativeLibrary(libDir.resolve("cudnn_cnn_infer64_8.dll").toString());
                LibUtils.loadNativeLibrary(libDir.resolve("cudnn_cnn_train64_8.dll").toString());
                LibUtils.loadNativeLibrary(libDir.resolve("cudnn_adv_infer64_8.dll").toString());
                LibUtils.loadNativeLibrary(libDir.resolve("cudnn_adv_train64_8.dll").toString());
            } else if (Files.exists(libDir.resolve("cudnn64_7.dll"), new LinkOption[0])) {
                LibUtils.loadNativeLibrary(libDir.resolve("cudnn64_7.dll").toString());
            }
            if (!isCuda) {
                deferred = Arrays.asList(System.mapLibraryName("fbgemm"), System.mapLibraryName("torch_cpu"), System.mapLibraryName("torch"));
            }
            for (String dep : deferred) {
                Path path2 = libDir.resolve(dep);
                if (!Files.exists(path2, new LinkOption[0])) continue;
                LibUtils.loadNativeLibrary(path2.toString());
            }
        }
        catch (IOException e) {
            throw new EngineException("Folder not exist! " + libDir, (Throwable)e);
        }
    }

    private static LibTorch findOverrideLibrary() {
        String libPath = Utils.getEnvOrSystemProperty((String)"PYTORCH_LIBRARY_PATH");
        if (libPath != null) {
            return LibUtils.findLibraryInPath(libPath);
        }
        return null;
    }

    private static LibTorch findLibraryInPath(String libPath) {
        String[] paths;
        for (String path : paths = libPath.split(File.pathSeparator)) {
            File p = new File(path);
            if (!p.exists()) continue;
            if (p.isFile() && NATIVE_LIB_NAME.equals(p.getName())) {
                return new LibTorch(p.getParentFile().toPath().toAbsolutePath());
            }
            File file = new File(path, NATIVE_LIB_NAME);
            if (!file.exists() || !file.isFile()) continue;
            return new LibTorch(p.toPath().toAbsolutePath());
        }
        return null;
    }

    /*
     * Loose catch block
     */
    private static Path findJniLibrary(LibTorch libTorch) {
        Path path;
        InputStream is;
        Path tmp;
        block29: {
            block28: {
                String classifier = libTorch.classifier;
                String version = libTorch.version;
                String djlVersion = libTorch.apiVersion;
                String flavor = libTorch.flavor;
                Path libDir = libTorch.dir.toAbsolutePath();
                Path path2 = libDir.resolve(djlVersion + '-' + JNI_LIB_NAME);
                if (Files.exists(path2, new LinkOption[0])) {
                    return path2;
                }
                path2 = libDir.resolve(JNI_LIB_NAME);
                if (Files.exists(path2, new LinkOption[0])) {
                    return path2;
                }
                Path cacheDir = Utils.getEngineCacheDir((String)"pytorch");
                Path dir = cacheDir.resolve(version + '-' + flavor + '-' + classifier);
                path2 = dir.resolve(djlVersion + '-' + JNI_LIB_NAME);
                if (Files.exists(path2, new LinkOption[0])) {
                    return path2;
                }
                Matcher matcher = VERSION_PATTERN.matcher(version);
                if (!matcher.matches()) {
                    throw new EngineException("Unexpected version: " + version);
                }
                version = matcher.group(1);
                try {
                    URL url = ClassLoaderUtils.getResource((String)"jnilib/pytorch.properties");
                    String jniVersion = null;
                    if (url != null) {
                        Properties prop = new Properties();
                        try (InputStream is2 = Utils.openUrl((URL)url);){
                            prop.load(is2);
                        }
                        jniVersion = prop.getProperty("jni_version");
                        if (jniVersion == null) {
                            throw new AssertionError((Object)"No PyTorch jni version found.");
                        }
                    }
                    if (jniVersion == null) {
                        LibUtils.downloadJniLib(dir, path2, djlVersion, version, classifier, flavor);
                        return path2;
                    }
                    if (!jniVersion.startsWith(version + '-' + djlVersion)) {
                        logger.warn("Found mismatch PyTorch jni: {}", (Object)jniVersion);
                        LibUtils.downloadJniLib(dir, path2, djlVersion, version, classifier, flavor);
                        return path2;
                    }
                }
                catch (IOException e) {
                    throw new AssertionError("Failed to read PyTorch jni properties file.", e);
                }
                tmp = null;
                String libPath = "jnilib/" + classifier + '/' + flavor + '/' + JNI_LIB_NAME;
                logger.info("Extracting {} to cache ...", (Object)libPath);
                is = ClassLoaderUtils.getResourceAsStream((String)libPath);
                Files.createDirectories(dir, new FileAttribute[0]);
                tmp = Files.createTempFile(dir, "jni", "tmp", new FileAttribute[0]);
                Files.copy(is, tmp, StandardCopyOption.REPLACE_EXISTING);
                Utils.moveQuietly((Path)tmp, (Path)path2);
                path = path2;
                if (is == null) break block28;
                is.close();
            }
            if (tmp == null) break block29;
            Utils.deleteQuietly((Path)tmp);
        }
        return path;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new EngineException("Cannot copy jni files", (Throwable)e);
                    }
                }
                catch (Throwable throwable3) {
                    if (tmp != null) {
                        Utils.deleteQuietly(tmp);
                    }
                    throw throwable3;
                }
            }
        }
    }

    private static LibTorch findNativeLibrary() {
        Platform platform = Platform.detectPlatform((String)"pytorch");
        String overrideVersion = Utils.getEnvOrSystemProperty((String)"PYTORCH_VERSION");
        if (overrideVersion != null && !overrideVersion.isEmpty() && !platform.getVersion().startsWith(overrideVersion)) {
            logger.warn("Override PyTorch version: {}.", (Object)overrideVersion);
            platform = Platform.detectPlatform((String)"pytorch", (String)overrideVersion);
            return LibUtils.downloadPyTorch(platform);
        }
        if (platform.isPlaceholder()) {
            return LibUtils.downloadPyTorch(platform);
        }
        return LibUtils.copyNativeLibraryFromClasspath(platform);
    }

    private static LibTorch copyNativeLibraryFromClasspath(Platform platform) {
        LibTorch libTorch;
        block17: {
            logger.debug("Found bundled PyTorch package: {}.", (Object)platform);
            String version = platform.getVersion();
            String flavor = platform.getFlavor();
            if (!flavor.endsWith("-precxx11") && Arrays.asList(platform.getLibraries()).contains("libstdc++.so.6")) {
                flavor = flavor + "-precxx11";
            }
            String classifier = platform.getClassifier();
            Path tmp = null;
            try {
                Path cacheDir = Utils.getEngineCacheDir((String)"pytorch");
                logger.debug("Using cache dir: {}", (Object)cacheDir);
                Path dir = cacheDir.resolve(version + '-' + flavor + '-' + classifier);
                Path path = dir.resolve(NATIVE_LIB_NAME);
                if (Files.exists(path, new LinkOption[0])) {
                    LibTorch libTorch2 = new LibTorch(dir.toAbsolutePath(), platform, flavor);
                    return libTorch2;
                }
                Utils.deleteQuietly((Path)dir);
                Matcher m = VERSION_PATTERN.matcher(version);
                if (!m.matches()) {
                    throw new AssertionError((Object)("Unexpected version: " + version));
                }
                String pathPrefix = "pytorch/" + flavor + '/' + classifier;
                Files.createDirectories(cacheDir, new FileAttribute[0]);
                tmp = Files.createTempDirectory(cacheDir, "tmp", new FileAttribute[0]);
                for (String file : platform.getLibraries()) {
                    String libPath = pathPrefix + '/' + file;
                    logger.info("Extracting {} to cache ...", (Object)libPath);
                    try (InputStream is = ClassLoaderUtils.getResourceAsStream((String)libPath);){
                        Files.copy(is, tmp.resolve(file), StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                Utils.moveQuietly((Path)tmp, (Path)dir);
                libTorch = new LibTorch(dir.toAbsolutePath(), platform, flavor);
                if (tmp == null) break block17;
            }
            catch (IOException e) {
                throw new EngineException("Failed to extract PyTorch native library", (Throwable)e);
            }
            finally {
                if (tmp != null) {
                    Utils.deleteQuietly(tmp);
                }
            }
            Utils.deleteQuietly((Path)tmp);
        }
        return libTorch;
    }

    private static void loadNativeLibrary(String path) {
        logger.debug("Loading native library: {}", (Object)path);
        String nativeHelper = System.getProperty("ai.djl.pytorch.native_helper");
        if (nativeHelper != null && !nativeHelper.isEmpty()) {
            ClassLoaderUtils.nativeLoad((String)nativeHelper, (String)path);
        } else {
            System.load(path);
        }
    }

    /*
     * Exception decompiling
     */
    private static LibTorch downloadPyTorch(Platform platform) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void downloadJniLib(Path cacheDir, Path path, String djlVersion, String version, String classifier, String flavor) {
        String url = "https://publish.djl.ai/pytorch/" + version + "/jnilib/" + djlVersion + '/' + classifier + '/' + flavor + '/' + JNI_LIB_NAME;
        logger.info("Downloading jni {} to cache ...", (Object)url);
        Path tmp = null;
        try {
            try (InputStream is = Utils.openUrl((String)url);){
                Files.createDirectories(cacheDir, new FileAttribute[0]);
                tmp = Files.createTempFile(cacheDir, "jni", "tmp", new FileAttribute[0]);
                Files.copy(is, tmp, StandardCopyOption.REPLACE_EXISTING);
                Utils.moveQuietly((Path)tmp, (Path)path);
            }
            if (tmp == null) return;
        }
        catch (IOException e) {
            try {
                throw new EngineException("Cannot download jni files: " + url, (Throwable)e);
            }
            catch (Throwable throwable) {
                if (tmp == null) throw throwable;
                Utils.deleteQuietly(tmp);
                throw throwable;
            }
        }
        Utils.deleteQuietly((Path)tmp);
        return;
    }

    private static final class LibTorch {
        Path dir;
        String version;
        String apiVersion;
        String flavor;
        String classifier;

        LibTorch(Path dir) {
            Platform platform = Platform.detectPlatform((String)"pytorch");
            this.dir = dir;
            this.apiVersion = platform.getApiVersion();
            this.classifier = platform.getClassifier();
            this.version = Utils.getEnvOrSystemProperty((String)"PYTORCH_VERSION");
            if (this.version == null || this.version.isEmpty()) {
                this.version = platform.getVersion();
            }
            this.flavor = Utils.getEnvOrSystemProperty((String)"PYTORCH_FLAVOR");
            if (this.flavor == null || this.flavor.isEmpty()) {
                this.flavor = CudaUtils.getGpuCount() > 0 ? "cu" + CudaUtils.getCudaVersionString() + "-precxx11" : ("linux".equals(platform.getOsPrefix()) ? "cpu-precxx11" : "cpu");
            }
        }

        LibTorch(Path dir, Platform platform, String flavor) {
            this.dir = dir;
            this.version = platform.getVersion();
            this.apiVersion = platform.getApiVersion();
            this.classifier = platform.getClassifier();
            this.flavor = flavor;
        }
    }
}

