/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.processor;

import java.util.Map;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.ml.engine.annotation.Processor;
import org.opensearch.ml.engine.processor.AbstractMLProcessor;
import org.opensearch.ml.engine.processor.MLProcessorType;

@Processor(value=MLProcessorType.REGEX_REPLACE)
public class MLRegexReplaceProcessor
extends AbstractMLProcessor {
    @Generated
    private static final Logger log = LogManager.getLogger(MLRegexReplaceProcessor.class);
    private final Pattern pattern;
    private final String replacement;
    private final boolean replaceAll;

    public MLRegexReplaceProcessor(Map<String, Object> config) {
        super(config);
        String patternStr = (String)config.get("pattern");
        try {
            this.pattern = Pattern.compile(patternStr, 32);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid regex pattern: " + patternStr, e);
        }
        this.replacement = (String)config.getOrDefault("replacement", "");
        this.replaceAll = Boolean.TRUE.equals(config.getOrDefault("replace_all", true));
    }

    @Override
    protected void validateConfig() {
        if (!this.config.containsKey("pattern")) {
            throw new IllegalArgumentException("'pattern' is required for regex_replace processor");
        }
        String patternValue = (String)this.config.get("pattern");
        if (patternValue == null || patternValue.trim().isEmpty()) {
            throw new IllegalArgumentException("'pattern' cannot be empty for regex_replace processor");
        }
    }

    @Override
    public Object process(Object input) {
        String text = StringUtils.toJson((Object)input);
        try {
            String result = this.replaceAll ? this.pattern.matcher(text).replaceAll(this.replacement) : this.pattern.matcher(text).replaceFirst(this.replacement);
            return result;
        }
        catch (Exception e) {
            log.warn("Failed to apply regex replacement with pattern '{}': {}", (Object)this.pattern.pattern(), (Object)e.getMessage());
            return input;
        }
    }
}

