/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.swing;

import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class ScreenGeometry {
    final GraphicsConfiguration graphicsConfiguration;
    final boolean aqua = UIManager.getLookAndFeel().getName().indexOf("Aqua") != -1;

    public ScreenGeometry(JComponent component) {
        this.graphicsConfiguration = this.graphicsConfigurationForComponent(component);
    }

    private GraphicsConfiguration graphicsConfigurationForComponent(Component component) {
        Point point = component.getLocationOnScreen();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gd = ge.getScreenDevices();
        for (int i = 0; i < gd.length; ++i) {
            GraphicsConfiguration defaultGraphicsConfiguration;
            if (gd[i].getType() != 0 || !(defaultGraphicsConfiguration = gd[i].getDefaultConfiguration()).getBounds().contains(point)) continue;
            return defaultGraphicsConfiguration;
        }
        return component.getGraphicsConfiguration();
    }

    public Rectangle getScreenBounds() {
        Rectangle screenSize = this.getScreenSize();
        Insets screenInsets = this.getScreenInsets();
        return new Rectangle(screenSize.x + screenInsets.left, screenSize.y + screenInsets.top, screenSize.width - screenInsets.left - screenInsets.right, screenSize.height - screenInsets.top - screenInsets.bottom);
    }

    public Rectangle getScreenSize() {
        if (this.graphicsConfiguration != null) {
            return this.graphicsConfiguration.getBounds();
        }
        return new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
    }

    public Insets getScreenInsets() {
        Insets screenInsets = this.graphicsConfiguration != null ? Toolkit.getDefaultToolkit().getScreenInsets(this.graphicsConfiguration) : new Insets(0, 0, 0, 0);
        if (this.aqua) {
            int aquaBottomInsets = 21;
            int aquaTopInsets = 22;
            screenInsets.bottom = Math.max(screenInsets.bottom, aquaBottomInsets);
            screenInsets.top = Math.max(screenInsets.top, aquaTopInsets);
        }
        return screenInsets;
    }
}

