/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.classic;

import java.awt.Color;
import java.util.prefs.Preferences;
import org.jsampler.view.std.StdPrefs;

public class ClassicPrefs
extends StdPrefs {
    private static final String prefNode = "org.jsampler.view.classic";
    private static final String WINDOW_SIZE_AND_LOCATION = ".sizeAndLocation";
    private static final String DEF_WINDOW_SIZE_AND_LOCATION = null;
    private static final String WINDOW_MAXIMIZED = ".maximized";
    private static final boolean DEF_WINDOW_MAXIMIZED = false;
    private static final String SAVE_WINDOW_PROPERTIES = "Mainframe.saveProperties";
    private static final boolean DEF_SAVE_WINDOW_PROPERTIES = true;
    private static final String HSPLIT_DIVIDER_LOCATION = "HSplit.dividerLocation";
    private static final int DEF_HSPLIT_DIVIDER_LOCATION = 180;
    private static final String SAVE_LEFT_PANE_STATE = "LeftPane.saveState";
    private static final boolean DEF_SAVE_LEFT_PANE_STATE = true;
    private static final String LEFT_PANE_PAGE_IDX = "LeftPane.pageIndex";
    private static final int DEF_LEFT_PANE_PAGE_IDX = 0;
    private static final String SHOW_CHANNELS_BAR = "ChannelsBar.visible";
    private static final boolean DEF_SHOW_CHANNELS_BAR = true;
    private static final String SHOW_STATUSBAR = "Statusbar.visible";
    private static final boolean DEF_SHOW_STATUSBAR = true;
    private static final String SHOW_LEFT_PANE = "LeftPane.visible";
    private static final boolean DEF_SHOW_LEFT_PANE = true;
    private static final String SHOW_STANDARD_BAR = "StandardBar.visible";
    private static final boolean DEF_SHOW_STANDARD_BAR = true;
    private static final String SHOW_LS_CONSOLE = "LSConsole.visible";
    private static final boolean DEF_SHOW_LS_CONSOLE = false;
    private static final String LS_CONSOLE_POPOUT = "LSConsole.popout";
    private static final boolean DEF_LS_CONSOLE_POPOUT = false;
    private static final String CHANNEL_BORDER_COLOR = "Channel.borderColor";
    private static final int DEF_CHANNEL_BORDER_COLOR = 12111845;
    private static final String CUSTOM_CHANNEL_BORDER_COLOR = "Channel.customBorderColor";
    private static final boolean DEF_CUSTOM_CHANNEL_BORDER_COLOR = false;
    private static final String CHANNEL_BORDER_HL_COLOR = "Channel.borderMouseOverColor";
    private static final int DEF_CHANNEL_BORDER_HL_COLOR = 12111845;
    private static final String CUSTOM_CHANNEL_BORDER_HL_COLOR = "Channel.customHlColor";
    private static final boolean DEF_CUSTOM_CHANNEL_BORDER_HL_COLOR = false;
    private static final String SEL_CHANNEL_BG_COLOR = "Channel.sel.BgColor";
    private static final int DEF_SEL_CHANNEL_BG_COLOR = 14739179;
    private static final String CUSTOM_SEL_CHANNEL_BG_COLOR = "Channel.sel.customBgColor";
    private static final boolean DEF_CUSTOM_SEL_CHANNEL_BG_COLOR = false;
    private static final String HL_CHANNEL_BG_COLOR = "Channel.hl.BgColor";
    private static final int DEF_HL_CHANNEL_BG_COLOR = -1;
    private static final String CUSTOM_HL_CHANNEL_BG_COLOR = "Channel.hl.customBgColor";
    private static final boolean DEF_CUSTOM_HL_CHANNEL_BG_COLOR = false;
    private static final String VSPLIT_DIVIDER_LOCATION = "VSplit.dividerLocation";
    private static final int DEF_VSPLIT_DIVIDER_LOCATION = 200;
    private static final String CURRENT_ORCHESTRA_IDX = "OrchestrasPage.currentOrchestraIndex";
    private static final int DEF_CURRENT_ORCHESTRA_IDX = 0;
    private static Preferences userPrefs = Preferences.userRoot().node("org.jsampler.view.classic");
    private static final ClassicPrefs prefs = new ClassicPrefs();

    private ClassicPrefs() {
        super(prefNode);
    }

    public static ClassicPrefs preferences() {
        return prefs;
    }

    public static Preferences user() {
        return userPrefs;
    }

    public static String getWindowSizeAndLocation(String string) {
        return ClassicPrefs.user().get(string + WINDOW_SIZE_AND_LOCATION, DEF_WINDOW_SIZE_AND_LOCATION);
    }

    public static void setWindowSizeAndLocation(String string, String string2) {
        if (string2 == null) {
            ClassicPrefs.user().remove(string + WINDOW_SIZE_AND_LOCATION);
            return;
        }
        ClassicPrefs.user().put(string + WINDOW_SIZE_AND_LOCATION, string2);
    }

    public static boolean getWindowMaximized(String string) {
        return ClassicPrefs.user().getBoolean(string + WINDOW_MAXIMIZED, false);
    }

    public static void setWindowMaximized(String string, boolean bl) {
        if (bl == ClassicPrefs.getWindowMaximized(string)) {
            return;
        }
        ClassicPrefs.user().putBoolean(string + WINDOW_MAXIMIZED, bl);
    }

    public static int getHSplitDividerLocation() {
        return ClassicPrefs.user().getInt(HSPLIT_DIVIDER_LOCATION, 180);
    }

    public static void setHSplitDividerLocation(int n) {
        if (n == ClassicPrefs.getHSplitDividerLocation()) {
            return;
        }
        ClassicPrefs.user().putInt(HSPLIT_DIVIDER_LOCATION, n);
    }

    public static boolean getSaveWindowProperties() {
        return ClassicPrefs.user().getBoolean(SAVE_WINDOW_PROPERTIES, true);
    }

    public static void setSaveWindowProperties(boolean bl) {
        if (bl == ClassicPrefs.getSaveWindowProperties()) {
            return;
        }
        ClassicPrefs.user().putBoolean(SAVE_WINDOW_PROPERTIES, bl);
    }

    public static boolean getSaveLeftPaneState() {
        return ClassicPrefs.user().getBoolean(SAVE_LEFT_PANE_STATE, true);
    }

    public static void setSaveLeftPaneState(boolean bl) {
        if (bl == ClassicPrefs.getSaveLeftPaneState()) {
            return;
        }
        ClassicPrefs.user().putBoolean(SAVE_LEFT_PANE_STATE, bl);
    }

    public static int getLeftPanePageIndex() {
        return ClassicPrefs.user().getInt(LEFT_PANE_PAGE_IDX, 0);
    }

    public static void setLeftPanePageIndex(int n) {
        if (n == ClassicPrefs.getLeftPanePageIndex()) {
            return;
        }
        ClassicPrefs.user().putInt(LEFT_PANE_PAGE_IDX, n);
    }

    public static boolean shouldShowChannelsBar() {
        return ClassicPrefs.user().getBoolean(SHOW_CHANNELS_BAR, true);
    }

    public static void setShowChannelsBar(boolean bl) {
        if (bl == ClassicPrefs.shouldShowChannelsBar()) {
            return;
        }
        ClassicPrefs.user().putBoolean(SHOW_CHANNELS_BAR, bl);
    }

    public static boolean shouldShowStatusbar() {
        return ClassicPrefs.user().getBoolean(SHOW_STATUSBAR, true);
    }

    public static void setShowStatusbar(boolean bl) {
        if (bl == ClassicPrefs.shouldShowStatusbar()) {
            return;
        }
        ClassicPrefs.user().putBoolean(SHOW_STATUSBAR, bl);
    }

    public static boolean shouldShowLSConsole() {
        return ClassicPrefs.user().getBoolean(SHOW_LS_CONSOLE, false);
    }

    public static void setShowLSConsole(boolean bl) {
        if (bl == ClassicPrefs.shouldShowLSConsole()) {
            return;
        }
        ClassicPrefs.user().putBoolean(SHOW_LS_CONSOLE, bl);
    }

    public static boolean isLSConsolePopOut() {
        return ClassicPrefs.user().getBoolean(LS_CONSOLE_POPOUT, false);
    }

    public static void setLSConsolePopOut(boolean bl) {
        if (bl == ClassicPrefs.isLSConsolePopOut()) {
            return;
        }
        ClassicPrefs.user().putBoolean(LS_CONSOLE_POPOUT, bl);
    }

    public static boolean shouldShowLeftPane() {
        return ClassicPrefs.user().getBoolean(SHOW_LEFT_PANE, true);
    }

    public static void setShowLeftPane(boolean bl) {
        if (bl == ClassicPrefs.shouldShowLeftPane()) {
            return;
        }
        ClassicPrefs.user().putBoolean(SHOW_LEFT_PANE, bl);
    }

    public static boolean shouldShowStandardBar() {
        return ClassicPrefs.user().getBoolean(SHOW_STANDARD_BAR, true);
    }

    public static void setShowStandardBar(boolean bl) {
        if (bl == ClassicPrefs.shouldShowStandardBar()) {
            return;
        }
        ClassicPrefs.user().putBoolean(SHOW_STANDARD_BAR, bl);
    }

    public static Color getDefaultChannelBorderColor() {
        return new Color(12111845);
    }

    public static Color getChannelBorderColor() {
        int n = ClassicPrefs.user().getInt(CHANNEL_BORDER_COLOR, 12111845);
        return new Color(n);
    }

    public static void setChannelBorderColor(Color color) {
        if (color == null) {
            ClassicPrefs.user().remove(CHANNEL_BORDER_COLOR);
            return;
        }
        if (color.getRGB() == ClassicPrefs.getChannelBorderColor().getRGB()) {
            return;
        }
        ClassicPrefs.user().putInt(CHANNEL_BORDER_COLOR, color.getRGB());
    }

    public static boolean getCustomChannelBorderColor() {
        return ClassicPrefs.user().getBoolean(CUSTOM_CHANNEL_BORDER_COLOR, false);
    }

    public static void setCustomChannelBorderColor(boolean bl) {
        if (bl == ClassicPrefs.getCustomChannelBorderColor()) {
            return;
        }
        ClassicPrefs.user().putBoolean(CUSTOM_CHANNEL_BORDER_COLOR, bl);
    }

    public static Color getDefaultChannelBorderHlColor() {
        return new Color(12111845);
    }

    public static Color getChannelBorderHlColor() {
        int n = ClassicPrefs.user().getInt(CHANNEL_BORDER_HL_COLOR, 12111845);
        return new Color(n);
    }

    public static void setChannelBorderHlColor(Color color) {
        if (color == null) {
            ClassicPrefs.user().remove(CHANNEL_BORDER_HL_COLOR);
            return;
        }
        if (color.getRGB() == ClassicPrefs.getChannelBorderHlColor().getRGB()) {
            return;
        }
        ClassicPrefs.user().putInt(CHANNEL_BORDER_HL_COLOR, color.getRGB());
    }

    public static boolean getCustomChannelBorderHlColor() {
        return ClassicPrefs.user().getBoolean(CUSTOM_CHANNEL_BORDER_HL_COLOR, false);
    }

    public static void setCustomChannelBorderHlColor(boolean bl) {
        if (bl == ClassicPrefs.getCustomChannelBorderHlColor()) {
            return;
        }
        ClassicPrefs.user().putBoolean(CUSTOM_CHANNEL_BORDER_HL_COLOR, bl);
    }

    public static Color getSelectedChannelBgColor() {
        int n = ClassicPrefs.user().getInt(SEL_CHANNEL_BG_COLOR, 14739179);
        return n == -1 ? null : new Color(n);
    }

    public static void setSelectedChannelBgColor(Color color) {
        if (color == null) {
            ClassicPrefs.user().remove(SEL_CHANNEL_BG_COLOR);
            return;
        }
        if (ClassicPrefs.getSelectedChannelBgColor() != null && color.getRGB() == ClassicPrefs.getSelectedChannelBgColor().getRGB()) {
            return;
        }
        ClassicPrefs.user().putInt(SEL_CHANNEL_BG_COLOR, color.getRGB());
    }

    public static boolean getCustomSelectedChannelBgColor() {
        return ClassicPrefs.user().getBoolean(CUSTOM_SEL_CHANNEL_BG_COLOR, false);
    }

    public static void setCustomSelectedChannelBgColor(boolean bl) {
        if (bl == ClassicPrefs.getCustomSelectedChannelBgColor()) {
            return;
        }
        ClassicPrefs.user().putBoolean(CUSTOM_SEL_CHANNEL_BG_COLOR, bl);
    }

    public static Color getHighlightedChannelBgColor() {
        int n = ClassicPrefs.user().getInt(HL_CHANNEL_BG_COLOR, -1);
        return n == -1 ? null : new Color(n);
    }

    public static void setHighlightedChannelBgColor(Color color) {
        if (color == null) {
            ClassicPrefs.user().remove(HL_CHANNEL_BG_COLOR);
            return;
        }
        if (ClassicPrefs.getHighlightedChannelBgColor() != null && color.getRGB() == ClassicPrefs.getHighlightedChannelBgColor().getRGB()) {
            return;
        }
        ClassicPrefs.user().putInt(HL_CHANNEL_BG_COLOR, color.getRGB());
    }

    public static boolean getCustomHighlightedChannelBgColor() {
        return ClassicPrefs.user().getBoolean(CUSTOM_HL_CHANNEL_BG_COLOR, false);
    }

    public static void setCustomHighlightedChannelBgColor(boolean bl) {
        if (bl == ClassicPrefs.getCustomHighlightedChannelBgColor()) {
            return;
        }
        ClassicPrefs.user().putBoolean(CUSTOM_HL_CHANNEL_BG_COLOR, bl);
    }

    public static int getVSplitDividerLocation() {
        return ClassicPrefs.user().getInt(VSPLIT_DIVIDER_LOCATION, 200);
    }

    public static void setVSplitDividerLocation(int n) {
        if (n == ClassicPrefs.getVSplitDividerLocation()) {
            return;
        }
        ClassicPrefs.user().putInt(VSPLIT_DIVIDER_LOCATION, n);
    }

    public static int getCurrentOrchestraIndex() {
        return ClassicPrefs.user().getInt(CURRENT_ORCHESTRA_IDX, 0);
    }

    public static void setCurrentOrchestraIndex(int n) {
        if (n == ClassicPrefs.getCurrentOrchestraIndex()) {
            return;
        }
        ClassicPrefs.user().putInt(CURRENT_ORCHESTRA_IDX, n);
    }

    @Override
    public int getDefaultIntValue(String string) {
        if (string == "LSConsole.backgroundColor") {
            return 0xFFFFFF;
        }
        if (string == "LSConsole.textColor") {
            return 0;
        }
        if (string == "LSConsole.notifyColor") {
            return 0xCCCCCC;
        }
        if (string == "LSConsole.warningColor") {
            return 0x6699FF;
        }
        if (string == "LSConsole.errorColor") {
            return 0xFF0000;
        }
        return super.getDefaultIntValue(string);
    }
}

