/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.tools;

import java.io.PrintStream;
import sun.jvm.hotspot.HotSpotAgent;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.JVMDebugger;
import sun.jvm.hotspot.runtime.VM;

public abstract class Tool
implements Runnable {
    private HotSpotAgent agent;
    private JVMDebugger jvmDebugger;
    private int debugeeType;
    protected static final int DEBUGEE_PID = 0;
    protected static final int DEBUGEE_CORE = 1;
    protected static final int DEBUGEE_REMOTE = 2;

    public Tool() {
    }

    public Tool(JVMDebugger d) {
        this.jvmDebugger = d;
    }

    public String getName() {
        return this.getClass().getName();
    }

    protected boolean needsJavaPrefix() {
        return true;
    }

    protected void setAgent(HotSpotAgent a) {
        this.agent = a;
    }

    protected void setDebugeeType(int dt) {
        this.debugeeType = dt;
    }

    protected HotSpotAgent getAgent() {
        return this.agent;
    }

    protected int getDebugeeType() {
        return this.debugeeType;
    }

    protected void printUsage() {
        String name = null;
        name = this.needsJavaPrefix() ? "java " + this.getName() : this.getName();
        System.out.println("Usage: " + name + " [option] <pid>");
        System.out.println("\t\t(to connect to a live java process)");
        System.out.println("   or " + name + " [option] <executable> <core>");
        System.out.println("\t\t(to connect to a core file)");
        System.out.println("   or " + name + " [option] [server_id@]<remote server IP or hostname>");
        System.out.println("\t\t(to connect to a remote debug server)");
        System.out.println();
        System.out.println("where option must be one of:");
        this.printFlagsUsage();
    }

    protected void printFlagsUsage() {
        System.out.println("    -h | -help\tto print this help message");
    }

    protected void usage() {
        this.printUsage();
    }

    protected void execute(String[] args) {
        int returnStatus = 1;
        try {
            returnStatus = this.start(args);
        }
        finally {
            this.stop();
        }
        System.exit(returnStatus);
    }

    public void stop() {
        if (this.agent != null) {
            this.agent.detach();
        }
    }

    private int start(String[] args) {
        if (args.length < 1 || args.length > 2) {
            this.usage();
            return 1;
        }
        if (args[0].startsWith("-h")) {
            this.usage();
            return 0;
        }
        if (args[0].startsWith("-")) {
            this.usage();
            return 1;
        }
        PrintStream err = System.err;
        PrintStream out = System.out;
        int pid = 0;
        String coreFileName = null;
        String executableName = null;
        String remoteServer = null;
        switch (args.length) {
            case 1: {
                try {
                    pid = Integer.parseInt(args[0]);
                    this.debugeeType = 0;
                }
                catch (NumberFormatException e) {
                    remoteServer = args[0];
                    this.debugeeType = 2;
                }
                break;
            }
            case 2: {
                executableName = args[0];
                coreFileName = args[1];
                this.debugeeType = 1;
                break;
            }
            default: {
                this.usage();
                return 1;
            }
        }
        this.agent = new HotSpotAgent();
        try {
            switch (this.debugeeType) {
                case 0: {
                    out.println("Attaching to process ID " + pid + ", please wait...");
                    this.agent.attach(pid);
                    break;
                }
                case 1: {
                    out.println("Attaching to core " + coreFileName + " from executable " + executableName + ", please wait...");
                    this.agent.attach(executableName, coreFileName);
                    break;
                }
                case 2: {
                    out.println("Attaching to remote server " + remoteServer + ", please wait...");
                    this.agent.attach(remoteServer);
                }
            }
        }
        catch (DebuggerException e) {
            switch (this.debugeeType) {
                case 0: {
                    err.print("Error attaching to process: ");
                    break;
                }
                case 1: {
                    err.print("Error attaching to core file: ");
                    break;
                }
                case 2: {
                    err.print("Error attaching to remote server: ");
                }
            }
            if (e.getMessage() != null) {
                err.println(e.getMessage());
                e.printStackTrace();
            }
            err.println();
            return 1;
        }
        out.println("Debugger attached successfully.");
        this.startInternal();
        return 0;
    }

    public void start() {
        if (this.jvmDebugger == null) {
            throw new RuntimeException("Tool.start() called with no JVMDebugger set.");
        }
        this.agent = new HotSpotAgent();
        this.agent.attach(this.jvmDebugger);
        this.startInternal();
    }

    private void startInternal() {
        PrintStream out = System.out;
        VM vm = VM.getVM();
        if (vm.isCore()) {
            out.println("Core build detected.");
        } else if (vm.isClientCompiler()) {
            out.println("Client compiler detected.");
        } else if (vm.isServerCompiler()) {
            out.println("Server compiler detected.");
        } else {
            throw new RuntimeException("Fatal error: should have been able to detect core/C1/C2 build");
        }
        String version = vm.getVMRelease();
        if (version != null) {
            out.print("JVM version is ");
            out.println(version);
        }
        this.run();
    }
}

