/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import java.util.Iterator;
import java.util.List;
import tim.prune.UpdateMessageBroker;
import tim.prune.data.DataPoint;
import tim.prune.data.DoubleRange;
import tim.prune.data.Field;
import tim.prune.data.FieldList;
import tim.prune.data.SourceInfo;
import tim.prune.gui.map.MapUtils;

public class Track {
    private DataPoint[] _dataPoints;
    private double[] _xValues = null;
    private double[] _yValues = null;
    private boolean _scaled = false;
    private int _numPoints;
    private boolean _hasTrackpoint = false;
    private boolean _hasWaypoint = false;
    private FieldList _masterFieldList;
    private DoubleRange _latRange = null;
    private DoubleRange _longRange = null;
    private DoubleRange _xRange = null;
    private DoubleRange _yRange = null;

    public Track() {
        this._masterFieldList = new FieldList();
        this._dataPoints = new DataPoint[0];
        this._numPoints = 0;
    }

    public Track(FieldList fieldList, DataPoint[] dataPointArray) {
        this._masterFieldList = fieldList;
        this._dataPoints = dataPointArray;
        if (this._dataPoints == null) {
            this._dataPoints = new DataPoint[0];
        }
        this._numPoints = this._dataPoints.length;
    }

    public void requestRescale() {
        this._scaled = false;
    }

    private void extendFieldList(FieldList fieldList) {
        this._masterFieldList = this._masterFieldList.merge(fieldList);
    }

    public void cropTo(int n) {
        if (n >= 0 && n < this.getNumPoints()) {
            this._numPoints = n;
            this._scaled = false;
            UpdateMessageBroker.informSubscribers();
        }
    }

    public boolean deletePoint(int n) {
        int n2;
        DataPoint[] dataPointArray;
        DataPoint dataPoint = this.getPoint(n);
        if (dataPoint == null) {
            return false;
        }
        if (dataPoint.getSegmentStart() && (dataPointArray = this.getNextTrackPoint(n + 1)) != null) {
            dataPointArray.setSegmentStart(true);
        }
        dataPointArray = new DataPoint[this._numPoints - 1];
        if (n > 0) {
            System.arraycopy(this._dataPoints, 0, dataPointArray, 0, n);
        }
        if ((n2 = this._numPoints - n - 1) > 0) {
            System.arraycopy(this._dataPoints, n + 1, dataPointArray, n, n2);
        }
        this._dataPoints = dataPointArray;
        --this._numPoints;
        this._scaled = false;
        return true;
    }

    public boolean rearrangePoints(List<Integer> list) {
        if (list == null || list.size() != this._numPoints) {
            return false;
        }
        DataPoint[] dataPointArray = new DataPoint[this._numPoints];
        int n = 0;
        while (n < this._numPoints) {
            dataPointArray[n] = this.getPoint(list.get(n));
            ++n;
        }
        this._dataPoints = dataPointArray;
        this._scaled = false;
        return true;
    }

    public DataPoint getPoint(int n) {
        if (n > -1 && n < this.getNumPoints()) {
            return this._dataPoints[n];
        }
        return null;
    }

    public int getNumPoints() {
        return this._numPoints;
    }

    public DoubleRange getXRange() {
        if (!this._scaled) {
            this.scalePoints();
        }
        return this._xRange;
    }

    public DoubleRange getYRange() {
        if (!this._scaled) {
            this.scalePoints();
        }
        return this._yRange;
    }

    public DoubleRange getLatRange() {
        if (!this._scaled) {
            this.scalePoints();
        }
        return this._latRange;
    }

    public DoubleRange getLonRange() {
        if (!this._scaled) {
            this.scalePoints();
        }
        return this._longRange;
    }

    public double getX(int n) {
        if (!this._scaled) {
            this.scalePoints();
        }
        return this._xValues[n];
    }

    public double getY(int n) {
        if (!this._scaled) {
            this.scalePoints();
        }
        return this._yValues[n];
    }

    public FieldList getFieldList() {
        return this._masterFieldList;
    }

    public boolean hasData(Field field) {
        return this.hasData(field, 0, this._numPoints - 1);
    }

    public boolean hasData(Field field, int n, int n2) {
        int n3 = n;
        while (n3 <= n2) {
            DataPoint dataPoint = this.getPoint(n3);
            if (dataPoint != null) {
                boolean bl;
                if (field == Field.ALTITUDE) {
                    bl = dataPoint.hasAltitude();
                } else if (field == Field.TIMESTAMP) {
                    bl = dataPoint.hasTimestamp();
                } else if (field == Field.PHOTO) {
                    bl = dataPoint.getPhoto() != null;
                } else if (field == Field.AUDIO) {
                    bl = dataPoint.getAudio() != null;
                } else {
                    boolean bl2 = bl = dataPoint.getFieldValue(field) != null;
                }
                if (bl) {
                    return true;
                }
            }
            ++n3;
        }
        return false;
    }

    public boolean hasAltitudeData() {
        return this.hasData(Field.ALTITUDE);
    }

    public boolean hasTrackPoints() {
        if (!this._scaled) {
            this.scalePoints();
        }
        return this._hasTrackpoint;
    }

    public boolean hasWaypoints() {
        if (!this._scaled) {
            this.scalePoints();
        }
        return this._hasWaypoint;
    }

    public void getWaypoints(List<DataPoint> list) {
        list.clear();
        int n = 0;
        while (n <= this._numPoints - 1) {
            if (this._dataPoints[n] != null && this._dataPoints[n].isWaypoint()) {
                list.add(this._dataPoints[n]);
            }
            ++n;
        }
    }

    public int getPointIndex(DataPoint dataPoint) {
        if (dataPoint != null) {
            int n = 0;
            while (n <= this._numPoints - 1) {
                if (this._dataPoints[n] == dataPoint) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    public boolean hasSingleSourceFile() {
        SourceInfo sourceInfo = null;
        int n = 0;
        while (n < this.getNumPoints()) {
            SourceInfo sourceInfo2;
            DataPoint dataPoint = this.getPoint(n);
            SourceInfo sourceInfo3 = sourceInfo2 = dataPoint == null ? null : dataPoint.getSourceInfo();
            if (sourceInfo2 == null || sourceInfo != null && sourceInfo2 != sourceInfo) {
                return false;
            }
            if (sourceInfo2.getFile() == null) {
                return false;
            }
            sourceInfo = sourceInfo2;
            ++n;
        }
        return true;
    }

    private synchronized void scalePoints() {
        DataPoint dataPoint;
        this._longRange = new DoubleRange();
        this._latRange = new DoubleRange();
        this._hasWaypoint = false;
        this._hasTrackpoint = false;
        int n = 0;
        while (n < this.getNumPoints()) {
            dataPoint = this.getPoint(n);
            if (dataPoint != null && dataPoint.isValid()) {
                this._longRange.addValue(dataPoint.getLongitude().getDouble());
                this._latRange.addValue(dataPoint.getLatitude().getDouble());
                if (dataPoint.isWaypoint()) {
                    this._hasWaypoint = true;
                } else {
                    this._hasTrackpoint = true;
                }
            }
            ++n;
        }
        this._xValues = new double[this.getNumPoints()];
        this._yValues = new double[this.getNumPoints()];
        this._xRange = new DoubleRange();
        this._yRange = new DoubleRange();
        n = 0;
        while (n < this.getNumPoints()) {
            dataPoint = this.getPoint(n);
            if (dataPoint != null) {
                this._xValues[n] = MapUtils.getXFromLongitude(dataPoint.getLongitude().getDouble());
                this._xRange.addValue(this._xValues[n]);
                this._yValues[n] = MapUtils.getYFromLatitude(dataPoint.getLatitude().getDouble());
                this._yRange.addValue(this._yValues[n]);
            }
            ++n;
        }
        this._scaled = true;
    }

    public int getNearestTrackPointIndex(int n) {
        return this.getNearestPointIndex(this._xValues[n], this._yValues[n], -1.0, true);
    }

    public int getNearestPointIndex(double d, double d2, double d3, boolean bl) {
        int n = 0;
        double d4 = -1.0;
        try {
            int n2 = 0;
            while (n2 < this.getNumPoints()) {
                double d5;
                double d6;
                if (!(bl && this._dataPoints[n2].isWaypoint() || !((d6 = Math.abs(this._yValues[n2] - d2)) < d4) && !(d4 < 0.0) || !((d5 = d6 + Track.getMinXDist(this._xValues[n2] - d)) < d4) && !(d4 < 0.0))) {
                    n = n2;
                    d4 = d5;
                }
                ++n2;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return -1;
        }
        if (d4 > d3 && d3 > 0.0) {
            return -1;
        }
        return n;
    }

    private static double getMinXDist(double d) {
        return Math.min(Math.min(Math.abs(d), Math.abs(d - 1.0)), Math.abs(d + 1.0));
    }

    public DataPoint getNextTrackPoint(int n) {
        return this.getNextTrackPoint(n, this._numPoints, true);
    }

    public DataPoint getFirstTrackPointBetween(int n, int n2) {
        return this.getNextTrackPoint(n, n2, true);
    }

    public DataPoint getPreviousTrackPoint(int n) {
        return this.getNextTrackPoint(n, this._numPoints, false);
    }

    private DataPoint getNextTrackPoint(int n, int n2, boolean bl) {
        int n3 = bl ? 1 : -1;
        int n4 = n;
        while (n4 <= n2) {
            DataPoint dataPoint = this.getPoint(n4);
            if (dataPoint == null) {
                return null;
            }
            if (dataPoint.isValid() && !dataPoint.isWaypoint()) {
                return dataPoint;
            }
            n4 += n3;
        }
        return null;
    }

    public boolean isTrackPointWithin(int n, int n2) {
        int n3 = n;
        while (n3 <= n2) {
            if (!this.getPoint(n3).isWaypoint()) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public boolean isSegmentBreakWithin(int n, int n2) {
        int n3 = n;
        while (n3 <= n2) {
            DataPoint dataPoint = this.getPoint(n3);
            if (!dataPoint.isWaypoint() && dataPoint.getSegmentStart()) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public boolean appendPoint(DataPoint dataPoint) {
        return this.insertPoint(dataPoint, this._numPoints);
    }

    public boolean insertPoint(DataPoint dataPoint, int n) {
        if (n > this._numPoints || dataPoint == null) {
            return false;
        }
        DataPoint[] dataPointArray = new DataPoint[this._numPoints + 1];
        if (n > 0) {
            System.arraycopy(this._dataPoints, 0, dataPointArray, 0, n);
        }
        dataPointArray[n] = dataPoint;
        if (n < this._numPoints) {
            System.arraycopy(this._dataPoints, n, dataPointArray, n + 1, this._numPoints - n);
        }
        this._dataPoints = dataPointArray;
        ++this._numPoints;
        this.extendFieldList(dataPoint.getFieldList());
        this._scaled = false;
        UpdateMessageBroker.informSubscribers();
        return true;
    }

    public boolean appendRange(List<DataPoint> list) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        DataPoint[] dataPointArray = new DataPoint[this._numPoints + list.size()];
        System.arraycopy(this._dataPoints, 0, dataPointArray, 0, this._numPoints);
        int n = this._numPoints;
        Iterator<DataPoint> iterator = list.iterator();
        while (iterator.hasNext()) {
            DataPoint dataPoint;
            dataPointArray[n] = dataPoint = iterator.next();
            this.extendFieldList(dataPoint.getFieldList());
            ++n;
        }
        this._dataPoints = dataPointArray;
        this._numPoints = this._dataPoints.length;
        this._scaled = false;
        return true;
    }
}

